/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.apps.vgpws;

import edu.uiowa.physics.pw.apps.vgpws.NoiseFilter;
import edu.uiowa.physics.pw.apps.vgpws.Spacecraft;
import edu.uiowa.physics.pw.apps.vgpws.Vg1pwsEventsDataSetDescriptor;
import edu.uiowa.physics.pw.apps.vgpws.Vg1pwsReaderNew;
import edu.uiowa.physics.pw.das.CancelledOperationException;
import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.DasIOException;
import edu.uiowa.physics.pw.das.dataset.AveragePeakTableRebinner;
import edu.uiowa.physics.pw.das.dataset.CacheTag;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.DataSetUtil;
import edu.uiowa.physics.pw.das.dataset.NoDataInIntervalException;
import edu.uiowa.physics.pw.das.dataset.RebinDescriptor;
import edu.uiowa.physics.pw.das.dataset.SyncUtil;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.dataset.TableDataSetBuilder;
import edu.uiowa.physics.pw.das.dataset.TableUtil;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.datum.TimeLocationUnits;
import edu.uiowa.physics.pw.das.datum.TimeUtil;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.system.UserMessageCenter;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class Vg1pwsDataSetDescriptor
extends DataSetDescriptor {
    Map optionsMap;
    Spacecraft spacecraft;
    File dataFullDir;
    Vg1pwsReaderNew reader;
    TableDataSet ds = null;
    Vg1pwsReaderNew.dataUnit unit = Vg1pwsReaderNew.dataUnit.ElectricField;
    private File fileSystemRoot;
    Vg1pwsEventsDataSetDescriptor eventsDsd;
    private static DataSetDescriptor currentDataSetDescriptor;
    private static int currentDataSetDescriptorHash;

    public TableDataSet readData(Datum datum, Datum datum2, Datum datum3, DasProgressMonitor dasProgressMonitor) throws DasException {
        Object object;
        Object object2;
        int n;
        Object object3;
        if (dasProgressMonitor == null) {
            dasProgressMonitor = DasProgressMonitor.NULL;
        }
        double d = datum3 == null ? 0.0 : datum3.doubleValue(Units.seconds);
        TableDataSetBuilder tableDataSetBuilder = null;
        TableDataSet tableDataSet = null;
        Datum datum4 = null;
        Datum datum5 = null;
        Datum datum6 = null;
        CacheTag cacheTag = null;
        boolean bl = true;
        Datum datum7 = datum;
        long l = 0L;
        ArrayList<File> arrayList = new ArrayList<File>();
        ArrayList<Datum> arrayList2 = new ArrayList<Datum>();
        datum4 = datum7 = TimeUtil.prevMidnight(datum7);
        if (!this.fileSystemRoot.isDirectory()) {
            throw new DasIOException("" + this.fileSystemRoot + " is not a directory");
        }
        String string = (String)this.optionsMap.get("spacecraft");
        this.dataFullDir = new File(this.fileSystemRoot, "/DATA/FULL" + string + "/");
        DasApplication.getDefaultApplication().getLogger(DasApplication.DATA_TRANSFER_LOG).info("Loading data from " + this.fileSystemRoot);
        while (datum7.compareTo(datum2) == -1) {
            if (dasProgressMonitor.isCancelled()) {
                throw new CancelledOperationException();
            }
            datum5 = datum7.add(1.0, Units.days);
            object3 = TimeUtil.toTimeStruct(datum7);
            int n2 = ((TimeUtil.TimeStruct)object3).year;
            n = ((TimeUtil.TimeStruct)object3).month;
            int n3 = ((TimeUtil.TimeStruct)object3).day;
            String string2 = n < 5 ? "01_04" : (n < 9 ? "05_08" : "09_12");
            object2 = new DecimalFormat();
            ((DecimalFormat)object2).applyPattern("00");
            object = new File(this.dataFullDir, "T" + ((NumberFormat)object2).format(n2 % 100) + string2 + "/");
            String string3 = "T" + ((NumberFormat)object2).format(n2 % 100) + ((NumberFormat)object2).format(n) + ((NumberFormat)object2).format(n3) + ".DAT";
            File file = new File((File)object, string3);
            if (file.exists()) {
                arrayList.add(file);
                arrayList2.add(datum7);
                if (file.length() > 0L) {
                    l += file.length();
                }
            }
            datum7 = datum7.add(86400.0, Units.seconds);
        }
        datum6 = d > 60.0 ? datum3 : null;
        cacheTag = new CacheTag(datum4, datum5, datum6);
        if (dasProgressMonitor != null && l > 0L) {
            dasProgressMonitor.setTaskSize((int)Math.ceil((double)l / 1024.0));
            dasProgressMonitor.started();
        }
        object3 = null;
        Datum datum8 = null;
        if (dasProgressMonitor.isCancelled()) {
            throw new CancelledOperationException();
        }
        for (n = 0; n < arrayList.size(); ++n) {
            try {
                tableDataSet = this.reader.readFile(((File)arrayList.get(n)).toString(), this.unit);
                bl = false;
                if (dasProgressMonitor.isCancelled()) {
                    throw new CancelledOperationException();
                }
                dasProgressMonitor.setTaskProgress(dasProgressMonitor.getTaskProgress() + (long)((int)((File)arrayList.get(n)).length() / 1024));
            }
            catch (FileNotFoundException fileNotFoundException) {
                tableDataSet = null;
            }
            catch (IOException iOException) {
                DasExceptionHandler.handle(iOException);
                tableDataSet = null;
            }
            if (tableDataSet == null) continue;
            if (this.optionsMap.containsKey("noiseFilter") && this.optionsMap.get("noiseFilter").equals("true")) {
                DasApplication.getDefaultApplication().getLogger().warning("using noise filter");
                tableDataSet = NoiseFilter.filter(tableDataSet);
            }
            if (this.optionsMap.containsKey("removeBackground") && this.optionsMap.get("removeBackground").equals("true")) {
                DasApplication.getDefaultApplication().getLogger().warning("removing background");
                tableDataSet = NoiseFilter.removeBackground(tableDataSet);
            }
            if (d > 60.0) {
                Datum datum9 = (Datum)arrayList2.get(n);
                int n4 = (int)Math.ceil(86400.0 / d);
                object2 = new RebinDescriptor(datum9, datum9.add(86400.0, Units.seconds), n4, false);
                object = new AveragePeakTableRebinner();
                tableDataSet = (TableDataSet)((AveragePeakTableRebinner)object).rebin(tableDataSet, (RebinDescriptor)object2, null);
                object3 = Datum.create(86400, Units.seconds).divide(n4);
            } else {
                object3 = DataSetUtil.guessXTagWidth(tableDataSet);
            }
            datum8 = (Datum)tableDataSet.getProperty("yTagWidth");
            if (tableDataSetBuilder == null) {
                tableDataSetBuilder = new TableDataSetBuilder(tableDataSet.getXUnits(), tableDataSet.getYUnits(), tableDataSet.getZUnits());
                if (d > 60.0) {
                    tableDataSetBuilder.addPlane("peaks", tableDataSet.getZUnits());
                }
                tableDataSetBuilder.append(tableDataSet);
                continue;
            }
            tableDataSetBuilder.append(tableDataSet);
        }
        dasProgressMonitor.finished();
        if (bl) {
            throw new NoDataInIntervalException("No files found");
        }
        if (tableDataSetBuilder != null) {
            tableDataSetBuilder.setProperty("cacheTag", cacheTag);
            tableDataSetBuilder.setProperty("xTagWidth", object3);
            tableDataSetBuilder.setProperty("yTagWidth", datum8);
            this.ds = tableDataSetBuilder.toTableDataSet();
            return this.ds;
        }
        throw new NoDataInIntervalException("");
    }

    private DataSet filterSpacecraftEvents(TableDataSet tableDataSet, Datum datum, Datum datum2) throws DasException {
        try {
            if (this.eventsDsd == null) {
                throw new IllegalStateException("events Data Set Descriptor not defined");
            }
            VectorDataSet vectorDataSet = (VectorDataSet)this.eventsDsd.getDataSet(datum, datum2, null, null);
            vectorDataSet = (VectorDataSet)SyncUtil.synchronizeNearestNeighbor(vectorDataSet, tableDataSet);
            Units units = vectorDataSet.getYUnits();
            Units units2 = tableDataSet.getZUnits();
            boolean bl = tableDataSet.getPlanarView("peaks") != null;
            TableDataSetBuilder tableDataSetBuilder = new TableDataSetBuilder(tableDataSet.getXUnits(), tableDataSet.getYUnits(), tableDataSet.getZUnits());
            if (bl) {
                tableDataSetBuilder.addPlane("peaks", units2);
            }
            Map map = tableDataSet.getProperties();
            for (Object object : map.keySet()) {
                tableDataSetBuilder.setProperty((String)object, map.get(object));
            }
            DatumVector datumVector = TableUtil.getYTagsDatumVector(tableDataSet, 0);
            if (tableDataSet.tableCount() > 1) {
                throw new IllegalStateException("dataset contains more than one table");
            }
            double[] dArray = null;
            for (int i = 0; i < tableDataSet.getXLength(); ++i) {
                Object object;
                object = TableUtil.getDatumVector(tableDataSet, i).toDoubleArray(units2);
                if (bl) {
                    dArray = TableUtil.getDatumVector((TableDataSet)tableDataSet.getPlanarView("peaks"), i).toDoubleArray(units2);
                }
                if (!units.isFill(vectorDataSet.getDouble(i, units))) {
                    object[5] = units2.getFillDouble();
                    object[6] = units2.getFillDouble();
                    object[7] = units2.getFillDouble();
                    if (bl) {
                        dArray[5] = units2.getFillDouble();
                        dArray[6] = units2.getFillDouble();
                        dArray[7] = units2.getFillDouble();
                    }
                }
                if (bl) {
                    DatumVector[] datumVectorArray = new DatumVector[]{DatumVector.newDatumVector((double[])object, units2), DatumVector.newDatumVector(dArray, units2)};
                    tableDataSetBuilder.insertYScan(tableDataSet.getXTagDatum(i), datumVector, datumVectorArray, new String[]{"", "peaks"});
                    continue;
                }
                tableDataSetBuilder.insertYScan(tableDataSet.getXTagDatum(i), datumVector, DatumVector.newDatumVector((double[])object, units2));
            }
            return tableDataSetBuilder.toTableDataSet();
        }
        catch (DasException dasException) {
            DasExceptionHandler.handle(dasException);
            return null;
        }
    }

    protected DataSet getDataSetImpl(Datum datum, Datum datum2, Datum datum3, DasProgressMonitor dasProgressMonitor) throws DasException {
        if (datum3 == null) {
            datum3 = Datum.create(0.0, Units.seconds);
        }
        DataSet dataSet = this.readData(datum, datum2, datum3, dasProgressMonitor);
        if (this.optionsMap.containsKey("filterSpacecraftEvents") && "true".equals(this.optionsMap.get("filterSpacecraftEvents"))) {
            dataSet = this.filterSpacecraftEvents((TableDataSet)dataSet, datum, datum2);
        }
        return dataSet;
    }

    public Units getXUnits() {
        return TimeLocationUnits.us2000;
    }

    public File getFileSystemRoot() {
        return this.fileSystemRoot;
    }

    private static boolean checkoptionsMap(Map map) {
        boolean bl = "1".equals(map.get("spacecraft")) || "2".equals(map.get("spacecraft"));
        boolean bl2 = map.containsKey("root");
        List<String> list = Arrays.asList("spacecraft", "root", "filterPLS", "filterSpacecraftEvents", "noiseFilter", "removeBackground");
        for (String string : map.keySet()) {
            if (list.contains(string)) continue;
            throw new IllegalArgumentException("invalid option: " + string);
        }
        if (bl && bl2) {
            return true;
        }
        throw new IllegalArgumentException("optionsMap not properly specified, needs spacecraft and root");
    }

    private Vg1pwsDataSetDescriptor(Map map) {
        Vg1pwsDataSetDescriptor.checkoptionsMap(map);
        this.optionsMap = map;
        this.eventsDsd = null;
        this.fileSystemRoot = new File((String)map.get("root"));
        String string = (String)map.get("spacecraft");
        File file = new File(this.fileSystemRoot, "/DATA/FULL" + string + "/");
        if (!file.isDirectory()) {
            UserMessageCenter.getDefault().notifyUser((Object)this, file + " should exist, but doesn't.  (use volume root for DVD's)");
        }
        this.reader = new Vg1pwsReaderNew(map);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("form", "x_tagged_y_scan");
        hashtable.put("y_coordinate", Vg1pwsReaderNew.PWSA_freq);
        this.setProperties(hashtable);
    }

    public void setEventsDataSetDescriptor(Vg1pwsEventsDataSetDescriptor vg1pwsEventsDataSetDescriptor) {
        this.eventsDsd = vg1pwsEventsDataSetDescriptor;
    }

    public static DataSetDescriptor newDataSetDescriptor(Map map) {
        if (((Object)map).hashCode() == currentDataSetDescriptorHash) {
            return currentDataSetDescriptor;
        }
        Vg1pwsDataSetDescriptor vg1pwsDataSetDescriptor = new Vg1pwsDataSetDescriptor(map);
        currentDataSetDescriptor = vg1pwsDataSetDescriptor;
        currentDataSetDescriptorHash = ((Object)map).hashCode();
        return vg1pwsDataSetDescriptor;
    }
}

