/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.apps.vgpws;

import edu.uiowa.physics.pw.apps.vgpws.Spacecraft;
import edu.uiowa.physics.pw.apps.vgpws.Vg1pws;
import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.datum.DatumRangeUtil;
import edu.uiowa.physics.pw.das.datum.TimeUtil;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.graph.StackedHistogramRenderer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class Vg1pwsApplet
extends JApplet {
    Vg1pws app;
    JFrame appFrame;
    DatumRange timeRange;
    File localRootFile;
    boolean waiting;

    private JFrame debuggerHelper() {
        JFrame jFrame = new JFrame("debuggerHelper");
        Box box = new Box(1);
        box.add(new JButton(new AbstractAction("setTimePart"){

            public void actionPerformed(ActionEvent actionEvent) {
                Vg1pwsApplet.this.setTimePart("VG1/1999/T990101_990111.PNG", 2, 10);
            }
        }));
        box.add(new JButton(new AbstractAction("setTimePart2"){

            public void actionPerformed(ActionEvent actionEvent) {
                Vg1pwsApplet.this.setTimePart("VG2/1999/T990101_990111.PNG", 3, 10);
            }
        }));
        jFrame.getContentPane().add(box);
        jFrame.pack();
        jFrame.setVisible(true);
        jFrame.setDefaultCloseOperation(1);
        return jFrame;
    }

    private File getDirectoryFromDocBaseURL(URL uRL, String string) {
        String string2 = uRL.toString();
        String string3 = string2.substring("file:".length());
        int n = string3.indexOf(":");
        if (n != -1) {
            string3 = string3.substring(n - 1);
        }
        if (string3.endsWith("HTM")) {
            n = string3.lastIndexOf("/");
            string3 = string3.substring(0, n);
        }
        File file = new File(string3);
        try {
            File file2 = new File(file, string);
            file2 = file2.getCanonicalFile();
            return file2;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void init() {
        Object object;
        Object object2;
        URL uRL;
        Object object3;
        super.init();
        String string = "???";
        URL uRL2 = this.getClass().getResource("/buildTime.txt");
        if (uRL2 != null) {
            try {
                object3 = new BufferedReader(new InputStreamReader(uRL2.openStream()));
                string = ((BufferedReader)object3).readLine();
                ((BufferedReader)object3).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        DasApplication.getDefaultApplication().setApplet(true);
        DasApplication.getDefaultApplication().setHeadless(false);
        object3 = this.getParameter("startTime");
        String string2 = this.getParameter("endTime");
        String string3 = this.getParameter("timeRange");
        String string4 = this.getParameter("pngFileName");
        String string5 = this.getParameter("subInterval");
        String string6 = this.getParameter("root");
        if (string6 == null) {
            string6 = "../..";
        }
        if (!(uRL = this.getDocumentBase()).getProtocol().equals("file")) {
            String string7 = "docBase protocol must be file://, not " + uRL.getProtocol() + "//";
            JOptionPane.showConfirmDialog(this, string7);
            throw new RuntimeException(string7);
        }
        this.localRootFile = string6.startsWith("/") || string6.charAt(1) == ':' ? new File(string6) : this.getDirectoryFromDocBaseURL(uRL, string6);
        String string8 = this.getParameter("spacecraft");
        this.timeRange = null;
        if (object3 != null) {
            object2 = TimeUtil.createValid((String)object3);
            object = TimeUtil.createValid(string2);
            this.timeRange = new DatumRange((Datum)object2, (Datum)object);
        }
        if (string3 != null) {
            this.timeRange = DatumRangeUtil.parseTimeRangeValid(string3);
        }
        if (string4 != null) {
            object2 = string4.substring(10, 16);
            object = string4.substring(17, 23);
            object2 = object2.substring(0, 2).compareTo("77") < 0 ? "20" + (String)object2 : "19" + (String)object2;
            object = ((String)object).substring(0, 2).compareTo("77") < 0 ? "20" + (String)object : "19" + (String)object;
            DatumRange datumRange = DatumRangeUtil.parseTimeRangeValid((String)object2);
            DatumRange datumRange2 = DatumRangeUtil.parseTimeRangeValid((String)object);
            this.timeRange = new DatumRange(datumRange.min(), datumRange2.min());
            String string9 = string4.substring(0, 3);
            if (string9.equals("VG1")) {
                string8 = "Voyager 1";
            } else if (string9.equals("VG2")) {
                string8 = "Voyager 2";
            }
        }
        if (string8 == null) {
            string8 = "Voyager 1";
        }
        if (!string8.equals("Voyager 1") && !string8.equals("Voyager 2")) {
            throw new IllegalArgumentException("spacecraft must be Voyager 1 or Voyager 2");
        }
        if (string5 != null && this.timeRange != null) {
            object2 = string5.split("of");
            int n = Integer.parseInt(object2[0].trim());
            int n2 = Integer.parseInt(object2[1].trim());
            this.timeRange = this.timeRange.rescale((double)n / (double)n2, (double)(n + 1) / (double)n2);
        }
        this.app = new Vg1pws(true, true, true, Preferences.userNodeForPackage(Vg1pws.class));
        if (this.timeRange != null) {
            this.launch(this.timeRange, Spacecraft.getByName(string8), this.localRootFile);
            this.waiting = false;
        } else {
            this.waiting = true;
        }
    }

    public void setTimePart(final String string, final int n, final int n2) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Vg1pwsApplet.this.setTimePartImmediately(string, n, n2);
            }
        });
    }

    private void setTimePartImmediately(String string, int n, int n2) {
        String string2 = string.substring(10, 16);
        String string3 = string.substring(17, 23);
        string2 = string2.substring(0, 2).compareTo("77") < 0 ? "20" + string2 : "19" + string2;
        string3 = string3.substring(0, 2).compareTo("77") < 0 ? "20" + string3 : "19" + string3;
        DatumRange datumRange = DatumRangeUtil.parseTimeRangeValid(string2);
        DatumRange datumRange2 = DatumRangeUtil.parseTimeRangeValid(string3);
        this.timeRange = new DatumRange(datumRange.min(), datumRange2.min());
        String string4 = string.substring(0, 3);
        Spacecraft spacecraft = null;
        if (string4.equals("VG1")) {
            spacecraft = Spacecraft.voyager1;
        } else if (string4.equals("VG2")) {
            spacecraft = Spacecraft.voyager2;
        } else {
            throw new IllegalArgumentException("bad spacecraft: >>" + string4 + "<<, should be VG1 or VG2");
        }
        this.timeRange = this.timeRange.rescale((double)n / (double)n2, (double)(n + 1) / (double)n2);
        if (this.app.applicationPanel == null) {
            this.launch(this.timeRange, spacecraft, this.localRootFile);
            ((StackedHistogramRenderer)this.app.getPlot().getRenderer(0)).setPeaksIndicator(StackedHistogramRenderer.PeaksIndicator.GrayPeaks);
            this.app.optionsPanel.setRemovePLSInterference(false);
            this.app.optionsPanel.setRemoveSCEvents(false);
        } else {
            this.app.optionsPanel.setSpacecraft(spacecraft);
            this.app.optionsPanel.update();
            this.app.setTimeRange(this.timeRange.min(), this.timeRange.max());
            this.appFrame.setVisible(true);
        }
        this.waiting = false;
        this.repaint();
    }

    public void testPermissions() {
        System.err.println(System.getProperty("java.awt.headless"));
    }

    private void launch(DatumRange datumRange, Spacecraft spacecraft, File file) {
        int n = 700;
        int n2 = 500;
        this.app.optionsPanel.setLocalFileSystemRoot(file);
        this.app.optionsPanel.setSpacecraft(spacecraft);
        this.appFrame = new JFrame("Voyager Low Rate Viewer");
        this.app.applicationPanel = this.app.createApplication(datumRange.min(), datumRange.max(), n, n2);
        this.app.setFrame(this.appFrame);
        this.appFrame.setContentPane(this.app.getApplicationPanel());
        this.appFrame.pack();
        this.appFrame.setVisible(true);
        this.appFrame.setDefaultCloseOperation(1);
        try {
            this.app.optionsPanel.update();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.DARK_GRAY);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(Color.white);
        if (this.waiting) {
            graphics.drawString("waiting", 10, 10);
        } else {
            graphics.drawString("" + this.timeRange, 10, 10);
        }
    }

    public void stop() {
    }

    public void start() {
    }

    public void destroy() {
        if (this.appFrame != null) {
            this.appFrame.dispose();
        }
        super.destroy();
    }

    public Vg1pws getApp() {
        return this.app;
    }

    public DasPlot getPlot() {
        return this.app.getPlot();
    }
}

