/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.apps.vgpws;

import edu.uiowa.physics.pw.apps.vgpws.Spacecraft;
import edu.uiowa.physics.pw.apps.vgpws.TCAComboBoxModel;
import edu.uiowa.physics.pw.apps.vgpws.Vg1pwsReader;
import edu.uiowa.physics.pw.apps.vgpws.VgpwsOptionsPanel;
import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.components.BatchMaster;
import edu.uiowa.physics.pw.das.components.DasTimeRangeSelector;
import edu.uiowa.physics.pw.das.components.TearoffTabbedPane;
import edu.uiowa.physics.pw.das.components.VerticalSpectrogramSlicer;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.datum.TimeUtil;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.format.LatinPrefixDatumFormatter;
import edu.uiowa.physics.pw.das.event.VerticalSlicerMouseModule;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.graph.DasColorBar;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasEventsIndicator;
import edu.uiowa.physics.pw.das.graph.DasLabelAxis;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.graph.DasRow;
import edu.uiowa.physics.pw.das.graph.DataRange;
import edu.uiowa.physics.pw.das.graph.Renderer;
import edu.uiowa.physics.pw.das.graph.SpectrogramRenderer;
import edu.uiowa.physics.pw.das.graph.StackedHistogramRenderer;
import edu.uiowa.physics.pw.das.graph.SymbolLineRenderer;
import edu.uiowa.physics.pw.das.graph.TimeRangeLabel;
import edu.uiowa.physics.pw.das.util.ArgumentList;
import edu.uiowa.physics.pw.das.util.DasDie;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import edu.uiowa.physics.pw.das.util.DasMath;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import edu.uiowa.physics.pw.das.util.Splash;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.EventListener;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class Vg1pws {
    private DasCanvas canvas;
    protected VgpwsOptionsPanel optionsPanel;
    private String tcaDataSetId = null;
    private boolean updating = false;
    private boolean spectrogram = false;
    private DasTimeRangeSelector ts = null;
    private DasPlot plot = null;
    private DasAxis ta = null;
    private DasAxis freqAxis = null;
    protected Renderer renderer = null;
    private DasEventsIndicator eventsIndicator;
    private TCAComboBoxModel comboBoxModel;
    JComboBox tcaSourceSelector;
    private TimeRangeLabel timeRangeLabel = null;
    protected static Preferences prefs;
    private boolean isInteractive;
    private boolean isApplet;
    boolean localOnly;
    private JFrame frame;
    protected JPanel applicationPanel;
    private SymbolLineRenderer fceRenderer;

    public Vg1pws(boolean bl, boolean bl2, boolean bl3, Preferences preferences) {
        this.localOnly = bl;
        this.isApplet = bl2;
        this.isInteractive = bl3;
        prefs = preferences;
        this.frame = null;
        this.optionsPanel = new VgpwsOptionsPanel(this);
        if (bl) {
            this.optionsPanel.setLocalFileSystemRoot(new File("../.."));
            this.optionsPanel.setUseLocalFileSystem();
        }
    }

    private void setAnnotations() {
        if (this.plot != null) {
            String string = "" + this.optionsPanel.getSpacecraft() + " PWS";
            this.plot.setTitle(string);
        }
    }

    public void setTimeRange(Datum datum, Datum datum2) {
        this.ta.setDataRange(datum, datum2);
    }

    protected void setFrame(JFrame jFrame) {
        this.frame = jFrame;
    }

    private ActionListener getTcaActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = Vg1pws.this.comboBoxModel.getTCADataSetId();
                Vg1pws.this.tcaDataSetId = string;
                if (Vg1pws.this.updating) {
                    if (Vg1pws.this.tcaDataSetId.equals("")) {
                        Vg1pws.this.ta.setDrawTca(false);
                    } else {
                        Vg1pws.this.ta.setDataPath(Vg1pws.this.tcaDataSetId);
                        Vg1pws.this.ta.setDrawTca(true);
                    }
                }
            }
        };
    }

    public void close() {
        if (this.isInteractive) {
            prefs.put("startTime", this.plot.getXAxis().getDataMinimum().toString());
            prefs.put("endTime", this.plot.getXAxis().getDataMaximum().toString());
            try {
                prefs.flush();
            }
            catch (BackingStoreException backingStoreException) {
                DasExceptionHandler.handle(backingStoreException);
            }
        }
    }

    private DatumRange swapUnits(DatumRange datumRange, Units units) {
        double d = datumRange.min().doubleValue(datumRange.getUnits());
        double d2 = datumRange.max().doubleValue(datumRange.getUnits());
        return new DatumRange(d, d2, units);
    }

    private DatumRange log10(DatumRange datumRange, Units units) {
        DatumRange datumRange2 = new DatumRange(DasMath.log10(datumRange.min().doubleValue(units)), DasMath.log10(datumRange.max().doubleValue(units)), Units.dimensionless);
        return datumRange2;
    }

    private DatumRange exp10(DatumRange datumRange, Units units) {
        DatumRange datumRange2 = new DatumRange(DasMath.exp10(datumRange.min().doubleValue(Units.dimensionless)), DasMath.exp10(datumRange.max().doubleValue(Units.dimensionless)), units);
        return datumRange2;
    }

    private DatumRange calcFceAxisRange(DatumRange datumRange, DasAxis dasAxis, double d, double d2) {
        double d3 = dasAxis.transform(dasAxis.getDataMinimum());
        double d4 = dasAxis.transform(dasAxis.getDataMaximum());
        double d5 = (d3 - d) / (d2 - d);
        double d6 = (d4 - d) / (d2 - d);
        DatumRange datumRange2 = this.log10(datumRange, datumRange.getUnits());
        datumRange2 = datumRange2.rescale(d5, d6);
        DatumRange datumRange3 = this.exp10(datumRange2, datumRange.getUnits());
        return datumRange3;
    }

    public JPanel createApplication(Datum datum, Datum datum2, int n, int n2) {
        Object object;
        JComponent jComponent;
        Object object2;
        Object object3;
        double[] dArray;
        Object object4;
        Cloneable cloneable;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.canvas = new DasCanvas(n, n2);
        jPanel.add((Component)this.canvas, "Center");
        DasRow dasRow = new DasRow(this.canvas, null, 0.0, 1.0, 2.0, -8.0, 0, 0);
        DasColumn dasColumn = new DasColumn(this.canvas, null, 0.0, 1.0, 6.0, -8.0, 0, 0);
        DasRow dasRow2 = new DasRow(null, dasRow, 1.02, 1.03, 0.0, 0.0, 0, 2);
        this.ta = new DasAxis(datum, datum2, 2);
        this.ta.setRow(dasRow2);
        String string = "electric field (V/m)";
        if (this.spectrogram) {
            cloneable = new DasAxis(Datum.create(10.0), Datum.create(56300.0), 3, true);
            this.freqAxis = new DasAxis(this.swapUnits(((DasAxis)cloneable).getRange(), Units.hertz), 4);
            this.freqAxis.setLog(true);
            this.freqAxis.setTickLabelsVisible(false);
            this.plot = new DasPlot(this.ta, (DasAxis)cloneable);
            object4 = new DasColorBar(Datum.create(1.0E-6), Datum.create(3.0E-4), true);
            ((DasCanvasComponent)object4).setRow(dasRow.createSubRow(0.75, 0.25));
            ((DasCanvasComponent)object4).setColumn(DasColorBar.getColorBarColumn(dasColumn));
            ((DasAxis)object4).setLabel(string);
            this.renderer = new SpectrogramRenderer(null, (DasColorBar)object4){

                public void render(Graphics graphics, DasAxis dasAxis, DasAxis dasAxis2) {
                    if (this.getDataSetDescriptor() == null) {
                        graphics.setColor(Color.DARK_GRAY);
                        String string = "press update to start loading";
                        graphics.drawString(string, dasAxis.getColumn().getDMiddle() - graphics.getFontMetrics().stringWidth(string) / 2, dasAxis2.getRow().getDMiddle());
                    } else {
                        super.render(graphics, dasAxis, dasAxis2);
                    }
                }
            };
            this.plot.addRenderer(this.renderer);
        } else {
            cloneable = new DasAxis(Datum.create(5.0E-7), Datum.create(0.001), 4, true);
            ((DasAxis)cloneable).setLabel(string);
            object4 = new DasColumn(null, dasColumn, 1.0, 1.0, 0.0, 2.5, 0, 0);
            this.canvas.add((DasCanvasComponent)((Object)cloneable), dasRow.createAttachedRow(0.25, 0.75), (DasColumn)object4);
            dArray = Vg1pwsReader.PWSA_freq;
            object3 = Units.dimensionless;
            object2 = DatumVector.newDatumVector(dArray, 0.1, (Units)object3);
            jComponent = new DasLabelAxis((DatumVector)object2, 3);
            ((DasLabelAxis)jComponent).setLabelFormatter(new LatinPrefixDatumFormatter(2));
            this.plot = new DasPlot(this.ta, (DasAxis)jComponent);
            object = ((DasAxis)jComponent).getDatumRange();
            DatumRange datumRange = this.swapUnits((DatumRange)object, Units.hertz);
            this.freqAxis = new DasAxis(datumRange, 4);
            this.freqAxis.setLog(true);
            this.freqAxis.setTickLabelsVisible(false);
            this.freqAxis.setVisible(false);
            StackedHistogramRenderer stackedHistogramRenderer = new StackedHistogramRenderer(this.plot, null, (DasAxis)cloneable, (DasLabelAxis)jComponent, (DatumRange)object){
                final /* synthetic */ DatumRange val$yRange;
                {
                    this.val$yRange = datumRange;
                    super(dasPlot, dataSetDescriptor, dasAxis, dasLabelAxis);
                }

                public void render(Graphics graphics, DasAxis dasAxis, DasAxis dasAxis2) {
                    if (this.getDataSetDescriptor() == null) {
                        graphics.setColor(Color.DARK_GRAY);
                        String string = "press update to start loading";
                        graphics.drawString(string, dasAxis.getColumn().getDMiddle() - graphics.getFontMetrics().stringWidth(string) / 2, dasAxis2.getRow().getDMiddle());
                    } else {
                        super.render(graphics, dasAxis, dasAxis2);
                    }
                }

                public void installRenderer() {
                    super.installRenderer();
                    VerticalSpectrogramSlicer verticalSpectrogramSlicer = VerticalSpectrogramSlicer.createSlicer(Vg1pws.this.plot, new DasAxis(this.val$yRange.min(), this.val$yRange.max(), 2, true), this);
                    VerticalSlicerMouseModule verticalSlicerMouseModule = VerticalSlicerMouseModule.create(this);
                    verticalSlicerMouseModule.addDataPointSelectionListener(verticalSpectrogramSlicer);
                    Vg1pws.this.plot.getMouseAdapter().addMouseModule(verticalSlicerMouseModule);
                }
            };
            this.renderer = stackedHistogramRenderer;
            this.plot.addRenderer(stackedHistogramRenderer);
            stackedHistogramRenderer.setSliceRebinnedData(true);
        }
        this.canvas.add(this.freqAxis, dasRow, dasColumn);
        if (!this.localOnly) {
            this.addFceRendererAxis();
        }
        this.plot.getYAxis().setLabel("frequency (Hz)");
        this.canvas.add(this.plot, dasRow, dasColumn);
        cloneable = this.ta.getDataRange();
        this.timeRangeLabel = new TimeRangeLabel((DataRange)cloneable);
        this.timeRangeLabel.setEmOffset(1.0);
        object4 = this.timeRangeLabel.createDataRangePropertyListener();
        ((DataRange)cloneable).addPropertyChangeListener("log", (PropertyChangeListener)object4);
        ((DataRange)cloneable).addPropertyChangeListener("minimum", (PropertyChangeListener)object4);
        ((DataRange)cloneable).addPropertyChangeListener("maximum", (PropertyChangeListener)object4);
        this.canvas.add(this.timeRangeLabel, dasRow, dasColumn);
        dArray = null;
        this.eventsIndicator = DasEventsIndicator.create((DataSetDescriptor)dArray, this.ta, "eventType");
        this.canvas.add(this.eventsIndicator, dasRow2, dasColumn);
        object3 = new JPanel();
        ((Container)object3).setLayout(new FlowLayout(2));
        this.ts = new DasTimeRangeSelector(datum, datum2);
        ((Container)object3).add(this.ts);
        this.ta.addTimeRangeSelectionListener(this.ts);
        this.ts.addTimeRangeSelectionListener(this.ta);
        object2 = new JButton(this.getPrintAction());
        ((Container)object3).add((Component)object2);
        object2 = new JButton(this.getUpdateAction());
        ((JComponent)object2).setToolTipText("read the data and refresh the plot image");
        ((Container)object3).add((Component)object2);
        object2 = new JButton(this.getQuitAction());
        ((Container)object3).add((Component)object2);
        jPanel.add((Component)object3, "South");
        this.setAnnotations();
        jComponent = new TearoffTabbedPane();
        ((JTabbedPane)jComponent).add("Plot", jPanel);
        ((JTabbedPane)jComponent).add("Options", this.optionsPanel);
        object = new JPanel();
        ((Container)object).setLayout(new BorderLayout());
        ((Container)object).add((Component)jComponent, "Center");
        return object;
    }

    private void addFceRendererAxis() {
        EventListener eventListener;
        try {
            eventListener = this.freqAxis;
            this.fceRenderer = new SymbolLineRenderer(DataSetDescriptor.create("class:edu.uiowa.physics.pw.apps.vgpws.hr.MagDataSetDescriptor?voyager=1&fce=true")){

                public void render(Graphics graphics, DasAxis dasAxis, DasAxis dasAxis2) {
                    super.render(graphics, dasAxis, Vg1pws.this.freqAxis);
                }

                public void updatePlotImage(DasAxis dasAxis, DasAxis dasAxis2, DasProgressMonitor dasProgressMonitor) {
                    super.updatePlotImage(dasAxis, Vg1pws.this.freqAxis, dasProgressMonitor);
                }
            };
            this.fceRenderer.setActive(false);
            this.fceRenderer.setLineWidth(1.0f);
            this.fceRenderer.setColor(this.spectrogram ? Color.WHITE : Color.LIGHT_GRAY);
            this.plot.addRenderer(this.fceRenderer);
        }
        catch (DasException dasException) {
            DasExceptionHandler.handle(dasException);
        }
        eventListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Object object;
                DasAxis dasAxis = Vg1pws.this.plot.getYAxis();
                DatumRange datumRange = Vg1pws.this.swapUnits(dasAxis.getDatumRange(), Units.hertz);
                Datum datum = dasAxis.getDataMaximum();
                Datum datum2 = dasAxis.getDataMinimum();
                double d = dasAxis.transform(datum);
                double d2 = dasAxis.transform(datum2);
                if (dasAxis instanceof DasLabelAxis) {
                    object = (DasLabelAxis)dasAxis;
                    d = ((DasLabelAxis)object).getItemMax(datum) + 1;
                    d2 = ((DasLabelAxis)object).getItemMax(datum2) + 1;
                }
                object = Vg1pws.this.calcFceAxisRange(datumRange, Vg1pws.this.freqAxis, d2, d);
                Vg1pws.this.freqAxis.setDatumRange((DatumRange)object);
            }
        };
        if (this.plot.getYAxis() instanceof DasLabelAxis) {
            DasLabelAxis dasLabelAxis = (DasLabelAxis)this.plot.getYAxis();
            dasLabelAxis.addPropertyChangeListener("labelPositions", (PropertyChangeListener)eventListener);
        } else {
            this.plot.getYAxis().getDataRange().addPropertyChangeListener("minimum", (PropertyChangeListener)eventListener);
            this.plot.getYAxis().getDataRange().addPropertyChangeListener("maximum", (PropertyChangeListener)eventListener);
        }
    }

    public void quit() {
        if (this.isApplet) {
            System.err.println("closing");
            this.close();
            if (this.frame != null) {
                this.frame.setVisible(false);
            }
        } else {
            this.close();
            System.exit(0);
        }
    }

    protected boolean isUpdating() {
        return this.updating;
    }

    private void setUpdating(boolean bl) {
        if (bl) {
            this.updating = true;
            this.optionsPanel.update();
        }
    }

    private Action getUpdateAction() {
        return new AbstractAction("update"){

            public void actionPerformed(ActionEvent actionEvent) {
                Vg1pws.this.setUpdating(true);
            }
        };
    }

    private Action getQuitAction() {
        return new AbstractAction("quit"){

            public void actionPerformed(ActionEvent actionEvent) {
                Vg1pws.this.quit();
            }
        };
    }

    private Action getPrintAction() {
        return new AbstractAction("print"){

            public void actionPerformed(ActionEvent actionEvent) {
                PrinterJob printerJob = PrinterJob.getPrinterJob();
                printerJob.setPrintable(Vg1pws.this.canvas);
                boolean bl = printerJob.printDialog();
                if (bl) {
                    try {
                        printerJob.print();
                    }
                    catch (PrinterException printerException) {
                        DasDie.println(printerException);
                    }
                }
            }
        };
    }

    public DasAxis getTimeAxis() {
        return this.ta;
    }

    public DasCanvas getCanvas() {
        return this.canvas;
    }

    public static void main(String[] stringArray) {
        try {
            Object object;
            Object object2;
            DasApplication.getDefaultApplication();
            if (!DasApplication.isHeadAvailable()) {
                DasApplication.getDefaultApplication().setHeadless(true);
            }
            final ArgumentList argumentList = new ArgumentList("vgpws");
            argumentList.addOptionalPositionArgument(0, "startTime", "", "Start Time");
            argumentList.addOptionalPositionArgument(1, "endTime", "", "End Time");
            argumentList.addOptionalPositionArgument(2, "spacecraft", "", "vg1|vg2");
            argumentList.addOptionalPositionArgument(3, "pngFilename", "", "png Filename");
            argumentList.addBooleanSwitchArgument("commandLinePrefs", "clp", "commandLinePrefs", "get persistent prefs command line, not OS");
            argumentList.addBooleanSwitchArgument("spectrogram", "s", "spectrogram", "use spectrogram");
            argumentList.addOptionalSwitchArgument("peaksIndicator", "pk", "peaksIndicator", "maxLines", "grayPeaks|maxLines");
            argumentList.addOptionalSwitchArgument("height", "h", "height", "600", "canvas height");
            argumentList.addOptionalSwitchArgument("width", "w", "width", "800", "canvas width");
            argumentList.addOptionalSwitchArgument("batchFile", "b", "batchFile", "", "batch description file");
            argumentList.addOptionalSwitchArgument("pngFilenameTemplate", "png", "pngFilenameTemplate", "BEGIN__END.png", "filename template");
            argumentList.addBooleanSwitchArgument("dontExit", "x", "dontExit", "don't exit after running");
            argumentList.addOptionalSwitchArgument("localRoot", "L", "localRoot", "", "set initial root of local data cache");
            argumentList.addBooleanSwitchArgument("local", "l", "local", "force use of local root");
            argumentList.addBooleanSwitchArgument("localOnly", "lo", "localOnly", "don't provide server option");
            argumentList.addBooleanSwitchArgument("headless", "hl", "headless", "force run in headless mode");
            argumentList.process(stringArray);
            if (argumentList.getBooleanValue("headless")) {
                DasApplication.getDefaultApplication().setHeadless(true);
            }
            boolean bl = argumentList.getValue("pngFilename").equals("") && argumentList.getValue("batchFile").equals("");
            Preferences preferences = bl && !argumentList.getBooleanValue("commandLinePrefs") ? Preferences.userNodeForPackage(Vg1pws.class) : argumentList.getPreferences();
            Vg1pws vg1pws = new Vg1pws(argumentList.getBooleanValue("localOnly"), false, bl, preferences);
            if (bl) {
                if (DasApplication.getDefaultApplication().isHeadless()) {
                    argumentList.printUsage();
                    System.out.println("Environment is headless, so pngFilename argument is required");
                    System.exit(0);
                }
                Splash.showSplash();
            }
            vg1pws.spectrogram = argumentList.getBooleanValue("spectrogram");
            if (argumentList.getValue("localRoot").equals("")) {
                object2 = preferences.get(VgpwsOptionsPanel.CURRENT_DIRECTORY_KEY, ".." + File.separator + ".." + File.separator);
                vg1pws.optionsPanel.setLocalFileSystemRoot(new File((String)object2));
            } else {
                vg1pws.optionsPanel.setLocalFileSystemRoot(new File(argumentList.getValue("localRoot")));
            }
            if (argumentList.getBooleanValue("local") || argumentList.getBooleanValue("localOnly")) {
                vg1pws.optionsPanel.setUseLocalFileSystem();
            }
            object2 = null;
            Datum datum = null;
            if (argumentList.getValue("endTime").equals("")) {
                object2 = TimeUtil.createValid(preferences.get("startTime", "1979-3-5"));
                datum = TimeUtil.createValid(preferences.get("endTime", "1979-3-5T04:00"));
            } else {
                try {
                    object2 = TimeUtil.create(argumentList.getValue("startTime"));
                    datum = TimeUtil.create(argumentList.getValue("endTime"));
                }
                catch (ParseException parseException) {
                    System.err.println("Invalid time format");
                    System.exit(-1);
                }
            }
            if (argumentList.getValue("spacecraft").equals("vg1")) {
                vg1pws.optionsPanel.setSpacecraft(Spacecraft.voyager1);
            } else if (argumentList.getValue("spacecraft").equals("vg2")) {
                vg1pws.optionsPanel.setSpacecraft(Spacecraft.voyager2);
            } else if (!argumentList.getValue("spacecraft").equals("")) {
                System.err.println("third argument must be \"vg1\" or \"vg2\"");
                System.exit(-1);
            }
            int n = Integer.parseInt(argumentList.getValue("width"));
            int n2 = Integer.parseInt(argumentList.getValue("height"));
            vg1pws.applicationPanel = vg1pws.createApplication((Datum)object2, datum, n, n2);
            if (argumentList.getValue("peaksIndicator").equals("grayPeaks")) {
                if (vg1pws.plot.getRenderer(0) instanceof StackedHistogramRenderer) {
                    object = (StackedHistogramRenderer)vg1pws.plot.getRenderer(0);
                    ((StackedHistogramRenderer)object).setPeaksIndicator(StackedHistogramRenderer.PeaksIndicator.GrayPeaks);
                } else {
                    System.err.println("ignoring DasStackedHistogram parameter \"peaksIndicator\"");
                }
            }
            object = null;
            if (!DasApplication.getDefaultApplication().isHeadless()) {
                Splash.showSplash();
                object = DasApplication.getDefaultApplication().createMainFrame("vgpws", vg1pws.applicationPanel);
            }
            if (bl) {
                vg1pws.isInteractive = true;
                ((Window)object).setVisible(true);
                Splash.hideSplash();
            } else {
                vg1pws.isInteractive = false;
                vg1pws.optionsPanel.update();
                if (object != null) {
                    ((Window)object).setVisible(true);
                }
                Splash.hideSplash();
                String string = argumentList.getValue("pngFilename");
                if (!string.equals("")) {
                    try {
                        vg1pws.canvas.writeToPng(string);
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException);
                    }
                }
                if (!argumentList.getValue("batchFile").equals("")) {
                    try {
                        vg1pws.canvas.setSize(vg1pws.canvas.getPreferredSize());
                        String string2 = argumentList.getValue("pngFilenameTemplate");
                        vg1pws.optionsPanel.update();
                        BatchMaster batchMaster = BatchMaster.createPngs(vg1pws.getCanvas(), new File(argumentList.getValue("batchFile")), string2);
                        batchMaster.addDataRangeSelectionListener(vg1pws.getTimeAxis());
                        batchMaster.start();
                    }
                    catch (Exception exception) {
                        DasExceptionHandler.handle(exception);
                    }
                }
                if (!vg1pws.isInteractive) {
                    prefs.flush();
                    argumentList.printPrefsSettings();
                }
            }
            if (!argumentList.getValue("pngFilename").equals("")) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (!argumentList.getBooleanValue("dontExit")) {
                            System.exit(0);
                        }
                    }
                });
            }
        }
        catch (Exception exception) {
            DasExceptionHandler.handle(exception);
        }
    }

    protected void setDataSetDescriptor(DataSetDescriptor dataSetDescriptor) {
        this.updating = true;
        this.setAnnotations();
        this.renderer.setDataSetDescriptor(dataSetDescriptor);
    }

    protected void setEventsDataSetDescriptor(DataSetDescriptor dataSetDescriptor) {
        this.updating = true;
        if (this.eventsIndicator != null && this.updating) {
            this.eventsIndicator.setDataSetDescriptor(dataSetDescriptor);
        }
    }

    protected JPanel getApplicationPanel() {
        return this.applicationPanel;
    }

    void setFceRendererActive(boolean bl) {
        if (this.fceRenderer != null) {
            this.fceRenderer.setActive(bl);
        }
    }

    DasPlot getPlot() {
        return this.plot;
    }
}

