/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.apps.vgpws;

import edu.uiowa.physics.pw.apps.vgpws.Spacecraft;
import edu.uiowa.physics.pw.apps.vgpws.Vg1pws;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;

class TCAComboBoxModel
extends AbstractListModel
implements ComboBoxModel {
    private final Vg1pws vg1pws;
    ComboBoxModel m;
    private Map v1tcas = new LinkedHashMap();
    private Map v2tcas = new LinkedHashMap();
    private Map tcas;
    private Object selectedItem;

    public TCAComboBoxModel(Vg1pws vg1pws, Spacecraft spacecraft) {
        this.vg1pws = vg1pws;
        this.v2tcas.put("No Trajectory Parameters", "");
        this.v2tcas.put("v2 Heliocentric Trajectory Parameters", "http://www-pw.physics.uiowa.edu/das/das2Server?voyager2/tca/v2ephemSun");
        this.v2tcas.put("v2 Earth Trajectory Parameters", "http://www-pw.physics.uiowa.edu/das/das2Server?voyager2/tca/v2ephemE");
        this.v2tcas.put("v2 Jupiter Trajectory Parameters", "http://www-pw.physics.uiowa.edu/das/das2Server?voyager2/tca/v2ephemJ");
        this.v2tcas.put("v2 Saturn Trajectory Parameters", "http://www-pw.physics.uiowa.edu/das/das2Server?voyager2/tca/v2ephemS");
        this.v2tcas.put("v2 Uranus Trajectory Parameters", "http://www-pw.physics.uiowa.edu/das/das2Server?voyager2/tca/v2ephemU");
        this.v2tcas.put("v2 Neptune Trajectory Parameters", "http://www-pw.physics.uiowa.edu/das/das2Server?voyager2/tca/v2ephemN");
        this.v1tcas.put("No Trajectory Parameters", "");
        this.v1tcas.put("v1 Heliocentric Trajectory Parameters", "http://www-pw.physics.uiowa.edu/das/das2Server?voyager1/tca/v1ephemSun");
        this.v1tcas.put("v1 Earth Trajectory Parameters", "http://www-pw.physics.uiowa.edu/das/das2Server?voyager1/tca/v1ephemE");
        this.v1tcas.put("v1 Jupiter Trajectory Parameters", "http://www-pw.physics.uiowa.edu/das/das2Server?voyager1/tca/v1ephemJ");
        this.v1tcas.put("v1 Saturn Trajectory Parameters", "http://www-pw.physics.uiowa.edu/das/das2Server?voyager1/tca/v1ephemS");
        this.setSpacecraft(spacecraft);
    }

    public void setSpacecraft(Spacecraft spacecraft) {
        if (this.tcas != null) {
            this.fireIntervalRemoved(this, 0, this.tcas.size());
        }
        this.tcas = spacecraft == Spacecraft.voyager2 ? this.v2tcas : this.v1tcas;
        this.fireIntervalAdded(this, 0, this.tcas.size());
        Object k = this.tcas.keySet().iterator().next();
    }

    public String getTCADataSetId() {
        String string = (String)this.tcas.get(this.selectedItem);
        if (string == null) {
            return "";
        }
        return string;
    }

    public Object getElementAt(int n) {
        Iterator iterator = this.tcas.keySet().iterator();
        for (int i = 0; i < n; ++i) {
            iterator.next();
        }
        return iterator.next();
    }

    public int getSize() {
        return this.tcas.size();
    }

    public Object getSelectedItem() {
        return this.selectedItem;
    }

    public void setSelectedItem(Object object) {
        this.selectedItem = object;
    }
}

