/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.apps.vgpws;

import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.dataset.VectorUtil;
import edu.uiowa.physics.pw.das.dataset.WritableTableDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.Units;

public class NoiseFilter {
    private static double median3(double d, double d2, double d3) {
        double d4;
        if (d > d2) {
            d4 = d;
            d = d2;
            d2 = d4;
        }
        if (d2 > d3) {
            d4 = d2;
            d2 = d3;
            d3 = d4;
        }
        if (d > d2) {
            d4 = d;
            d = d2;
            d2 = d4;
        }
        return d2;
    }

    static WritableTableDataSet medianOfThreeFilter(TableDataSet tableDataSet) {
        if (tableDataSet.tableCount() != 1) {
            throw new IllegalArgumentException("Only simple tables");
        }
        Units units = tableDataSet.getZUnits();
        int n = 16;
        WritableTableDataSet writableTableDataSet = WritableTableDataSet.newEmpty(tableDataSet);
        for (int i = 0; i < n; ++i) {
            writableTableDataSet.setDouble(0, i, tableDataSet.getDouble(0, i, units), units);
            for (int j = 1; j < tableDataSet.getXLength() - 1; ++j) {
                writableTableDataSet.setDouble(j, i, NoiseFilter.median3(tableDataSet.getDouble(j - 1, i, units), tableDataSet.getDouble(j, i, units), tableDataSet.getDouble(j + 1, i, units)), units);
            }
            writableTableDataSet.setDouble(tableDataSet.getXLength() - 1, i, tableDataSet.getDouble(tableDataSet.getXLength() - 1, i, units), units);
        }
        Units units2 = tableDataSet.getXUnits();
        return writableTableDataSet;
    }

    static WritableTableDataSet noiseBurstFilter(TableDataSet tableDataSet) {
        WritableTableDataSet writableTableDataSet = WritableTableDataSet.newCopy(tableDataSet);
        Units units = tableDataSet.getZUnits();
        for (int i = 8; i < tableDataSet.getXLength() - 9; ++i) {
            int n;
            int n2;
            int n3 = 0;
            int n4 = 0;
            Datum datum = tableDataSet.getXTagDatum(i);
            for (n2 = i - 8; n2 < i + 8 + 1; ++n2) {
                if (!(Math.abs(tableDataSet.getXTagDatum(n2).subtract(datum).doubleValue(Units.seconds)) < 144.0)) continue;
                for (n = 0; n < 16; ++n) {
                    ++n4;
                    double d = tableDataSet.getDouble(n2, n, units);
                    if (!(d > 1.0E-5) && (!(d > 0.0) || !(d < 4.0E-7))) continue;
                    ++n3;
                }
            }
            if (n3 <= n4 / 16) continue;
            for (n2 = i - 8; n2 < i + 8 + 1; ++n2) {
                if (!(Math.abs(tableDataSet.getXTagDatum(n2).subtract(datum).doubleValue(Units.seconds)) < 144.0)) continue;
                for (n = 0; n < 16; ++n) {
                    writableTableDataSet.setDouble(n2, n, units.getFillDouble(), units);
                }
            }
        }
        return writableTableDataSet;
    }

    static WritableTableDataSet maximumThresholdFilter(TableDataSet tableDataSet) {
        double[] dArray = new double[]{1.0E31, 1.0E31, 1.0E31, 1.0E31, 1.0E31, 1.0E31, 1.0E31, 1.0E31, 1.0E31, 1.0E31, 1.0E31, 1.0E31, 1.0E31, 1.0E31, 1.0E31, 1.0E31};
        Units units = Units.dimensionless;
        WritableTableDataSet writableTableDataSet = WritableTableDataSet.newCopy(tableDataSet);
        for (int i = 0; i < writableTableDataSet.getXLength(); ++i) {
            for (int j = 0; j < 16; ++j) {
                if (!(writableTableDataSet.getDouble(i, j, units) > dArray[j])) continue;
                writableTableDataSet.setDouble(i, j, units.getFillDouble(), units);
            }
        }
        return writableTableDataSet;
    }

    protected static TableDataSet removeBackground(TableDataSet tableDataSet) {
        int n;
        if (tableDataSet.getXTagDatum(tableDataSet.getXLength() - 1).subtract(tableDataSet.getXTagDatum(0)).gt(Datum.create(1.1, Units.days))) {
            throw new IllegalArgumentException("removeBackground received data set that is longer than a day.  This is not supported.");
        }
        WritableTableDataSet writableTableDataSet = WritableTableDataSet.newCopy(tableDataSet);
        Units units = writableTableDataSet.getZUnits();
        for (n = 0; n < writableTableDataSet.getXLength(); ++n) {
            for (int i = 0; i < 16; ++i) {
                double d = writableTableDataSet.getDouble(n, i, writableTableDataSet.getZUnits());
                if (units.isFill(d)) continue;
                writableTableDataSet.setDouble(n, i, Math.pow(d, 2.0), units);
            }
        }
        for (n = 0; n < 16; ++n) {
            Datum datum = VectorUtil.median(writableTableDataSet.getYSlice(n, 0));
            for (int i = 0; i < writableTableDataSet.getXLength(); ++i) {
                Datum datum2 = writableTableDataSet.getDatum(i, n);
                writableTableDataSet.setDatum(i, n, datum2.subtract(datum));
            }
        }
        return writableTableDataSet;
    }

    public static TableDataSet filter(TableDataSet tableDataSet) {
        WritableTableDataSet writableTableDataSet = NoiseFilter.noiseBurstFilter(tableDataSet);
        writableTableDataSet = NoiseFilter.medianOfThreeFilter(writableTableDataSet);
        writableTableDataSet = NoiseFilter.maximumThresholdFilter(writableTableDataSet);
        return writableTableDataSet;
    }

    public static void main(String[] stringArray) {
        System.out.println(NoiseFilter.median3(1.0, 2.0, 3.0));
        System.out.println(NoiseFilter.median3(2.0, 3.0, 1.0));
        System.out.println(NoiseFilter.median3(3.0, 1.0, 2.0));
        System.out.println(NoiseFilter.median3(2.0, 1.0, 3.0));
        System.out.println(NoiseFilter.median3(1.0, 3.0, 2.0));
        System.out.println(NoiseFilter.median3(3.0, 2.0, 1.0));
    }
}

