/*
 * Decompiled with CFR 0.152.
 */
package xml;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyEditor;
import java.util.EventObject;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import xml.DasForm;
import xml.FormChoice;
import xml.ListOption;
import xml.OptionList;

public class OptionListEditor
extends JButton
implements OptionList,
TableCellEditor,
PropertyEditor {
    EventListenerList listenerList = new EventListenerList();
    ListOption editing;
    JDialog dialog;
    JPanel editorPanel;
    JLabel labelLabel;
    JLabel valueLabel;
    JTextField labelField;
    JTextField valueField;
    JList optionList;
    AllPurposeListener listener = new AllPurposeListener();
    JButton add;
    JButton moveUp;
    JButton moveDown;
    JButton delete;
    JButton commitChanges;
    JButton cancelEdit;
    private final ListModel EMPTY_MODEL = new ListModel(){

        public void addListDataListener(ListDataListener listDataListener) {
        }

        public void removeListDataListener(ListDataListener listDataListener) {
        }

        public Object getElementAt(int n) {
            return "<no data>";
        }

        public int getSize() {
            return 1;
        }
    };
    static /* synthetic */ Class class$javax$swing$event$CellEditorListener;

    public OptionListEditor() {
        super("edit");
        this.addActionListener(this.listener);
        this.labelLabel = new JLabel("label:", 2);
        this.labelField = new JTextField(20);
        this.labelField.addFocusListener(this.listener);
        this.valueLabel = new JLabel("value:", 2);
        this.valueField = new JTextField(20);
        this.valueField.addFocusListener(this.listener);
        this.optionList = new JList(this.EMPTY_MODEL);
        this.optionList.setVisibleRowCount(10);
        this.optionList.setSelectionMode(0);
        this.optionList.addListSelectionListener(this.listener);
        this.editorPanel = new JPanel(new BorderLayout());
        this.editorPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.editorPanel.add(new JScrollPane(this.optionList, 22, 30));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(0, 5, 0, 0));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.add = new JButton("Add");
        this.moveUp = new JButton("Move up");
        this.moveDown = new JButton("Move down");
        this.delete = new JButton("Delete");
        this.add.addActionListener(this.listener);
        this.moveUp.addActionListener(this.listener);
        this.moveDown.addActionListener(this.listener);
        this.delete.addActionListener(this.listener);
        Dimension dimension = this.moveDown.getPreferredSize();
        this.add.setPreferredSize(dimension);
        this.add.setMaximumSize(dimension);
        this.moveUp.setPreferredSize(dimension);
        this.moveUp.setMaximumSize(dimension);
        this.moveDown.setPreferredSize(dimension);
        this.moveDown.setMaximumSize(dimension);
        this.delete.setPreferredSize(dimension);
        this.delete.setMaximumSize(dimension);
        jPanel.add(this.add);
        jPanel.add(this.moveUp);
        jPanel.add(this.moveDown);
        jPanel.add(this.delete);
        this.editorPanel.add((Component)jPanel, "East");
        JPanel jPanel2 = new JPanel();
        this.commitChanges = new JButton("Commit changes");
        this.commitChanges.addActionListener(this.listener);
        this.cancelEdit = new JButton("Cancel Edit");
        this.cancelEdit.addActionListener(this.listener);
        jPanel2.add(this.commitChanges);
        jPanel2.add(this.cancelEdit);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        this.labelLabel.setAlignmentX(0.0f);
        this.labelField.setAlignmentX(0.0f);
        this.valueLabel.setAlignmentX(0.0f);
        this.valueField.setAlignmentX(0.0f);
        jPanel2.setAlignmentX(0.0f);
        jPanel3.add(this.labelLabel);
        jPanel3.add(this.labelField);
        jPanel3.add(this.valueLabel);
        jPanel3.add(this.valueField);
        jPanel3.add(jPanel2);
        this.editorPanel.add((Component)jPanel3, "South");
    }

    public void showDialog() {
        if (this.dialog == null) {
            Window window = SwingUtilities.windowForComponent(this);
            if (window instanceof Dialog) {
                this.dialog = new JDialog((Dialog)window, true);
            } else if (window instanceof Frame) {
                this.dialog = new JDialog((Frame)window, true);
            } else {
                this.dialog = new JDialog();
                this.dialog.setModal(true);
            }
            this.dialog.setContentPane(this.editorPanel);
            this.dialog.pack();
            this.dialog.setResizable(false);
            this.dialog.addWindowListener(this.listener);
        }
        this.dialog.show();
    }

    private void addOption() {
        DefaultListModel defaultListModel = this.getListModel();
        defaultListModel.addElement(new ListOption("label", "value"));
        this.optionList.setSelectedIndex(defaultListModel.getSize() - 1);
    }

    private DefaultListModel getListModel() {
        return (DefaultListModel)this.optionList.getModel();
    }

    private void moveUp(int n) {
        if (n >= 0) {
            if (n == 0) {
                return;
            }
            DefaultListModel defaultListModel = this.getListModel();
            Object e = defaultListModel.getElementAt(n);
            defaultListModel.removeElementAt(n);
            defaultListModel.insertElementAt(e, n - 1);
            this.optionList.setSelectedIndex(n - 1);
        }
    }

    private void moveDown(int n) {
        if (n >= 0) {
            DefaultListModel defaultListModel = this.getListModel();
            if (n == defaultListModel.getSize()) {
                return;
            }
            Object e = defaultListModel.getElementAt(n);
            defaultListModel.removeElementAt(n);
            defaultListModel.insertElementAt(e, n + 1);
            this.optionList.setSelectedIndex(n + 1);
        }
    }

    private void deleteOption(int n) {
        if (n >= 0) {
            DefaultListModel defaultListModel = this.getListModel();
            defaultListModel.removeElementAt(n);
            this.optionList.clearSelection();
        }
    }

    public static void main(String[] stringArray) {
        JPanel jPanel = new JPanel(new BorderLayout());
        DasForm dasForm = new DasForm(true);
        FormChoice formChoice = new FormChoice("fred");
        formChoice.addOption(new ListOption("One", "1"));
        formChoice.addOption(new ListOption("Two", "2"));
        OptionListEditor optionListEditor = new OptionListEditor();
        optionListEditor.setOptions(formChoice.getOptions());
        jPanel.add((Component)formChoice, "Center");
        jPanel.add((Component)optionListEditor, "South");
        JFrame jFrame = new JFrame();
        jFrame.setContentPane(jPanel);
        jFrame.pack();
        jFrame.setDefaultCloseOperation(3);
        jFrame.setVisible(true);
    }

    public ListOption[] getOptions() {
        DefaultListModel defaultListModel = this.getListModel();
        ListOption[] listOptionArray = new ListOption[defaultListModel.getSize()];
        int n = 0;
        while (n < listOptionArray.length) {
            listOptionArray[n] = (ListOption)defaultListModel.getElementAt(n);
            ++n;
        }
        return listOptionArray;
    }

    public void setOptions(ListOption[] listOptionArray) {
        DefaultListModel<ListOption> defaultListModel = new DefaultListModel<ListOption>();
        defaultListModel.ensureCapacity(listOptionArray.length);
        int n = 0;
        while (n < listOptionArray.length) {
            defaultListModel.addElement(listOptionArray[n]);
            ++n;
        }
        this.optionList.setModel(defaultListModel);
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.add(class$javax$swing$event$CellEditorListener == null ? (class$javax$swing$event$CellEditorListener = OptionListEditor.class$("javax.swing.event.CellEditorListener")) : class$javax$swing$event$CellEditorListener, cellEditorListener);
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled();
        this.dialog.setVisible(false);
    }

    public Object getCellEditorValue() {
        return this.getOptions();
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        ListOption[] listOptionArray = (ListOption[])object;
        if (this.dialog != null && this.dialog.isVisible()) {
            this.dialog.setVisible(false);
        }
        this.setOptions(listOptionArray);
        return this;
    }

    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.remove(class$javax$swing$event$CellEditorListener == null ? (class$javax$swing$event$CellEditorListener = OptionListEditor.class$("javax.swing.event.CellEditorListener")) : class$javax$swing$event$CellEditorListener, cellEditorListener);
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    public boolean stopCellEditing() {
        this.fireEditingStopped();
        this.dialog.setVisible(false);
        return true;
    }

    private void fireEditingCanceled() {
        ChangeEvent changeEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$CellEditorListener == null ? OptionListEditor.class$("javax.swing.event.CellEditorListener") : class$javax$swing$event$CellEditorListener)) {
                if (changeEvent == null) {
                    changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)objectArray[n + 1]).editingCanceled(changeEvent);
            }
            n -= 2;
        }
    }

    private void fireEditingStopped() {
        ChangeEvent changeEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$CellEditorListener == null ? OptionListEditor.class$("javax.swing.event.CellEditorListener") : class$javax$swing$event$CellEditorListener)) {
                if (changeEvent == null) {
                    changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)objectArray[n + 1]).editingStopped(changeEvent);
            }
            n -= 2;
        }
    }

    public String getAsText() {
        return null;
    }

    public Component getCustomEditor() {
        return this;
    }

    public String getJavaInitializationString() {
        return "???";
    }

    public String[] getTags() {
        return null;
    }

    public Object getValue() {
        return this.getOptions();
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    public void setAsText(String string) throws IllegalArgumentException {
        throw new IllegalArgumentException();
    }

    public void setValue(Object object) {
        this.setOptions((ListOption[])object);
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class AllPurposeListener
    implements ActionListener,
    ListSelectionListener,
    FocusListener,
    WindowListener {
        private AllPurposeListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == OptionListEditor.this) {
                OptionListEditor.this.showDialog();
            } else if (object == OptionListEditor.this.add) {
                OptionListEditor.this.addOption();
            } else if (object == OptionListEditor.this.moveUp) {
                OptionListEditor.this.moveUp(OptionListEditor.this.optionList.getSelectedIndex());
            } else if (object == OptionListEditor.this.moveDown) {
                OptionListEditor.this.moveDown(OptionListEditor.this.optionList.getSelectedIndex());
            } else if (object == OptionListEditor.this.delete) {
                OptionListEditor.this.deleteOption(OptionListEditor.this.optionList.getSelectedIndex());
            } else if (object == OptionListEditor.this.commitChanges) {
                OptionListEditor.this.stopCellEditing();
            } else if (object == OptionListEditor.this.cancelEdit) {
                OptionListEditor.this.cancelCellEditing();
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            int n = OptionListEditor.this.optionList.getSelectedIndex();
            if (n >= 0) {
                OptionListEditor.this.editing = (ListOption)OptionListEditor.this.getListModel().getElementAt(n);
                OptionListEditor.this.labelField.setText(OptionListEditor.this.editing.getLabel());
                OptionListEditor.this.valueField.setText(OptionListEditor.this.editing.getValue());
            } else {
                OptionListEditor.this.editing = null;
                OptionListEditor.this.labelField.setText("");
                OptionListEditor.this.valueField.setText("");
            }
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            if (OptionListEditor.this.editing != null) {
                if (focusEvent.getComponent() == OptionListEditor.this.labelField) {
                    OptionListEditor.this.editing.setLabel(OptionListEditor.this.labelField.getText());
                    OptionListEditor.this.optionList.repaint();
                } else if (focusEvent.getComponent() == OptionListEditor.this.valueField) {
                    OptionListEditor.this.editing.setValue(OptionListEditor.this.valueField.getText());
                }
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            OptionListEditor.this.fireEditingCanceled();
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }
    }
}

