/*
 * Decompiled with CFR 0.152.
 */
package xml;

import components.PropertyEditor;
import das.DasNameException;
import das.NameContext;
import graph.dnd.TransferableCanvas;
import graph.pwCanvas;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import util.DasExceptionHandler;
import util.DnDSupport;
import xml.DasForm;
import xml.DasPropertyException;
import xml.FormComponent;
import xml.FormContainer;
import xml.FormPanel;
import xml.ParsedExpressionException;
import xml.TransferableFormComponent;

public class FormWindow
extends FormContainer
implements PropertyEditor.Editable,
FormComponent {
    DasForm form;
    JDialog dialog;
    String title = "";
    int preferredWidth;
    int preferredHeight;
    boolean shouldBeVisible = false;
    private String dasName;

    public FormWindow(String string, String string2, int n, int n2) {
        this.flavorList = Arrays.asList(TransferableFormComponent.BUTTONGROUP_FLAVOR, TransferableFormComponent.BUTTON_FLAVOR, TransferableFormComponent.CHECKBOX_FLAVOR, TransferableFormComponent.CHOICE_FLAVOR, TransferableFormComponent.PANEL_FLAVOR, TransferableFormComponent.TEXTFIELD_FLAVOR, TransferableFormComponent.TEXT_FLAVOR, TransferableCanvas.CANVAS_FLAVOR);
        this.setLayout(new BorderLayout());
        this.title = string2;
        this.preferredWidth = n;
        this.preferredHeight = n2;
        if (string == null) {
            string = "window_" + Integer.toHexString(System.identityHashCode(this));
        }
        try {
            this.setDasName(string);
        }
        catch (DasNameException dasNameException) {
            DasExceptionHandler.handle(dasNameException);
        }
        this.dndSupport = new FormContainer.ContainerDnDSupport(null);
    }

    FormWindow(Element element, DasForm dasForm) throws DasPropertyException, DasNameException, ParsedExpressionException, SAXException {
        this.flavorList = Arrays.asList(TransferableFormComponent.BUTTONGROUP_FLAVOR, TransferableFormComponent.BUTTON_FLAVOR, TransferableFormComponent.CHECKBOX_FLAVOR, TransferableFormComponent.CHOICE_FLAVOR, TransferableFormComponent.PANEL_FLAVOR, TransferableFormComponent.TEXTFIELD_FLAVOR, TransferableFormComponent.TEXT_FLAVOR, TransferableCanvas.CANVAS_FLAVOR);
        this.setLayout(new BorderLayout());
        this.form = dasForm;
        String string = element.getAttribute("name");
        String string2 = element.getAttribute("title");
        String string3 = element.getAttribute("alignment");
        int n = Integer.parseInt(element.getAttribute("width"));
        int n2 = Integer.parseInt(element.getAttribute("height"));
        Point point = FormWindow.parsePoint(element.getAttribute("location"));
        boolean bl = element.getAttribute("visible").equals("true");
        NodeList nodeList = element.getChildNodes();
        int n3 = 0;
        while (n3 < nodeList.getLength()) {
            JComponent jComponent;
            Node node = nodeList.item(n3);
            if (node instanceof Element && node.getNodeName().equals("panel")) {
                jComponent = new FormPanel((Element)node, dasForm);
                this.add(jComponent);
            } else if (node instanceof Element && node.getNodeName().equals("canvas")) {
                jComponent = pwCanvas.processCanvasElement((Element)node, dasForm);
                this.add(jComponent);
            }
            ++n3;
        }
        this.setTitle(string2);
        this.preferredWidth = n;
        this.preferredHeight = n2;
        this.setWindowVisible(bl);
        try {
            this.setDasName(string);
        }
        catch (DasNameException dasNameException) {
            DasExceptionHandler.handle(dasNameException);
        }
        this.dndSupport = new FormContainer.ContainerDnDSupport(null);
    }

    private static Point parsePoint(String string) {
        int n = string.indexOf(44);
        return new Point(Integer.parseInt(string.substring(1, n)), Integer.parseInt(string.substring(n + 1, string.length() - 1)));
    }

    public DasForm getForm() {
        return this.form;
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("window");
        element.setAttribute("name", this.getDasName());
        element.setAttribute("width", String.valueOf(this.getWidth()));
        element.setAttribute("height", String.valueOf(this.getHeight()));
        element.setAttribute("title", this.title);
        element.setAttribute("visible", String.valueOf(this.isVisible()));
        if (this.getComponentCount() > 0) {
            Component component = this.getComponent(0);
            if (component instanceof FormComponent) {
                FormComponent formComponent = (FormComponent)((Object)component);
                element.appendChild(formComponent.getDOMElement(document));
            } else if (component instanceof pwCanvas) {
                pwCanvas pwCanvas2 = (pwCanvas)component;
                element.appendChild(pwCanvas2.getDOMElement(document));
            }
        }
        return element;
    }

    public String getDasName() {
        return this.dasName;
    }

    public void setDasName(String string) throws DasNameException {
        if (string.equals(this.dasName)) {
            return;
        }
        String string2 = this.dasName;
        this.dasName = string;
        NameContext.getDefaultNameContext().put(string, this);
        if (string2 != null) {
            NameContext.getDefaultNameContext().remove(string2);
        }
        this.firePropertyChange("name", string2, string);
    }

    public boolean isWindowVisible() {
        if (this.getEditingMode()) {
            return this.shouldBeVisible;
        }
        return this.dialog == null ? false : this.dialog.isVisible();
    }

    public void setWindowVisible(boolean bl) {
        boolean bl2 = this.isWindowVisible();
        if (bl2 == bl) {
            return;
        }
        this.shouldBeVisible = bl;
        if (!this.getEditingMode() && bl) {
            if (this.dialog == null) {
                this.initDialog();
            }
            this.dialog.setVisible(bl);
        }
        this.firePropertyChange("visible", bl2, bl);
    }

    public void setEditingMode(boolean bl) {
        if (this.getEditingMode() == bl) {
            return;
        }
        if (bl) {
            if (this.dialog != null) {
                this.shouldBeVisible = this.dialog.isVisible();
                this.dialog.setVisible(false);
            } else {
                this.shouldBeVisible = false;
            }
        } else if (this.dialog != null) {
            this.dialog.setContentPane(this);
            this.dialog.pack();
            this.dialog.setVisible(this.shouldBeVisible);
        } else if (this.shouldBeVisible) {
            this.initDialog();
            this.dialog.pack();
            this.dialog.setVisible(this.shouldBeVisible);
        }
        super.setEditingMode(bl);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        if (this.title == string || this.title != null && this.title.equals(string)) {
            return;
        }
        String string2 = this.title;
        this.title = string;
        if (this.getEditingMode()) {
            DasForm dasForm = this.getForm();
            dasForm.setTitleAt(dasForm.indexOfComponent(this), string);
        }
        this.firePropertyChange("title", string2, string);
    }

    public void pack() {
        if (this.dialog == null) {
            this.initDialog();
        }
        this.dialog.pack();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.preferredWidth, this.preferredHeight);
    }

    private void initDialog() {
        Window window = SwingUtilities.getWindowAncestor(this.form);
        this.dialog = window instanceof Frame ? new JDialog((Frame)window) : (window instanceof Dialog ? new JDialog((Dialog)window) : new JDialog());
        this.dialog.setContentPane(this);
        this.dialog.setTitle(this.title);
    }

    public DnDSupport getDnDSupport() {
        if (this.dndSupport == null) {
            this.dndSupport = new FormContainer.ContainerDnDSupport(null);
        }
        return this.dndSupport;
    }

    protected void addImpl(Component component, Object object, int n) {
        if (this.getComponentCount() >= 1) {
            throw new IllegalArgumentException("Only one component allowed");
        }
        super.addImpl(component, object, n);
        if (component instanceof JComponent) {
            ((JComponent)component).setAlignmentY(0.0f);
        }
    }
}

