/*
 * Decompiled with CFR 0.152.
 */
package xml;

import components.PropertyEditor;
import das.DasNameException;
import das.NameContext;
import java.awt.event.MouseEvent;
import javax.swing.JTextField;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import util.DasExceptionHandler;
import util.DnDSupport;
import xml.DasForm;
import xml.DasPropertyException;
import xml.DefaultComponentDnDSupport;
import xml.FormComponent;
import xml.ParsedExpressionException;

public class FormTextField
extends JTextField
implements PropertyEditor.Editable,
FormComponent {
    private String dasName;
    protected DnDSupport dndSupport;
    private boolean editingMode;

    public FormTextField(String string) {
        super(10);
        if (string == null) {
            string = "textfield_" + Integer.toHexString(System.identityHashCode(this));
        }
        try {
            this.setDasName(string);
        }
        catch (DasNameException dasNameException) {
            DasExceptionHandler.handle(dasNameException);
        }
        this.setMinimumSize(this.getPreferredSize());
        this.setMaximumSize(this.getPreferredSize());
    }

    public FormTextField(Element element, DasForm dasForm) throws DasPropertyException, DasNameException, ParsedExpressionException {
        String string = element.getAttribute("name");
        int n = Integer.parseInt(element.getAttribute("length"));
        this.setColumns(n);
        this.setMinimumSize(this.getPreferredSize());
        this.setMaximumSize(this.getPreferredSize());
        NodeList nodeList = element.getChildNodes();
        int n2 = nodeList.getLength();
        int n3 = 0;
        while (n3 < n2) {
            if (nodeList.item(n3) instanceof Text) {
                Text text = (Text)nodeList.item(n3);
                this.setText(text.getData());
                break;
            }
            ++n3;
        }
        try {
            this.setDasName(string);
        }
        catch (DasNameException dasNameException) {
            DasExceptionHandler.handle(dasNameException);
        }
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("textfield");
        Text text = document.createTextNode(this.getText());
        element.appendChild(text);
        element.setAttribute("name", this.getDasName());
        element.setAttribute("enabled", this.isEnabled() ? "true" : "false");
        element.setAttribute("length", Integer.toString(this.getColumns()));
        return element;
    }

    public DasForm getForm() {
        FormComponent formComponent = (FormComponent)((Object)this.getParent());
        if (formComponent == null) {
            return null;
        }
        return formComponent.getForm();
    }

    public DnDSupport getDnDSupport() {
        if (this.dndSupport == null) {
            this.dndSupport = new DefaultComponentDnDSupport(this);
        }
        return this.dndSupport;
    }

    public boolean startDrag(int n, int n2, int n3, MouseEvent mouseEvent) {
        return false;
    }

    public void setEditingMode(boolean bl) {
        this.editingMode = bl;
    }

    public boolean getEditingMode() {
        return this.editingMode;
    }

    public String getDasName() {
        return this.dasName;
    }

    public void setDasName(String string) throws DasNameException {
        if (string.equals(this.dasName)) {
            return;
        }
        String string2 = this.dasName;
        this.dasName = string;
        NameContext.getDefaultNameContext().put(string, this);
        if (string2 != null) {
            NameContext.getDefaultNameContext().remove(string2);
        }
        this.firePropertyChange("name", string2, string);
    }
}

