/*
 * Decompiled with CFR 0.152.
 */
package xml;

import das.DasNameException;
import das.NameContext;
import graph.dnd.TransferableCanvas;
import graph.pwCanvas;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.util.Arrays;
import javax.swing.JComponent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import util.DasExceptionHandler;
import util.DnDSupport;
import xml.DasForm;
import xml.DasPropertyException;
import xml.FormButton;
import xml.FormCheckBox;
import xml.FormChoice;
import xml.FormComponent;
import xml.FormContainer;
import xml.FormList;
import xml.FormPanel;
import xml.FormRadioButtonGroup;
import xml.FormText;
import xml.FormTextField;
import xml.Orientation;
import xml.ParsedExpressionException;
import xml.TransferableFormComponent;

public class FormTab
extends FormContainer {
    private String label;
    private String dasName;

    public FormTab(String string, String string2) {
        DataFlavor[] dataFlavorArray = new DataFlavor[]{TransferableFormComponent.BUTTONGROUP_FLAVOR, TransferableFormComponent.BUTTON_FLAVOR, TransferableFormComponent.CHECKBOX_FLAVOR, TransferableFormComponent.CHOICE_FLAVOR, TransferableFormComponent.PANEL_FLAVOR, TransferableFormComponent.TEXTFIELD_FLAVOR, TransferableFormComponent.TEXT_FLAVOR, TransferableCanvas.CANVAS_FLAVOR};
        this.flavorList = Arrays.asList(dataFlavorArray);
        this.setDirection(Orientation.VERTICAL);
        if (string == null) {
            string = "form_" + Integer.toHexString(System.identityHashCode(this));
        }
        try {
            this.setDasName(string);
        }
        catch (DasNameException dasNameException) {
            DasExceptionHandler.handle(dasNameException);
        }
        this.label = string2;
        this.dndSupport = new FormContainer.ContainerDnDSupport(this, null);
    }

    FormTab(Element element, DasForm dasForm) throws DasPropertyException, DasNameException, ParsedExpressionException, SAXException {
        Object object = new DataFlavor[]{TransferableFormComponent.BUTTONGROUP_FLAVOR, TransferableFormComponent.BUTTON_FLAVOR, TransferableFormComponent.CHECKBOX_FLAVOR, TransferableFormComponent.CHOICE_FLAVOR, TransferableFormComponent.PANEL_FLAVOR, TransferableFormComponent.TEXTFIELD_FLAVOR, TransferableFormComponent.TEXT_FLAVOR, TransferableCanvas.CANVAS_FLAVOR};
        this.flavorList = Arrays.asList(object);
        object = element.getAttribute("alignment");
        this.horizontalComponentAlignment = ((String)object).equals("left") ? 0.0f : (((String)object).equals("right") ? 1.0f : 0.5f);
        String string = element.getAttribute("name");
        String string2 = element.getAttribute("label");
        this.setDirection(Orientation.VERTICAL);
        try {
            this.setDasName(string);
        }
        catch (DasNameException dasNameException) {
            DasExceptionHandler.handle(dasNameException);
        }
        if (string2.equals("")) {
            this.setLabel(string);
        } else {
            this.setLabel(string2);
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node instanceof Element) {
                JComponent jComponent;
                String string3 = node.getNodeName();
                if (string3.equals("panel")) {
                    jComponent = new FormPanel((Element)node, dasForm);
                    this.add(jComponent);
                } else if (string3.equals("text") || string3.equals("info")) {
                    jComponent = new FormText((Element)node);
                    this.add(jComponent);
                } else if (string3.equals("textfield")) {
                    jComponent = new FormTextField((Element)node, dasForm);
                    this.add(jComponent);
                } else if (string3.equals("button")) {
                    jComponent = new FormButton((Element)node, dasForm);
                    this.add(jComponent);
                } else if (string3.equals("checkbox")) {
                    jComponent = new FormCheckBox((Element)node, dasForm);
                    this.add(jComponent);
                } else if (string3.equals("list")) {
                    jComponent = new FormList((Element)node, dasForm);
                    this.add(jComponent);
                } else if (string3.equals("choice")) {
                    jComponent = new FormChoice((Element)node, dasForm);
                    this.add(jComponent);
                } else if (string3.equals("glue")) {
                    this.add(dasForm.processGlueElement((Element)node));
                } else if (string3.equals("buttongroup")) {
                    this.add(new FormRadioButtonGroup((Element)node, dasForm));
                } else if (string3.equals("canvas")) {
                    try {
                        jComponent = pwCanvas.processCanvasElement((Element)node, dasForm);
                        jComponent.setAlignmentX(this.horizontalComponentAlignment);
                        this.add(jComponent);
                    }
                    catch (DasNameException dasNameException) {
                        // empty catch block
                    }
                }
            }
            ++n2;
        }
        this.dndSupport = new FormContainer.ContainerDnDSupport(this, null);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
        DasForm dasForm = this.getForm();
        if (dasForm != null) {
            dasForm.setTitleAt(this.getForm().indexOfComponent(this), string);
        }
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("form");
        element.setAttribute("name", this.getDasName());
        element.setAttribute("label", this.getLabel());
        int n = 0;
        while (n < this.getComponentCount()) {
            Element element2;
            FormComponent formComponent;
            Component component = this.getComponent(n);
            if (component instanceof FormComponent) {
                formComponent = (FormComponent)((Object)component);
                element2 = formComponent.getDOMElement(document);
                element.appendChild(element2);
            } else if (component instanceof pwCanvas) {
                formComponent = (pwCanvas)component;
                element2 = ((pwCanvas)formComponent).getDOMElement(document);
                element.appendChild(element2);
            }
            ++n;
        }
        return element;
    }

    public String getDasName() {
        return this.dasName;
    }

    public void setDasName(String string) throws DasNameException {
        if (string.equals(this.dasName)) {
            return;
        }
        String string2 = this.dasName;
        this.dasName = string;
        NameContext.getDefaultNameContext().put(string, this);
        if (string2 != null) {
            NameContext.getDefaultNameContext().remove(string2);
        }
        this.firePropertyChange("name", string2, string);
    }

    public DnDSupport getDnDSupport() {
        if (this.dndSupport == null) {
            this.dndSupport = new FormContainer.ContainerDnDSupport(this, null);
        }
        return this.dndSupport;
    }
}

