/*
 * Decompiled with CFR 0.152.
 */
package xml;

import components.PropertyEditor;
import das.DasNameException;
import das.NameContext;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.basic.BasicListUI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import util.DasExceptionHandler;
import util.DnDSupport;
import xml.DasForm;
import xml.DasPropertyException;
import xml.DefaultComponentDnDSupport;
import xml.FormComponent;
import xml.ListOption;
import xml.ParsedExpressionException;

public class FormList
extends JList
implements PropertyEditor.Editable,
FormComponent {
    private String delimiter = " ";
    protected DnDSupport dndSupport;
    private String dasName;
    private boolean editable;

    public FormList(String string) {
        try {
            this.setDasName(string);
        }
        catch (DasNameException dasNameException) {
            DasExceptionHandler.handle(dasNameException);
        }
    }

    FormList(Element element, DasForm dasForm) throws DasPropertyException, DasNameException, ParsedExpressionException {
        super(new OptionListModel());
        String string = element.getAttribute("name");
        String string2 = element.getAttribute("selectionMode");
        if (string2.equals("single")) {
            this.setSelectionMode(0);
        } else if (string2.equals("multiple")) {
            this.setSelectionMode(2);
        }
        this.setDelimiter(element.getAttribute("delimiter"));
        this.setEnabled(element.getAttribute("enabled").equals("true"));
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node instanceof Element && node.getNodeName().equals("option")) {
                this.processOptionElement((Element)node);
            }
            ++n2;
        }
        this.setMinimumSize(this.getPreferredSize());
        this.setMaximumSize(this.getPreferredSize());
        try {
            this.setDasName(string);
        }
        catch (DasNameException dasNameException) {
            DasExceptionHandler.handle(dasNameException);
        }
    }

    private void processOptionElement(Element element) {
        ListOption listOption = new ListOption(element);
        ((OptionListModel)this.getModel()).list.add(listOption);
        boolean bl = element.getAttribute("selected").equals("true");
        if (bl) {
            this.addSelectionInterval(this.getModel().getSize() - 1, this.getModel().getSize() - 1);
        }
    }

    public void addMouseListener(MouseListener mouseListener) {
        if (mouseListener instanceof BasicListUI.MouseInputHandler) {
            mouseListener = new CtrlDownMouseInputListener((MouseInputListener)mouseListener);
        }
        super.addMouseListener(mouseListener);
    }

    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        if (mouseMotionListener instanceof BasicListUI.MouseInputHandler) {
            mouseMotionListener = new CtrlDownMouseInputListener((MouseInputListener)mouseMotionListener);
        }
        super.addMouseMotionListener(mouseMotionListener);
    }

    public void addItem(ListOption listOption) {
        ((OptionListModel)this.getModel()).list.add(listOption);
    }

    public ListOption getItem(int n) {
        return (ListOption)((OptionListModel)this.getModel()).list.get(n);
    }

    public int getItemCount() {
        return ((OptionListModel)this.getModel()).list.size();
    }

    public void setDelimiter(String string) {
        this.delimiter = string;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public String getSelected() {
        Object[] objectArray = this.getSelectedValues();
        if (objectArray.length == 0) {
            return "";
        }
        String string = ((ListOption)objectArray[0]).getValue();
        int n = 1;
        while (n < objectArray.length) {
            string = string + this.delimiter + ((ListOption)objectArray[n]).getValue();
            ++n;
        }
        return string;
    }

    void setSelected(Object object, boolean bl) {
        OptionListModel optionListModel = (OptionListModel)this.getModel();
        int n = 0;
        while (n < optionListModel.list.size() && optionListModel.list.get(n) != object) {
            ++n;
        }
        if (optionListModel.list.get(n) != object) {
            return;
        }
        if (bl) {
            this.addSelectionInterval(n, n);
        } else {
            this.removeSelectionInterval(n, n);
        }
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("list");
        element.setAttribute("name", this.getDasName());
        element.setAttribute("delimiter", this.delimiter);
        element.setAttribute("enabled", this.isEnabled() ? "true" : "false");
        int n = 0;
        while (n < this.getItemCount()) {
            element.appendChild(this.getItem(0).getDOMElement(document));
            ++n;
        }
        return element;
    }

    public DasForm getForm() {
        FormComponent formComponent = (FormComponent)((Object)this.getParent());
        if (formComponent == null) {
            return null;
        }
        return formComponent.getForm();
    }

    public boolean getEditingMode() {
        return this.editable;
    }

    public void setEditingMode(boolean bl) {
        this.editable = bl;
    }

    public DnDSupport getDnDSupport() {
        if (this.dndSupport == null) {
            this.dndSupport = new DefaultComponentDnDSupport(this);
        }
        return this.dndSupport;
    }

    public boolean startDrag(int n, int n2, int n3, MouseEvent mouseEvent) {
        return false;
    }

    public String getDasName() {
        return this.dasName;
    }

    public void setDasName(String string) throws DasNameException {
        if (string.equals(this.dasName)) {
            return;
        }
        String string2 = this.dasName;
        this.dasName = string;
        NameContext.getDefaultNameContext().put(string, this);
        if (string2 != null) {
            NameContext.getDefaultNameContext().remove(string2);
        }
        this.firePropertyChange("name", string2, string);
    }

    private static class OptionListModel
    extends AbstractListModel {
        List list = new ArrayList();

        private OptionListModel() {
        }

        public Object getElementAt(int n) {
            return this.list.get(n);
        }

        public int getSize() {
            return this.list.size();
        }
    }

    private static class CtrlDownMouseInputListener
    extends MouseInputAdapter {
        private MouseInputListener listener;

        public CtrlDownMouseInputListener(MouseInputListener mouseInputListener) {
            this.listener = mouseInputListener;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.listener.mousePressed(new CtrlDownMouseEvent(mouseEvent));
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.listener.mouseReleased(new CtrlDownMouseEvent(mouseEvent));
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.listener.mouseDragged(new CtrlDownMouseEvent(mouseEvent));
        }
    }

    private static class CtrlDownMouseEvent
    extends MouseEvent {
        private static final int CTRL_YES = 130;
        private static final int SHIFT_NO = -66;

        public CtrlDownMouseEvent(MouseEvent mouseEvent) {
            super(mouseEvent.getComponent(), mouseEvent.getID(), mouseEvent.getWhen(), (mouseEvent.getModifiers() | 0x82) & 0xFFFFFFBE, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
        }
    }
}

