/*
 * Decompiled with CFR 0.152.
 */
package xml;

import components.PropertyEditor;
import das.DasApplication;
import das.DasNameException;
import das.NameContext;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import util.DasExceptionHandler;
import util.DnDSupport;
import xml.CommandAction;
import xml.CommandBlock;
import xml.DasForm;
import xml.DasPropertyException;
import xml.DefaultComponentDnDSupport;
import xml.FormComponent;
import xml.ParsedExpressionException;

public class FormButton
extends JButton
implements PropertyEditor.Editable,
FormComponent {
    CommandAction commandAction;
    CommandBlock commandBlock;
    private boolean editable;
    private String dasName;
    protected DnDSupport dndSupport;

    public FormButton(String string, String string2) {
        super(string2);
        if (string == null) {
            string = "button_" + Integer.toHexString(System.identityHashCode(this));
        }
        try {
            this.setDasName(string);
        }
        catch (DasNameException dasNameException) {
            DasExceptionHandler.handle(dasNameException);
        }
    }

    FormButton(Element element, DasForm dasForm) throws DasPropertyException, ParsedExpressionException {
        String string = element.getAttribute("name");
        String string2 = element.getAttribute("label");
        boolean bl = element.getAttribute("enabled").equals("true");
        this.setText(string2);
        this.setEnabled(bl);
        if (!string.equals("")) {
            DasApplication.getDefaultApplication().getNameContext().put(string, this);
            try {
                this.setDasName(string);
            }
            catch (DasNameException dasNameException) {
                DasExceptionHandler.handle(dasNameException);
            }
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (node instanceof Element && node.getNodeName().equals("action")) {
                Element element2 = (Element)node;
                this.commandBlock = new CommandBlock(element2, dasForm);
                this.commandAction = new CommandAction(this.commandBlock);
                this.addActionListener(this.commandAction);
            }
            ++n2;
        }
    }

    public CommandBlock getFormAction() {
        return this.commandBlock;
    }

    public void setFormAction(CommandBlock commandBlock) {
        if (commandBlock == this.commandBlock) {
            return;
        }
        if (this.commandBlock != null) {
            this.removeActionListener(this.commandAction);
        }
        if (commandBlock == null) {
            this.commandAction = null;
            this.commandBlock = null;
        } else {
            this.commandBlock = commandBlock;
            this.commandAction = new CommandAction(this.commandBlock);
            this.addActionListener(this.commandAction);
        }
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("button");
        element.setAttribute("name", this.getDasName());
        element.setAttribute("label", this.getText());
        element.setAttribute("enabled", String.valueOf(this.isEnabled()));
        if (this.commandBlock != null) {
            Element element2 = document.createElement("action");
            this.commandBlock.appendDOMElements(element2);
            element.appendChild(element2);
        }
        return element;
    }

    public String getDasName() {
        return this.dasName;
    }

    public void setDasName(String string) throws DasNameException {
        if (string.equals(this.dasName)) {
            return;
        }
        String string2 = this.dasName;
        this.dasName = string;
        NameContext.getDefaultNameContext().put(string, this);
        if (string2 != null) {
            NameContext.getDefaultNameContext().remove(string2);
        }
        this.firePropertyChange("name", string2, string);
    }

    public DasForm getForm() {
        FormComponent formComponent = (FormComponent)((Object)this.getParent());
        if (formComponent == null) {
            return null;
        }
        return formComponent.getForm();
    }

    public boolean getEditingMode() {
        return this.editable;
    }

    public void setEditingMode(boolean bl) {
        this.editable = bl;
    }

    public DnDSupport getDnDSupport() {
        if (this.dndSupport == null) {
            this.dndSupport = new DefaultComponentDnDSupport(this);
        }
        return this.dndSupport;
    }

    public boolean startDrag(int n, int n2, int n3, MouseEvent mouseEvent) {
        return false;
    }
}

