/*
 * Decompiled with CFR 0.152.
 */
package xml;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import util.pwDie;

public class DasMLValidator
extends DefaultHandler {
    public static Pattern INTEGER_PATTERN = Pattern.compile("(0|[1-9][0-9]*)");
    public static Pattern WINDOW_POSITION_PATTERN = Pattern.compile("\\((0|[1-9][0-9]*),(0|[1-9][0-9]*)\\)");
    public static Pattern FLOAT_PATTERN = Pattern.compile("-?[0-9]*(\\.[0-9]*)?([eE]-?[0-9]+)?");
    private static SAXParserFactory factory = SAXParserFactory.newInstance();
    private SAXParser parser = factory.newSAXParser();
    private ErrorHandler errorHandler;
    private SAXException lastError;
    private Locator locator;
    private Map typeMap = new HashMap();
    private List typeCheckList = new LinkedList();
    private boolean hasXAxis = false;
    private boolean hasYAxis = false;
    private boolean hasZAxis = false;
    private boolean insideSpectrogram = false;

    public boolean validate(InputSource inputSource, ErrorHandler errorHandler) throws IOException {
        this.errorHandler = errorHandler;
        if (this == errorHandler) {
            throw new IllegalArgumentException("cannot pass an instance of DasMLValidator to its own validate() method");
        }
        this.lastError = null;
        try {
            this.typeMap.clear();
            this.typeCheckList.clear();
            this.parser.parse(inputSource, (DefaultHandler)this);
        }
        catch (SAXException sAXException) {
            this.lastError = sAXException;
        }
        return this.lastError == null;
    }

    public SAXException getLastError() {
        return this.lastError;
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        if (this.errorHandler != null) {
            this.errorHandler.fatalError(sAXParseException);
        }
        throw sAXParseException;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        if (this.errorHandler != null) {
            this.errorHandler.error(sAXParseException);
        }
        this.lastError = sAXParseException;
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        if (this.errorHandler != null) {
            this.errorHandler.warning(sAXParseException);
        }
        this.lastError = sAXParseException;
    }

    public void startDocument() throws SAXException {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = attributes.getValue("name");
        if (string4 != null) {
            if (this.typeMap.containsKey(string4)) {
                this.errorInternal("An element with the name " + string4 + " already exists.  " + "The values of name attributes must be unique.");
            }
            this.typeMap.put(string4, string3);
        }
        if (string3.equals("window")) {
            this.checkWindow(attributes);
        } else if (string3.equals("form")) {
            this.checkForm(attributes);
        } else if (string3.equals("textfield")) {
            this.checkTextfield(attributes);
        } else if (string3.equals("checkbox")) {
            this.checkCheckbox(attributes);
        } else if (!string3.equals("if") && !string3.equals("elseif")) {
            if (string3.equals("update")) {
                this.typeCheckList.add(new TypeCheck("update", "target", "spectrogram", attributes.getValue("target"), this.locator));
            } else if (string3.equals("radiobutton")) {
                this.checkRadiobutton(attributes);
            } else if (string3.equals("panel")) {
                this.checkPanel(attributes);
            } else if (string3.equals("glue")) {
                this.checkGlue(attributes);
            } else if (string3.equals("canvas")) {
                this.checkCanvas(attributes);
            } else if (string3.equals("row")) {
                this.checkRowColumn("row", attributes);
            } else if (string3.equals("column")) {
                this.checkRowColumn("column", attributes);
            } else if (string3.equals("spectrogram")) {
                this.checkSpectrogram(attributes);
            } else if (string3.equals("xAxis")) {
                this.checkXAxis(attributes);
            } else if (string3.equals("yAxis")) {
                this.checkYAxis(attributes);
            } else if (string3.equals("zAxis")) {
                this.checkZAxis(attributes);
            } else if (string3.equals("axis")) {
                this.checkAxis(attributes);
            } else if (string3.equals("timeaxis")) {
                this.checkTimeaxis(attributes);
            } else if (string3.equals("attachedaxis")) {
                this.checkAttachedaxis(attributes);
            } else if (string3.equals("colorbar")) {
                this.checkColorbar(attributes);
            }
        }
    }

    private void checkColorbar(Attributes attributes) throws SAXException {
        String string;
        String string2;
        String string3 = attributes.getValue("minimum");
        if (!FLOAT_PATTERN.matcher(string3).matches() || string3.charAt(0) == '-') {
            this.errorInternal("The minimum attribute of a colorbar element must be a positive number");
        }
        if (!FLOAT_PATTERN.matcher(string2 = attributes.getValue("maximum")).matches() || string2.charAt(0) == '-') {
            this.errorInternal("The maximum attribute of a colorbar element must be a positive number");
        }
        if ((string = attributes.getValue("row")) != null) {
            this.typeCheckList.add(new TypeCheck("colorbar", "row", "row", string, this.locator));
        } else if (!this.insideSpectrogram) {
            this.errorInternal("The \"row\" attribute of a \"colorbar\" element must be specified if the element is not nested in a \"spectrogram\" element");
        }
        String string4 = attributes.getValue("column");
        if (string4 != null) {
            this.typeCheckList.add(new TypeCheck("colorbar", "column", "column", string4, this.locator));
        } else if (!this.insideSpectrogram) {
            this.errorInternal("The \"column\" attribute of a \"colorbar\" element must be specified if the element is not nested in a \"spectrogram\" element");
        }
        String string5 = attributes.getValue("log");
        if (!string5.equals("true") && !string5.equals("false")) {
            this.errorInternal("The log attribute of a colorbar must be either 'true' or 'false'");
        }
    }

    private void checkSpectrogram(Attributes attributes) throws SAXParseException {
        String string;
        String string2;
        String string3 = attributes.getValue("row");
        this.typeCheckList.add(new TypeCheck("spectrogram", "row", "row", string3, this.locator));
        String string4 = attributes.getValue("column");
        this.typeCheckList.add(new TypeCheck("spectrogram", "column", "column", string4, this.locator));
        String string5 = attributes.getValue("xAxis");
        if (string5 != null) {
            this.typeCheckList.add(new TypeCheck("spectrogram", "xAxis", "axis|timeaxis|attachedaxis", string5, this.locator));
            this.hasXAxis = true;
        }
        if ((string2 = attributes.getValue("yAxis")) != null) {
            this.typeCheckList.add(new TypeCheck("spectrogram", "yAxis", "axis|timeaxis|attachedaxis", string2, this.locator));
            this.hasYAxis = true;
        }
        if ((string = attributes.getValue("colorbar")) != null) {
            this.typeCheckList.add(new TypeCheck("spectrogram", "colorbar", "colorbar", string, this.locator));
            this.hasZAxis = true;
        }
        this.insideSpectrogram = true;
    }

    private void endCheckSpectrogram() throws SAXException {
        if (!this.hasXAxis) {
            this.errorInternal("No xAxis specified.  Spectrograms require an xAxis to be specified");
        }
        if (!this.hasYAxis) {
            this.errorInternal("No yAxis specified.  Spectrograms required a yAxis to be specified");
        }
        if (!this.hasZAxis) {
            this.errorInternal("No zAxis specified.  Spectrograms required a zAxis to be specified");
        }
        this.hasXAxis = false;
        this.hasYAxis = false;
        this.hasZAxis = false;
        this.insideSpectrogram = false;
    }

    private void checkXAxis(Attributes attributes) throws SAXException {
        this.hasXAxis = true;
    }

    private void checkYAxis(Attributes attributes) throws SAXException {
        this.hasYAxis = true;
    }

    private void checkZAxis(Attributes attributes) throws SAXException {
        this.hasZAxis = true;
    }

    private void checkAttachedaxis(Attributes attributes) throws SAXException {
        String string = attributes.getValue("ref");
        this.typeCheckList.add(new TypeCheck("attachedaxis", "ref", "axis|timeaxis", string, this.locator));
        String string2 = attributes.getValue("row");
        if (string2 != null) {
            this.typeCheckList.add(new TypeCheck("attachedaxis", "row", "row", string2, this.locator));
        } else if (!this.insideSpectrogram) {
            this.errorInternal("The \"row\" attribute of an \"attachedaxis\" element must be specified if the element is not nested in a \"spectrogram\" element");
        }
        String string3 = attributes.getValue("column");
        if (string3 != null) {
            this.typeCheckList.add(new TypeCheck("attachedaxis", "column", "column", string3, this.locator));
        } else if (!this.insideSpectrogram) {
            this.errorInternal("The \"column\" attribute of an \"attachedaxis\" element must be specified if the element is not nested in a \"spectrogram\" element");
        }
        String string4 = attributes.getValue("orientation");
        if (!string4.equals("horizontal") && !string4.equals("vertical")) {
            this.errorInternal("The orientation attibute of an attachedaxis element must be either 'horizontal' or 'vertical'");
        }
    }

    private void checkTimeaxis(Attributes attributes) throws SAXException {
        String string;
        String string2 = attributes.getValue("showTca");
        if (!string2.equals("true") && !string2.equals("false")) {
            this.errorInternal("The showTca attribute of a timeaxis element must be either 'true' or 'false'");
        }
        if ((string = attributes.getValue("row")) != null) {
            this.typeCheckList.add(new TypeCheck("timeaxis", "row", "row", string, this.locator));
        } else if (!this.insideSpectrogram) {
            this.errorInternal("The \"row\" attribute of a \"timeaxis\" element must be specified if the element is not nested in a \"spectrogram\" element");
        }
        String string3 = attributes.getValue("column");
        if (string3 != null) {
            this.typeCheckList.add(new TypeCheck("timeaxis", "column", "column", string3, this.locator));
        } else if (!this.insideSpectrogram) {
            this.errorInternal("The \"column\" attribute of a \"timeaxis\" element must be specified if the element is not nested in a \"spectrogram\" element");
        }
        String string4 = attributes.getValue("orientation");
        if (!string4.equals("horizontal") && !string4.equals("vertical")) {
            this.errorInternal("The orientation attibute of an axis element must be either 'horizontal' or 'vertical'");
        }
        if (string2.equals("true") && string4.equals("vertical")) {
            this.errorInternal("Vertical axes cannot diplay time correlated annotations");
        }
    }

    private void checkAxis(Attributes attributes) throws SAXException {
        String string;
        String string2;
        String string3 = attributes.getValue("log");
        if (!string3.equals("true") && !string3.equals("false")) {
            this.errorInternal("The log attribute of an axis element must be either 'true' or 'false'");
        }
        if (!FLOAT_PATTERN.matcher(string2 = attributes.getValue("dataMinimum")).matches()) {
            this.errorInternal("The dataMinimum attribute of an axis element must be a valid number'");
        }
        String string4 = attributes.getValue("dataMaximum");
        if (!FLOAT_PATTERN.matcher(string2).matches()) {
            this.errorInternal("The dataMaximum attribute of an axis element must be a valid number'");
        }
        if ((string = attributes.getValue("row")) != null) {
            this.typeCheckList.add(new TypeCheck("axis", "row", "row", string, this.locator));
        } else if (!this.insideSpectrogram) {
            this.errorInternal("The \"row\" attribute of an \"axis\" element must be specified if the element is not nested in a \"spectrogram\" element");
        }
        String string5 = attributes.getValue("column");
        if (string5 != null) {
            this.typeCheckList.add(new TypeCheck("axis", "column", "column", string5, this.locator));
        } else if (!this.insideSpectrogram) {
            this.errorInternal("The \"column\" attribute of an \"axis\" element must be specified if the element is not nested in a \"spectrogram\" element");
        }
        String string6 = attributes.getValue("orientation");
        if (!string6.equals("horizontal") && !string6.equals("vertical")) {
            this.errorInternal("The orientation attibute of an axis element must be either 'horizontal' or 'vertical'");
        }
    }

    private void checkRowColumn(String string, Attributes attributes) throws SAXException {
        String string2;
        String string3 = attributes.getValue("minimum");
        if (!FLOAT_PATTERN.matcher(string3).matches() || string3.charAt(0) == '-') {
            this.errorInternal("The minimum attribute of a " + string + " element must be a positive number");
        }
        if (!FLOAT_PATTERN.matcher(string2 = attributes.getValue("maximum")).matches() || string2.charAt(0) == '-') {
            this.errorInternal("The maximum attribute of a " + string + " element must be a positive number");
        }
    }

    private void checkCanvas(Attributes attributes) throws SAXException {
        String string;
        String string2 = attributes.getValue("width");
        if (!INTEGER_PATTERN.matcher(string2).matches()) {
            this.errorInternal("The width attribute of a canvas element must be a positive integer");
        }
        if (!INTEGER_PATTERN.matcher(string = attributes.getValue("height")).matches()) {
            this.errorInternal("The height attribute of a canvas element must be a positive integer");
        }
    }

    private void checkGlue(Attributes attributes) throws SAXException {
        String string = attributes.getValue("direction");
        if (!string.equals("horizontal") && !string.equals("vertical")) {
            this.errorInternal("The direction attribute of a glue element must be either 'horizontal' or 'vertical'");
        }
    }

    private void checkPanel(Attributes attributes) throws SAXException {
        String string;
        String string2 = attributes.getValue("direction");
        if (!string2.equals("horizontal") && !string2.equals("vertical")) {
            this.errorInternal("The direction attribute of a panel element must be either 'horizontal' or 'vertical'");
        }
        if (!(string = attributes.getValue("border")).equals("true") && !string.equals("false")) {
            this.errorInternal("The border attribute of a panel element must be either 'true' or 'false'");
        }
    }

    private void checkRadiobutton(Attributes attributes) throws SAXException {
        String string = attributes.getValue("group");
        this.typeCheckList.add(new TypeCheck("radiobutton", "group", "buttongroup", string, this.locator));
        String string2 = attributes.getValue("selected");
        if (!string2.equals("true") && !string2.equals("false")) {
            this.errorInternal("The selected attribute of a radiobutton element must be either 'true' or 'false'");
        }
    }

    private void checkCheckbox(Attributes attributes) throws SAXException {
        String string = attributes.getValue("selected");
        if (!string.equals("true") && !string.equals("false")) {
            this.errorInternal("The selected attribute of a checkbox element must be either 'true' or 'false'");
        }
    }

    private void checkTextfield(Attributes attributes) throws SAXException {
        String string = attributes.getValue("length");
        if (!INTEGER_PATTERN.matcher(string).matches()) {
            this.errorInternal("The length attribute of textfield elements must be a positive integer");
        }
    }

    private void checkForm(Attributes attributes) throws SAXException {
        String string = attributes.getValue("alignment");
        if (!(string.equals("left") || string.equals("center") || string.equals("right"))) {
            this.errorInternal("The alignment attribute of a form element must be 'left', 'center', or 'right'");
        }
    }

    private void checkWindow(Attributes attributes) throws SAXException {
        String string;
        String string2;
        String string3;
        String string4 = attributes.getValue("width");
        if (!INTEGER_PATTERN.matcher(string4).matches()) {
            this.errorInternal("The width attribute of a window element must be a positve integer.");
        }
        if (!INTEGER_PATTERN.matcher(string3 = attributes.getValue("height")).matches()) {
            this.errorInternal("The height attribute of a window element must be a positive integer.");
        }
        if (!WINDOW_POSITION_PATTERN.matcher(string2 = attributes.getValue("location")).matches()) {
            this.errorInternal("The location attribute of a window element must be a pair of the form (x,y)");
        }
        if (!(string = attributes.getValue("visible")).equals("true") && !string.equals("false")) {
            this.errorInternal("The visible attribute of a window element must be either 'true' or 'false'");
        }
    }

    public void endDocument() throws SAXException {
        Iterator iterator = this.typeCheckList.iterator();
        SAXParseException sAXParseException = null;
        while (iterator.hasNext()) {
            TypeCheck typeCheck = (TypeCheck)iterator.next();
            String string = (String)this.typeMap.get(typeCheck.value);
            if (string == null) {
                sAXParseException = new SAXParseException("No element of type \"" + typeCheck.type + "\" with attribute " + "name=\"" + typeCheck.value + "\" exists.", typeCheck);
                this.error(sAXParseException);
            }
            if (Pattern.matches(typeCheck.type, string)) continue;
            sAXParseException = new SAXParseException("Element '" + typeCheck.elementName + "', " + "attribute '" + typeCheck.attributeName + "' : " + string + " expected, but found " + string + " (" + typeCheck.value + ")", typeCheck);
            this.error(sAXParseException);
        }
        if (sAXParseException != null) {
            throw sAXParseException;
        }
    }

    private void errorInternal(String string) throws SAXException {
        this.lastError = new SAXParseException(string, this.locator);
        this.error((SAXParseException)this.lastError);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.err.println("usage: java xml.DasMLValidator <filename>");
            return;
        }
        ErrorHandler errorHandler = new ErrorHandler(){

            public void warning(SAXParseException sAXParseException) throws SAXException {
                pwDie.println("Line " + sAXParseException.getLineNumber() + ", " + sAXParseException.getMessage());
            }

            public void error(SAXParseException sAXParseException) throws SAXException {
                pwDie.println("Line " + sAXParseException.getLineNumber() + ", " + sAXParseException.getMessage());
            }

            public void fatalError(SAXParseException sAXParseException) throws SAXException {
                pwDie.println("Line " + sAXParseException.getLineNumber() + ", " + sAXParseException.getMessage());
            }
        };
        try {
            String string = new File(stringArray[0]).getCanonicalPath();
            DasMLValidator dasMLValidator = new DasMLValidator();
            if (dasMLValidator.validate(new InputSource("file://" + string), errorHandler)) {
                pwDie.println("No errors");
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            pwDie.println(parserConfigurationException.getMessage());
        }
        catch (SAXException sAXException) {
            pwDie.println(sAXException.getMessage());
        }
        catch (IOException iOException) {
            pwDie.println(iOException.getMessage());
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equals("spectrogram")) {
            this.endCheckSpectrogram();
        }
    }

    static {
        factory.setValidating(true);
    }

    private static class TypeCheck
    implements Locator {
        public String elementName;
        public String attributeName;
        public String type;
        public String value;
        private int lineNumber;
        private int columnNumber;
        private String publicId;
        private String systemId;

        public TypeCheck(String string, String string2, String string3, String string4, Locator locator) {
            this.elementName = string;
            this.attributeName = string2;
            this.type = string3;
            this.value = string4;
            this.lineNumber = locator.getLineNumber();
            this.columnNumber = locator.getColumnNumber();
            this.publicId = locator.getPublicId();
            this.systemId = locator.getSystemId();
        }

        public int getColumnNumber() {
            return this.columnNumber;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public String getPublicId() {
            return this.publicId;
        }

        public String getSystemId() {
            return this.systemId;
        }
    }
}

