/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;

public class MessageBox
extends Dialog {
    public static final int OK = 1;
    public static final int CANCEL = 2;
    public static final int YES = 4;
    public static final int NO = 8;
    public static final int YES_NO = 12;
    public static final int YES_NO_CANCEL = 14;
    public static final int OK_CANCEL = 3;
    public static final int DEFAULT = 3;
    private int result;
    private int type;
    private Button yes;
    private Button no;
    private Button ok;
    private Button cancel;

    private MessageBox(Frame frame) {
        super(frame);
    }

    private MessageBoxListener createListener() {
        return new MessageBoxListener();
    }

    public static int showModalMessage(Frame frame, int n, String string, String string2) {
        return MessageBox.showModalMessage(frame, n, string, MessageBox.breakLines(string2));
    }

    public static int showModalMessage(Frame frame, int n, String string, String[] stringArray) {
        MessageBox messageBox = new MessageBox(frame);
        MessageBoxListener messageBoxListener = messageBox.createListener();
        if (n == 0) {
            n = 3;
        }
        messageBox.type = n;
        messageBox.setTitle(string);
        messageBox.setModal(true);
        messageBox.setLayout(new BorderLayout());
        messageBox.addWindowListener(messageBoxListener);
        Panel panel = new Panel(new GridLayout(0, 1));
        int n2 = 0;
        while (n2 < stringArray.length) {
            panel.add(new Label(stringArray[n2]));
            ++n2;
        }
        messageBox.add((Component)panel, "Center");
        Panel panel2 = new Panel(new FlowLayout(2));
        if ((n & 1) == 1) {
            messageBox.ok = new Button("Ok");
            messageBox.ok.addActionListener(messageBoxListener);
            panel2.add(messageBox.ok);
        }
        if ((n & 4) == 4) {
            messageBox.yes = new Button("Yes");
            messageBox.yes.addActionListener(messageBoxListener);
            panel2.add(messageBox.yes);
        }
        if ((n & 8) == 8) {
            messageBox.no = new Button("No");
            messageBox.no.addActionListener(messageBoxListener);
            panel2.add(messageBox.no);
        }
        if ((n & 2) == 2) {
            messageBox.cancel = new Button("Cancel");
            messageBox.cancel.addActionListener(messageBoxListener);
            panel2.add(messageBox.cancel);
        }
        messageBox.add((Component)panel, "Center");
        messageBox.add((Component)panel2, "South");
        messageBox.pack();
        Dimension dimension = frame.getSize();
        Point point = frame.getLocation();
        Dimension dimension2 = messageBox.getSize();
        messageBox.setLocation(point.x + (dimension.width - dimension2.width) / 2, point.y + (dimension.height - dimension2.height) / 2);
        messageBox.show();
        return messageBox.result;
    }

    private static String[] breakLines(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", false);
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        return stringArray;
    }

    private class MessageBoxListener
    extends WindowAdapter
    implements ActionListener {
        private MessageBoxListener() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            MessageBox.this.result = 2;
            MessageBox.this.hide();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == MessageBox.this.ok) {
                MessageBox.this.result = 1;
            } else if (actionEvent.getSource() == MessageBox.this.cancel) {
                MessageBox.this.result = 2;
            } else if (actionEvent.getSource() == MessageBox.this.yes) {
                MessageBox.this.result = 4;
            } else if (actionEvent.getSource() == MessageBox.this.no) {
                MessageBox.this.result = 8;
            }
            MessageBox.this.hide();
        }
    }
}

