/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;

public abstract class DnDSupport {
    private Component component;
    private DnDSupport parent;
    private int ops;
    private GestureRecognizer gestureRecognizer;

    protected DnDSupport(Component component, int n, DnDSupport dnDSupport) {
        this.component = component;
        this.parent = dnDSupport;
        this.ops = n;
        component.setDropTarget(new DropTarget(component, n, new DropHandler()));
    }

    public void setParent(DnDSupport dnDSupport) {
        this.parent = dnDSupport;
    }

    protected abstract int canAccept(DataFlavor[] var1, int var2, int var3, int var4);

    protected abstract boolean importData(Transferable var1, int var2, int var3, int var4);

    protected abstract void done();

    protected abstract void exportDone(Transferable var1, int var2);

    protected abstract Transferable getTransferable(int var1, int var2, int var3);

    private int canAcceptInternal(DataFlavor[] dataFlavorArray, int n, int n2, int n3) {
        int n4 = this.canAccept(dataFlavorArray, n, n2, n3);
        if (n4 == -1 && this.parent != null) {
            return this.parent.canAcceptInternal(dataFlavorArray, n + this.component.getX(), n2 + this.component.getY(), n3);
        }
        return n4;
    }

    private boolean importDataInternal(Transferable transferable, int n, int n2, int n3) {
        if (this.canAccept(transferable.getTransferDataFlavors(), n, n2, n3) != -1) {
            return this.importData(transferable, n, n2, n3);
        }
        if (this.parent != null) {
            return this.parent.importDataInternal(transferable, n + this.component.getX(), n2 + this.component.getY(), n3);
        }
        return false;
    }

    private void doneInternal() {
        this.done();
        if (this.parent != null) {
            this.parent.doneInternal();
        }
    }

    public void startDrag(int n, int n2, int n3, MouseEvent mouseEvent) {
        if (this.gestureRecognizer == null) {
            this.gestureRecognizer = new GestureRecognizer(this.component, new DragHandler());
        }
        this.gestureRecognizer.startDrag(n, n2, n3, mouseEvent);
    }

    private class DragHandler
    implements DragGestureListener,
    DragSourceListener {
        private DragHandler() {
        }

        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            Point point = dragGestureEvent.getDragOrigin();
            int n = dragGestureEvent.getDragAction();
            Transferable transferable = DnDSupport.this.getTransferable(point.x, point.y, n);
            if (transferable != null) {
                dragGestureEvent.startDrag(new Cursor(12), transferable, this);
            }
        }

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            DragSourceContext dragSourceContext = dragSourceDropEvent.getDragSourceContext();
            if (dragSourceDropEvent.getDropSuccess()) {
                DnDSupport.this.exportDone(dragSourceContext.getTransferable(), dragSourceDropEvent.getDropAction());
            } else {
                DnDSupport.this.exportDone(null, 0);
            }
        }

        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragExit(DragSourceEvent dragSourceEvent) {
        }

        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }
    }

    private class GestureRecognizer
    extends DragGestureRecognizer {
        GestureRecognizer(Component component, DragHandler dragHandler) {
            super(DragSource.getDefaultDragSource(), component, DnDSupport.this.ops, dragHandler);
        }

        void startDrag(int n, int n2, int n3, MouseEvent mouseEvent) {
            this.appendEvent(mouseEvent);
            this.fireDragGestureRecognized(n3, new Point(n, n2));
        }

        protected void registerListeners() {
        }

        protected void unregisterListeners() {
        }
    }

    private class DropHandler
    implements DropTargetListener {
        private DropHandler() {
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            Point point = dropTargetDragEvent.getLocation();
            int n = DnDSupport.this.canAcceptInternal(dropTargetDragEvent.getCurrentDataFlavors(), point.x, point.y, dropTargetDragEvent.getDropAction());
            if (n == -1) {
                dropTargetDragEvent.rejectDrag();
            } else {
                dropTargetDragEvent.acceptDrag(n);
            }
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
            DnDSupport.this.doneInternal();
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            Point point = dropTargetDragEvent.getLocation();
            int n = DnDSupport.this.canAcceptInternal(dropTargetDragEvent.getCurrentDataFlavors(), point.x, point.y, dropTargetDragEvent.getDropAction());
            if (n == -1) {
                dropTargetDragEvent.rejectDrag();
            } else {
                dropTargetDragEvent.acceptDrag(n);
            }
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            Point point = dropTargetDropEvent.getLocation();
            int n = DnDSupport.this.canAcceptInternal(dropTargetDropEvent.getCurrentDataFlavors(), point.x, point.y, dropTargetDropEvent.getDropAction());
            if (n == -1) {
                dropTargetDropEvent.rejectDrop();
            } else {
                dropTargetDropEvent.acceptDrop(n);
                boolean bl = DnDSupport.this.importDataInternal(dropTargetDropEvent.getTransferable(), point.x, point.y, dropTargetDropEvent.getDropAction());
                dropTargetDropEvent.dropComplete(bl);
            }
            DnDSupport.this.doneInternal();
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }
    }
}

