/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;
import util.pwDie;

public final class DasExceptionHandler {
    private DasExceptionHandler() {
    }

    public static void handle(Throwable throwable) {
        if (System.getProperty("java.awt.headless", "").equals("true")) {
            pwDie.println(pwDie.CRITICAL, throwable.toString());
        } else {
            DasExceptionHandler.showExceptionDialog(throwable);
            pwDie.println(pwDie.CRITICAL, throwable.toString());
        }
    }

    public static void showExceptionDialog(final Throwable throwable) {
        JComponent jComponent;
        JComponent jComponent2;
        final JDialog jDialog = new JDialog();
        jDialog.setTitle("Error");
        jDialog.setModal(true);
        jDialog.setResizable(false);
        jDialog.setDefaultCloseOperation(2);
        String string = throwable.getMessage();
        if (string == null) {
            jComponent2 = new JTextField(throwable.toString());
            ((JTextComponent)jComponent2).setEditable(false);
            jComponent2.setOpaque(false);
            jComponent = jComponent2;
        } else if (Pattern.matches(".*<[Hh][Tt][Mm][Ll]>.*</[Hh][Tt][Mm][Ll]>.*", string)) {
            jComponent2 = new JEditorPane("text/html", string);
            ((JTextComponent)jComponent2).setEditable(false);
            jComponent = new JScrollPane(jComponent2);
        } else {
            jComponent2 = new JTextArea(throwable.getMessage());
            ((JTextArea)jComponent2).setLineWrap(true);
            ((JTextComponent)jComponent2).setEditable(false);
            jComponent2.setOpaque(false);
            jComponent = new JScrollPane(jComponent2);
        }
        jComponent.setBorder(new EmptyBorder(10, 10, 10, 10));
        jComponent2 = new JPanel(new BorderLayout());
        jComponent2.add((Component)jComponent, "Center");
        JPanel jPanel = new JPanel(new FlowLayout(2));
        JButton jButton = new JButton("Ok");
        final JToggleButton jToggleButton = new JToggleButton("Show Details");
        jPanel.add(jButton);
        jPanel.add(jToggleButton);
        jComponent2.add((Component)jPanel, "South");
        jDialog.getContentPane().add((Component)jComponent2, "Center");
        JTextArea jTextArea = new JTextArea(10, 40);
        jTextArea.setLineWrap(false);
        jTextArea.setEditable(false);
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.close();
        jTextArea.setText(stringWriter.toString());
        jTextArea.setTabSize(4);
        final JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)new JScrollPane(jTextArea), "North");
        jPanel2.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel jPanel3 = new JPanel(new FlowLayout(2));
        jPanel3.setBorder(new EmptyBorder(10, 0, 0, 0));
        JButton jButton2 = new JButton("Dump to STDERR");
        jPanel3.add(jButton2);
        jPanel2.add((Component)jButton2, "South");
        Dimension dimension = jComponent.getPreferredSize();
        dimension.width = jPanel2.getPreferredSize().width;
        jComponent.setPreferredSize(dimension);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        jToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (jToggleButton.isSelected()) {
                    jToggleButton.setText("Less Details");
                    jDialog.getContentPane().add((Component)jPanel2, "South");
                    jDialog.pack();
                } else {
                    jToggleButton.setText("More Details");
                    jDialog.getContentPane().remove(jPanel2);
                    jDialog.pack();
                }
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                throwable.printStackTrace(System.err);
            }
        });
        jDialog.pack();
        jDialog.setLocationRelativeTo(null);
        jDialog.setVisible(true);
    }
}

