/*
 * Decompiled with CFR 0.152.
 */
package graph;

import das_proto.data.ConstantDataSetDescriptor;
import das_proto.data.DataSetDescriptor;
import das_proto.data.Datum;
import das_proto.data.TimeLocationUnits;
import das_proto.data.Units;
import das_proto.data.XMultiYDataSet;
import das_proto.data.XMultiYDataSetDescriptor;
import graph.Psym;
import graph.SymbolLineRenderer;
import graph.pwAxis;
import graph.pwCanvas;
import graph.pwColumn;
import graph.pwPlot;
import graph.pwRow;
import graph.pwTimeAxis;
import util.pwDate;
import util.pwDie;

public class pwSymbolPlot
extends pwPlot {
    private SymbolLineRenderer renderer;

    public pwSymbolPlot(XMultiYDataSet xMultiYDataSet, pwAxis pwAxis2, pwAxis pwAxis3, pwRow pwRow2, pwColumn pwColumn2) {
        this(xMultiYDataSet == null ? null : new ConstantDataSetDescriptor(xMultiYDataSet), pwAxis2, pwAxis3, pwRow2, pwColumn2);
    }

    public pwSymbolPlot(XMultiYDataSetDescriptor xMultiYDataSetDescriptor, pwAxis pwAxis2, pwAxis pwAxis3, pwRow pwRow2, pwColumn pwColumn2) {
        this((DataSetDescriptor)xMultiYDataSetDescriptor, pwAxis2, pwAxis3, pwRow2, pwColumn2);
    }

    protected pwSymbolPlot(DataSetDescriptor dataSetDescriptor, pwAxis pwAxis2, pwAxis pwAxis3, pwRow pwRow2, pwColumn pwColumn2) {
        super(pwAxis2, pwAxis3, pwRow2, pwColumn2);
        this.renderer = new SymbolLineRenderer((pwPlot)this, dataSetDescriptor);
        this.addRenderer(this.renderer);
    }

    public Psym getPsym() {
        return this.renderer.getPsym();
    }

    public void setPsym(Psym psym) {
        this.renderer.setPsym(psym);
    }

    public void addData(double[] dArray, double[] dArray2) {
        this.addData(XMultiYDataSet.create(dArray, Units.dimensionless, dArray2, Units.dimensionless));
    }

    public void addData(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        int n = 0;
        while (n < dArray2.length) {
            dArray2[n] = n;
            ++n;
        }
        this.addData(dArray2, dArray);
    }

    public void addData(XMultiYDataSet xMultiYDataSet) {
        this.renderer.setDataSet(xMultiYDataSet);
    }

    public static pwSymbolPlot create(pwCanvas pwCanvas2, XMultiYDataSetDescriptor xMultiYDataSetDescriptor) {
        pwRow pwRow2 = new pwRow(pwCanvas2, 0.05, 0.85);
        pwColumn pwColumn2 = new pwColumn(pwCanvas2, 0.15, 0.9);
        pwDie.println("  dsd: " + xMultiYDataSetDescriptor + " units: " + xMultiYDataSetDescriptor.getXUnits());
        pwAxis pwAxis2 = xMultiYDataSetDescriptor.getXUnits() instanceof TimeLocationUnits ? new pwTimeAxis(new pwDate("2000/1/1"), new pwDate("2000/1/2"), pwRow2, pwColumn2, 2) : new pwAxis(new Datum(0.0, xMultiYDataSetDescriptor.getXUnits()), new Datum(10.0, xMultiYDataSetDescriptor.getXUnits()), pwRow2, pwColumn2, 2);
        pwAxis pwAxis3 = xMultiYDataSetDescriptor.getYUnits() instanceof TimeLocationUnits ? new pwTimeAxis(new pwDate("2000/1/1"), new pwDate("2000/1/2"), pwRow2, pwColumn2, 3) : new pwAxis(new Datum(0.0, xMultiYDataSetDescriptor.getYUnits()), new Datum(10.0, xMultiYDataSetDescriptor.getYUnits()), pwRow2, pwColumn2, 3);
        pwSymbolPlot pwSymbolPlot2 = new pwSymbolPlot(xMultiYDataSetDescriptor, pwAxis2, pwAxis3, pwRow2, pwColumn2);
        pwCanvas2.addCanvasComponent(pwSymbolPlot2);
        pwCanvas2.addCanvasComponent(pwSymbolPlot2.getXAxis());
        pwCanvas2.addCanvasComponent(pwSymbolPlot2.getYAxis());
        return pwSymbolPlot2;
    }

    public static pwSymbolPlot create(pwCanvas pwCanvas2, XMultiYDataSet xMultiYDataSet) {
        pwRow pwRow2 = new pwRow(pwCanvas2, 0.05, 0.85);
        pwColumn pwColumn2 = new pwColumn(pwCanvas2, 0.15, 0.9);
        int n = xMultiYDataSet.data.length;
        int n2 = xMultiYDataSet.ny * n;
        double[] dArray = new double[n];
        int n3 = 0;
        while (n3 < n) {
            dArray[n3] = xMultiYDataSet.data[n3].x;
            ++n3;
        }
        double d = xMultiYDataSet.y_fill;
        double[] dArray2 = new double[n2];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            int n6 = 0;
            while (n6 < xMultiYDataSet.ny) {
                if (xMultiYDataSet.data[n5].y[n6] != d) {
                    dArray2[n4++] = xMultiYDataSet.data[n5].y[n6];
                }
                ++n6;
            }
            ++n5;
        }
        pwSymbolPlot pwSymbolPlot2 = new pwSymbolPlot(xMultiYDataSet, pwAxis.create(dArray, xMultiYDataSet.getXUnits(), pwRow2, pwColumn2, 2, false), pwAxis.create(dArray2, xMultiYDataSet.getYUnits(), pwRow2, pwColumn2, 3, false), pwRow2, pwColumn2);
        pwCanvas2.addCanvasComponent(pwSymbolPlot2);
        pwCanvas2.addCanvasComponent(pwSymbolPlot2.getXAxis());
        pwCanvas2.addCanvasComponent(pwSymbolPlot2.getYAxis());
        return pwSymbolPlot2;
    }

    public double getSymSize() {
        return this.renderer.getSymSize();
    }

    public void setSymSize(double d) {
        this.renderer.setSymSize(d);
    }
}

