/*
 * Decompiled with CFR 0.152.
 */
package graph;

import das_proto.data.Datum;
import das_proto.data.TimeLocationUnits;
import das_proto.data.Units;
import das_proto.data.XMultiYDataSet;
import das_proto.data.XMultiYDataSetDescriptor;
import graph.Psym;
import graph.pwAxis;
import graph.pwCanvas;
import graph.pwColumn;
import graph.pwPlot;
import graph.pwRow;
import graph.pwTimeAxis;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import util.pwDate;
import util.pwDie;

public class pwStackedSymbolPlot
extends pwPlot {
    protected double symSize = 1.0;
    protected Psym psym = Psym.LINES;

    public pwStackedSymbolPlot(XMultiYDataSet xMultiYDataSet, pwAxis pwAxis2, pwAxis pwAxis3, pwRow pwRow2, pwColumn pwColumn2) {
        super(pwAxis2, pwAxis3, pwRow2, pwColumn2);
        this.Data = xMultiYDataSet;
    }

    public pwStackedSymbolPlot(XMultiYDataSetDescriptor xMultiYDataSetDescriptor, pwAxis pwAxis2, pwAxis pwAxis3, pwRow pwRow2, pwColumn pwColumn2) {
        super(pwAxis2, pwAxis3, pwRow2, pwColumn2);
    }

    public Psym getPsym() {
        return this.psym;
    }

    public void setPsym(Psym psym) {
        if (psym == null) {
            throw new NullPointerException("psym cannot be null");
        }
        Psym psym2 = this.psym;
        this.psym = psym;
        this.repaint();
        if (psym2 != psym) {
            this.firePropertyChange("psym", psym2, psym);
        }
    }

    public void addData(double[] dArray, double[] dArray2) {
        this.Data = XMultiYDataSet.create(dArray, Units.dimensionless, dArray2, Units.dimensionless);
    }

    public void addData(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        int n = 0;
        while (n < dArray2.length) {
            dArray2[n] = n;
            ++n;
        }
        this.addData(dArray2, dArray);
    }

    public void addData(XMultiYDataSet xMultiYDataSet) {
        this.Data = xMultiYDataSet;
    }

    protected void drawContent(Graphics2D graphics2D) {
        XMultiYDataSet xMultiYDataSet = (XMultiYDataSet)this.Data;
        if (xMultiYDataSet == null) {
            return;
        }
        if (this.getXAxis().getUnits() != xMultiYDataSet.getXUnits()) {
            throw new IllegalArgumentException("Data x units and xAxis units differ");
        }
        if (this.getYAxis().getUnits() != xMultiYDataSet.getYUnits()) {
            throw new IllegalArgumentException("Data y units and yAxis units differ");
        }
        double d = this.getXAxis().getDataMaximum().getValue();
        double d2 = this.getXAxis().getDataMinimum().getValue();
        double d3 = this.getYAxis().getDataMaximum().getValue();
        double d4 = this.getYAxis().getDataMinimum().getValue();
        int n = 0;
        while (n < xMultiYDataSet.data.length - 1 && xMultiYDataSet.data[n].x < d2) {
            ++n;
        }
        if (n > xMultiYDataSet.data.length - 1) {
            --n;
        }
        int n2 = xMultiYDataSet.data.length - 1;
        while (n2 > 0 && xMultiYDataSet.data[n].x > d) {
            --n2;
        }
        if (n2 < 0) {
            ++n2;
        }
        graphics2D.setColor(Color.black);
        int n3 = 0;
        while (n3 < xMultiYDataSet.data[0].y.length) {
            int n4;
            int n5;
            if (this.psym.drawsLines()) {
                n5 = (int)Math.floor(this.getXAxis().transform(xMultiYDataSet.data[n].x, xMultiYDataSet.getXUnits()) + 0.5);
                n4 = (int)Math.floor(this.getYAxis().transform(xMultiYDataSet.data[n].y[n3], xMultiYDataSet.getYUnits()) + 0.5);
                Line2D.Double double_ = new Line2D.Double();
                int n6 = n + 1;
                while (n6 <= n2) {
                    int n7 = (int)Math.floor(this.getXAxis().transform(xMultiYDataSet.data[n6].x, xMultiYDataSet.getXUnits()) + 0.5);
                    int n8 = (int)Math.floor(this.getYAxis().transform(xMultiYDataSet.data[n6].y[n3], xMultiYDataSet.getYUnits()) + 0.5);
                    if (xMultiYDataSet.data[n6].y[n3] != xMultiYDataSet.y_fill) {
                        if (xMultiYDataSet.data[n6].y[n3] != xMultiYDataSet.y_fill && xMultiYDataSet.data[n6 - 1].y[n3] != xMultiYDataSet.y_fill) {
                            double_.setLine(n5, n4, n7, n8);
                            graphics2D.draw(double_);
                        }
                        n5 = n7;
                        n4 = n8;
                    }
                    ++n6;
                }
            }
            n5 = n;
            while (n5 <= n2) {
                if (xMultiYDataSet.data[n5].y[n3] != xMultiYDataSet.y_fill) {
                    n4 = (int)Math.floor(this.getXAxis().transform(xMultiYDataSet.data[n5].x, xMultiYDataSet.getXUnits()) + 0.5);
                    int n9 = (int)Math.floor(this.getYAxis().transform(xMultiYDataSet.data[n5].y[n3], xMultiYDataSet.getYUnits()) + 0.5);
                    this.psym.draw(graphics2D, n4, n9);
                }
                ++n5;
            }
            ++n3;
        }
    }

    public static pwStackedSymbolPlot create(pwCanvas pwCanvas2, XMultiYDataSetDescriptor xMultiYDataSetDescriptor) {
        pwRow pwRow2 = new pwRow(pwCanvas2, 0.05, 0.85);
        pwColumn pwColumn2 = new pwColumn(pwCanvas2, 0.15, 0.9);
        pwDie.println("  dsd: " + xMultiYDataSetDescriptor + " units: " + xMultiYDataSetDescriptor.getXUnits());
        pwAxis pwAxis2 = xMultiYDataSetDescriptor.getXUnits() instanceof TimeLocationUnits ? new pwTimeAxis(new pwDate("2000/1/1"), new pwDate("2000/1/2"), pwRow2, pwColumn2, 2) : new pwAxis(new Datum(0.0, xMultiYDataSetDescriptor.getXUnits()), new Datum(10.0, xMultiYDataSetDescriptor.getXUnits()), pwRow2, pwColumn2, 2);
        pwAxis pwAxis3 = xMultiYDataSetDescriptor.getYUnits() instanceof TimeLocationUnits ? new pwTimeAxis(new pwDate("2000/1/1"), new pwDate("2000/1/2"), pwRow2, pwColumn2, 3) : new pwAxis(new Datum(0.0, xMultiYDataSetDescriptor.getYUnits()), new Datum(10.0, xMultiYDataSetDescriptor.getYUnits()), pwRow2, pwColumn2, 3);
        pwStackedSymbolPlot pwStackedSymbolPlot2 = new pwStackedSymbolPlot(xMultiYDataSetDescriptor, pwAxis2, pwAxis3, pwRow2, pwColumn2);
        pwCanvas2.addCanvasComponent(pwStackedSymbolPlot2);
        pwCanvas2.addCanvasComponent(pwStackedSymbolPlot2.getXAxis());
        pwCanvas2.addCanvasComponent(pwStackedSymbolPlot2.getYAxis());
        return pwStackedSymbolPlot2;
    }

    public static pwStackedSymbolPlot create(pwCanvas pwCanvas2, XMultiYDataSet xMultiYDataSet) {
        pwRow pwRow2 = new pwRow(pwCanvas2, 0.05, 0.85);
        pwColumn pwColumn2 = new pwColumn(pwCanvas2, 0.15, 0.9);
        int n = xMultiYDataSet.data.length;
        int n2 = xMultiYDataSet.ny * n;
        double[] dArray = new double[n];
        int n3 = 0;
        while (n3 < n) {
            dArray[n3] = xMultiYDataSet.data[n3].x;
            ++n3;
        }
        double d = xMultiYDataSet.y_fill;
        double[] dArray2 = new double[n2];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            int n6 = 0;
            while (n6 < xMultiYDataSet.ny) {
                if (xMultiYDataSet.data[n5].y[n6] != d) {
                    dArray2[n4++] = xMultiYDataSet.data[n5].y[n6];
                }
                ++n6;
            }
            ++n5;
        }
        pwStackedSymbolPlot pwStackedSymbolPlot2 = new pwStackedSymbolPlot(xMultiYDataSet, pwAxis.create(dArray, xMultiYDataSet.getXUnits(), pwRow2, pwColumn2, 2, false), pwAxis.create(dArray2, xMultiYDataSet.getYUnits(), pwRow2, pwColumn2, 3, false), pwRow2, pwColumn2);
        pwCanvas2.addCanvasComponent(pwStackedSymbolPlot2);
        pwCanvas2.addCanvasComponent(pwStackedSymbolPlot2.getXAxis());
        pwCanvas2.addCanvasComponent(pwStackedSymbolPlot2.getYAxis());
        return pwStackedSymbolPlot2;
    }

    public double getSymSize() {
        return this.symSize;
    }

    public void setSymSize(double d) {
        this.symSize = d;
        this.setPsym(this.psym);
    }
}

