/*
 * Decompiled with CFR 0.152.
 */
package graph;

import components.PropertyEditor;
import das_proto.DasException;
import das_proto.data.ConstantDataSetDescriptor;
import das_proto.data.DataSetDescriptor;
import das_proto.data.Datum;
import das_proto.data.TimeDatum;
import das_proto.data.TimeLocationUnits;
import das_proto.data.Units;
import das_proto.data.XTaggedYScan;
import das_proto.data.XTaggedYScanDataSet;
import das_proto.data.XTaggedYScanDataSetDescriptor;
import das_proto.data.rebinDescriptor;
import graph.AttachedColumn;
import graph.AttachedRow;
import graph.pwAxis;
import graph.pwCanvas;
import graph.pwCanvasComponent;
import graph.pwColumn;
import graph.pwLabelAxis;
import graph.pwPlot;
import graph.pwRow;
import graph.pwTimeAxis;
import graph.pwZAxisPlot;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import util.pwDate;
import util.pwDie;

public class pwStackedHistogramPlot
extends pwPlot
implements pwZAxisPlot {
    private ZAxisComponent zAxisComponent = null;
    private rebinDescriptor xBins = null;
    private pwCanvas parent;
    private PeaksIndicator peaksIndicator;

    public static pwStackedHistogramPlot create(pwCanvas pwCanvas2, XTaggedYScanDataSet xTaggedYScanDataSet) {
        pwRow pwRow2 = new pwRow(pwCanvas2, 0.05, 0.85);
        pwColumn pwColumn2 = new pwColumn(pwCanvas2, 0.15, 0.9);
        int n = xTaggedYScanDataSet.data.length;
        int n2 = xTaggedYScanDataSet.y_coordinate.length;
        double[] dArray = new double[n];
        int n3 = 0;
        while (n3 < n) {
            dArray[n3] = xTaggedYScanDataSet.data[n3].x;
            ++n3;
        }
        double[] dArray2 = new double[n * n2];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            int n6 = 0;
            while (n6 < n2) {
                dArray2[n4++] = xTaggedYScanDataSet.data[n5].z[n6];
                ++n6;
            }
            ++n5;
        }
        pwAxis pwAxis2 = pwAxis.create(dArray2, xTaggedYScanDataSet.getZUnits(), new AttachedRow(pwRow2, 0.0, 0.6), new AttachedColumn(pwColumn2, 1.05, 1.1), 4, true);
        pwAxis pwAxis3 = xTaggedYScanDataSet.getXUnits() instanceof TimeLocationUnits ? pwAxis.create(dArray, xTaggedYScanDataSet.getXUnits(), pwRow2, pwColumn2, 2, false) : pwTimeAxis.create(dArray, xTaggedYScanDataSet.getXUnits(), pwRow2, pwColumn2, 2);
        pwStackedHistogramPlot pwStackedHistogramPlot2 = new pwStackedHistogramPlot(pwCanvas2, xTaggedYScanDataSet, pwAxis3, pwAxis2, pwRow2, pwColumn2);
        return pwStackedHistogramPlot2;
    }

    public pwStackedHistogramPlot(pwCanvas pwCanvas2, XTaggedYScanDataSet xTaggedYScanDataSet, pwAxis pwAxis2, pwAxis pwAxis3, pwRow pwRow2, pwColumn pwColumn2) {
        this(new ConstantDataSetDescriptor(xTaggedYScanDataSet), pwAxis2, new pwLabelAxis(xTaggedYScanDataSet.y_coordinate, pwRow2, pwColumn2, 3), pwAxis3, pwRow2, pwColumn2);
    }

    public pwStackedHistogramPlot(XTaggedYScanDataSetDescriptor xTaggedYScanDataSetDescriptor, pwAxis pwAxis2, pwAxis pwAxis3, pwRow pwRow2, pwColumn pwColumn2) {
        this(xTaggedYScanDataSetDescriptor, pwAxis2, new pwLabelAxis(xTaggedYScanDataSetDescriptor.y_coordinate, pwRow2, pwColumn2, 3), pwAxis3, pwRow2, pwColumn2);
    }

    public pwStackedHistogramPlot(XTaggedYScanDataSetDescriptor xTaggedYScanDataSetDescriptor, pwAxis pwAxis2, pwLabelAxis pwLabelAxis2, pwAxis pwAxis3, pwRow pwRow2, pwColumn pwColumn2) {
        this((DataSetDescriptor)xTaggedYScanDataSetDescriptor, pwAxis2, pwLabelAxis2, pwAxis3, pwRow2, pwColumn2);
    }

    private pwStackedHistogramPlot(DataSetDescriptor dataSetDescriptor, pwAxis pwAxis2, pwLabelAxis pwLabelAxis2, pwAxis pwAxis3, pwRow pwRow2, pwColumn pwColumn2) {
        super(pwAxis2, pwLabelAxis2, pwRow2, pwColumn2);
        this.zAxisComponent = new ZAxisComponent(this, pwAxis3);
        this.setZAxis(pwAxis3);
        this.peaksIndicator = PeaksIndicator.MaxLines;
    }

    public static pwStackedHistogramPlot create(pwCanvas pwCanvas2, XTaggedYScanDataSetDescriptor xTaggedYScanDataSetDescriptor, pwDate pwDate2, pwDate pwDate3) throws DasException {
        XTaggedYScanDataSet xTaggedYScanDataSet = (XTaggedYScanDataSet)xTaggedYScanDataSetDescriptor.getDataSet("", pwDate2, pwDate3);
        pwStackedHistogramPlot pwStackedHistogramPlot2 = pwStackedHistogramPlot.create(pwCanvas2, xTaggedYScanDataSet);
        pwStackedHistogramPlot2.setDataSetDescriptor(xTaggedYScanDataSetDescriptor);
        return pwStackedHistogramPlot2;
    }

    public void setZAxis(pwAxis pwAxis2) {
        if (pwAxis2.isHorizontal()) {
            throw new IllegalArgumentException("ZAxis is not VERTICAL");
        }
        pwAxis pwAxis3 = this.zAxisComponent.getAxis();
        if (pwAxis3 != null) {
            if (this.parent != null) {
                this.parent.remove(pwAxis3);
            }
            pwAxis3.removePropertyChangeListener("dataMinimum", this.rebinListener);
            pwAxis3.removePropertyChangeListener("dataMaximum", this.rebinListener);
            pwAxis3.removePropertyChangeListener("log", this.rebinListener);
        }
        if (this.parent != null) {
            this.parent.addCanvasComponent(pwAxis2);
        }
        pwAxis2.addPropertyChangeListener("dataMinimum", this.rebinListener);
        pwAxis2.addPropertyChangeListener("dataMaximum", this.rebinListener);
        pwAxis2.addPropertyChangeListener("log", this.rebinListener);
        this.getYAxis().addPropertyChangeListener("dataMinimum", this.zAxisComponent);
        this.getYAxis().addPropertyChangeListener("dataMaximum", this.zAxisComponent);
        this.getYAxis().addPropertyChangeListener("log", this.zAxisComponent);
    }

    public void setYAxis(pwAxis pwAxis2) {
        if (pwAxis2 instanceof pwLabelAxis) {
            super.setYAxis(pwAxis2);
        } else {
            pwDie.die("You can't call setYAxis for stackedHistogramPlot");
        }
    }

    protected void updatePlotImage() {
        Container container = this.getParent();
        Cursor cursor = container.getCursor();
        container.setCursor(new Cursor(3));
        int n = (int)this.getColumn().getWidth();
        int n2 = (int)this.getRow().getHeight();
        this.plotImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = (Graphics2D)this.plotImage.getGraphics();
        graphics2D.translate(-((int)this.getColumn().getDMinimum()), -((int)this.getRow().getDMinimum()));
        double d = this.getColumn().getDMinimum();
        double d2 = this.getRow().getDMinimum();
        RenderingHints renderingHints = graphics2D.getRenderingHints();
        RenderingHints renderingHints2 = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics2D.setRenderingHints(renderingHints2);
        pwAxis pwAxis2 = this.getXAxis();
        rebinDescriptor rebinDescriptor2 = new rebinDescriptor(pwAxis2.getDataMinimum(), pwAxis2.getDataMaximum(), (int)(Math.abs(this.getColumn().getDMaximum() - this.getColumn().getDMinimum()) / 1.0) + 1, this.getXAxis().isLog());
        float f = (float)this.getColumn().getDMaximum();
        float f2 = (float)this.getColumn().getDMinimum();
        XTaggedYScanDataSet xTaggedYScanDataSet = (XTaggedYScanDataSet)this.Data;
        if (this.Data == null) {
            pwDie.println("null data set");
            return;
        }
        xTaggedYScanDataSet.getPeaks();
        XTaggedYScanDataSet xTaggedYScanDataSet2 = xTaggedYScanDataSet.binAverageX(rebinDescriptor2);
        XTaggedYScan[] xTaggedYScanArray = xTaggedYScanDataSet2.data;
        XTaggedYScan[] xTaggedYScanArray2 = xTaggedYScanDataSet2.getPeaks();
        XTaggedYScan[] xTaggedYScanArray3 = xTaggedYScanDataSet2.getWeights();
        int n3 = 0;
        while (n3 < xTaggedYScanDataSet.y_coordinate.length) {
            double d3 = this.getYAxis().transform(new Datum(n3));
            Line2D.Float float_ = new Line2D.Float(f2, (float)d3, f, (float)d3);
            graphics2D.setColor(Color.lightGray);
            graphics2D.draw(float_);
            graphics2D.setColor(Color.darkGray);
            double d4 = this.getYAxis().transform(new Datum((double)n3 + 1.0));
            double d5 = container.getHeight();
            pwRow pwRow2 = new pwRow(this.getCanvas(), d4 / d5, d3 / d5);
            this.zAxisComponent.setLittleRow(pwRow2);
            double[] dArray = rebinDescriptor2.binStarts();
            double[] dArray2 = rebinDescriptor2.binStops();
            double d6 = d3;
            Rectangle2D.Double double_ = new Rectangle2D.Double();
            Line2D.Double double_2 = new Line2D.Double();
            Rectangle2D.Double double_3 = new Rectangle2D.Double();
            int n4 = (int)pwRow2.getHeight();
            double d7 = this.zAxisComponent.getAxis().getDataMaximum().getValue();
            double d8 = TimeDatum.create("2003-7-12").convertTo(this.getXAxis().getUnits()).doubleValue();
            int n5 = 0;
            int n6 = 0;
            while (n6 < xTaggedYScanArray.length) {
                double d9;
                double d10 = (int)this.getXAxis().transform(dArray[n6], rebinDescriptor2.getUnits());
                double d11 = d10 + 1.0;
                if (xTaggedYScanArray3[n6].z[n3] > 0.0f && n6 > n5) {
                    n5 = n6;
                }
                d9 = (d9 = this.zAxisComponent.transform(xTaggedYScanArray[n6].z[n3], xTaggedYScanDataSet.getZUnits())) > d6 - (double)n4 ? d9 : d6 - (double)n4;
                double d12 = d6 - d9 > 0.0 ? d6 - d9 : 0.0;
                double d13 = d12 = d12 < (double)n4 ? d12 : (double)n4;
                if ((double)xTaggedYScanArray2[n6].z[n3] <= d7) {
                    double d14 = this.zAxisComponent.transform(xTaggedYScanArray2[n6].z[n3], xTaggedYScanDataSet.getZUnits());
                    double d15 = d14 = d6 - d14 > 0.0 ? d14 : d6;
                    if (this.peaksIndicator == PeaksIndicator.MaxLines) {
                        double_2.setLine(d10, d14, d10, d14);
                        graphics2D.drawLine((int)d10, (int)d14, (int)d10, (int)d14);
                    } else if (this.peaksIndicator == PeaksIndicator.GrayPeaks) {
                        double_3.setRect(d10, d14, d11 - d10, d6 - d14);
                        graphics2D.setColor(Color.lightGray);
                        graphics2D.fill(double_3);
                        graphics2D.setColor(Color.darkGray);
                    }
                }
                double_.setRect(d10, d9, d11 - d10, d12);
                graphics2D.fill(double_);
                ++n6;
            }
            ++n3;
        }
        graphics2D.setRenderingHints(renderingHints);
        graphics2D.dispose();
        container.setCursor(cursor);
    }

    public void setData(XTaggedYScanDataSet xTaggedYScanDataSet) {
        super.setData(xTaggedYScanDataSet);
    }

    public pwAxis getZAxis() {
        return this.zAxisComponent.getAxis();
    }

    public void setZTitle(String string) {
        this.getZAxis().setLabel(string);
    }

    protected void installComponent() {
        super.installComponent();
        this.getCanvas().addCanvasComponent(this.zAxisComponent);
    }

    public PeaksIndicator getPeaksIndicator() {
        return this.peaksIndicator;
    }

    public void setPeaksIndicator(PeaksIndicator peaksIndicator) {
        this.peaksIndicator = peaksIndicator;
        this.updatePlotImage();
        this.repaint();
    }

    public class ZAxisComponent
    extends pwCanvasComponent
    implements PropertyChangeListener {
        private pwAxis zAxis;
        private pwPlot parent;
        private pwRow rowLittle;
        private pwRow rowLittleDoc;
        private pwRow row0;

        public ZAxisComponent(pwPlot pwPlot2, pwAxis pwAxis2) {
            this.zAxis = pwAxis2;
            this.row0 = pwAxis2.getRow();
            this.setRow(pwPlot2.getRow());
            this.setColumn(pwPlot2.getColumn());
            this.parent = pwPlot2;
            this.setBounds(this.getBounds());
        }

        public Rectangle getBounds() {
            double d = this.parent.getColumn().getDMaximum();
            double d2 = this.zAxis.getColumn().getDMaximum();
            double d3 = this.parent.getRow().getDMaximum();
            double d4 = this.zAxis.getRow().getDMaximum();
            double d5 = this.parent.getRow().getDMinimum();
            double d6 = this.zAxis.getRow().getDMinimum();
            Rectangle rectangle = new Rectangle((int)d, (int)d5 - 1, (int)(d2 - d), (int)(d3 - d5 + 2.0));
            rectangle.add(d2, d6 - 1.0);
            rectangle.add(d2, d4 + 1.0);
            return rectangle;
        }

        protected pwAxis getAxis() {
            return this.zAxis;
        }

        public void setLittleRow(pwRow pwRow2) {
            this.rowLittle = pwRow2;
            double d = (this.zAxis.getRow().getDMinimum() + this.zAxis.getRow().getDMaximum()) / 2.0;
            if (pwRow2.contains(d)) {
                this.rowLittleDoc = pwRow2;
            }
        }

        public double transform(double d, Units units) {
            double d2 = this.zAxis.transform(d, units, this.rowLittle.getDMaximum(), this.rowLittle.getDMinimum());
            return d2;
        }

        public void resize() {
            this.setBounds(this.getBounds());
        }

        protected void paintComponent(Graphics graphics) {
            if (this.rowLittleDoc == null) {
                return;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.translate(-this.getX(), -this.getY());
            int n = 3;
            double d = this.parent.getColumn().getDMaximum() + (double)n;
            double d2 = this.zAxis.getColumn().getDMaximum() - (double)n;
            double d3 = this.rowLittleDoc.getDMaximum();
            double d4 = this.zAxis.getRow().getDMaximum();
            double d5 = this.rowLittleDoc.getDMinimum();
            double d6 = this.zAxis.getRow().getDMinimum();
            graphics2D.setColor(Color.lightGray);
            graphics2D.draw(new Line2D.Double(d - (double)n, d3, d, d3));
            graphics2D.draw(new Line2D.Double(d2, d4, d2 + (double)n, d4));
            graphics2D.draw(new Line2D.Double(d, d3, d2, d4));
            graphics2D.draw(new Line2D.Double(d - (double)n, d5, d, d5));
            graphics2D.draw(new Line2D.Double(d2, d6, d2 + (double)n, d6));
            graphics2D.draw(new Line2D.Double(d, d5, d2, d6));
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.update();
        }

        protected void installComponent() {
            super.installComponent();
            this.getCanvas().addCanvasComponent(this.zAxis);
        }
    }

    public static class PeaksIndicator
    implements PropertyEditor.Enumeration {
        String id;
        public static final PeaksIndicator GrayPeaks = new PeaksIndicator("Gray Peaks");
        public static final PeaksIndicator NoPeaks = new PeaksIndicator("None");
        public static final PeaksIndicator MaxLines = new PeaksIndicator("Lines");

        PeaksIndicator(String string) {
            this.id = string;
        }

        public String toString() {
            return this.id;
        }

        public Icon getListIcon() {
            return null;
        }
    }
}

