/*
 * Decompiled with CFR 0.152.
 */
package graph;

import components.DasProgressPanel;
import das.DasNameException;
import das_proto.DasException;
import das_proto.DasProperties;
import das_proto.data.ConstantDataSetDescriptor;
import das_proto.data.DataRequestThread;
import das_proto.data.DataRequestor;
import das_proto.data.DataSet;
import das_proto.data.DataSetConsumer;
import das_proto.data.DataSetDescriptor;
import das_proto.data.Datum;
import das_proto.data.Units;
import event.ProgressIndicator;
import event.dasMouseModuleCrossHair;
import event.dasMouseModuleHorizontalRangeSelector;
import event.dasMouseModuleVerticalRangeSelector;
import graph.Renderer;
import graph.SpectrogramRenderer;
import graph.SymbolLineRenderer;
import graph.dnd.TransferableRenderer;
import graph.pwAxis;
import graph.pwCanvas;
import graph.pwCanvasComponent;
import graph.pwColumn;
import graph.pwRow;
import graph.pwTimeAxis;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JEditorPane;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import util.DasExceptionHandler;
import util.DnDSupport;
import util.GrannyTextRenderer;
import util.pwDie;
import xml.DasForm;
import xml.DasPropertyException;

public class pwPlot
extends pwCanvasComponent
implements DataSetConsumer {
    protected DataSetDescriptor dataSetDescriptor;
    protected DataSet Data;
    private pwAxis xAxis;
    private pwAxis yAxis;
    protected String offsetTime = "";
    protected String plotTitle = "";
    protected double[] psym_x;
    protected double[] psym_y;
    protected Image plotImage;
    protected RebinListener rebinListener = new RebinListener();
    DnDSupport dndSupport;
    DataRequestThread drt;
    DasProgressPanel progressPanel;
    private int button = 0;
    private Point zoomStart;
    private Point zoomEnd;
    private boolean isShiftDown;
    private List renderers = null;
    static /* synthetic */ Class class$graph$pwRow;
    static /* synthetic */ Class class$graph$pwColumn;
    static /* synthetic */ Class class$graph$pwAxis;

    private pwPlot() {
        this.setOpaque(true);
    }

    public pwPlot(pwAxis pwAxis2, pwAxis pwAxis3, pwRow pwRow2, pwColumn pwColumn2) {
        super(pwRow2, pwColumn2);
        this.setOpaque(false);
        this.renderers = new ArrayList();
        this.xAxis = pwAxis2;
        if (pwAxis2 != null) {
            if (!pwAxis2.isHorizontal()) {
                throw new IllegalArgumentException("xAxis is not horizontal");
            }
            pwAxis2.addPropertyChangeListener("dataMinimum", this.rebinListener);
            pwAxis2.addPropertyChangeListener("dataMaximum", this.rebinListener);
            pwAxis2.addPropertyChangeListener("log", this.rebinListener);
        }
        this.yAxis = pwAxis3;
        if (pwAxis3 != null) {
            if (pwAxis3.isHorizontal()) {
                throw new IllegalArgumentException("yAxis is not vertical");
            }
            pwAxis3.addPropertyChangeListener("dataMinimum", this.rebinListener);
            pwAxis3.addPropertyChangeListener("dataMaximum", this.rebinListener);
            pwAxis3.addPropertyChangeListener("log", this.rebinListener);
        }
        if (!"true".equals(System.getProperty("java.awt.headless"))) {
            dasMouseModuleHorizontalRangeSelector dasMouseModuleHorizontalRangeSelector2 = new dasMouseModuleHorizontalRangeSelector(this, pwAxis2);
            this.mouseAdapter.addMouseModule(dasMouseModuleHorizontalRangeSelector2);
            this.mouseAdapter.setPrimaryModule(dasMouseModuleHorizontalRangeSelector2);
            dasMouseModuleHorizontalRangeSelector2.addDataRangeSelectionListener(pwAxis2);
            dasMouseModuleVerticalRangeSelector dasMouseModuleVerticalRangeSelector2 = new dasMouseModuleVerticalRangeSelector(this, pwAxis3);
            this.mouseAdapter.addMouseModule(dasMouseModuleVerticalRangeSelector2);
            dasMouseModuleVerticalRangeSelector2.addDataRangeSelectionListener(pwAxis3);
            dasMouseModuleCrossHair dasMouseModuleCrossHair2 = new dasMouseModuleCrossHair(this, pwAxis2, pwAxis3);
            this.mouseAdapter.addMouseModule(dasMouseModuleCrossHair2);
            this.mouseAdapter.setSecondaryModule(dasMouseModuleCrossHair2);
        }
    }

    public DataSet getDataSet() {
        return this.Data;
    }

    public DataSet getData() {
        return this.Data;
    }

    public void setXRange(double d, double d2) {
        this.setXRange(new Datum(d), new Datum(d2));
    }

    public void setXRange(Datum datum, Datum datum2) {
        this.xAxis.setDataRange(datum, datum2);
    }

    public void setYRange(double d, double d2) {
        this.setYRange(new Datum(d), new Datum(d2));
    }

    public void setYRange(Datum datum, Datum datum2) {
        this.yAxis.setDataRange(datum, datum2);
    }

    public void setDPosition(double d, double d2, double d3, double d4) {
        if (this.getRow() == null) {
            this.setRow(new pwRow((pwCanvas)this.getParent(), 0.0, 0.0));
        }
        if (this.getColumn() == null) {
            this.setColumn(new pwColumn((pwCanvas)this.getParent(), 0.0, 0.0));
        }
        this.getRow().setDPosition(d2, d2 + d4);
        this.getColumn().setDPosition(d, d + d3);
    }

    public void setPosition(double d, double d2, double d3, double d4) {
        if (this.getRow() == null) {
            this.setRow(new pwRow((pwCanvas)this.getParent(), 0.0, 0.0));
        }
        if (this.getColumn() == null) {
            this.setColumn(new pwColumn((pwCanvas)this.getParent(), 0.0, 0.0));
        }
        this.getRow().setPosition(d2, d2 + d4);
        this.getColumn().setPosition(d, d + d3);
    }

    public void setPosition(pwRow pwRow2, pwColumn pwColumn2) {
        this.setRow(pwRow2);
        this.setColumn(pwColumn2);
    }

    public void setRow(pwRow pwRow2) {
        super.setRow(pwRow2);
        if (this.xAxis != null) {
            this.xAxis.setRow(pwRow2);
        }
        if (this.yAxis != null) {
            this.yAxis.setRow(pwRow2);
        }
    }

    public void setColumn(pwColumn pwColumn2) {
        super.setColumn(pwColumn2);
        if (this.xAxis != null) {
            this.xAxis.setColumn(pwColumn2);
        }
        if (this.yAxis != null) {
            this.yAxis.setColumn(pwColumn2);
        }
    }

    public void setXAxis(pwAxis pwAxis2) {
        pwAxis pwAxis3 = this.xAxis;
        Container container = this.getParent();
        if (this.xAxis != null) {
            pwDie.println("setXAxis upsets the dmia");
            if (container != null) {
                container.remove(this.xAxis);
            }
            pwAxis2.removePropertyChangeListener("minimum", this.rebinListener);
            pwAxis2.removePropertyChangeListener("maximum", this.rebinListener);
            pwAxis2.removePropertyChangeListener("log", this.rebinListener);
        }
        this.xAxis = pwAxis2;
        if (pwAxis2 != null) {
            if (!pwAxis2.isHorizontal()) {
                throw new IllegalArgumentException("xAxis is not horizontal");
            }
            if (container != null) {
                container.add(this.xAxis);
            }
            pwAxis2.addPropertyChangeListener("minimum", this.rebinListener);
            pwAxis2.addPropertyChangeListener("maximum", this.rebinListener);
            pwAxis2.addPropertyChangeListener("log", this.rebinListener);
        }
        if (pwAxis2 != pwAxis3) {
            this.firePropertyChange("xAxis", pwAxis3, pwAxis2);
        }
    }

    public void setYAxis(pwAxis pwAxis2) {
        pwAxis pwAxis3 = this.yAxis;
        Container container = this.getParent();
        if (this.yAxis != null) {
            pwDie.println("setYAxis upsets the dmia");
            if (container != null) {
                container.remove(this.yAxis);
            }
            pwAxis2.removePropertyChangeListener("minimum", this.rebinListener);
            pwAxis2.removePropertyChangeListener("maximum", this.rebinListener);
            pwAxis2.removePropertyChangeListener("log", this.rebinListener);
        }
        this.yAxis = pwAxis2;
        if (pwAxis2 != null) {
            if (pwAxis2.isHorizontal()) {
                throw new IllegalArgumentException("yAxis is not vertical");
            }
            if (container != null) {
                container.add(this.yAxis);
            }
            pwAxis2.addPropertyChangeListener("minimum", this.rebinListener);
            pwAxis2.addPropertyChangeListener("maximum", this.rebinListener);
            pwAxis2.addPropertyChangeListener("log", this.rebinListener);
        }
        if (pwAxis2 != pwAxis3) {
            this.firePropertyChange("yAxis", pwAxis3, pwAxis2);
        }
    }

    protected void drawInvalid() {
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        if (graphics2D == null) {
            return;
        }
        graphics2D.translate(-this.getX(), -this.getY());
        Rectangle2D.Double double_ = pwRow.toRectangle(this.getRow(), this.getColumn());
        double_.width -= 1.0;
        double_.height -= 1.0;
        double_.y += 1.0;
        Color color = graphics2D.getColor();
        graphics2D.setColor(new Color(245, 245, 245, 220));
        graphics2D.fill(double_);
        graphics2D.dispose();
    }

    protected void updateImmediately() {
        if (this.dataSetDescriptor == null) {
            pwDie.println("DataSetDescriptor is null");
        } else {
            this.loadDataSet();
        }
        int n = 0;
        while (n < this.renderers.size()) {
            Renderer renderer = (Renderer)this.renderers.get(n);
            renderer.update(this.xAxis, this.yAxis);
            ++n;
        }
    }

    protected void loadDataSet() {
        if (this.getXAxis() instanceof pwTimeAxis) {
            final Container container = this.getParent();
            final Cursor cursor = null;
            if (container != null) {
                container.getCursor();
                container.setCursor(new Cursor(3));
            }
            if (container != null) {
                ((pwCanvas)container).lockDisplay(this);
            }
            Datum datum = this.getXAxis().getDataMaximum().subtract(this.getXAxis().getDataMinimum());
            double d = datum.convertTo(Units.seconds).doubleValue();
            double d2 = Math.floor(this.getColumn().getDMaximum() + 0.5) - Math.floor(this.getColumn().getDMinimum() + 0.5);
            double d3 = d / d2;
            pwTimeAxis pwTimeAxis2 = (pwTimeAxis)this.getXAxis();
            if (this.progressPanel == null) {
                this.progressPanel = new DasProgressPanel();
                ((Container)((pwCanvas)this.getParent()).getGlassPane()).add(this.progressPanel);
            }
            this.progressPanel.setSize(this.progressPanel.getPreferredSize());
            if (this.getX() == 0) {
                this.progressPanel.setVisible(false);
            } else {
                this.progressPanel.setLocation(this.getX() + (this.getWidth() - this.progressPanel.getWidth()) / 2, this.getY() + (this.getHeight() - this.progressPanel.getHeight()) / 2);
            }
            this.dataSetDescriptor.addDasReaderListener(this.progressPanel);
            this.dataSetDescriptor.setProgressIndicator(this.progressPanel);
            DataRequestor dataRequestor = new DataRequestor(){

                public void currentByteCount(int n) {
                }

                public void totalByteCount(int n) {
                }

                public void exception(Exception exception) {
                    if (!(exception instanceof InterruptedIOException)) {
                        Object[] objectArray = new Object[]{"Error reading data set", new JEditorPane("text/html", exception.getMessage())};
                        ((JEditorPane)objectArray[1]).setEditable(false);
                        DasExceptionHandler.handle(exception);
                        this.finished(null);
                    }
                }

                public void finished(DataSet dataSet) {
                    if (pwPlot.this.dataSetDescriptor != null) {
                        pwPlot.this.dataSetDescriptor.removeDasReaderListener(pwPlot.this.progressPanel);
                    }
                    pwPlot.this.progressPanel.setVisible(false);
                    if (container != null) {
                        container.setCursor(cursor);
                    }
                    pwPlot.this.Data = dataSet;
                    pwPlot.this.updatePlotImage();
                    if (container != null) {
                        ((pwCanvas)container).freeDisplay(this);
                    }
                }
            };
            if (this.drt == null) {
                this.drt = new DataRequestThread();
            }
            try {
                this.drt.request(this.dataSetDescriptor, "", pwTimeAxis2.getTimeMinimum(), pwTimeAxis2.getTimeMaximum(), d3, dataRequestor);
            }
            catch (InterruptedException interruptedException) {
                DasExceptionHandler.handle(interruptedException);
            }
        } else if (this.dataSetDescriptor instanceof ConstantDataSetDescriptor) {
            try {
                this.Data = this.dataSetDescriptor.getDataSet(null, null, null);
                this.updatePlotImage();
            }
            catch (DasException dasException) {
                DasExceptionHandler.handle(dasException);
            }
        } else {
            throw new AssertionError((Object)"axis not a timeAxis, and DataSetDescriptor is not constant");
        }
    }

    protected void updatePlotImage() {
    }

    protected void paintComponent(Graphics graphics) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHints(DasProperties.getRenderingHints());
        int n = (int)Math.floor(this.getColumn().getDMinimum() + 0.5);
        int n2 = (int)Math.floor(this.getRow().getDMinimum() + 0.5);
        int n3 = (int)Math.floor(this.getColumn().getDMaximum() + 0.5) - n;
        int n4 = (int)Math.floor(this.getRow().getDMaximum() + 0.5) - n2;
        graphics2D.translate(-this.getX(), -this.getY());
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create(n - 1, n2 - 1, n3 + 2, n4 + 2);
        graphics2D2.translate(-n + 1, -n2 + 1);
        this.drawContent(graphics2D2);
        int n5 = 0;
        while (n5 < this.renderers.size()) {
            object = (Renderer)this.renderers.get(n5);
            ((Renderer)object).render(graphics2D2, this.xAxis, this.yAxis);
            ++n5;
        }
        graphics2D.setColor(Color.black);
        graphics2D.drawRect(n - 1, n2 - 1, n3 + 1, n4 + 1);
        if (this.plotTitle != null && this.plotTitle.length() != 0) {
            object = this.getFont();
            GrannyTextRenderer grannyTextRenderer = new GrannyTextRenderer();
            grannyTextRenderer.setAlignment(1);
            grannyTextRenderer.setString(this, this.plotTitle);
            int n6 = (int)grannyTextRenderer.getWidth();
            pwColumn pwColumn2 = this.getColumn();
            int n7 = n + (n3 - n6) / 2;
            int n8 = n2 - (int)grannyTextRenderer.getDescent() - (int)grannyTextRenderer.getAscent() / 2;
            grannyTextRenderer.draw(graphics2D, n7, n8);
        }
    }

    protected void drawContent(Graphics2D graphics2D) {
        if (this.plotImage != null) {
            int n = (int)Math.floor(this.getColumn().getDMinimum() + 0.5);
            int n2 = (int)Math.floor(this.getRow().getDMinimum() + 0.5);
            graphics2D.drawImage(this.plotImage, n, n2 + 1, this);
        }
    }

    public void resize() {
        Font font = this.getFont();
        GrannyTextRenderer grannyTextRenderer = new GrannyTextRenderer();
        grannyTextRenderer.setString(this, this.getTitle());
        int n = (int)grannyTextRenderer.getHeight() + (int)grannyTextRenderer.getAscent() / 2;
        Rectangle rectangle = new Rectangle();
        rectangle.x = (int)Math.floor(this.getColumn().getDMinimum() + 0.5) - 1;
        rectangle.y = (int)Math.floor(this.getRow().getDMinimum() + 0.5) - 1;
        rectangle.width = (int)Math.floor(this.getColumn().getDMaximum() + 0.5) - rectangle.x + 1;
        rectangle.height = (int)Math.floor(this.getRow().getDMaximum() + 0.5) - rectangle.y + 1;
        if (!this.getTitle().equals("")) {
            rectangle.y -= n;
            rectangle.height += n;
        }
        this.setBounds(rectangle);
    }

    public void setTitle(String string) {
        String string2 = this.plotTitle;
        this.plotTitle = string;
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = fontMetrics.getHeight() + fontMetrics.getHeight() / 2;
        this.resize();
        this.repaint(0, 0, this.getWidth(), n);
        if (string != string2) {
            this.firePropertyChange("title", string2, string);
        }
    }

    public String getTitle() {
        return this.plotTitle;
    }

    public pwAxis getXAxis() {
        return this.xAxis;
    }

    public pwAxis getYAxis() {
        return this.yAxis;
    }

    public DataSetDescriptor getDataSetDescriptor() {
        return this.dataSetDescriptor;
    }

    public void setDataSetDescriptor(DataSetDescriptor dataSetDescriptor) {
        this.dataSetDescriptor = dataSetDescriptor;
        this.markDirty();
    }

    public void setData(DataSet dataSet) {
        this.Data = dataSet;
        this.markDirty();
    }

    protected void installComponent() {
        super.installComponent();
        if (this.xAxis != null) {
            this.getParent().add(this.xAxis);
        }
        if (this.yAxis != null) {
            this.getParent().add(this.yAxis);
        }
        Renderer[] rendererArray = this.getRenderers();
        int n = 0;
        while (n < rendererArray.length) {
            rendererArray[n].installRenderer();
            ++n;
        }
        if (!"true".equals(System.getProperty("java.awt.headless"))) {
            this.dndSupport = new PlotDnDSupport(this.getCanvas().dndSupport);
        }
    }

    protected void uninstallComponent() {
        super.uninstallComponent();
        if (this.xAxis != null) {
            this.xAxis.getCanvas().remove(this.xAxis);
        }
        if (this.yAxis != null) {
            this.yAxis.getCanvas().remove(this.yAxis);
        }
        Renderer[] rendererArray = this.getRenderers();
        int n = 0;
        while (n < rendererArray.length) {
            rendererArray[n].uninstallRenderer();
            ++n;
        }
    }

    public void addRenderer(Renderer renderer) {
        if (renderer.parent != null) {
            renderer.parent.removeRenderer(renderer);
        }
        this.renderers.add(renderer);
        renderer.parent = this;
        if (this.getCanvas() != null) {
            renderer.installRenderer();
        }
    }

    public void removeRenderer(Renderer renderer) {
        if (this.getCanvas() != null) {
            renderer.uninstallRenderer();
        }
        this.renderers.remove(renderer);
        renderer.parent = null;
    }

    public static pwPlot createDummyPlot(pwRow pwRow2, pwColumn pwColumn2) {
        pwAxis pwAxis2 = new pwAxis(new Datum(0.0), new Datum(10.0), pwRow2, pwColumn2, 2);
        pwAxis pwAxis3 = new pwAxis(new Datum(0.0), new Datum(10.0), pwRow2, pwColumn2, 3);
        pwPlot pwPlot2 = new pwPlot(pwAxis2, pwAxis3, pwRow2, pwColumn2);
        return pwPlot2;
    }

    public Renderer getRenderer(int n) {
        return (Renderer)this.renderers.get(n);
    }

    public Renderer[] getRenderers() {
        return this.renderers.toArray(new Renderer[0]);
    }

    public static pwPlot processPlotElement(Element element, DasForm dasForm) throws DasPropertyException, DasNameException {
        Object object;
        String string = element.getAttribute("name");
        pwRow pwRow2 = (pwRow)dasForm.checkValue(element.getAttribute("row"), class$graph$pwRow == null ? (class$graph$pwRow = pwPlot.class$("graph.pwRow")) : class$graph$pwRow, "<row>");
        pwColumn pwColumn2 = (pwColumn)dasForm.checkValue(element.getAttribute("column"), class$graph$pwColumn == null ? (class$graph$pwColumn = pwPlot.class$("graph.pwColumn")) : class$graph$pwColumn, "<column>");
        pwAxis pwAxis2 = null;
        pwAxis pwAxis3 = null;
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            object = nodeList.item(n);
            if (object instanceof Element) {
                if (object.getNodeName().equals("xAxis")) {
                    pwAxis2 = pwPlot.processXAxisElement((Element)object, pwRow2, pwColumn2, dasForm);
                } else if (object.getNodeName().equals("yAxis")) {
                    pwAxis3 = pwPlot.processYAxisElement((Element)object, pwRow2, pwColumn2, dasForm);
                }
            }
            ++n;
        }
        if (pwAxis2 == null) {
            pwAxis2 = (pwAxis)dasForm.checkValue(element.getAttribute("xAxis"), class$graph$pwAxis == null ? (class$graph$pwAxis = pwPlot.class$("graph.pwAxis")) : class$graph$pwAxis, "<axis> or <timeaxis>");
        }
        if (pwAxis3 == null) {
            pwAxis3 = (pwAxis)dasForm.checkValue(element.getAttribute("yAxis"), class$graph$pwAxis == null ? (class$graph$pwAxis = pwPlot.class$("graph.pwAxis")) : class$graph$pwAxis, "<axis> or <timeaxis>");
        }
        object = new pwPlot(pwAxis2, pwAxis3, pwRow2, pwColumn2);
        ((pwPlot)object).setTitle(element.getAttribute("title"));
        try {
            ((pwCanvasComponent)object).setDasName(string);
        }
        catch (DasNameException dasNameException) {
            DasExceptionHandler.handle(dasNameException);
        }
        int n2 = 0;
        while (n2 < nodeList.getLength()) {
            Node node = nodeList.item(n2);
            if (node instanceof Element && node.getNodeName().equals("renderers")) {
                pwPlot.processRenderersElement((Element)node, (pwPlot)object, dasForm);
            }
            ++n2;
        }
        return object;
    }

    private static pwAxis processXAxisElement(Element element, pwRow pwRow2, pwColumn pwColumn2, DasForm dasForm) throws DasPropertyException, DasNameException {
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof Element) {
                Element element2 = (Element)node;
                if (node.getNodeName().equals("axis")) {
                    pwAxis pwAxis2 = pwAxis.processAxisElement(element2, pwRow2, pwColumn2, dasForm);
                    if (!pwAxis2.isHorizontal()) {
                        pwAxis2.setOrientation(2);
                    }
                    return pwAxis2;
                }
                if (node.getNodeName().equals("timeaxis")) {
                    pwTimeAxis pwTimeAxis2 = pwTimeAxis.processTimeaxisElement(element2, pwRow2, pwColumn2, dasForm);
                    if (!pwTimeAxis2.isHorizontal()) {
                        pwTimeAxis2.setOrientation(2);
                    }
                    return pwTimeAxis2;
                }
                if (node.getNodeName().equals("attachedaxis")) {
                    pwAxis pwAxis3 = pwAxis.processAttachedaxisElement(element2, pwRow2, pwColumn2, dasForm);
                    if (!pwAxis3.isHorizontal()) {
                        pwAxis3.setOrientation(2);
                    }
                    return pwAxis3;
                }
            }
            ++n;
        }
        return null;
    }

    private static pwAxis processYAxisElement(Element element, pwRow pwRow2, pwColumn pwColumn2, DasForm dasForm) throws DasPropertyException, DasNameException {
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof Element) {
                Element element2 = (Element)node;
                if (node.getNodeName().equals("axis")) {
                    pwAxis pwAxis2 = pwAxis.processAxisElement(element2, pwRow2, pwColumn2, dasForm);
                    if (pwAxis2.isHorizontal()) {
                        pwAxis2.setOrientation(3);
                    }
                    return pwAxis2;
                }
                if (node.getNodeName().equals("timeaxis")) {
                    pwTimeAxis pwTimeAxis2 = pwTimeAxis.processTimeaxisElement(element2, pwRow2, pwColumn2, dasForm);
                    if (pwTimeAxis2.isHorizontal()) {
                        pwTimeAxis2.setOrientation(3);
                    }
                    return pwTimeAxis2;
                }
                if (node.getNodeName().equals("attachedaxis")) {
                    pwAxis pwAxis3 = pwAxis.processAttachedaxisElement(element2, pwRow2, pwColumn2, dasForm);
                    if (pwAxis3.isHorizontal()) {
                        pwAxis3.setOrientation(3);
                    }
                    return pwAxis3;
                }
            }
            ++n;
        }
        return null;
    }

    private static void processRenderersElement(Element element, pwPlot pwPlot2, DasForm dasForm) throws DasPropertyException, DasNameException {
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof Element) {
                if (node.getNodeName().equals("spectrogram")) {
                    pwPlot2.addRenderer(SpectrogramRenderer.processSpectrogramElement((Element)node, pwPlot2, dasForm));
                } else if (node.getNodeName().equals("lineplot")) {
                    pwPlot2.addRenderer(SymbolLineRenderer.processLinePlotElement((Element)node, pwPlot2, dasForm));
                }
            }
            ++n;
        }
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("plot");
        element.setAttribute("name", this.getDasName());
        element.setAttribute("row", this.getRow().getDasName());
        element.setAttribute("column", this.getColumn().getDasName());
        element.setAttribute("title", this.getTitle());
        Element element2 = document.createElement("xAxis");
        Element element3 = this.getXAxis().getDOMElement(document);
        element3.removeAttribute("orientation");
        if (element3.getAttribute("row").equals(this.getRow().getDasName())) {
            element3.removeAttribute("row");
        }
        if (element3.getAttribute("column").equals(this.getColumn().getDasName())) {
            element3.removeAttribute("column");
        }
        element2.appendChild(element3);
        element.appendChild(element2);
        Element element4 = document.createElement("yAxis");
        Element element5 = this.getYAxis().getDOMElement(document);
        element5.removeAttribute("orientation");
        if (element5.getAttribute("row").equals(this.getRow().getDasName())) {
            element5.removeAttribute("row");
        }
        if (element5.getAttribute("column").equals(this.getColumn().getDasName())) {
            element5.removeAttribute("column");
        }
        element4.appendChild(element5);
        element.appendChild(element4);
        Renderer[] rendererArray = this.getRenderers();
        if (rendererArray.length > 0) {
            Element element6 = document.createElement("renderers");
            int n = 0;
            while (n < rendererArray.length) {
                if (rendererArray[n] instanceof SpectrogramRenderer) {
                    element6.appendChild(((SpectrogramRenderer)rendererArray[n]).getDOMElement(document));
                } else if (rendererArray[n] instanceof SymbolLineRenderer) {
                    element6.appendChild(((SymbolLineRenderer)rendererArray[n]).getDOMElement(document));
                }
                ++n;
            }
            element.appendChild(element6);
        }
        return element;
    }

    public static pwPlot createNamedPlot(String string) {
        pwTimeAxis pwTimeAxis2 = pwTimeAxis.createNamedTimeAxis(null);
        pwTimeAxis2.setOrientation(2);
        pwAxis pwAxis2 = pwAxis.createNamedAxis(null);
        pwAxis2.setOrientation(3);
        pwPlot pwPlot2 = new pwPlot(pwTimeAxis2, pwAxis2, null, null);
        if (string == null) {
            string = "plot_" + Integer.toHexString(System.identityHashCode(pwPlot2));
        }
        try {
            pwPlot2.setDasName(string);
        }
        catch (DasNameException dasNameException) {
            DasExceptionHandler.handle(dasNameException);
        }
        return pwPlot2;
    }

    public ProgressIndicator getProgressIndicator() {
        return this.progressPanel;
    }

    public Shape getActiveRegion() {
        return this.getBounds();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class PlotDnDSupport
    extends DnDSupport {
        PlotDnDSupport(DnDSupport dnDSupport) {
            super(pwPlot.this, 3, dnDSupport);
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
        }

        protected int canAccept(DataFlavor[] dataFlavorArray, int n, int n2, int n3) {
            int n4 = 0;
            while (n4 < dataFlavorArray.length) {
                if (dataFlavorArray[n4].equals(TransferableRenderer.RENDERER_FLAVOR)) {
                    return n3;
                }
                ++n4;
            }
            return -1;
        }

        protected void done() {
        }

        protected boolean importData(Transferable transferable, int n, int n2, int n3) {
            boolean bl = false;
            try {
                Renderer renderer = (Renderer)transferable.getTransferData(TransferableRenderer.RENDERER_FLAVOR);
                pwPlot.this.addRenderer(renderer);
                pwPlot.this.revalidate();
                bl = true;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {}
            return bl;
        }

        protected Transferable getTransferable(int n, int n2, int n3) {
            return null;
        }

        protected void exportDone(Transferable transferable, int n) {
        }
    }

    protected class RebinListener
    implements PropertyChangeListener {
        protected RebinListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            pwPlot.this.markDirty();
            pwPlot.this.update();
        }
    }
}

