/*
 * Decompiled with CFR 0.152.
 */
package graph;

import components.PropertyEditor;
import das.DasNameException;
import das.NameContext;
import graph.event.pwUpdateEvent;
import graph.event.pwUpdateListener;
import graph.pwCanvas;
import graph.pwColumn;
import graph.pwRow;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import javax.swing.event.EventListenerList;

public abstract class pwDevicePosition
implements PropertyEditor.Editable,
Serializable {
    protected transient pwCanvas parent;
    private double minimum;
    private double maximum;
    private String dasName;
    private transient PropertyChangeSupport propertyChangeDelegate;
    protected EventListenerList listenerList = new EventListenerList();
    static /* synthetic */ Class class$graph$event$pwUpdateListener;

    public pwDevicePosition(pwCanvas pwCanvas2, double d, double d2) {
        if (pwCanvas2 == null) {
            throw new IllegalArgumentException("parent cannot be null, absolute rows and columns are no longer allowed. Jun 26, 03");
        }
        this.parent = pwCanvas2;
        this.minimum = d;
        this.maximum = d2;
        this.dasName = "dp_" + Integer.toString(this.hashCode());
        this.propertyChangeDelegate = new PropertyChangeSupport(this);
        if (pwCanvas2 != null) {
            pwCanvas2.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent componentEvent) {
                    pwDevicePosition.this.firePropertyChange("dMinimum", 0.0, pwDevicePosition.this.getDMinimum());
                    pwDevicePosition.this.firePropertyChange("dMaximum", 0.0, pwDevicePosition.this.getDMaximum());
                    pwDevicePosition.this.fireUpdate();
                }
            });
            pwCanvas2.addDevicePosition(this);
        }
    }

    public void setDasName(String string) throws DasNameException {
        if (string.equals(this.dasName)) {
            return;
        }
        String string2 = this.dasName;
        this.dasName = string;
        NameContext.getDefaultNameContext().put(string, this);
        if (string2 != null) {
            NameContext.getDefaultNameContext().remove(string2);
        }
        this.firePropertyChange("name", string2, string);
    }

    public String getDasName() {
        return this.dasName;
    }

    public double getDMinimum() {
        return this.minimum * this.getDeviceSize();
    }

    public double getDMaximum() {
        return this.maximum * this.getDeviceSize();
    }

    public double getMinimum() {
        return this.minimum;
    }

    public double getMaximum() {
        return this.maximum;
    }

    public void setPosition(double d, double d2) {
        double d3 = this.minimum;
        double d4 = this.maximum;
        this.minimum = Math.min(d, d2);
        this.maximum = Math.max(d2, d2);
        if (d3 != this.minimum) {
            this.firePropertyChange("minimum", d3, this.minimum);
            this.firePropertyChange("dMinimum", d3 * this.getDeviceSize(), this.getDMinimum());
        }
        if (d4 != this.maximum) {
            this.firePropertyChange("maximum", d4, this.maximum);
            this.firePropertyChange("dMaximum", d4 * this.getDeviceSize(), this.getDMaximum());
        }
        this.fireUpdate();
    }

    public void setDPosition(double d, double d2) {
        this.setPosition(d / this.getDeviceSize(), d2 / this.getDeviceSize());
    }

    public void setMaximum(double d) {
        if (d == this.maximum) {
            return;
        }
        if (d < this.minimum) {
            this.setPosition(d, this.minimum);
        } else {
            double d2 = this.maximum;
            this.maximum = d;
            this.firePropertyChange("maximum", d2, d);
            this.firePropertyChange("dMaximum", d2 * this.getDeviceSize(), this.getDMaximum());
            this.fireUpdate();
        }
    }

    public void setDMaximum(double d) {
        this.setMaximum(d / this.getDeviceSize());
    }

    public void setMinimum(double d) {
        if (d == this.minimum) {
            return;
        }
        if (d > this.maximum) {
            this.setPosition(this.maximum, d);
        } else {
            double d2 = this.minimum;
            this.minimum = d;
            this.firePropertyChange("minimum", d2, d);
            this.firePropertyChange("dMinimum", d2 * this.getDeviceSize(), this.getDMinimum());
            this.fireUpdate();
        }
    }

    public void setDMinimum(double d) {
        this.setMinimum(d / this.getDeviceSize());
    }

    public void translate(double d) {
        this.setPosition(this.minimum + d, this.maximum + d);
    }

    public void dTranslate(double d) {
        this.setDPosition(this.getDMinimum() + d, this.getDMaximum() + d);
    }

    public pwCanvas getParent() {
        return this.parent;
    }

    public void setParent(pwCanvas pwCanvas2) {
        this.parent = pwCanvas2;
        this.fireUpdate();
    }

    public void addpwUpdateListener(pwUpdateListener pwUpdateListener2) {
        this.listenerList.add(class$graph$event$pwUpdateListener == null ? (class$graph$event$pwUpdateListener = pwDevicePosition.class$("graph.event.pwUpdateListener")) : class$graph$event$pwUpdateListener, pwUpdateListener2);
    }

    public void removepwUpdateListener(pwUpdateListener pwUpdateListener2) {
        this.listenerList.remove(class$graph$event$pwUpdateListener == null ? (class$graph$event$pwUpdateListener = pwDevicePosition.class$("graph.event.pwUpdateListener")) : class$graph$event$pwUpdateListener, pwUpdateListener2);
    }

    protected void fireUpdate() {
        pwUpdateEvent pwUpdateEvent2 = new pwUpdateEvent(this);
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$graph$event$pwUpdateListener == null ? pwDevicePosition.class$("graph.event.pwUpdateListener") : class$graph$event$pwUpdateListener)) {
                ((pwUpdateListener)objectArray[n + 1]).update(pwUpdateEvent2);
            }
            n -= 2;
        }
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeDelegate.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeDelegate.addPropertyChangeListener(string, propertyChangeListener);
    }

    protected void firePropertyChange(String string, boolean bl, boolean bl2) {
        this.firePropertyChange(string, bl ? Boolean.TRUE : Boolean.FALSE, bl2 ? Boolean.TRUE : Boolean.FALSE);
    }

    protected void firePropertyChange(String string, int n, int n2) {
        this.firePropertyChange(string, new Integer(n), new Integer(n2));
    }

    protected void firePropertyChange(String string, long l, long l2) {
        this.firePropertyChange(string, new Long(l), new Long(l2));
    }

    protected void firePropertyChange(String string, float f, float f2) {
        this.firePropertyChange(string, new Float(f), new Float(f2));
    }

    protected void firePropertyChange(String string, double d, double d2) {
        this.firePropertyChange(string, new Double(d), new Double(d2));
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.propertyChangeDelegate.firePropertyChange(string, object, object2);
    }

    protected abstract double getDeviceSize();

    public static Rectangle2D.Double toRectangle(pwRow pwRow2, pwColumn pwColumn2) {
        double d = pwColumn2.getDMinimum();
        double d2 = pwRow2.getDMinimum();
        return new Rectangle2D.Double(d, d2, pwColumn2.getDMaximum() - d, pwRow2.getDMaximum() - d2);
    }

    public String toString() {
        return this.getClass().getName() + "[minimum=" + this.getDMinimum() + " maximum=" + this.getDMaximum() + "]";
    }

    public boolean contains(double d) {
        return this.getDMinimum() <= d && d <= this.getDMaximum();
    }

    public double getDMiddle() {
        return (this.getDMinimum() + this.getDMaximum()) / 2.0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

