/*
 * Decompiled with CFR 0.152.
 */
package graph;

import components.PropertyEditor;
import das.DasNameException;
import das.NameContext;
import event.DasUpdateEvent;
import event.dasMouseInputAdapter_1;
import event.dasMouseModule;
import graph.event.pwUpdateEvent;
import graph.event.pwUpdateListener;
import graph.pwCanvas;
import graph.pwColumn;
import graph.pwRow;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import javax.swing.JPanel;
import util.pwDie;

public abstract class pwCanvasComponent
extends JPanel
implements PropertyEditor.Editable {
    private pwRow row;
    private pwColumn column;
    private ResizeListener rl = new ResizeListener();
    protected dasMouseInputAdapter_1 mouseAdapter = new dasMouseInputAdapter_1(this);
    private String dasName;
    private DasUpdateEvent devt;
    boolean dirty = true;

    public pwCanvasComponent() {
        this.addMouseListener(this.mouseAdapter);
        this.addMouseMotionListener(this.mouseAdapter);
        try {
            this.setDasName("c_" + Integer.toString(this.hashCode()));
        }
        catch (DasNameException dasNameException) {}
    }

    public pwCanvasComponent(pwRow pwRow2, pwColumn pwColumn2) {
        this();
        this.setRow(pwRow2);
        this.setColumn(pwColumn2);
    }

    public void addMouseModule(dasMouseModule dasMouseModule2) {
        this.mouseAdapter.addMouseModule(dasMouseModule2);
    }

    public void removeMouseModule(dasMouseModule dasMouseModule2) {
        this.mouseAdapter.removeMouseModule(dasMouseModule2);
    }

    public pwRow getRow() {
        return this.row;
    }

    public pwColumn getColumn() {
        return this.column;
    }

    public void resize() {
        if (this.column == null) {
            pwDie.println("" + this + " has null column in resize");
        } else if (this.row == null) {
            pwDie.println("" + this + " has null row in resize");
        } else {
            this.setBounds((int)this.column.getDMinimum(), (int)this.row.getDMinimum(), (int)(this.column.getDMaximum() - this.column.getDMinimum()), (int)(this.row.getDMaximum() - this.row.getDMinimum()));
        }
    }

    public void setRow(pwRow pwRow2) {
        if (this.row == pwRow2) {
            return;
        }
        pwRow pwRow3 = this.row;
        if (this.row != null) {
            this.row.removepwUpdateListener(this.rl);
        }
        this.row = pwRow2;
        if (this.row != null) {
            this.row.addpwUpdateListener(this.rl);
        }
        this.firePropertyChange("row", pwRow3, pwRow2);
    }

    public void setColumn(pwColumn pwColumn2) {
        if (this.column == pwColumn2) {
            return;
        }
        pwColumn pwColumn3 = this.column;
        if (this.column != null) {
            this.column.removepwUpdateListener(this.rl);
        }
        this.column = pwColumn2;
        if (this.column != null) {
            this.column.addpwUpdateListener(this.rl);
        }
        this.firePropertyChange("column", pwColumn3, pwColumn2);
    }

    public void showProperties() {
        PropertyEditor propertyEditor = new PropertyEditor(this);
        propertyEditor.showDialog(this);
    }

    public String toString() {
        return this.getClass().getName() + "'" + this.getName() + "'";
    }

    protected void updateImmediately() {
    }

    public void update() {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        if (this.devt == null) {
            this.devt = new DasUpdateEvent(this);
        }
        eventQueue.postEvent(this.devt);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        super.processEvent(aWTEvent);
        if (aWTEvent instanceof DasUpdateEvent) {
            this.processDasUpdateEvent((DasUpdateEvent)aWTEvent);
        }
    }

    protected void processDasUpdateEvent(DasUpdateEvent dasUpdateEvent) {
        if (this.isDisplayable()) {
            if (this.isDirty()) {
                this.markClean();
                this.updateImmediately();
            }
            this.resize();
            this.repaint();
        }
    }

    protected AWTEvent coalesceEvents(AWTEvent aWTEvent, AWTEvent aWTEvent2) {
        if (aWTEvent instanceof DasUpdateEvent && aWTEvent2 instanceof DasUpdateEvent) {
            return aWTEvent;
        }
        return super.coalesceEvents(aWTEvent, aWTEvent2);
    }

    protected void installComponent() {
    }

    protected void uninstallComponent() {
    }

    public Font getFont() {
        return this.getParent() == null ? super.getFont() : this.getParent().getFont();
    }

    void markDirty() {
        this.dirty = true;
    }

    boolean isDirty() {
        return this.dirty;
    }

    void markClean() {
        this.dirty = false;
    }

    public pwCanvas getCanvas() {
        return (pwCanvas)this.getParent();
    }

    public String getDasName() {
        return this.dasName;
    }

    public void setDasName(String string) throws DasNameException {
        if (string.equals(this.dasName)) {
            return;
        }
        String string2 = this.dasName;
        this.dasName = string;
        NameContext.getDefaultNameContext().put(string, this);
        if (string2 != null) {
            NameContext.getDefaultNameContext().remove(string2);
        }
        this.firePropertyChange("name", string2, string);
    }

    public Shape getActiveRegion() {
        int n = (int)Math.round(this.getColumn().getDMinimum());
        int n2 = (int)Math.round(this.getRow().getDMinimum());
        int n3 = (int)Math.round(this.getColumn().getDMaximum()) - n;
        int n4 = (int)Math.round(this.getRow().getDMaximum()) - n2;
        return new Rectangle(n, n2, n3, n4);
    }

    private class ResizeListener
    implements pwUpdateListener {
        private ResizeListener() {
        }

        public void update(pwUpdateEvent pwUpdateEvent2) {
            pwCanvasComponent.this.markDirty();
            pwCanvasComponent.this.update();
        }
    }
}

