/*
 * Decompiled with CFR 0.152.
 */
package graph;

import components.PropertyEditor;
import das.DasNameException;
import das.NameContext;
import das_proto.DasProperties;
import graph.Renderer;
import graph.SpectrogramRenderer;
import graph.dnd.TransferableCanvasComponent;
import graph.pwAxis;
import graph.pwCanvasComponent;
import graph.pwColorBar;
import graph.pwColumn;
import graph.pwDevicePosition;
import graph.pwPlot;
import graph.pwRow;
import graph.pwSpectrogramPlot;
import graph.pwTimeAxis;
import java.awt.AWTEventMulticaster;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import util.DasExceptionHandler;
import util.DasPNGEncoder;
import util.DnDSupport;
import util.pwDie;
import xml.DasForm;
import xml.DasPropertyException;
import xml.FormComponent;
import xml.ParsedExpressionException;

public class pwCanvas
extends JLayeredPane
implements Printable,
PropertyEditor.Editable,
FormComponent,
ItemSelectable {
    public static final Integer DEFAULT_LAYER = JLayeredPane.DEFAULT_LAYER;
    public static final Integer PLOT_LAYER = new Integer(300);
    public static final Integer VERTICAL_AXIS_LAYER = new Integer(400);
    public static final Integer HORIZONTAL_AXIS_LAYER = new Integer(500);
    public static final Integer AXIS_LAYER = VERTICAL_AXIS_LAYER;
    public static final Integer ANNOTATION_LAYER = new Integer(1000);
    public static final Integer GLASS_PANE_LAYER = new Integer(30000);
    private final GlassPane glassPane;
    private String dasName;
    private JPopupMenu popup;
    private boolean editable;
    List devicePositionList = new ArrayList();
    DnDSupport dndSupport;
    private ItemListener itemListener;
    private int displayLockCount = 0;
    private Object displayLockObject = new String("DISPLAY_LOCK_OBJECT");
    private static final int R_1024_X_768 = 786432;
    private static final int R_800_X_600 = 480000;
    private static final int R_640_X_480 = 307200;
    private static final int R_320_X_240 = 76800;
    private HashSet horizontalLineSet = new HashSet();
    private HashSet verticalLineSet = new HashSet();
    private HashSet cellSet = new HashSet();

    public pwCanvas() {
        LookAndFeel.installColorsAndFont(this, "Panel.background", "Panel.foreground", "Panel.font");
        this.setOpaque(true);
        this.setLayout(new RowColumnLayout());
        this.addComponentListener(this.createResizeListener());
        this.setBackground(Color.white);
        this.setDoubleBuffered(true);
        this.glassPane = new GlassPane();
        this.add((Component)this.glassPane, GLASS_PANE_LAYER);
        this.popup = this.createPopupMenu();
        this.addMouseListener(this.createMouseInputAdapter());
        if (!"true".equals(System.getProperty("java.awt.headless"))) {
            this.dndSupport = new CanvasDnDSupport();
        }
    }

    private MouseInputAdapter createMouseInputAdapter() {
        return new MouseInputAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                pwCanvas.this.popup.show(pwCanvas.this, mouseEvent.getX(), mouseEvent.getY());
            }
        };
    }

    private ActionListener createPopupMenuListener() {
        return new ActionListener(){
            private JFileChooser pngFileChooser;
            private JPanel pngFileNamePanel;
            private JTextField pngFileTextField;

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Das Properties")) {
                    DasProperties.showEditor();
                } else if (string.equals("print")) {
                    Printable printable = pwCanvas.this.getPrintable();
                    PrinterJob printerJob = PrinterJob.getPrinterJob();
                    printerJob.setPrintable(printable);
                    if (printerJob.printDialog()) {
                        try {
                            printerJob.print();
                        }
                        catch (PrinterException printerException) {
                            Object[] objectArray = new Object[]{"Error printing", printerException.getMessage()};
                            JOptionPane.showMessageDialog(null, objectArray, "ERROR", 0);
                        }
                    }
                } else if (string.equals("toPng")) {
                    Object object;
                    if (this.pngFileNamePanel == null) {
                        this.pngFileNamePanel = new JPanel();
                        this.pngFileNamePanel.setLayout(new BoxLayout(this.pngFileNamePanel, 0));
                        this.pngFileTextField = new JTextField(32);
                        this.pngFileTextField.setMaximumSize(this.pngFileTextField.getPreferredSize());
                        this.pngFileChooser = new JFileChooser();
                        this.pngFileChooser.setApproveButtonText("Select File");
                        this.pngFileChooser.setDialogTitle("Write to PNG");
                        object = new JButton("Browse");
                        ((AbstractButton)object).setActionCommand("pngBrowse");
                        ((AbstractButton)object).addActionListener(this);
                        this.pngFileNamePanel.add(this.pngFileTextField);
                        this.pngFileNamePanel.add((Component)object);
                    }
                    this.pngFileTextField.setText(this.pngFileChooser.getCurrentDirectory().getPath());
                    object = new String[]{"Save as PNG", "Cancel"};
                    int n = JOptionPane.showOptionDialog(pwCanvas.this, this.pngFileNamePanel, "Write to PNG", 0, 3, null, (Object[])object, "Ok");
                    if (n == 0) {
                        pwCanvas pwCanvas2 = pwCanvas.this;
                        try {
                            pwCanvas2.writeToPng(this.pngFileTextField.getText());
                        }
                        catch (IOException iOException) {
                            DasExceptionHandler.handle(iOException);
                        }
                    }
                } else if (string.equals("pngBrowse")) {
                    int n = this.pngFileChooser.showDialog(pwCanvas.this, "Select File");
                    if (n == 0) {
                        this.pngFileTextField.setText(this.pngFileChooser.getSelectedFile().getPath());
                    }
                } else {
                    pwDie.println("" + string);
                }
            }
        };
    }

    private JPopupMenu createPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        ActionListener actionListener = this.createPopupMenuListener();
        JMenuItem jMenuItem = new JMenuItem("Das Properties");
        jMenuItem.addActionListener(actionListener);
        jMenuItem.setToolTipText("edit global properties");
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        JMenuItem jMenuItem2 = new JMenuItem("print...");
        jMenuItem2.setActionCommand("print");
        jMenuItem2.addActionListener(actionListener);
        jMenuItem2.setToolTipText("print entire canvas");
        jPopupMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("save as PNG...");
        jMenuItem3.setActionCommand("toPng");
        jMenuItem3.setToolTipText("save canvas to png image file");
        jMenuItem3.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem3);
        jPopupMenu.addSeparator();
        JMenuItem jMenuItem4 = new JMenuItem("close");
        jMenuItem4.addActionListener(actionListener);
        jMenuItem4.setToolTipText("close this popup");
        jPopupMenu.add(jMenuItem4);
        return jPopupMenu;
    }

    public Component getGlassPane() {
        return this.glassPane;
    }

    public List getDevicePositionList() {
        return Collections.unmodifiableList(this.devicePositionList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void lockDisplay(Object object) {
        Object object2 = this.displayLockObject;
        synchronized (object2) {
            ++this.displayLockCount;
            if (this.displayLockCount == 1 && this.glassPane.mode == 0) {
                this.glassPane.setMode(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void freeDisplay(Object object) {
        Object object2 = this.displayLockObject;
        synchronized (object2) {
            --this.displayLockCount;
            if (this.displayLockCount == 0) {
                if (this.glassPane.mode == 1) {
                    this.glassPane.setMode(0);
                }
                this.displayLockObject.notifyAll();
            }
        }
    }

    public pwCanvas(int n, int n2) {
        this();
        this.setPreferredSize(new Dimension(n, n2));
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    protected void paintComponent(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (n != 0) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        double d = this.getWidth();
        double d2 = this.getHeight();
        double d3 = pageFormat.getImageableWidth();
        double d4 = pageFormat.getImageableHeight();
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        double d5 = Math.max(d, d2);
        double d6 = Math.min(d, d2);
        double d7 = Math.max(d3, d4);
        double d8 = Math.min(d3, d4);
        double d9 = d7 / d5;
        double d10 = d8 / d6;
        double d11 = Math.min(d9, d10);
        graphics2D.scale(d11, d11);
        if (d == d5 ^ d3 == d7) {
            graphics2D.rotate(1.5707963267948966);
            graphics2D.translate(0.0, -d2);
        }
        this.print(graphics2D);
        return 0;
    }

    public Printable getPrintable() {
        return this;
    }

    public void writeToPng(String string) throws IOException {
        final FileOutputStream fileOutputStream = new FileOutputStream(string);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                pwCanvas.this.writeToPngImmediately(fileOutputStream);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void writeToPngImmediately(FileOutputStream fileOutputStream) {
        block15: {
            Object object;
            try {
                object = this.displayLockObject;
                synchronized (object) {
                    if (this.displayLockCount != 0) {
                        this.displayLockObject.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            object = new BufferedImage(this.getWidth(), this.getHeight(), 1);
            this.print(((BufferedImage)object).getGraphics());
            DasPNGEncoder dasPNGEncoder = new DasPNGEncoder();
            dasPNGEncoder.addText("Creation Time", new Date().toString());
            dasPNGEncoder.write((BufferedImage)object, fileOutputStream);
            Object var6_6 = null;
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {}
            break block15;
            {
                catch (IOException iOException) {
                    Object var6_7 = null;
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(int n, int n2) {
        this.setPreferredWidth(n);
        this.setPreferredHeight(n2);
        if ("true".equals(System.getProperty("java.awt.headless"))) {
            this.addNotify();
            this.setSize(this.getPreferredSize());
            this.validate();
        }
        final BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        if (EventQueue.isDispatchThread()) {
            this.writeToImageImmediately(bufferedImage);
        } else {
            try {
                BufferedImage bufferedImage2 = bufferedImage;
                synchronized (bufferedImage2) {
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            pwCanvas.this.writeToImageImmediately(bufferedImage);
                            Image image = bufferedImage;
                            synchronized (image) {
                                bufferedImage.notifyAll();
                            }
                        }
                    });
                    bufferedImage.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeToImageImmediately(Image image) {
        try {
            Object object = this.displayLockObject;
            synchronized (object) {
                if (this.displayLockCount != 0) {
                    this.displayLockObject.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.print(image.getGraphics());
    }

    public void addCanvasComponent(pwCanvasComponent pwCanvasComponent2) {
        this.add(pwCanvasComponent2);
    }

    protected void addImpl(Component component, Object object, int n) {
        if (component == null) {
            pwDie.println("NULL COMPONENT");
            Thread.dumpStack();
            return;
        }
        if (n < 0) {
            n = 0;
        }
        if (component instanceof pwPlot) {
            ((pwPlot)component).putClientProperty("layeredContainerLayer", PLOT_LAYER);
        } else if (component instanceof pwAxis) {
            ((pwAxis)component).putClientProperty("layeredContainerLayer", AXIS_LAYER);
        } else if (component instanceof JComponent) {
            ((JComponent)component).putClientProperty("layeredContainerLayer", DEFAULT_LAYER);
        }
        super.addImpl(component, object, n);
        if (component instanceof pwCanvasComponent) {
            ((pwCanvasComponent)component).installComponent();
        }
    }

    public void setPreferredWidth(int n) {
        Dimension dimension = this.getPreferredSize();
        dimension.width = n;
        this.setPreferredSize(dimension);
    }

    public void setPreferredHeight(int n) {
        Dimension dimension = this.getPreferredSize();
        dimension.height = n;
        this.setPreferredSize(dimension);
    }

    public Font getBaseFont() {
        return this.getFont();
    }

    private ComponentListener createResizeListener() {
        return new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                int n;
                int n2 = pwCanvas.this.getWidth();
                int n3 = n2 * (n = pwCanvas.this.getHeight());
                Font font = n3 >= 633216 ? pwCanvas.this.getFont().deriveFont(18.0f) : (n3 >= 393600 ? pwCanvas.this.getFont().deriveFont(14.0f) : (n3 >= 192000 ? pwCanvas.this.getFont().deriveFont(12.0f) : (n3 >= 38400 ? pwCanvas.this.getFont().deriveFont(8.0f) : pwCanvas.this.getFont().deriveFont(6.0f))));
                pwCanvas.this.setFont(font);
            }
        };
    }

    public Element getDOMElement(Document document) {
        Renderer[] rendererArray;
        Object object;
        Serializable serializable;
        Object object2;
        Element element = document.createElement("canvas");
        Dimension dimension = this.getPreferredSize();
        element.setAttribute("name", this.getDasName());
        element.setAttribute("width", Integer.toString(dimension.width));
        element.setAttribute("height", Integer.toString(dimension.height));
        int n = 0;
        while (n < this.devicePositionList.size()) {
            object2 = this.devicePositionList.get(n);
            if (object2 instanceof pwRow) {
                serializable = (pwRow)object2;
                element.appendChild(((pwRow)serializable).getDOMElement(document));
            } else if (object2 instanceof pwColumn) {
                serializable = (pwColumn)object2;
                element.appendChild(((pwColumn)serializable).getDOMElement(document));
            }
            ++n;
        }
        object2 = this.getComponents();
        serializable = new LinkedHashMap();
        int n2 = 0;
        while (n2 < ((Component[])object2).length) {
            if (object2[n2] instanceof pwAxis) {
                pwAxis pwAxis2 = (pwAxis)object2[n2];
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < ((Component[])object2).length) {
            if (object2[n3] instanceof pwColorBar) {
                pwColorBar pwColorBar2 = (pwColorBar)object2[n3];
                serializable.put(pwColorBar2.getDasName(), pwColorBar2.getDOMElement(document));
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < ((Component[])object2).length) {
            if (object2[n4] instanceof pwSpectrogramPlot) {
                object = (pwSpectrogramPlot)object2[n4];
                serializable.remove(((pwPlot)object).getXAxis().getDasName());
                serializable.remove(((pwPlot)object).getYAxis().getDasName());
                serializable.remove(((pwSpectrogramPlot)object).getColorBar().getDasName());
                serializable.put(((pwCanvasComponent)object).getDasName(), ((pwSpectrogramPlot)object).getDOMElement(document));
            } else if (object2[n4] instanceof pwPlot) {
                object = (pwPlot)object2[n4];
                serializable.remove(((pwPlot)object).getXAxis().getDasName());
                serializable.remove(((pwPlot)object).getYAxis().getDasName());
                rendererArray = ((pwPlot)object).getRenderers();
                int n5 = 0;
                while (n5 < rendererArray.length) {
                    if (rendererArray[n5] instanceof SpectrogramRenderer) {
                        SpectrogramRenderer spectrogramRenderer = (SpectrogramRenderer)rendererArray[n5];
                        serializable.remove(spectrogramRenderer.getColorBar().getDasName());
                    }
                    ++n5;
                }
                serializable.put(((pwCanvasComponent)object).getDasName(), ((pwPlot)object).getDOMElement(document));
            }
            ++n4;
        }
        object = serializable.values().iterator();
        while (object.hasNext()) {
            rendererArray = (Renderer[])object.next();
            if (rendererArray == null) continue;
            element.appendChild((Node)rendererArray);
        }
        return element;
    }

    public static pwCanvas processCanvasElement(Element element, DasForm dasForm) throws DasPropertyException, DasNameException, ParsedExpressionException {
        try {
            String string = element.getAttribute("name");
            int n = Integer.parseInt(element.getAttribute("width"));
            int n2 = Integer.parseInt(element.getAttribute("height"));
            pwCanvas pwCanvas2 = new pwCanvas(n, n2);
            NodeList nodeList = element.getChildNodes();
            int n3 = nodeList.getLength();
            int n4 = 0;
            while (n4 < n3) {
                Node node = nodeList.item(n4);
                if (node instanceof Element) {
                    PropertyEditor.Editable editable;
                    String string2 = node.getNodeName();
                    if (string2.equals("row")) {
                        editable = pwRow.processRowElement((Element)node, pwCanvas2, dasForm);
                    } else if (string2.equals("column")) {
                        editable = pwColumn.processColumnElement((Element)node, pwCanvas2, dasForm);
                    } else if (string2.equals("axis")) {
                        editable = pwAxis.processAxisElement((Element)node, null, null, dasForm);
                        pwCanvas2.add((Component)((Object)editable));
                    } else if (string2.equals("timeaxis")) {
                        editable = pwTimeAxis.processTimeaxisElement((Element)node, null, null, dasForm);
                        pwCanvas2.add((Component)((Object)editable));
                    } else if (string2.equals("attachedaxis")) {
                        editable = pwAxis.processAttachedaxisElement((Element)node, null, null, dasForm);
                        pwCanvas2.add((Component)((Object)editable));
                    } else if (string2.equals("colorbar")) {
                        editable = pwColorBar.processColorbarElement((Element)node, null, null, dasForm);
                        pwCanvas2.add((Component)((Object)editable));
                    } else if (string2.equals("spectrogram")) {
                        editable = pwSpectrogramPlot.processSpectrogramElement((Element)node, dasForm);
                        pwCanvas2.add((Component)((Object)editable));
                    } else if (string2.equals("plot")) {
                        editable = pwPlot.processPlotElement((Element)node, dasForm);
                        pwCanvas2.add((Component)((Object)editable));
                    }
                }
                ++n4;
            }
            try {
                pwCanvas2.setDasName(string);
            }
            catch (DasNameException dasNameException) {
                DasExceptionHandler.handle(dasNameException);
            }
            return pwCanvas2;
        }
        catch (DasPropertyException dasPropertyException) {
            if (!element.getAttribute("name").equals("")) {
                dasPropertyException.setObjectName(element.getAttribute("name"));
            }
            throw dasPropertyException;
        }
    }

    public static pwCanvas createFormCanvas(String string, int n, int n2) {
        pwCanvas pwCanvas2 = new pwCanvas(n, n2);
        if (string == null) {
            string = "canvas_" + Integer.toHexString(System.identityHashCode(pwCanvas2));
        }
        try {
            pwCanvas2.setDasName(string);
        }
        catch (DasNameException dasNameException) {
            DasExceptionHandler.handle(dasNameException);
        }
        return pwCanvas2;
    }

    public pwCanvasComponent getCanvasComponentAt(int n, int n2) {
        Component[] componentArray = this.getComponents();
        int n3 = 1;
        while (n3 < componentArray.length) {
            pwCanvasComponent pwCanvasComponent2;
            Component component = componentArray[n3];
            if (component instanceof pwCanvasComponent && (pwCanvasComponent2 = (pwCanvasComponent)component).getActiveRegion().contains(n, n2)) {
                return pwCanvasComponent2;
            }
            ++n3;
        }
        return null;
    }

    public void remove(int n) {
        Component component = this.getComponent(n);
        super.remove(n);
        if (component instanceof pwCanvasComponent) {
            ((pwCanvasComponent)component).uninstallComponent();
        }
    }

    public HotLine getLineAt(int n, int n2) {
        HotLine hotLine;
        Iterator iterator = this.horizontalLineSet.iterator();
        while (iterator.hasNext()) {
            hotLine = (HotLine)iterator.next();
            if (n2 < hotLine.position - 1 || n2 > hotLine.position + 1) continue;
            return hotLine;
        }
        iterator = this.verticalLineSet.iterator();
        while (iterator.hasNext()) {
            hotLine = (HotLine)iterator.next();
            if (n < hotLine.position - 1 || n > hotLine.position + 1) continue;
            return hotLine;
        }
        return null;
    }

    public Cell getCellAt(int n, int n2) {
        Cell cell = null;
        Point point = null;
        Point point2 = null;
        Iterator iterator = this.cellSet.iterator();
        while (iterator.hasNext()) {
            Cell cell2 = (Cell)iterator.next();
            Rectangle rectangle = cell2.rc;
            if (!rectangle.contains(n, n2)) continue;
            if (cell == null) {
                cell = cell2;
                continue;
            }
            if (point == null) {
                point = new Point();
                point2 = new Point();
            }
            if (cell.rc.contains(rectangle)) {
                cell = cell2;
                continue;
            }
            point.setLocation(cell.rc.x + cell.rc.width / 2, cell.rc.y + cell.rc.height / 2);
            point2.setLocation(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
            int n3 = pwCanvas.distanceSquared(n, n2, point.x, point.y);
            int n4 = pwCanvas.distanceSquared(n, n2, point2.x, point2.y);
            if (n4 < n3) {
                cell = cell2;
                continue;
            }
            if (n4 != n3 || rectangle.width * rectangle.height >= cell.rc.width * cell.rc.height) continue;
            cell = cell2;
        }
        return cell;
    }

    private static int distanceSquared(int n, int n2, int n3, int n4) {
        return (n3 - n) * (n3 - n) + (n4 - n2) * (n4 - n2);
    }

    void addDevicePosition(pwDevicePosition pwDevicePosition2) {
        this.devicePositionList.add(pwDevicePosition2);
        if (pwDevicePosition2 instanceof pwRow) {
            this.addRow((pwRow)pwDevicePosition2);
        } else if (pwDevicePosition2 instanceof pwColumn) {
            this.addColumn((pwColumn)pwDevicePosition2);
        }
    }

    private void addRow(pwRow pwRow2) {
        HotLine hotLine = new HotLine(pwRow2, -1);
        HotLine hotLine2 = new HotLine(pwRow2, 1);
        this.horizontalLineSet.add(hotLine);
        this.horizontalLineSet.add(hotLine2);
        Iterator iterator = this.devicePositionList.iterator();
        while (iterator.hasNext()) {
            pwDevicePosition pwDevicePosition2 = (pwDevicePosition)iterator.next();
            if (!(pwDevicePosition2 instanceof pwColumn)) continue;
            pwColumn pwColumn2 = (pwColumn)pwDevicePosition2;
            this.cellSet.add(new Cell(pwRow2, pwColumn2));
        }
    }

    private void addColumn(pwColumn pwColumn2) {
        HotLine hotLine = new HotLine(pwColumn2, -1);
        HotLine hotLine2 = new HotLine(pwColumn2, 1);
        this.verticalLineSet.add(hotLine);
        this.verticalLineSet.add(hotLine2);
        Iterator iterator = this.devicePositionList.iterator();
        while (iterator.hasNext()) {
            pwDevicePosition pwDevicePosition2 = (pwDevicePosition)iterator.next();
            if (!(pwDevicePosition2 instanceof pwRow)) continue;
            pwRow pwRow2 = (pwRow)pwDevicePosition2;
            this.cellSet.add(new Cell(pwRow2, pwColumn2));
        }
    }

    void removepwDevicePosition(pwDevicePosition pwDevicePosition2) {
        this.devicePositionList.remove(pwDevicePosition2);
        if (pwDevicePosition2 instanceof pwRow) {
            this.removeRow((pwRow)pwDevicePosition2);
        } else if (pwDevicePosition2 instanceof pwColumn) {
            this.removeColumn((pwColumn)pwDevicePosition2);
        }
    }

    private void removeRow(pwRow pwRow2) {
        Object object;
        Iterator iterator = this.horizontalLineSet.iterator();
        while (iterator.hasNext()) {
            object = (HotLine)iterator.next();
            if (((HotLine)object).devicePosition != pwRow2) continue;
            iterator.remove();
        }
        object = this.cellSet.iterator();
        while (object.hasNext()) {
            Cell cell = (Cell)object.next();
            if (cell.row != pwRow2) continue;
            object.remove();
        }
    }

    private void removeColumn(pwColumn pwColumn2) {
        Object object;
        Iterator iterator = this.verticalLineSet.iterator();
        while (iterator.hasNext()) {
            object = (HotLine)iterator.next();
            if (((HotLine)object).devicePosition != pwColumn2) continue;
            iterator.remove();
        }
        object = this.cellSet.iterator();
        while (object.hasNext()) {
            Cell cell = (Cell)object.next();
            if (cell.column != pwColumn2) continue;
            object.remove();
        }
    }

    public DasForm getForm() {
        Container container = this.getParent();
        if (container instanceof FormComponent) {
            return ((FormComponent)((Object)container)).getForm();
        }
        return null;
    }

    public boolean getEditingMode() {
        return this.editable;
    }

    public void setEditingMode(boolean bl) {
        if (this.editable == bl) {
            return;
        }
        this.editable = bl;
        if (bl) {
            this.glassPane.setMode(2);
        } else {
            this.glassPane.setMode(0);
        }
        this.revalidate();
    }

    public void removeItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }

    public void addItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
    }

    private void fireItemSelected(Object object) {
        this.fireItemStateChanged(object, 1);
    }

    private void fireItemDeselected(Object object) {
        this.fireItemStateChanged(object, 2);
    }

    private void fireItemStateChanged(Object object, int n) {
        if (this.itemListener != null) {
            int n2 = 701;
            ItemEvent itemEvent = new ItemEvent(this, n2, object, n);
            this.itemListener.itemStateChanged(itemEvent);
        }
    }

    public Object[] getSelectedObjects() {
        if (this.glassPane.selected == null) {
            return null;
        }
        return new Object[]{this.glassPane.selected};
    }

    public DnDSupport getDnDSupport() {
        return this.dndSupport;
    }

    public boolean startDrag(int n, int n2, int n3, MouseEvent mouseEvent) {
        int n4 = 0;
        while (n4 < this.getComponentCount()) {
            if (this.getComponent(n4).getBounds().contains(n, n2)) {
                this.dndSupport.startDrag(n, n2, n3, mouseEvent);
                return true;
            }
            ++n4;
        }
        return false;
    }

    public String getDasName() {
        return this.dasName;
    }

    public void setDasName(String string) throws DasNameException {
        if (string.equals(this.dasName)) {
            return;
        }
        String string2 = this.dasName;
        this.dasName = string;
        NameContext.getDefaultNameContext().put(string, this);
        if (string2 != null) {
            NameContext.getDefaultNameContext().remove(string2);
        }
        this.firePropertyChange("name", string2, string);
    }

    public static class Cell
    implements PropertyChangeListener {
        Rectangle rc;
        pwRow row;
        pwColumn column;

        Cell(pwRow pwRow2, pwColumn pwColumn2) {
            this.row = pwRow2;
            this.column = pwColumn2;
            this.rc = new Rectangle();
            pwRow2.addPropertyChangeListener("dMinimum", this);
            pwRow2.addPropertyChangeListener("dMaximum", this);
            pwColumn2.addPropertyChangeListener("dMinimum", this);
            pwColumn2.addPropertyChangeListener("dMaximum", this);
            this.rc.x = (int)Math.floor(pwColumn2.getDMinimum() + 0.5);
            this.rc.y = (int)Math.floor(pwRow2.getDMinimum() + 0.5);
            this.rc.width = (int)Math.floor(pwColumn2.getDMaximum() + 0.5) - this.rc.x;
            this.rc.height = (int)Math.floor(pwRow2.getDMaximum() + 0.5) - this.rc.y;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() == this.row) {
                this.rc.y = (int)Math.floor(this.row.getDMinimum() + 0.5);
                this.rc.height = (int)Math.floor(this.row.getDMaximum() + 0.5) - this.rc.y;
            } else {
                this.rc.x = (int)Math.floor(this.column.getDMinimum() + 0.5);
                this.rc.width = (int)Math.floor(this.column.getDMaximum() + 0.5) - this.rc.x;
            }
        }

        public boolean equals(Object object) {
            if (object instanceof Cell) {
                Cell cell = (Cell)object;
                return cell.row == this.row && cell.column == this.column;
            }
            return false;
        }

        public String toString() {
            return "{" + this.row.getDasName() + " x " + this.column.getDasName() + ": " + this.rc.toString() + "}";
        }

        public Rectangle getCellBounds() {
            return new Rectangle(this.rc);
        }

        public Rectangle getCellBounds(Rectangle rectangle) {
            if (rectangle == null) {
                return this.getCellBounds();
            }
            rectangle.setBounds(this.rc);
            return rectangle;
        }

        public pwRow getRow() {
            return this.row;
        }

        public pwColumn getColumn() {
            return this.column;
        }
    }

    public static class HotLine
    implements PropertyChangeListener {
        public static final int MIN = -1;
        public static final int NONE = 0;
        public static final int MAX = 1;
        int position;
        pwDevicePosition devicePosition;
        int minOrMax;

        HotLine(pwDevicePosition pwDevicePosition2, int n) {
            this.devicePosition = pwDevicePosition2;
            this.minOrMax = n;
            this.refresh();
            pwDevicePosition2.addPropertyChangeListener(n == -1 ? "dMinimum" : "dMaximum", this);
        }

        void refresh() {
            this.position = this.minOrMax == -1 ? (int)Math.floor(this.devicePosition.getDMinimum() + 0.5) : (int)Math.floor(this.devicePosition.getDMaximum() + 0.5);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.refresh();
        }

        public boolean equals(Object object) {
            if (object instanceof HotLine) {
                HotLine hotLine = (HotLine)object;
                return hotLine.devicePosition == this.devicePosition && hotLine.minOrMax == this.minOrMax;
            }
            return false;
        }

        public int hashCode() {
            return this.minOrMax * this.devicePosition.hashCode();
        }

        public String toString() {
            return "{" + this.devicePosition.getDasName() + (this.minOrMax == -1 ? ", MIN, " : ", MAX, ") + this.position + "}";
        }

        public pwDevicePosition getDevicePosition() {
            return this.devicePosition;
        }

        public int getMinOrMax() {
            return this.minOrMax;
        }
    }

    private static class GlassPane
    extends JPanel
    implements MouseInputListener,
    KeyListener {
        private static final int MODE_NORMAL = 0;
        private static final int MODE_LOADING = 1;
        private static final int MODE_EDITING = 2;
        private static final int MODE_NEW_ROW = 3;
        private static final int MODE_NEW_COLUMN = 4;
        private static final int MODE_DND = 5;
        JPopupMenu editorMenu;
        Object selected;
        Rectangle target = new Rectangle(100, 100, 100, 100);
        int mode = 0;
        boolean dragging;
        int startX;
        int endX;
        int startY;
        int endY;

        public GlassPane() {
            this.setOpaque(false);
            this.setLayout(null);
            this.setFocusable(true);
        }

        pwCanvas getCanvas() {
            return (pwCanvas)this.getParent();
        }

        private void setSelected(Object object) {
            if (this.selected == object) {
                return;
            }
            if (this.selected != null) {
                this.getCanvas().fireItemDeselected(this.selected);
            }
            this.selected = object;
            if (object != null) {
                this.getCanvas().fireItemSelected(this.selected);
            }
        }

        protected void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            switch (this.mode) {
                case 1: {
                    this.paintLoading(graphics2D);
                    break;
                }
                case 2: {
                    this.paintRowColumn(graphics2D);
                    this.paintSelection(graphics2D);
                    if (!this.dragging || !(this.selected instanceof HotLine)) break;
                    this.paintResizeLine(graphics2D);
                    break;
                }
                case 3: {
                    this.paintRowColumn(graphics2D);
                    if (!this.dragging) break;
                    this.paintNewRow(graphics2D);
                    break;
                }
                case 4: {
                    this.paintRowColumn(graphics2D);
                    if (!this.dragging) break;
                    this.paintNewColumn(graphics2D);
                    break;
                }
                case 5: {
                    this.paintRowColumn(graphics2D);
                    if (this.target == null) break;
                    this.paintDnDTarget(graphics2D);
                }
            }
            graphics2D.dispose();
        }

        private void paintDnDTarget(Graphics2D graphics2D) {
            graphics2D.setStroke(Strokes.DASHED);
            graphics2D.setPaint(Paints.SELECTION);
            graphics2D.drawRect(this.target.x + 1, this.target.y + 1, this.target.width - 2, this.target.height - 2);
        }

        private void paintLoading(Graphics2D graphics2D) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
            graphics2D.setColor(new Color(-587202561, true));
            Rectangle rectangle = graphics2D.getClipBounds();
            if (rectangle == null) {
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            } else {
                graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        private void paintNewRow(Graphics2D graphics2D) {
            int n = Math.min(this.startY, this.endY);
            int n2 = Math.max(this.startY, this.endY);
            graphics2D.setColor(Color.WHITE);
            graphics2D.setStroke(Strokes.THICK);
            graphics2D.drawLine(this.endX, n, this.endX, n2);
            graphics2D.drawLine(this.endX - 3, n, this.endX + 3, n);
            graphics2D.drawLine(this.endX - 3, n2, this.endX + 3, n2);
            graphics2D.setColor(Color.BLACK);
            graphics2D.setStroke(Strokes.THIN);
            graphics2D.drawLine(this.endX, n, this.endX, n2);
            graphics2D.drawLine(this.endX - 3, n, this.endX + 3, n);
            graphics2D.drawLine(this.endX - 3, n2, this.endX + 3, n2);
        }

        private void paintNewColumn(Graphics2D graphics2D) {
            int n = Math.min(this.startX, this.endX);
            int n2 = Math.max(this.startX, this.endX);
            graphics2D.setColor(Color.WHITE);
            graphics2D.setStroke(Strokes.THICK);
            graphics2D.drawLine(n, this.endY, n2, this.endY);
            graphics2D.drawLine(n, this.endY - 3, n, this.endY + 3);
            graphics2D.drawLine(n2, this.endY - 3, n2, this.endY + 3);
            graphics2D.setColor(Color.BLACK);
            graphics2D.setStroke(Strokes.THIN);
            graphics2D.drawLine(n, this.endY, n2, this.endY);
            graphics2D.drawLine(n, this.endY - 3, n, this.endY + 3);
            graphics2D.drawLine(n2, this.endY - 3, n2, this.endY + 3);
        }

        private void paintRowColumn(Graphics2D graphics2D) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
            pwCanvas pwCanvas2 = this.getCanvas();
            Iterator iterator = pwCanvas2.devicePositionList.iterator();
            while (iterator.hasNext()) {
                Paint paint;
                int n;
                int n2;
                int n3;
                int n4;
                pwDevicePosition pwDevicePosition2 = (pwDevicePosition)iterator.next();
                double d = pwDevicePosition2.getMinimum();
                double d2 = pwDevicePosition2.getMaximum();
                int n5 = pwCanvas2.getWidth();
                int n6 = pwCanvas2.getHeight();
                if (pwDevicePosition2 instanceof pwRow) {
                    n4 = 0;
                    n3 = n5;
                    n2 = (int)Math.floor(d * (double)n6 + 0.5);
                    n = (int)Math.floor(d2 * (double)n6 + 0.5) - n2;
                    paint = Paints.ROW;
                } else {
                    n4 = (int)Math.floor(d * (double)n5 + 0.5);
                    n3 = (int)Math.floor(d2 * (double)n5 + 0.5) - n4;
                    n2 = 0;
                    n = n6;
                    paint = Paints.COLUMN;
                }
                graphics2D.setPaint(paint);
                graphics2D.fillRect(n4, n2, n3, n);
            }
        }

        void paintSelection(Graphics2D graphics2D) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            if (this.selected instanceof HotLine) {
                pwDevicePosition pwDevicePosition2 = ((HotLine)this.selected).getDevicePosition();
                if (pwDevicePosition2 instanceof pwRow) {
                    int n3 = (int)Math.floor(pwDevicePosition2.getMinimum() * (double)n2 + 0.5);
                    int n4 = (int)Math.floor(pwDevicePosition2.getMaximum() * (double)n2 + 0.5);
                    graphics2D.setStroke(Strokes.DASHED);
                    graphics2D.setPaint(Paints.ROW_BORDER);
                    graphics2D.drawLine(0, n3, n, n3);
                    graphics2D.drawLine(0, n4, n, n4);
                } else {
                    int n5 = (int)Math.floor(pwDevicePosition2.getMinimum() * (double)n + 0.5);
                    int n6 = (int)Math.floor(pwDevicePosition2.getMaximum() * (double)n + 0.5);
                    graphics2D.setStroke(Strokes.DASHED);
                    graphics2D.setPaint(Paints.COLUMN_BORDER);
                    graphics2D.drawLine(n5, 0, n5, n2);
                    graphics2D.drawLine(n6, 0, n6, n2);
                }
            } else if (this.selected instanceof pwCanvasComponent) {
                Shape shape = ((pwCanvasComponent)this.selected).getActiveRegion();
                graphics2D.setStroke(Strokes.DASHED);
                graphics2D.setPaint(Paints.SELECTION);
                graphics2D.draw(shape);
            }
        }

        private void paintResizeLine(Graphics2D graphics2D) {
            if (this.selected instanceof HotLine) {
                HotLine hotLine = (HotLine)this.selected;
                pwDevicePosition pwDevicePosition2 = hotLine.getDevicePosition();
                int n = this.getCanvas().getWidth();
                int n2 = this.getCanvas().getHeight();
                graphics2D.setStroke(Strokes.DASHED);
                if (pwDevicePosition2 instanceof pwRow) {
                    graphics2D.drawLine(0, this.endY, n, this.endY);
                } else {
                    graphics2D.drawLine(this.endX, 0, this.endX, n2);
                }
            } else {
                throw new RuntimeException("selected not instance of HotLine");
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n = this.mode;
            switch (n) {
                case 0: {
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 2: {
                    if (mouseEvent.getButton() != 3) break;
                    if (this.editorMenu == null) {
                        this.initEditorMenu();
                    }
                    this.editorMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
                    break;
                }
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            switch (this.mode) {
                case 0: {
                    break;
                }
                case 2: {
                    if (this.dragging && this.selected instanceof HotLine) {
                        HotLine hotLine = (HotLine)this.selected;
                        if (hotLine.getDevicePosition() instanceof pwRow) {
                            this.repaint(0, this.endY - 1, this.getWidth(), 3);
                        } else {
                            this.repaint(this.endX - 1, 0, 3, this.getHeight());
                        }
                        this.endX = mouseEvent.getX();
                        this.endY = mouseEvent.getY();
                        break;
                    }
                    if (!this.dragging || !(this.selected instanceof pwCanvasComponent)) break;
                    this.dragging = false;
                    this.getCanvas().dndSupport.startDrag(mouseEvent.getX(), mouseEvent.getY(), 2, mouseEvent);
                    break;
                }
                case 3: {
                    this.repaint(this.endX - 4, Math.min(this.startY, this.endY) - 1, 9, Math.abs(this.startY - this.endY) + 3);
                    this.endX = mouseEvent.getX();
                    this.endY = mouseEvent.getY();
                    this.repaint(this.endX - 4, Math.min(this.startY, this.endY) - 1, 9, Math.abs(this.startY - this.endY) + 3);
                    break;
                }
                case 4: {
                    this.repaint(Math.min(this.startX, this.endX) - 1, this.endY - 4, Math.abs(this.startX - this.endX) + 3, 9);
                    this.endX = mouseEvent.getX();
                    this.endY = mouseEvent.getY();
                    this.repaint(Math.min(this.startX, this.endX) - 1, this.endY - 4, Math.abs(this.startX - this.endX) + 3, 9);
                    break;
                }
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            switch (this.mode) {
                case 0: {
                    break;
                }
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            switch (this.mode) {
                case 0: {
                    break;
                }
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            switch (this.mode) {
                case 0: {
                    break;
                }
                case 2: {
                    HotLine hotLine = this.getCanvas().getLineAt(mouseEvent.getX(), mouseEvent.getY());
                    if (hotLine == null) {
                        this.setCursor(Cursors.DEFAULT);
                        break;
                    }
                    if (hotLine.getDevicePosition() instanceof pwRow) {
                        this.setCursor(hotLine.minOrMax == -1 ? Cursors.ROW_MIN : Cursors.ROW_MAX);
                        break;
                    }
                    this.setCursor(hotLine.minOrMax == -1 ? Cursors.COL_MIN : Cursors.COL_MAX);
                    break;
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            switch (this.mode) {
                case 0: {
                    break;
                }
                case 2: {
                    pwCanvasComponent pwCanvasComponent2 = this.getCanvas().getCanvasComponentAt(mouseEvent.getX(), mouseEvent.getY());
                    if (pwCanvasComponent2 == null) {
                        HotLine hotLine = this.getCanvas().getLineAt(mouseEvent.getX(), mouseEvent.getY());
                        if (hotLine != null) {
                            this.setSelected(hotLine);
                            this.dragging = true;
                            this.endX = this.startX = mouseEvent.getX();
                            this.endY = this.startY = mouseEvent.getY();
                            this.requestFocusInWindow();
                            this.repaint();
                            break;
                        }
                        this.setSelected(null);
                        this.repaint();
                        break;
                    }
                    this.setSelected(pwCanvasComponent2);
                    this.dragging = true;
                    this.requestFocusInWindow();
                    this.repaint();
                    break;
                }
                case 3: 
                case 4: {
                    if (mouseEvent.getButton() != 1) break;
                    this.dragging = true;
                    this.startX = mouseEvent.getX();
                    this.startY = mouseEvent.getY();
                    break;
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            switch (this.mode) {
                case 0: {
                    break;
                }
                case 2: {
                    if (this.dragging && this.selected instanceof HotLine) {
                        HotLine hotLine = (HotLine)this.selected;
                        double d = hotLine.getDevicePosition() instanceof pwRow ? (double)this.endY / (double)this.getCanvas().getHeight() : (double)this.endX / (double)this.getCanvas().getWidth();
                        if (hotLine.minOrMax == -1) {
                            hotLine.getDevicePosition().setMinimum(d);
                        } else {
                            hotLine.getDevicePosition().setMaximum(d);
                        }
                        this.repaint();
                    }
                    this.dragging = false;
                    break;
                }
                case 3: 
                case 4: {
                    this.endX = mouseEvent.getX();
                    this.endY = mouseEvent.getY();
                    this.newDevicePosition();
                    this.mode = 2;
                    this.dragging = false;
                    this.repaint();
                    break;
                }
            }
        }

        void newDevicePosition() {
            pwCanvas pwCanvas2 = this.getCanvas();
            double d = pwCanvas2.getWidth();
            double d2 = pwCanvas2.getHeight();
            if (this.mode == 3) {
                if (Math.abs(this.startY - this.endY) <= 5) {
                    return;
                }
                double d3 = (double)Math.min(this.startY, this.endY) / d2;
                double d4 = (double)Math.max(this.startY, this.endY) / d2;
                this.setSelected(new pwRow(pwCanvas2, d3, d4));
            } else if (this.mode == 4) {
                if (Math.abs(this.startX - this.endX) <= 5) {
                    return;
                }
                double d5 = (double)Math.min(this.startX, this.endX) / d;
                double d6 = (double)Math.max(this.startX, this.endX) / d;
                this.setSelected(new pwColumn(pwCanvas2, d5, d6));
            }
        }

        Component findComponentForEvent(MouseEvent mouseEvent) {
            Component component = this.getParent();
            Point point = SwingUtilities.convertPoint(this, mouseEvent.getPoint(), component);
            Component[] componentArray = ((Container)component).getComponents();
            int n = 1;
            while (n < componentArray.length) {
                if (componentArray[n].getBounds().contains(point)) {
                    component = componentArray[n];
                    break;
                }
                ++n;
            }
            point = SwingUtilities.convertPoint(this, mouseEvent.getPoint(), component);
            if (component instanceof Container && component != this.getParent()) {
                component = ((Container)component).findComponentAt(point);
            }
            return component;
        }

        void redispatchMouseEvent(MouseEvent mouseEvent, Component component) {
            component.dispatchEvent(SwingUtilities.convertMouseEvent(this, mouseEvent, component));
        }

        void dispatchMouseEnteredEvent(MouseEvent mouseEvent, Component component) {
            Point point = SwingUtilities.convertPoint(this, mouseEvent.getPoint(), component);
            component.dispatchEvent(new MouseEvent(component, 504, mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton()));
        }

        void dispatchMouseExitedEvent(MouseEvent mouseEvent, Component component) {
            Point point = SwingUtilities.convertPoint(this, mouseEvent.getPoint(), component);
            component.dispatchEvent(new MouseEvent(component, 505, mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton()));
        }

        private void initEditorMenu() {
            JPopupMenu jPopupMenu = new JPopupMenu("Canvas Editor Menu");
            ActionListener actionListener = new ActionListener(this){
                private final /* synthetic */ GlassPane this$0;
                {
                    this.this$0 = glassPane;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = actionEvent.getActionCommand();
                    if (string.equals("new row")) {
                        GlassPane.access$100(this.this$0, 3);
                    } else if (string.equals("new column")) {
                        GlassPane.access$100(this.this$0, 4);
                    }
                }
            };
            jPopupMenu.add("new row").addActionListener(actionListener);
            jPopupMenu.add("new column").addActionListener(actionListener);
            jPopupMenu.addSeparator();
            jPopupMenu.add("close");
            this.editorMenu = jPopupMenu;
        }

        private void setMode(int n) {
            if (this.mode == n) {
                return;
            }
            if (this.mode == 0) {
                this.addMouseListener(this);
                this.addMouseMotionListener(this);
                this.addKeyListener(this);
            } else if (n == 0) {
                this.removeMouseListener(this);
                this.removeMouseMotionListener(this);
                this.removeKeyListener(this);
                if (this.hasFocus()) {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
                }
            }
            this.mode = n;
            this.repaint();
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
            switch (this.mode) {
                case 2: {
                    if (keyEvent.getKeyCode() != 127) break;
                    if (this.selected instanceof pwCanvasComponent) {
                        this.getCanvas().remove((Component)this.selected);
                        this.getCanvas().revalidate();
                        this.setSelected(null);
                        this.repaint();
                        break;
                    }
                    if (!(this.selected instanceof HotLine)) break;
                    pwDevicePosition pwDevicePosition2 = ((HotLine)this.selected).getDevicePosition();
                    pwCanvas pwCanvas2 = this.getCanvas();
                    int n = 0;
                    while (n < pwCanvas2.getComponentCount()) {
                        Component component = pwCanvas2.getComponent(n);
                        if (component instanceof pwCanvasComponent) {
                            pwCanvasComponent pwCanvasComponent2 = (pwCanvasComponent)component;
                            if (pwCanvasComponent2.getRow() == pwDevicePosition2) {
                                JOptionPane.showMessageDialog(this, "That row is still in use");
                                return;
                            }
                            if (pwCanvasComponent2.getColumn() == pwDevicePosition2) {
                                JOptionPane.showMessageDialog(this, "That column is still in use");
                                return;
                            }
                        }
                        ++n;
                    }
                    pwCanvas2.removepwDevicePosition(pwDevicePosition2);
                    this.setSelected(null);
                    this.repaint();
                    break;
                }
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }

    private static class Paints {
        private static final Paint ROW = new Color(255, 178, 178, 146);
        private static final Paint COLUMN = new Color(178, 178, 255, 146);
        private static final Paint ROW_BORDER = ((Color)ROW).darker();
        private static final Paint COLUMN_BORDER = ((Color)COLUMN).darker();
        private static final Paint SELECTION = Color.GRAY;

        private Paints() {
        }
    }

    private static class Strokes {
        private static final Stroke THICK = Strokes.createStroke(3.0f);
        private static final Stroke THIN = Strokes.createStroke(1.0f);
        private static final Stroke DASHED = Strokes.createDashedStroke(3.0f);

        private Strokes() {
        }

        private static Stroke createStroke(float f) {
            return new BasicStroke(f, 2, 0);
        }

        private static Stroke createDashedStroke(float f) {
            return new BasicStroke(f, 2, 0, f, new float[]{f * 4.0f, f * 4.0f}, 0.0f);
        }
    }

    private static class Cursors {
        private static final Cursor DEFAULT = new Cursor(0);
        private static final Cursor ROW_MIN = new Cursor(8);
        private static final Cursor ROW_MAX = new Cursor(9);
        private static final Cursor COL_MIN = new Cursor(10);
        private static final Cursor COL_MAX = new Cursor(11);

        private Cursors() {
        }
    }

    private class CanvasDnDSupport
    extends DnDSupport {
        private List acceptList = Arrays.asList(TransferableCanvasComponent.PLOT_FLAVOR, TransferableCanvasComponent.AXIS_FLAVOR, TransferableCanvasComponent.COLORBAR_FLAVOR);

        CanvasDnDSupport() {
            super(pwCanvas.this, 3, null);
        }

        private Rectangle getAxisRectangle(Rectangle rectangle, Rectangle rectangle2, int n, int n2) {
            if (rectangle2 == null) {
                rectangle2 = new Rectangle();
            }
            int n3 = this.getAxisOrientation(rectangle, n, n2);
            switch (n3) {
                case 1: {
                    rectangle2.width = rectangle.width;
                    rectangle2.height = 3 * pwCanvas.this.getFont().getSize();
                    rectangle2.x = rectangle.x;
                    rectangle2.y = rectangle.y - rectangle2.height;
                    break;
                }
                case 4: {
                    rectangle2.width = 3 * pwCanvas.this.getFont().getSize();
                    rectangle2.height = rectangle.height;
                    rectangle2.x = rectangle.x + rectangle.width;
                    rectangle2.y = rectangle.y;
                    break;
                }
                case 3: {
                    rectangle2.width = 3 * pwCanvas.this.getFont().getSize();
                    rectangle2.height = rectangle.height;
                    rectangle2.x = rectangle.x - rectangle2.width;
                    rectangle2.y = rectangle.y;
                    break;
                }
                case 2: {
                    rectangle2.width = rectangle.width;
                    rectangle2.height = 3 * pwCanvas.this.getFont().getSize();
                    rectangle2.x = rectangle.x;
                    rectangle2.y = rectangle.y + rectangle.height;
                    break;
                }
                default: {
                    throw new RuntimeException("invalid orientation: " + n3);
                }
            }
            return rectangle2;
        }

        private int getAxisOrientation(Rectangle rectangle, int n, int n2) {
            boolean bl;
            int n3 = (n - rectangle.x) * rectangle.height;
            int n4 = (n2 - rectangle.y) * rectangle.width;
            int n5 = rectangle.width * rectangle.height;
            boolean bl2 = bl = n3 + n4 < n5;
            return n3 > n4 ? (bl ? 1 : 4) : (bl ? 3 : 2);
        }

        protected int canAccept(DataFlavor[] dataFlavorArray, int n, int n2, int n3) {
            if (((pwCanvas)pwCanvas.this).glassPane.mode != 5) {
                pwCanvas.this.glassPane.setMode(5);
            }
            List<DataFlavor> list = Arrays.asList(dataFlavorArray);
            Cell cell = pwCanvas.this.getCellAt(n, n2);
            Rectangle rectangle = cell == null ? null : cell.getCellBounds();
            Rectangle rectangle2 = ((pwCanvas)pwCanvas.this).glassPane.target;
            if (list.contains(TransferableCanvasComponent.COLORBAR_FLAVOR)) {
                return n3;
            }
            if (list.contains(TransferableCanvasComponent.AXIS_FLAVOR)) {
                if (!(rectangle2 == rectangle || rectangle2 != null && rectangle2.equals(rectangle))) {
                    if (rectangle2 != null) {
                        pwCanvas.this.glassPane.repaint(rectangle2.x - 1, rectangle2.y - 1, rectangle2.width + 2, rectangle2.height + 2);
                    }
                    if (rectangle != null) {
                        rectangle2 = ((pwCanvas)pwCanvas.this).glassPane.target = this.getAxisRectangle(rectangle, rectangle2, n, n2);
                        pwCanvas.this.glassPane.repaint(rectangle2.x - 1, rectangle2.y - 1, rectangle2.width + 2, rectangle2.height + 2);
                    } else {
                        ((pwCanvas)pwCanvas.this).glassPane.target = null;
                    }
                }
                return n3;
            }
            if (list.contains(TransferableCanvasComponent.CANVAS_COMPONENT_FLAVOR)) {
                if (!(rectangle2 == rectangle || rectangle2 != null && rectangle2.equals(rectangle))) {
                    if (rectangle2 != null) {
                        pwCanvas.this.glassPane.repaint(rectangle2.x - 1, rectangle2.y - 1, rectangle2.width + 2, rectangle2.height + 2);
                    }
                    rectangle2 = ((pwCanvas)pwCanvas.this).glassPane.target = rectangle;
                    if (rectangle != null) {
                        pwCanvas.this.glassPane.repaint(rectangle2.x - 1, rectangle2.y - 1, rectangle2.width + 2, rectangle2.height + 2);
                    }
                }
                return n3;
            }
            return -1;
        }

        protected void done() {
            pwCanvas.this.glassPane.setMode(2);
            if (((pwCanvas)pwCanvas.this).glassPane.target != null) {
                Rectangle rectangle = ((pwCanvas)pwCanvas.this).glassPane.target;
                ((pwCanvas)pwCanvas.this).glassPane.target = null;
                pwCanvas.this.glassPane.repaint(rectangle.x - 1, rectangle.y - 1, rectangle.width + 2, rectangle.height + 2);
            }
        }

        protected boolean importData(Transferable transferable, int n, int n2, int n3) {
            boolean bl;
            block6: {
                bl = false;
                try {
                    Cell cell;
                    if (transferable.isDataFlavorSupported(TransferableCanvasComponent.COLORBAR_FLAVOR)) {
                        Cell cell2 = pwCanvas.this.getCellAt(n, n2);
                        if (cell2 == null) break block6;
                        pwCanvasComponent pwCanvasComponent2 = (pwCanvasComponent)transferable.getTransferData(TransferableCanvasComponent.CANVAS_COMPONENT_FLAVOR);
                        pwCanvasComponent2.setRow(cell2.getRow());
                        pwCanvasComponent2.setColumn(cell2.getColumn());
                        pwCanvas.this.add(pwCanvasComponent2);
                        pwCanvas.this.revalidate();
                        bl = true;
                        break block6;
                    }
                    if (transferable.isDataFlavorSupported(TransferableCanvasComponent.AXIS_FLAVOR)) {
                        Cell cell3 = pwCanvas.this.getCellAt(n, n2);
                        if (cell3 == null) break block6;
                        pwAxis pwAxis2 = (pwAxis)transferable.getTransferData(TransferableCanvasComponent.AXIS_FLAVOR);
                        pwAxis2.setRow(cell3.getRow());
                        pwAxis2.setColumn(cell3.getColumn());
                        Rectangle rectangle = cell3.getCellBounds();
                        int n4 = this.getAxisOrientation(rectangle, n, n2);
                        pwAxis2.setOrientation(n4);
                        pwCanvas.this.add(pwAxis2);
                        pwCanvas.this.revalidate();
                        bl = true;
                        break block6;
                    }
                    if (transferable.isDataFlavorSupported(TransferableCanvasComponent.CANVAS_COMPONENT_FLAVOR) && (cell = pwCanvas.this.getCellAt(n, n2)) != null) {
                        pwCanvasComponent pwCanvasComponent3 = (pwCanvasComponent)transferable.getTransferData(TransferableCanvasComponent.CANVAS_COMPONENT_FLAVOR);
                        pwCanvasComponent3.setRow(cell.getRow());
                        pwCanvasComponent3.setColumn(cell.getColumn());
                        pwCanvas.this.add(pwCanvasComponent3);
                        pwCanvas.this.revalidate();
                        bl = true;
                    }
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                }
                catch (IOException iOException) {}
            }
            return bl;
        }

        protected Transferable getTransferable(int n, int n2, int n3) {
            pwCanvasComponent pwCanvasComponent2 = pwCanvas.this.getCanvasComponentAt(n, n2);
            if (pwCanvasComponent2 instanceof pwColorBar) {
                return new TransferableCanvasComponent((pwColorBar)pwCanvasComponent2);
            }
            if (pwCanvasComponent2 instanceof pwAxis) {
                return new TransferableCanvasComponent((pwAxis)pwCanvasComponent2);
            }
            if (pwCanvasComponent2 instanceof pwPlot) {
                return new TransferableCanvasComponent((pwPlot)pwCanvasComponent2);
            }
            return null;
        }

        protected void exportDone(Transferable transferable, int n) {
        }
    }

    protected static class RowColumnLayout
    implements LayoutManager {
        protected RowColumnLayout() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void layoutContainer(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                int n = container.getComponentCount();
                int n2 = 0;
                while (n2 < n) {
                    Component component = container.getComponent(n2);
                    if (component instanceof pwCanvasComponent) {
                        ((pwCanvasComponent)component).update();
                    } else if (component == ((pwCanvas)container).glassPane) {
                        Dimension dimension = container.getSize();
                        component.setBounds(0, 0, dimension.width, dimension.height);
                    }
                    ++n2;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension minimumLayoutSize(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                int n = container.getComponentCount();
                Rectangle rectangle = new Rectangle(0, 0, 0, 0);
                int n2 = 0;
                while (n2 < n) {
                    rectangle.add(container.getComponent(n2).getBounds());
                    ++n2;
                }
                return new Dimension(rectangle.width, rectangle.height);
            }
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }
    }
}

