/*
 * Decompiled with CFR 0.152.
 */
package graph;

import das.DasNameException;
import das_proto.data.DasFormatter;
import das_proto.data.Datum;
import das_proto.data.TimeDatum;
import das_proto.data.TimeLocationUnits;
import das_proto.data.Units;
import event.DataRangeSelectionEvent;
import event.DataRangeSelectionListener;
import event.dasMouseModule;
import event.dasMouseModuleHorizontalRangeSelector;
import event.dasMouseModuleVerticalRangeSelector;
import graph.DataRange;
import graph.pwCanvas;
import graph.pwCanvasComponent;
import graph.pwColumn;
import graph.pwDevicePosition;
import graph.pwRow;
import graph.pwTimeAxis;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import util.DasExceptionHandler;
import util.GrannyTextRenderer;
import util.pwDie;
import util.pwMath;
import xml.DasForm;
import xml.DasPropertyException;

public class pwAxis
extends pwCanvasComponent
implements DataRangeSelectionListener,
Cloneable {
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;
    public static final int HORIZONTAL = 2;
    public static final int VERTICAL = 3;
    public static final int UP = 995;
    public static final int DOWN = 996;
    private static final String SCAN_PREVIOUS_LABEL = "<< scan";
    private static final String SCAN_NEXT_LABEL = "scan >>";
    protected DataRange dataRange;
    private pwCanvas parent;
    private boolean visible;
    private int orientation;
    private int tickDirection = 1;
    private boolean ticksVisible = true;
    private boolean tickLabelsVisible = true;
    protected String axisLabel = "";
    private DasFormatter nf;
    private dasMouseModule zoom = null;
    private boolean oppositeAxisVisible;
    private PropertyChangeListener dataRangePropertyListener;
    protected JPanel primaryInputPanel;
    protected JPanel secondaryInputPanel;
    protected ScanButton scanPrevious;
    protected ScanButton scanNext;
    protected tickVDescriptor tickV;
    private int button;
    private boolean isShiftDown;
    private Point zoomStart;
    private Point zoomEnd;
    private boolean animated = false;
    static /* synthetic */ Class class$graph$pwRow;
    static /* synthetic */ Class class$graph$pwColumn;
    static /* synthetic */ Class class$graph$pwAxis;

    public static pwAxis create(double[] dArray, Units units, pwRow pwRow2, pwColumn pwColumn2, int n, boolean bl) {
        pwAxis pwAxis2 = units instanceof TimeLocationUnits ? new pwTimeAxis((TimeDatum)Datum.create(0.0, units), (TimeDatum)Datum.create(0.0, units), pwRow2, pwColumn2, n) : new pwAxis(Datum.create(0.0, units), Datum.create(0.0, units), pwRow2, pwColumn2, n, bl);
        pwAxis2.setDataRange(dArray);
        return pwAxis2;
    }

    public pwAxis(Datum datum, Datum datum2, pwRow pwRow2, pwColumn pwColumn2, int n) {
        this(datum, datum2, pwRow2, pwColumn2, n, false);
    }

    public pwAxis(Datum datum, Datum datum2, pwRow pwRow2, pwColumn pwColumn2, int n, boolean bl) {
        this(pwRow2, pwColumn2, n);
        this.dataRange = new DataRange(this, datum, datum2, bl);
        this.dataRange.addPropertyChangeListener("log", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("minimum", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("maximum", this.dataRangePropertyListener);
    }

    protected pwAxis(DataRange dataRange, pwRow pwRow2, pwColumn pwColumn2, int n) {
        this(pwRow2, pwColumn2, n);
        this.dataRange = dataRange;
        this.dataRange.addPropertyChangeListener("log", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("minimum", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("maximum", this.dataRangePropertyListener);
    }

    private pwAxis(pwRow pwRow2, pwColumn pwColumn2, int n) {
        super(pwRow2, pwColumn2);
        this.setOpaque(false);
        this.visible = true;
        this.setOrientationInternal(n);
        this.installMouseModules();
        JMenuItem jMenuItem = new JMenuItem("Back");
        jMenuItem.addActionListener(this.createActionListener());
        jMenuItem.setActionCommand("back");
        jMenuItem.setToolTipText("undo last operation");
        this.mouseAdapter.addMenuItem(jMenuItem);
        this.dataRangePropertyListener = this.createDataRangePropertyListener();
        this.setLayout(new AxisLayoutManager());
        this.maybeInitializeInputPanels();
        this.add(this.primaryInputPanel);
        this.add(this.secondaryInputPanel);
    }

    private void maybeInitializeInputPanels() {
        if (this.primaryInputPanel == null) {
            this.primaryInputPanel = new JPanel();
            this.primaryInputPanel.setOpaque(false);
        }
        if (this.secondaryInputPanel == null) {
            this.secondaryInputPanel = new JPanel();
            this.secondaryInputPanel.setOpaque(false);
        }
    }

    protected void maybeInitializeScanButtons() {
        this.scanPrevious = new ScanButton(SCAN_PREVIOUS_LABEL);
        this.scanNext = new ScanButton(SCAN_NEXT_LABEL);
        ActionListener actionListener = this.createScanActionListener();
        this.scanPrevious.addActionListener(actionListener);
        this.scanNext.addActionListener(actionListener);
        this.add(this.scanPrevious);
        this.add(this.scanNext);
    }

    private ActionListener createActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals("back")) {
                    pwAxis.this.setDataRangePrev();
                }
            }
        };
    }

    private ActionListener createScanActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals(pwAxis.SCAN_PREVIOUS_LABEL)) {
                    pwAxis.this.scanPrevious();
                } else if (string.equals(pwAxis.SCAN_NEXT_LABEL)) {
                    pwAxis.this.scanNext();
                }
            }
        };
    }

    private PropertyChangeListener createDataRangePropertyListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                Object object = propertyChangeEvent.getOldValue();
                Object object2 = propertyChangeEvent.getNewValue();
                if (string.equals("log")) {
                    pwAxis.this.update();
                    pwAxis.this.firePropertyChange("log", object, object2);
                } else if (string.equals("minimum")) {
                    pwAxis.this.update();
                    pwAxis.this.firePropertyChange("dataMinimum", object, object2);
                } else if (string.equals("maximum")) {
                    pwAxis.this.update();
                    pwAxis.this.firePropertyChange("dataMaximum", object, object2);
                }
                pwAxis.this.markDirty();
            }
        };
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.maybeInitializeInputPanels();
        this.primaryInputPanel.addMouseListener(mouseListener);
        this.secondaryInputPanel.addMouseListener(mouseListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this.maybeInitializeInputPanels();
        this.primaryInputPanel.removeMouseListener(mouseListener);
        this.secondaryInputPanel.removeMouseListener(mouseListener);
    }

    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.maybeInitializeInputPanels();
        this.primaryInputPanel.addMouseMotionListener(mouseMotionListener);
        this.secondaryInputPanel.addMouseMotionListener(mouseMotionListener);
    }

    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.maybeInitializeInputPanels();
        this.primaryInputPanel.removeMouseMotionListener(mouseMotionListener);
        this.secondaryInputPanel.removeMouseMotionListener(mouseMotionListener);
    }

    public void setOrientation(int n) {
        boolean bl = this.isHorizontal();
        this.setOrientationInternal(n);
        if (bl != this.isHorizontal()) {
            this.installMouseModules();
        }
    }

    private void setOrientationInternal(int n) {
        this.orientation = n;
        if (n == 1) {
            this.setTickDirection(995);
        } else if (n == 2) {
            this.setTickDirection(996);
        } else if (n == 3) {
            this.setTickDirection(4);
        } else if (n == 4) {
            this.setTickDirection(3);
        } else {
            throw new IllegalArgumentException("Invalid value for orientation");
        }
    }

    private void installMouseModules() {
        if (this.zoom instanceof dasMouseModuleHorizontalRangeSelector) {
            ((dasMouseModuleHorizontalRangeSelector)this.zoom).removeDataRangeSelectionListener(this);
            this.mouseAdapter.removeMouseModule(this.zoom);
        } else if (this.zoom instanceof dasMouseModuleVerticalRangeSelector) {
            ((dasMouseModuleVerticalRangeSelector)this.zoom).removeDataRangeSelectionListener(this);
            this.mouseAdapter.removeMouseModule(this.zoom);
        }
        if (this.isHorizontal()) {
            this.zoom = new dasMouseModuleHorizontalRangeSelector(this, this);
            ((dasMouseModuleHorizontalRangeSelector)this.zoom).addDataRangeSelectionListener(this);
            this.mouseAdapter.addMouseModule(this.zoom);
            this.mouseAdapter.setPrimaryModule(this.zoom);
        } else {
            this.zoom = new dasMouseModuleVerticalRangeSelector(this, this);
            ((dasMouseModuleVerticalRangeSelector)this.zoom).addDataRangeSelectionListener(this);
            this.mouseAdapter.addMouseModule(this.zoom);
            this.mouseAdapter.setPrimaryModule(this.zoom);
        }
    }

    public void setDataRange(Datum datum, Datum datum2) {
        if (!datum2.gt(datum)) {
            pwDie.println(pwDie.CRITICAL, "setDataRange where min > max ignored");
            return;
        }
        Units units = this.dataRange.getUnits();
        if (datum.getUnits() != units) {
            datum.convertTo(units);
            datum2.convertTo(units);
        }
        double d = this.dataRange.getMinimum();
        double d2 = this.dataRange.getMaximum();
        this.animateChange(d, d2, datum.getValue(), datum2.getValue());
        this.dataRange.setRange(datum.getValue(), datum2.getValue());
        this.update();
    }

    public void setDataRange(double[] dArray) {
        double d = dArray[0];
        double d2 = dArray[0];
        int n = 1;
        while (n < dArray.length) {
            d = d < dArray[n] ? d : dArray[n];
            d2 = d2 > dArray[n] ? d2 : dArray[n];
            ++n;
        }
        double d3 = d2 - d;
        if (this.isLog()) {
            this.setDataRange(Datum.create(d, this.getUnits()), Datum.create(d2, this.getUnits()));
        } else {
            Datum datum = Datum.create(d - d3 * 0.05, this.getUnits());
            Datum datum2 = Datum.create(d2 + d3 * 0.05, this.getUnits());
            this.setDataRange(datum, datum2);
        }
    }

    public void setDataRangePrev() {
        double d = this.dataRange.getMinimum();
        double d2 = this.dataRange.getMaximum();
        this.dataRange.setRangePrev();
        double d3 = this.dataRange.getMinimum();
        double d4 = this.dataRange.getMaximum();
        this.animateChange(d, d2, d3, d4);
        this.update();
    }

    public void setDataRangeForward() {
        double d = this.dataRange.getMinimum();
        double d2 = this.dataRange.getMaximum();
        this.dataRange.setRangeForward();
        double d3 = this.dataRange.getMinimum();
        double d4 = this.dataRange.getMaximum();
        this.animateChange(d, d2, d3, d4);
        this.update();
    }

    public void setDataRangeZoomOut() {
        double d = this.dataRange.getMinimum();
        double d2 = this.dataRange.getMaximum();
        if (this.isLog()) {
            d = Math.log(d);
            d2 = Math.log(d2);
        }
        double d3 = d2 - d;
        double d4 = d - d3 / 2.0;
        double d5 = d2 + d3 / 2.0;
        if (this.isLog()) {
            d4 = Math.exp(d4);
            d5 = Math.exp(d5);
        }
        this.animateChange(d, d2, d4, d5);
        this.dataRange.setRange(d4, d5);
    }

    public void setDeviceRange(double d, double d2) {
        if (this.isHorizontal()) {
            this.getColumn().setDPosition(d, d2);
        } else {
            this.getRow().setDPosition(d, d2);
        }
        this.deviceRangeChanged();
    }

    protected void deviceRangeChanged() {
    }

    public Datum getDataMinimum() {
        Datum datum = Datum.create(this.dataRange.getMinimum(), this.dataRange.getUnits());
        datum.setFormatter(this.nf);
        return datum;
    }

    public Datum getDataMaximum() {
        Datum datum = Datum.create(this.dataRange.getMaximum(), this.dataRange.getUnits());
        datum.setFormatter(this.nf);
        return datum;
    }

    public double getDataMaximum(Units units) {
        double d = units != this.dataRange.getUnits() ? this.dataRange.getUnits().getConverter(units).convert(this.dataRange.getMaximum()) : this.dataRange.getMaximum();
        return d;
    }

    public double getDataMinimum(Units units) {
        double d = units != this.dataRange.getUnits() ? this.dataRange.getUnits().getConverter(units).convert(this.dataRange.getMinimum()) : this.dataRange.getMinimum();
        return d;
    }

    public double getDeviceMinimum() {
        if (this.isHorizontal()) {
            return this.getColumn().getDMinimum();
        }
        return this.getRow().getDMinimum();
    }

    public double getDeviceMaximum() {
        if (this.isHorizontal()) {
            return this.getColumn().getDMaximum();
        }
        return this.getRow().getDMaximum();
    }

    public final double getDevicePosition() {
        if (this.orientation == 2) {
            return this.getRow().getDMaximum();
        }
        if (this.orientation == 1) {
            return this.getRow().getDMinimum();
        }
        if (this.orientation == 3) {
            return this.getColumn().getDMinimum();
        }
        return this.getColumn().getDMaximum();
    }

    public boolean isLog() {
        return this.dataRange.isLog();
    }

    public void setLog(boolean bl) {
        boolean bl2 = this.isLog();
        this.dataRange.setLog(bl);
        this.update();
        if (bl != bl2) {
            this.firePropertyChange("log", bl2, bl);
        }
    }

    public pwAxis createAttachedAxis(pwRow pwRow2, pwColumn pwColumn2) {
        return new pwAxis(this.dataRange, pwRow2, pwColumn2, this.getOrientation());
    }

    public pwAxis createAttachedAxis(pwRow pwRow2, pwColumn pwColumn2, int n) {
        return new pwAxis(this.dataRange, pwRow2, pwColumn2, n);
    }

    public pwAxis getMasterAxis() {
        return this.dataRange.getCreator();
    }

    public void attachTo(pwAxis pwAxis2) {
        if (this instanceof pwTimeAxis ^ pwAxis2 instanceof pwTimeAxis) {
            throw new IllegalArgumentException("Cannot attach a time axis to a non-time axis");
        }
        DataRange dataRange = this.dataRange;
        this.dataRange = pwAxis2.dataRange;
        dataRange.removePropertyChangeListener("log", this.dataRangePropertyListener);
        dataRange.removePropertyChangeListener("minimum", this.dataRangePropertyListener);
        dataRange.removePropertyChangeListener("maximum", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("log", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("minimum", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("maximum", this.dataRangePropertyListener);
        if (dataRange.isLog() != this.dataRange.isLog()) {
            this.firePropertyChange("log", dataRange.isLog(), this.dataRange.isLog());
        }
        this.firePropertyChange("minimum", dataRange.getMinimum(), this.dataRange.getMinimum());
        this.firePropertyChange("maximum", dataRange.getMaximum(), this.dataRange.getMaximum());
    }

    public void detach() {
        DataRange dataRange;
        this.dataRange.removePropertyChangeListener("log", this.dataRangePropertyListener);
        this.dataRange.removePropertyChangeListener("minimum", this.dataRangePropertyListener);
        this.dataRange.removePropertyChangeListener("maximum", this.dataRangePropertyListener);
        this.dataRange = dataRange = new DataRange(this, new Datum(this.dataRange.getMinimum(), this.dataRange.getUnits()), new Datum(this.dataRange.getMaximum(), this.dataRange.getUnits()), this.dataRange.isLog());
        this.dataRange.addPropertyChangeListener("log", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("minimum", this.dataRangePropertyListener);
        this.dataRange.addPropertyChangeListener("maximum", this.dataRangePropertyListener);
    }

    public boolean isAttached() {
        return this != this.getMasterAxis();
    }

    protected tickVDescriptor getTickV() {
        if (this.tickV == null) {
            this.updateTickV();
        }
        return this.tickV;
    }

    protected void updateTickV() {
        int n;
        int n2;
        int n3;
        if (this.dataRange.isLog()) {
            tickVDescriptor tickVDescriptor2 = new tickVDescriptor();
            tickVDescriptor2.units = this.dataRange.getUnits();
            double d = this.dataRange.getMinimum();
            double d2 = this.dataRange.getMaximum();
            tickVDescriptor2.isLog = true;
            double d3 = pwMath.roundNDigits(Math.log(d) / Math.log(10.0), 4);
            int n4 = (int)Math.ceil(d3);
            double d4 = pwMath.roundNDigits(Math.log(d2) / Math.log(10.0), 4);
            int n5 = (int)Math.floor(d4);
            int n6 = 1;
            int n7 = (n5 - n4) / n6 + 1;
            int n8 = this.isHorizontal() ? (int)this.getColumn().getWidth() / n7 : (int)this.getRow().getHeight() / n7;
            if (n8 < 30) {
                n6 = (int)Math.floor((double)(n5 - n4) / 5.0);
                n4 = (int)Math.ceil((float)n4 / (float)n6) * n6;
                n5 = (int)Math.floor((float)n5 / (float)n6) * n6;
                n7 = (n5 - n4) / n6 + 1;
                tickVDescriptor2.minor = 0.0;
            } else {
                tickVDescriptor2.minor = 1.0;
            }
            double[] dArray = new double[n7];
            int n9 = 0;
            while (n9 < n7) {
                dArray[n9] = Math.exp((double)(n9 * n6 + n4) * Math.log(10.0));
                ++n9;
            }
            if (n4 >= n5) {
                tickVDescriptor2.labelMinor = true;
            }
            tickVDescriptor2.tickV = dArray;
            if (pwMath.log10(d2 / d) >= 5.0 || pwMath.log10(d2) >= 5.0 || pwMath.log10(d) <= -5.0) {
                this.setFormatter(new DasFormatter(new DecimalFormat("0E0")));
            } else {
                DasFormatter dasFormatter = new DasFormatter(new DecimalFormat());
                if (n4 < 0) {
                    dasFormatter.setMinimumFractionDigits(-1 * n4);
                }
                this.setFormatter(dasFormatter);
            }
            tickVDescriptor2.nf = this.nf;
            this.tickV = tickVDescriptor2;
            return;
        }
        if (this.isHorizontal()) {
            n3 = this.getFontMetrics(this.getTickLabelFont()).stringWidth("0.0000");
            n2 = (int)this.getColumn().getWidth();
            n = n2 / n3;
        } else {
            n3 = this.getFontMetrics(this.getTickLabelFont()).getHeight();
            n2 = (int)this.getRow().getHeight();
            n = n2 / n3;
        }
        n = n < 7 ? n : 7;
        tickVDescriptor tickVDescriptor3 = new tickVDescriptor();
        tickVDescriptor3.units = this.dataRange.getUnits();
        double d = this.dataRange.getMinimum();
        double d5 = this.dataRange.getMaximum();
        double d6 = (d5 - d) / (double)n;
        double d7 = Math.exp(Math.log(10.0) * Math.floor(Math.log(d6) / Math.log(10.0)));
        double d8 = d6 / d7;
        d8 = d8 < 1.666 ? 1.0 : (d8 < 3.333 ? 2.0 : 5.0);
        double d9 = d8 * d7;
        double d10 = d9 * Math.ceil(d / d9 - 0.01);
        double d11 = d9 * Math.floor(d5 / d9 + 0.01);
        int n10 = 1 + (int)Math.round((d11 - d10) / d9);
        double[] dArray = new double[n10];
        int n11 = 0;
        while (n11 < n10) {
            dArray[n11] = d10 + (double)n11 * d9;
            ++n11;
        }
        tickVDescriptor3.tickV = dArray;
        tickVDescriptor3.minor = d8 == 5.0 ? d9 / 5.0 : (d8 == 2.0 ? d9 / 2.0 : d9 / 4.0);
        int n12 = n2;
        tickVDescriptor3.nf = this.nf = Datum.getFormatter(this.getDataMinimum(), this.getDataMaximum(), n10);
        this.tickV = tickVDescriptor3;
    }

    protected void paintComponent(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle != null && rectangle.width <= 1 && rectangle.height <= 1) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        if (this.isHorizontal()) {
            this.paintHorizontalAxis(graphics2D);
        } else {
            this.paintVerticalAxis(graphics2D);
        }
    }

    protected void paintHorizontalAxis(Graphics2D graphics2D) {
        Object object;
        int n;
        Rectangle rectangle = this.getBounds();
        graphics2D.translate(-rectangle.x, -rectangle.y);
        boolean bl = this.orientation == 2 || this.oppositeAxisVisible;
        boolean bl2 = this.orientation == 2 && this.tickLabelsVisible;
        boolean bl3 = this.orientation == 2 && !this.axisLabel.equals("");
        boolean bl4 = this.orientation == 1 || this.oppositeAxisVisible;
        boolean bl5 = this.orientation == 1 && this.tickLabelsVisible;
        boolean bl6 = this.orientation == 1 && !this.axisLabel.equals("");
        int n2 = (int)Math.round(this.getRow().getDMinimum()) - 1;
        int n3 = (int)Math.round(this.getRow().getDMaximum());
        int n4 = (int)Math.round(this.getColumn().getDMaximum());
        int n5 = (int)Math.round(this.getColumn().getDMinimum());
        Font font = this.getTickLabelFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        double d = this.dataRange.getMaximum();
        double d2 = this.dataRange.getMinimum();
        tickVDescriptor tickVDescriptor2 = this.getTickV();
        double[] dArray = tickVDescriptor2.tickV;
        if (!(this instanceof pwTimeAxis)) {
            n = 0;
            while (n < dArray.length) {
                double d3;
                dArray[n] = d3 = pwMath.roundNDigits(dArray[n], 3);
                ++n;
            }
        }
        if (bl) {
            graphics2D.drawLine(n5, n3, n4, n3);
        }
        if (bl4) {
            graphics2D.drawLine(n5, n2, n4, n2);
        }
        n = font.getSize() * 2 / 3;
        int n6 = n / 2;
        int n7 = dArray == null ? 0 : dArray.length;
        int n8 = -1;
        while (n8 < n7) {
            int n9;
            double d4;
            double d5;
            double d6;
            if (n8 >= 0) {
                d6 = dArray[n8];
                d5 = n8 + 1 < n7 ? dArray[n8 + 1] : d;
                d4 = tickVDescriptor2.isLog ? tickVDescriptor2.minor * dArray[n8] : tickVDescriptor2.minor;
            } else if (tickVDescriptor2.isLog) {
                d5 = n7 > 0 ? dArray[n8 + 1] : d;
                d4 = tickVDescriptor2.minor != 0.0 ? Math.exp(Math.log(10.0) * (double)((int)Math.floor(Math.log(d2) / Math.log(10.0)))) : 0.0;
                d6 = Math.ceil(d2 / d4) * d4;
            } else {
                d4 = tickVDescriptor2.minor;
                n9 = (int)Math.floor((dArray[0] - d2) / d4);
                d6 = dArray[0] - (double)n9 * d4;
                d5 = dArray[0];
            }
            if (d4 == 0.0) {
                n9 = 1;
            } else {
                if (d6 > d5 && (d5 - d6) / d4 > -0.01) {
                    d5 = d6;
                }
                n9 = 1 + (int)Math.floor((d5 - d6) / d4);
            }
            int n10 = 0;
            while (n10 < n9) {
                int n11;
                double d7 = d6 + (double)n10 * d4;
                int n12 = (int)Math.floor(this.transform(d7, tickVDescriptor2.units) + 0.5);
                if (tickVDescriptor2.labelMinor || n10 == 0 && n8 >= 0) {
                    object = this.tickFormatter(d7);
                    n11 = n;
                    if (bl) {
                        graphics2D.drawLine(n12, n3, n12, n3 + n11);
                        if (bl2) {
                            this.drawLabel(graphics2D, d7, n8, n12, n3 + n11);
                        }
                    }
                    if (bl4) {
                        graphics2D.drawLine(n12, n2, n12, n2 - n11);
                        if (bl5) {
                            this.drawLabel(graphics2D, d7, n8, n12, n2 - n11);
                        }
                    }
                } else {
                    n11 = n6;
                    if (bl) {
                        graphics2D.drawLine(n12, n3, n12, n3 + n11);
                    }
                    if (bl4) {
                        graphics2D.drawLine(n12, n2, n12, n2 - n11);
                    }
                }
                ++n10;
            }
            ++n8;
        }
        if (!this.axisLabel.equals("")) {
            int n13;
            object = (Graphics2D)graphics2D.create();
            int n14 = this.getTitlePositionOffset();
            GrannyTextRenderer grannyTextRenderer = new GrannyTextRenderer();
            grannyTextRenderer.setString(this, this.axisLabel);
            int n15 = (int)grannyTextRenderer.getWidth();
            ((Graphics)object).setFont(this.getLabelFont());
            if (bl3) {
                int n16 = n5 + (n4 - n5 - n15) / 2;
                n13 = n3 + n14;
                grannyTextRenderer.draw((Graphics)object, n16, n13);
            }
            if (bl6) {
                int n17 = n5 + (n4 - n5 - n15) / 2;
                n13 = n2 - n14;
                grannyTextRenderer.draw((Graphics)object, n17, n13);
            }
            ((Graphics)object).dispose();
        }
    }

    protected void paintVerticalAxis(Graphics2D graphics2D) {
        Object object;
        int n;
        Rectangle rectangle = this.getBounds();
        graphics2D.translate(-rectangle.x, -rectangle.y);
        boolean bl = this.orientation == 3 || this.oppositeAxisVisible;
        boolean bl2 = this.orientation == 3 && this.tickLabelsVisible;
        boolean bl3 = this.orientation == 3 && !this.axisLabel.equals("");
        boolean bl4 = this.orientation == 4 || this.oppositeAxisVisible;
        boolean bl5 = this.orientation == 4 && this.tickLabelsVisible;
        boolean bl6 = this.orientation == 4 && !this.axisLabel.equals("");
        int n2 = (int)Math.round(this.getColumn().getDMinimum()) - 1;
        int n3 = (int)Math.round(this.getColumn().getDMaximum());
        int n4 = (int)Math.round(this.getRow().getDMaximum());
        int n5 = (int)Math.round(this.getRow().getDMinimum());
        Font font = this.getTickLabelFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        double d = this.dataRange.getMaximum();
        double d2 = this.dataRange.getMinimum();
        tickVDescriptor tickVDescriptor2 = this.getTickV();
        double[] dArray = tickVDescriptor2.tickV;
        if (!(this instanceof pwTimeAxis)) {
            n = 0;
            while (n < dArray.length) {
                double d3;
                dArray[n] = d3 = pwMath.roundNDigits(dArray[n], 3);
                ++n;
            }
        }
        if (bl) {
            graphics2D.drawLine(n2, n5, n2, n4);
        }
        if (bl4) {
            graphics2D.drawLine(n3, n5, n3, n4);
        }
        n = font.getSize() * 2 / 3;
        int n6 = n * 2 / 3;
        int n7 = dArray == null ? 0 : dArray.length;
        int n8 = -1;
        while (n8 < n7) {
            int n9;
            double d4;
            double d5;
            double d6;
            if (n8 >= 0) {
                d6 = dArray[n8];
                d5 = n8 + 1 < n7 ? dArray[n8 + 1] : d;
                d4 = tickVDescriptor2.isLog ? tickVDescriptor2.minor * dArray[n8] : tickVDescriptor2.minor;
            } else if (tickVDescriptor2.isLog) {
                d5 = n7 > 0 ? dArray[n8 + 1] : d;
                d4 = tickVDescriptor2.minor != 0.0 ? Math.exp(Math.log(10.0) * (double)((int)Math.floor(Math.log(d2) / Math.log(10.0)))) : 0.0;
                d6 = Math.ceil(d2 / d4) * d4;
            } else {
                d4 = tickVDescriptor2.minor;
                n9 = (int)Math.floor((dArray[0] - d2) / d4);
                d6 = dArray[0] - (double)n9 * d4;
                d5 = dArray[0];
            }
            if (d4 == 0.0) {
                n9 = 1;
            } else {
                if (d6 > d5 && (d5 - d6) / d4 > -0.01) {
                    d5 = d6;
                }
                n9 = 1 + (int)Math.floor((d5 - d6) / d4);
            }
            int n10 = 0;
            while (n10 < n9) {
                int n11;
                double d7 = d6 + (double)n10 * d4;
                int n12 = (int)Math.floor(this.transform(d7, tickVDescriptor2.units) + 0.5);
                if (tickVDescriptor2.labelMinor || n10 == 0 && n8 >= 0) {
                    object = this.tickFormatter(d7);
                    n11 = n;
                    if (bl) {
                        graphics2D.drawLine(n2, n12, n2 - n11, n12);
                        if (bl2) {
                            this.drawLabel(graphics2D, d7, n8, n2 - n11, n12);
                        }
                    }
                    if (bl4) {
                        graphics2D.drawLine(n3, n12, n3 + n11, n12);
                        if (bl5) {
                            this.drawLabel(graphics2D, d7, n8, n3 + n11, n12);
                        }
                    }
                } else {
                    n11 = n6;
                    if (bl) {
                        graphics2D.drawLine(n2, n12, n2 - n11, n12);
                    }
                    if (bl4) {
                        graphics2D.drawLine(n3, n12, n3 + n11, n12);
                    }
                }
                ++n10;
            }
            ++n8;
        }
        if (!this.axisLabel.equals("")) {
            int n13;
            object = (Graphics2D)graphics2D.create();
            int n14 = this.getTitlePositionOffset();
            GrannyTextRenderer grannyTextRenderer = new GrannyTextRenderer();
            grannyTextRenderer.setString(this, this.axisLabel);
            int n15 = (int)grannyTextRenderer.getWidth();
            ((Graphics)object).setFont(this.getLabelFont());
            if (bl3) {
                ((Graphics2D)object).rotate(-1.5707963267948966);
                int n16 = -n4 + (n4 - n5 - n15) / 2;
                n13 = n2 - n14;
                grannyTextRenderer.draw((Graphics)object, n16, n13);
            }
            if (bl6) {
                ((Graphics2D)object).rotate(1.5707963267948966);
                int n17 = n5 + (n4 - n5 - n15) / 2;
                n13 = -n3 - n14;
                grannyTextRenderer.draw((Graphics)object, n17, n13);
            }
            ((Graphics)object).dispose();
        }
    }

    protected int getTitlePositionOffset() {
        Font font = this.getTickLabelFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        Font font2 = this.getLabelFont();
        int n = font.getSize() * 2 / 3;
        GrannyTextRenderer grannyTextRenderer = new GrannyTextRenderer();
        grannyTextRenderer.setString(this, this.axisLabel);
        if (this.orientation == 2) {
            return font.getSize() + n + fontMetrics.stringWidth(" ") + font2.getSize() + font2.getSize() / 2;
        }
        if (this.orientation == 1) {
            return n + fontMetrics.stringWidth(" ") + font2.getSize() + font2.getSize() / 2 + (int)grannyTextRenderer.getDescent();
        }
        if (this.orientation == 3) {
            return n + this.getMaxLabelWidth(fontMetrics) + fontMetrics.stringWidth(" ") + font2.getSize() / 2 + (int)grannyTextRenderer.getDescent();
        }
        return n + this.getMaxLabelWidth(fontMetrics) + fontMetrics.stringWidth(" ") + font2.getSize() / 2 + (int)grannyTextRenderer.getDescent();
    }

    protected void drawLabel(Graphics graphics, double d, int n, int n2, int n3) {
        if (!this.tickLabelsVisible) {
            return;
        }
        String string = this.tickFormatter(d);
        Font font = graphics.getFont();
        graphics.setFont(this.getTickLabelFont());
        GrannyTextRenderer grannyTextRenderer = new GrannyTextRenderer();
        grannyTextRenderer.setString(this, string);
        int n4 = (int)grannyTextRenderer.getWidth();
        int n5 = (int)grannyTextRenderer.getHeight();
        int n6 = (int)grannyTextRenderer.getAscent();
        int n7 = this.getFontMetrics(this.getTickLabelFont()).stringWidth(" ");
        if (this.orientation == 2) {
            n2 -= n4 / 2;
            n3 += n6 + n7;
        } else if (this.orientation == 1) {
            n2 -= n4 / 2;
            n3 = (int)((double)n3 - ((double)n7 + grannyTextRenderer.getDescent()));
        } else if (this.orientation == 3) {
            n2 -= n4 + n7;
            n3 += n6 - n5 / 2;
        } else {
            n2 += n7;
            n3 += n6 - n5 / 2;
        }
        grannyTextRenderer.draw(graphics, n2, n3);
    }

    public Font getTickLabelFont() {
        return this.getFont();
    }

    public void setTickLabelFont(Font font) {
    }

    public Font getLabelFont() {
        return this.getFont();
    }

    public void setLabelFont(Font font) {
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Assertion failure");
        }
    }

    private void setTickDirection(int n) {
        if (n == 995 || n == 4) {
            this.tickDirection = -1;
        } else if (n == 996 || n == 3) {
            this.tickDirection = 1;
        } else {
            throw new IllegalArgumentException("Invalid tick direction");
        }
    }

    protected int getMaxLabelWidth(FontMetrics fontMetrics) {
        tickVDescriptor tickVDescriptor2 = this.getTickV();
        double[] dArray = tickVDescriptor2.tickV;
        int n = Integer.MIN_VALUE;
        int n2 = 0;
        while (n2 < dArray.length) {
            String string = this.tickFormatter(dArray[n2]);
            int n3 = fontMetrics.stringWidth(string);
            if (n3 > n) {
                n = n3;
            }
            ++n2;
        }
        return n;
    }

    public void resize() {
        this.setBounds(this.getAxisBounds());
        this.invalidate();
        this.validate();
    }

    public boolean isHorizontal() {
        return this.orientation == 2 || this.orientation == 1;
    }

    protected Rectangle getAxisBounds() {
        if (this.isHorizontal()) {
            return this.getHorizontalAxisBounds();
        }
        return this.getVerticalAxisBounds();
    }

    private Rectangle getHorizontalAxisBounds() {
        int n;
        Object object;
        Serializable serializable;
        Rectangle rectangle;
        int n2 = (int)Math.round(this.getRow().getDMinimum()) - 1;
        int n3 = (int)Math.round(this.getRow().getDMaximum());
        pwColumn pwColumn2 = this.getColumn();
        int n4 = (int)Math.round(pwColumn2.getDMaximum());
        int n5 = (int)Math.round(pwColumn2.getDMinimum());
        boolean bl = this.orientation == 2 || this.oppositeAxisVisible;
        boolean bl2 = this.orientation == 2 && this.tickLabelsVisible;
        boolean bl3 = this.orientation == 2 && !this.axisLabel.equals("");
        boolean bl4 = this.orientation == 1 || this.oppositeAxisVisible;
        boolean bl5 = this.orientation == 1 && this.tickLabelsVisible;
        boolean bl6 = this.orientation == 1 && !this.axisLabel.equals("");
        Font font = this.getTickLabelFont();
        int n6 = font.getSize() * 2 / 3;
        if (this.oppositeAxisVisible) {
            rectangle = new Rectangle(n5, n2, n4 - n5 + 1, n3 - n2);
        } else if (this.orientation == 2) {
            rectangle = new Rectangle(n5, n3, n4 - n5 + 1, 1);
        } else if (this.orientation == 1) {
            rectangle = new Rectangle(n5, n2, n4 - n5 + 1, 1);
        } else {
            throw new IllegalStateException("Illegal axis orientation: " + this.orientation);
        }
        if (bl) {
            rectangle.height += n6;
        }
        if (bl4) {
            rectangle.height += n6;
            rectangle.y -= n6;
        }
        int n7 = this.getMaxLabelWidth(this.getFontMetrics(font));
        int n8 = this.getFontMetrics(font).stringWidth(" ");
        if (bl2) {
            rectangle.height += font.getSize() * 3 / 2 + n8;
            rectangle.x -= n7 / 2;
            rectangle.width += n7;
        }
        if (bl5) {
            rectangle.y -= font.getSize() * 3 / 2 + n8;
            rectangle.height += font.getSize() * 3 / 2 + n8;
            rectangle.x -= n7 / 2;
            rectangle.width += n7;
        }
        if (this.scanPrevious != null && this.scanNext != null) {
            serializable = this.scanPrevious.getPreferredSize();
            object = this.scanPrevious.getPreferredSize();
            n = Math.min(n5 - ((Dimension)serializable).width, rectangle.x);
            int n9 = Math.max(n4 + ((Dimension)object).width, rectangle.x + rectangle.width);
            rectangle.x = n;
            rectangle.width = n9 - n;
        }
        serializable = this.getLabelFont();
        object = new GrannyTextRenderer();
        ((GrannyTextRenderer)object).setString(this, this.getLabel());
        n = (int)((GrannyTextRenderer)object).getHeight() + ((Font)serializable).getSize() / 2;
        if (bl3) {
            rectangle.height += n;
        }
        if (bl6) {
            rectangle.y -= n;
            rectangle.height += n;
        }
        return rectangle;
    }

    private Rectangle getVerticalAxisBounds() {
        Rectangle rectangle;
        boolean bl = this.orientation == 3 || this.oppositeAxisVisible;
        boolean bl2 = this.orientation == 3 && this.tickLabelsVisible;
        boolean bl3 = this.orientation == 3 && !this.axisLabel.equals("");
        boolean bl4 = this.orientation == 4 || this.oppositeAxisVisible;
        boolean bl5 = this.orientation == 4 && this.tickLabelsVisible;
        boolean bl6 = this.orientation == 4 && !this.axisLabel.equals("");
        int n = (int)Math.round(this.getColumn().getDMinimum()) - 1;
        int n2 = (int)Math.round(this.getColumn().getDMaximum());
        int n3 = (int)Math.round(this.getRow().getDMaximum());
        int n4 = (int)Math.round(this.getRow().getDMinimum());
        Font font = this.getTickLabelFont();
        int n5 = font.getSize() * 2 / 3;
        if (this.oppositeAxisVisible) {
            rectangle = new Rectangle(n, n4, n2 - n, n3 - n4 + 1);
        } else if (this.orientation == 3) {
            rectangle = new Rectangle(n, n4, 1, n3 - n4 + 1);
        } else if (this.orientation == 4) {
            rectangle = new Rectangle(n2, n4, 1, n3 - n4 + 1);
        } else {
            throw new IllegalStateException("Illegal axis orientation: " + this.orientation);
        }
        if (bl) {
            rectangle.width += n5;
            rectangle.x -= n5;
        }
        if (bl4) {
            rectangle.width += n5;
        }
        int n6 = this.getMaxLabelWidth(this.getFontMetrics(font));
        int n7 = this.getFontMetrics(font).stringWidth(" ");
        if (bl2) {
            rectangle.x -= n6 + n7;
            rectangle.width += n6 + n7;
            rectangle.y -= font.getSize();
            rectangle.height += font.getSize() * 2;
        }
        if (bl5) {
            rectangle.width += n6 + n7;
            rectangle.y -= font.getSize();
            rectangle.height += font.getSize() * 2;
        }
        Font font2 = this.getLabelFont();
        GrannyTextRenderer grannyTextRenderer = new GrannyTextRenderer();
        grannyTextRenderer.setString(this, this.getLabel());
        int n8 = (int)grannyTextRenderer.getHeight() + font2.getSize() / 2;
        if (bl3) {
            rectangle.x -= n8;
            rectangle.width += n8;
        }
        if (bl6) {
            rectangle.width += n8;
        }
        return rectangle;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public DasFormatter getFormatter() {
        if (this.nf == null) {
            this.updateTickV();
        }
        return this.nf;
    }

    public int getTickDirection() {
        return this.tickDirection;
    }

    public double transform(Datum datum) {
        return this.transform(datum.getValue(), datum.getUnits());
    }

    double transform(double d, Units units) {
        if (this.isHorizontal()) {
            pwColumn pwColumn2 = this.getColumn();
            return this.transform(d, units, pwColumn2.getDMinimum(), pwColumn2.getDMaximum());
        }
        pwRow pwRow2 = this.getRow();
        return this.transform(d, units, pwRow2.getDMaximum(), pwRow2.getDMinimum());
    }

    double transform(double d, Units units, double d2, double d3) {
        double d4;
        if (units != this.dataRange.getUnits()) {
            d = Units.getConverter(this.dataRange.getUnits(), units).convert(d);
        }
        double d5 = d3 - d2;
        if (this.dataRange.isLog()) {
            double d6 = Math.log(d);
            double d7 = Math.log(this.dataRange.getMinimum());
            double d8 = Math.log(this.dataRange.getMaximum());
            double d9 = d8 - d7;
            d4 = d5 * (d6 - d7) / d9 + d2;
        } else {
            double d10 = this.dataRange.getMinimum();
            double d11 = this.dataRange.getMaximum();
            double d12 = d11 - d10;
            d4 = d5 * (d - d10) / d12 + d2;
        }
        if (d4 > 10000.0) {
            d4 = 10000.0;
        }
        if (d4 < -10000.0) {
            d4 = -10000.0;
        }
        return d4;
    }

    public Datum invTransform(double d) {
        double d2;
        int n;
        Object object;
        if (this.dataRange.isLog()) {
            object = this.isHorizontal() ? this.getColumn() : this.getRow();
            double d3 = ((pwDevicePosition)object).getDMaximum() - ((pwDevicePosition)object).getDMinimum();
            n = (int)d3;
            double d4 = Math.log(this.dataRange.getMinimum());
            double d5 = Math.log(this.dataRange.getMaximum());
            double d6 = d5 - d4;
            double d7 = this.isHorizontal() ? d4 + d6 * (d - ((pwDevicePosition)object).getDMinimum()) / d3 : d4 + d6 * (1.0 - (d - ((pwDevicePosition)object).getDMinimum()) / d3);
            d2 = Math.exp(d7);
        } else {
            object = this.isHorizontal() ? this.getColumn() : this.getRow();
            double d8 = ((pwDevicePosition)object).getDMaximum() - ((pwDevicePosition)object).getDMinimum();
            n = (int)d8;
            double d9 = this.dataRange.getMinimum();
            double d10 = this.dataRange.getMaximum();
            double d11 = d10 - d9;
            d2 = this.isHorizontal() ? d11 * (d - ((pwDevicePosition)object).getDMinimum()) / d8 + d9 : d11 * (1.0 - (d - ((pwDevicePosition)object).getDMinimum()) / d8) + d9;
        }
        object = Datum.create(d2, this.dataRange.getUnits());
        ((Datum)object).setFormatter(this.getDataMinimum().getFormatter(this.getDataMaximum(), n));
        return object;
    }

    protected String tickFormatter(double d) {
        if (this.nf == null) {
            pwDie.println("this");
        }
        return this.nf.grannyFormat(d, this.getUnits());
    }

    public void setOppositeAxisVisible(boolean bl) {
        if (bl == this.oppositeAxisVisible) {
            return;
        }
        boolean bl2 = this.oppositeAxisVisible;
        this.oppositeAxisVisible = bl;
        this.revalidate();
        this.repaint();
        this.firePropertyChange("oppositeAxisVisible", bl2, bl);
    }

    public boolean isOppositeAxisVisible() {
        return this.oppositeAxisVisible;
    }

    public void setLabel(String string) {
        if (string == null) {
            throw new NullPointerException("axis label cannot be null");
        }
        String string2 = this.axisLabel;
        this.axisLabel = string;
        this.update();
        this.firePropertyChange("label", string2, string);
    }

    public String getLabel() {
        return this.axisLabel;
    }

    public void setDataMaximum(Datum datum) {
        datum = datum.convertTo(this.dataRange.getUnits());
        this.dataRange.setMaximum(datum.getValue());
        this.update();
    }

    public void setDataMinimum(Datum datum) {
        datum = datum.convertTo(this.dataRange.getUnits());
        this.dataRange.setMinimum(datum.getValue());
        this.update();
    }

    public void DataRangeSelected(DataRangeSelectionEvent dataRangeSelectionEvent) {
        this.setDataRange(dataRangeSelectionEvent.getMinimum(), dataRangeSelectionEvent.getMaximum());
    }

    private Datum findTickLog(Datum datum, double d, boolean bl) {
        double d2;
        double d3 = datum.getValue();
        if (d > 0.0) {
            d2 = this.tickV.tickV[this.tickV.tickV.length - 1] * 10.0;
            int n = this.tickV.tickV.length - 1;
            while (n >= 0) {
                if (d3 < this.tickV.tickV[n]) {
                    d2 = this.tickV.tickV[n];
                }
                --n;
            }
        } else if (d < 0.0) {
            d2 = this.tickV.tickV[0] / 10.0;
            int n = 0;
            while (n < this.tickV.tickV.length) {
                if (d3 > this.tickV.tickV[n]) {
                    d2 = this.tickV.tickV[n];
                }
                ++n;
            }
        } else {
            d2 = -999.0;
            double d4 = Double.MAX_VALUE;
            int n = 0;
            while (n < this.tickV.tickV.length) {
                double d5 = Math.abs(Math.log(d3) - Math.log(this.tickV.tickV[n]));
                if (d5 < d4) {
                    d2 = this.tickV.tickV[n];
                    d4 = d5;
                }
                ++n;
            }
        }
        return new Datum(d2, datum.getUnits());
    }

    public Datum findTick(Datum datum, double d, boolean bl) {
        if (this.tickV == null) {
            return datum;
        }
        if (datum.getUnits() != this.getUnits()) {
            datum = datum.convertTo(this.getUnits());
        }
        if (this.isLog()) {
            return this.findTickLog(datum, d, bl);
        }
        double d2 = datum.getValue();
        double d3 = bl ? this.tickV.minor : this.tickV.tickV[1] - this.tickV.tickV[0];
        double d4 = this.tickV.tickV[0];
        double d5 = d < 0.0 ? d3 * Math.floor((d2 - d4) / d3) + d4 : (d > 0.0 ? d3 * Math.ceil((d2 - d4) / d3) + d4 : d3 * (double)Math.round((d2 - d4) / d3) + d4);
        return Datum.create(d5, this.getUnits());
    }

    public void animateChange(double d, double d2, double d3, double d4) {
        if (this.animated) {
            boolean bl = false;
            if (this instanceof pwTimeAxis) {
                bl = ((pwTimeAxis)this).getDrawTca();
                ((pwTimeAxis)this).setDrawTca(false);
            }
            long l = System.currentTimeMillis();
            DataRange dataRange = this.dataRange;
            DataRange dataRange2 = null;
            try {
                dataRange2 = (DataRange)this.dataRange.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                DasExceptionHandler.handle(cloneNotSupportedException);
                return;
            }
            this.dataRange = dataRange2;
            double d5 = 200.0;
            double d6 = (double)(System.currentTimeMillis() - l) / d5;
            while (d6 < 1.0) {
                d6 = (double)(System.currentTimeMillis() - l) / d5;
                double d7 = -4.0 + 8.0 * d6;
                double d8 = (pwMath.tanh(d7) + 1.0) / 2.0;
                double d9 = 1.0 - d8;
                if (this.isLog()) {
                    dataRange2.setRange(Math.exp(Math.log(d) * d9 + Math.log(d3) * d8), Math.exp(Math.log(d2) * d9 + Math.log(d4) * d8));
                } else {
                    dataRange2.setRange(d * d9 + d3 * d8, d2 * d9 + d4 * d8);
                }
                this.updateTickV();
                this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
            }
            if (this instanceof pwTimeAxis) {
                ((pwTimeAxis)this).setDrawTca(bl);
            }
            this.dataRange = dataRange;
        }
    }

    public Units getUnits() {
        return this.dataRange.getUnits();
    }

    protected void updateImmediately() {
        super.updateImmediately();
        this.updateTickV();
    }

    public boolean areTickLabelsVisible() {
        return this.tickLabelsVisible;
    }

    public void setTickLabelsVisible(boolean bl) {
        if (this.tickLabelsVisible == bl) {
            return;
        }
        boolean bl2 = this.ticksVisible;
        this.tickLabelsVisible = bl;
        this.update();
        this.firePropertyChange("tickLabelsVisible", bl2, bl);
    }

    public void setFormatter(DasFormatter dasFormatter) {
        this.nf = dasFormatter;
    }

    protected void installComponent() {
        super.installComponent();
    }

    protected void uninstallComponent() {
        super.uninstallComponent();
    }

    public boolean isAnimated() {
        return this.animated;
    }

    public void setAnimated(boolean bl) {
        this.animated = bl;
    }

    static pwAxis processAxisElement(Element element, pwRow pwRow2, pwColumn pwColumn2, DasForm dasForm) throws DasPropertyException, DasNameException {
        pwAxis pwAxis2;
        block4: {
            String string;
            String string2 = element.getAttribute("name");
            boolean bl = element.getAttribute("log").equals("true");
            double d = Double.parseDouble(element.getAttribute("dataMinimum"));
            double d2 = Double.parseDouble(element.getAttribute("dataMaximum"));
            int n = pwAxis.parseOrientationString(element.getAttribute("orientation"));
            String string3 = element.getAttribute("row");
            if (!string3.equals("") || pwRow2 == null) {
                pwRow2 = (pwRow)dasForm.checkValue(string3, class$graph$pwRow == null ? (class$graph$pwRow = pwAxis.class$("graph.pwRow")) : class$graph$pwRow, "<row>");
            }
            if (!(string = element.getAttribute("column")).equals("") || pwRow2 == null) {
                pwColumn2 = (pwColumn)dasForm.checkValue(string, class$graph$pwColumn == null ? (class$graph$pwColumn = pwAxis.class$("graph.pwColumn")) : class$graph$pwColumn, "<column>");
            }
            pwAxis2 = new pwAxis(new Datum(d), new Datum(d2), pwRow2, pwColumn2, n, bl);
            pwAxis2.setLabel(element.getAttribute("label"));
            pwAxis2.setOppositeAxisVisible(!element.getAttribute("oppositeAxisVisible").equals("false"));
            pwAxis2.setTickLabelsVisible(!element.getAttribute("tickLabelsVisible").equals("false"));
            if (string2.equals("")) break block4;
            try {
                pwAxis2.setDasName(string2);
            }
            catch (DasNameException dasNameException) {
                DasExceptionHandler.handle(dasNameException);
            }
        }
        return pwAxis2;
    }

    protected static String orientationToString(int n) {
        switch (n) {
            case 1: {
                return "top";
            }
            case 2: {
                return "bottom";
            }
            case 3: {
                return "left";
            }
            case 4: {
                return "right";
            }
        }
        throw new IllegalStateException("invalid orienation: " + n);
    }

    protected static int parseOrientationString(String string) {
        if (string.equals("horizontal")) {
            return 2;
        }
        if (string.equals("vertical")) {
            return 3;
        }
        if (string.equals("left")) {
            return 3;
        }
        if (string.equals("right")) {
            return 4;
        }
        if (string.equals("top")) {
            return 1;
        }
        if (string.equals("bottom")) {
            return 2;
        }
        throw new IllegalArgumentException("Invalid orientation: " + string);
    }

    public Element getDOMElement(Document document) {
        Element element = this.isAttached() ? document.createElement("attachedaxis") : document.createElement("axis");
        if (this.isAttached()) {
            element.setAttribute("ref", this.getMasterAxis().getDasName());
        } else {
            String string = this.getDataMinimum().toString();
            element.setAttribute("dataMinimum", string);
            String string2 = this.getDataMaximum().toString();
            element.setAttribute("dataMaximum", string2);
        }
        element.setAttribute("name", this.getDasName());
        element.setAttribute("row", this.getRow().getDasName());
        element.setAttribute("column", this.getColumn().getDasName());
        element.setAttribute("label", this.getLabel());
        element.setAttribute("log", Boolean.toString(this.isLog()));
        element.setAttribute("tickLabelsVisible", Boolean.toString(this.areTickLabelsVisible()));
        element.setAttribute("oppositeAxisVisible", Boolean.toString(this.isOppositeAxisVisible()));
        element.setAttribute("animated", Boolean.toString(this.isAnimated()));
        element.setAttribute("orientation", pwAxis.orientationToString(this.getOrientation()));
        return element;
    }

    static pwAxis processAttachedaxisElement(Element element, pwRow pwRow2, pwColumn pwColumn2, DasForm dasForm) throws DasPropertyException, DasNameException {
        pwAxis pwAxis2;
        block5: {
            String string;
            String string2 = element.getAttribute("name");
            pwAxis pwAxis3 = (pwAxis)dasForm.checkValue(element.getAttribute("ref"), class$graph$pwAxis == null ? (class$graph$pwAxis = pwAxis.class$("graph.pwAxis")) : class$graph$pwAxis, "<attachedaxis>");
            int n = element.getAttribute("orientation").equals("horizontal") ? 2 : 3;
            String string3 = element.getAttribute("row");
            if (!string3.equals("") || pwRow2 == null) {
                pwRow2 = (pwRow)dasForm.checkValue(string3, class$graph$pwRow == null ? (class$graph$pwRow = pwAxis.class$("graph.pwRow")) : class$graph$pwRow, "<row>");
            }
            if (!(string = element.getAttribute("column")).equals("") || pwColumn2 == null) {
                pwColumn2 = (pwColumn)dasForm.checkValue(string, class$graph$pwColumn == null ? (class$graph$pwColumn = pwAxis.class$("graph.pwColumn")) : class$graph$pwColumn, "<column>");
            }
            if ((pwAxis2 = pwAxis3.createAttachedAxis(pwRow2, pwColumn2, n)) instanceof pwTimeAxis) {
                ((pwTimeAxis)pwAxis2).setDataPath(element.getAttribute("dataPath"));
                ((pwTimeAxis)pwAxis2).setDrawTca(element.getAttribute("showTca").equals("true"));
            }
            pwAxis2.setLabel(element.getAttribute("label"));
            pwAxis2.setOppositeAxisVisible(!element.getAttribute("oppositeAxisVisible").equals("false"));
            pwAxis2.setTickLabelsVisible(!element.getAttribute("tickLabelsVisible").equals("false"));
            if (string2.equals("")) break block5;
            try {
                pwAxis2.setDasName(string2);
            }
            catch (DasNameException dasNameException) {
                DasExceptionHandler.handle(dasNameException);
            }
        }
        return pwAxis2;
    }

    public static pwAxis createNamedAxis(String string) {
        pwAxis pwAxis2 = new pwAxis(Datum.create(1.0, Units.dimensionless), Datum.create(10.0, Units.dimensionless), null, null, 2);
        if (string == null) {
            string = "axis_" + Integer.toHexString(System.identityHashCode(pwAxis2));
        }
        try {
            pwAxis2.setDasName(string);
        }
        catch (DasNameException dasNameException) {
            DasExceptionHandler.handle(dasNameException);
        }
        return pwAxis2;
    }

    public DataRange getDataRange() {
        return this.dataRange;
    }

    public void scanPrevious() {
        Datum datum = this.getDataMaximum().subtract(this.getDataMinimum()).multiply(1.0);
        Datum datum2 = this.getDataMinimum().subtract(datum);
        Datum datum3 = this.getDataMaximum().subtract(datum);
        this.setDataRange(datum2, datum3);
    }

    public void scanNext() {
        Datum datum = this.getDataMaximum().subtract(this.getDataMinimum()).multiply(1.0);
        Datum datum2 = this.getDataMinimum().add(datum);
        Datum datum3 = this.getDataMaximum().add(datum);
        this.setDataRange(datum2, datum3);
    }

    public Shape getActiveRegion() {
        Rectangle rectangle = this.primaryInputPanel.getBounds();
        rectangle.translate(this.getX(), this.getY());
        if (this.oppositeAxisVisible) {
            Rectangle rectangle2 = this.secondaryInputPanel.getBounds();
            rectangle2.translate(this.getX(), this.getY());
            GeneralPath generalPath = new GeneralPath(rectangle);
            generalPath.setWindingRule(0);
            generalPath.append(rectangle2, false);
            return generalPath;
        }
        return rectangle;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static class ScanButton
    extends JButton {
        private boolean hover;
        private boolean pressed;

        public ScanButton(String string) {
            this.setOpaque(true);
            this.setContentAreaFilled(false);
            this.setText(string);
            this.setFocusable(false);
            this.setBorder(new CompoundBorder(new LineBorder(Color.BLACK), new EmptyBorder(2, 2, 2, 2)));
            this.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ ScanButton this$0;
                {
                    this.this$0 = scanButton;
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.getButton() == 1) {
                        this.this$0.setForeground(Color.LIGHT_GRAY);
                        ScanButton.access$602(this.this$0, true);
                        this.this$0.repaint();
                    }
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    if (mouseEvent.getButton() == 1) {
                        this.this$0.setForeground(Color.BLACK);
                        ScanButton.access$602(this.this$0, false);
                        this.this$0.repaint();
                    }
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                    ScanButton.access$702(this.this$0, true);
                    this.this$0.repaint();
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    ScanButton.access$702(this.this$0, false);
                    this.this$0.repaint();
                }
            });
        }

        protected void paintComponent(Graphics graphics) {
            if (this.hover || this.pressed) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setColor(Color.white);
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                Object object2 = RenderingHints.VALUE_ANTIALIAS_ON;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object2);
                super.paintComponent(graphics2D);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
            }
        }

        protected void paintBorder(Graphics graphics) {
            if (this.hover || this.pressed) {
                super.paintBorder(graphics);
            }
        }

        static /* synthetic */ boolean access$602(ScanButton scanButton, boolean bl) {
            scanButton.pressed = bl;
            return scanButton.pressed;
        }

        static /* synthetic */ boolean access$702(ScanButton scanButton, boolean bl) {
            scanButton.hover = bl;
            return scanButton.hover;
        }
    }

    protected class AxisLayoutManager
    implements LayoutManager {
        protected AxisLayoutManager() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void layoutContainer(Container container) {
            if (pwAxis.this != container) {
                throw new IllegalArgumentException();
            }
            if (pwAxis.this.isHorizontal()) {
                this.horizontalLayout();
            } else {
                this.verticalLayout();
            }
        }

        protected void horizontalLayout() {
            int n = (int)Math.round(pwAxis.this.getRow().getDMinimum()) - 1;
            int n2 = (int)Math.round(pwAxis.this.getRow().getDMaximum());
            int n3 = (int)Math.round(pwAxis.this.getColumn().getDMaximum());
            int n4 = (int)Math.round(pwAxis.this.getColumn().getDMinimum());
            boolean bl = pwAxis.this.orientation == 2 || pwAxis.this.oppositeAxisVisible;
            boolean bl2 = pwAxis.this.orientation == 2 && pwAxis.this.tickLabelsVisible;
            boolean bl3 = pwAxis.this.orientation == 2 && !pwAxis.this.axisLabel.equals("");
            boolean bl4 = pwAxis.this.orientation == 1 || pwAxis.this.oppositeAxisVisible;
            boolean bl5 = pwAxis.this.orientation == 1 && pwAxis.this.tickLabelsVisible;
            boolean bl6 = pwAxis.this.orientation == 1 && !pwAxis.this.axisLabel.equals("");
            Rectangle rectangle = null;
            Rectangle rectangle2 = null;
            Font font = pwAxis.this.getTickLabelFont();
            int n5 = font.getSize() * 2 / 3;
            if (bl) {
                rectangle = new Rectangle(n4, n2, n3 - n4 + 1, 1);
            }
            if (bl4) {
                rectangle2 = new Rectangle(n4, n, n3 - n4 + 1, 1);
            }
            if (bl) {
                rectangle.height += n5;
            }
            if (bl4) {
                rectangle2.height += n5;
                rectangle2.y -= n5;
            }
            int n6 = pwAxis.this.getMaxLabelWidth(pwAxis.this.getFontMetrics(font));
            int n7 = pwAxis.this.getFontMetrics(font).stringWidth(" ");
            if (bl2) {
                rectangle.height += font.getSize() * 3 / 2 + n7;
            }
            if (bl5) {
                rectangle2.y -= font.getSize() * 3 / 2 + n7;
                rectangle2.height += font.getSize() * 3 / 2 + n7;
            }
            Rectangle rectangle3 = pwAxis.this.orientation == 2 ? rectangle : rectangle2;
            Rectangle rectangle4 = pwAxis.this.orientation == 2 ? rectangle2 : rectangle;
            rectangle3.translate(-pwAxis.this.getX(), -pwAxis.this.getY());
            if (pwAxis.this.oppositeAxisVisible) {
                rectangle4.translate(-pwAxis.this.getX(), -pwAxis.this.getY());
            }
            pwAxis.this.primaryInputPanel.setBounds(rectangle3);
            if (pwAxis.this.oppositeAxisVisible) {
                pwAxis.this.secondaryInputPanel.setBounds(rectangle4);
            } else {
                pwAxis.this.secondaryInputPanel.setBounds(-100, -100, 0, 0);
            }
            if (pwAxis.this.scanPrevious != null && pwAxis.this.scanNext != null) {
                Dimension dimension = pwAxis.this.scanPrevious.getPreferredSize();
                int n8 = n4 - dimension.width - pwAxis.this.getX();
                int n9 = (pwAxis.this.orientation == 2 ? n2 : n - dimension.height) - pwAxis.this.getY();
                pwAxis.this.scanPrevious.setBounds(n8, n9, dimension.width, dimension.height);
                dimension = pwAxis.this.scanNext.getPreferredSize();
                n8 = n3 - pwAxis.this.getX();
                pwAxis.this.scanNext.setBounds(n8, n9, dimension.width, dimension.height);
            }
        }

        protected void verticalLayout() {
            boolean bl = pwAxis.this.orientation == 3 || pwAxis.this.oppositeAxisVisible;
            boolean bl2 = pwAxis.this.orientation == 3 && pwAxis.this.tickLabelsVisible;
            boolean bl3 = pwAxis.this.orientation == 3 && !pwAxis.this.axisLabel.equals("");
            boolean bl4 = pwAxis.this.orientation == 4 || pwAxis.this.oppositeAxisVisible;
            boolean bl5 = pwAxis.this.orientation == 4 && pwAxis.this.tickLabelsVisible;
            boolean bl6 = pwAxis.this.orientation == 4 && !pwAxis.this.axisLabel.equals("");
            int n = (int)Math.round(pwAxis.this.getColumn().getDMinimum()) - 1;
            int n2 = (int)Math.round(pwAxis.this.getColumn().getDMaximum());
            int n3 = (int)Math.round(pwAxis.this.getRow().getDMaximum());
            int n4 = (int)Math.round(pwAxis.this.getRow().getDMinimum());
            Rectangle rectangle = null;
            Rectangle rectangle2 = null;
            Font font = pwAxis.this.getTickLabelFont();
            int n5 = font.getSize() * 2 / 3;
            if (bl) {
                rectangle = new Rectangle(n, n4, 1, n3 - n4 + 1);
            }
            if (bl4) {
                rectangle2 = new Rectangle(n2, n4, 1, n3 - n4 + 1);
            }
            if (bl) {
                rectangle.width += n5;
                rectangle.x -= n5;
            }
            if (bl4) {
                rectangle2.width += n5;
            }
            int n6 = pwAxis.this.getMaxLabelWidth(pwAxis.this.getFontMetrics(font));
            int n7 = pwAxis.this.getFontMetrics(font).stringWidth(" ");
            if (bl2) {
                rectangle.x -= n6 + n7;
                rectangle.width += n6 + n7;
            }
            if (bl5) {
                rectangle2.width += n6 + n7;
            }
            Rectangle rectangle3 = pwAxis.this.orientation == 3 ? rectangle : rectangle2;
            Rectangle rectangle4 = pwAxis.this.orientation == 3 ? rectangle2 : rectangle;
            rectangle3.translate(-pwAxis.this.getX(), -pwAxis.this.getY());
            if (pwAxis.this.oppositeAxisVisible) {
                rectangle4.translate(-pwAxis.this.getX(), -pwAxis.this.getY());
            }
            pwAxis.this.primaryInputPanel.setBounds(rectangle3);
            if (pwAxis.this.oppositeAxisVisible) {
                pwAxis.this.secondaryInputPanel.setBounds(rectangle4);
            } else {
                pwAxis.this.secondaryInputPanel.setBounds(-100, -100, 0, 0);
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            return new Dimension();
        }

        public Dimension preferredLayoutSize(Container container) {
            return new Dimension();
        }

        public void removeLayoutComponent(Component component) {
        }
    }

    protected static class tickVDescriptor {
        double[] tickV = null;
        double minor = 1.0;
        boolean isLog = false;
        boolean labelMinor = false;
        DasFormatter nf = null;
        Units units = null;

        protected tickVDescriptor() {
        }

        public String toString() {
            String string = "tickV=[";
            int n = 0;
            while (n < this.tickV.length) {
                string = string + this.tickV[n] + ", ";
                ++n;
            }
            string = string + "],minor=" + this.minor;
            return string;
        }
    }
}

