/*
 * Decompiled with CFR 0.152.
 */
package graph.dnd;

import graph.pwAxis;
import graph.pwCanvasComponent;
import graph.pwColorBar;
import graph.pwPlot;
import graph.pwTimeAxis;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class TransferableCanvasComponent
implements Transferable {
    public static final DataFlavor CANVAS_COMPONENT_FLAVOR = TransferableCanvasComponent.localJVMFlavor("graph.pwCanvasComponent");
    public static final DataFlavor AXIS_FLAVOR = TransferableCanvasComponent.localJVMFlavor("graph.pwAxis");
    public static final DataFlavor TIME_AXIS_FLAVOR = TransferableCanvasComponent.localJVMFlavor("graph.pwAxis");
    public static final DataFlavor PLOT_FLAVOR = TransferableCanvasComponent.localJVMFlavor("graph.pwPlot");
    public static final DataFlavor COLORBAR_FLAVOR = TransferableCanvasComponent.localJVMFlavor("graph.pwColorBar");
    private List flavorList;
    private pwCanvasComponent component;

    private static DataFlavor localJVMFlavor(String string) {
        try {
            String string2 = "application/x-java-jvm-local-objectref";
            return new DataFlavor(string2 + ";class=" + string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }

    public TransferableCanvasComponent(pwAxis pwAxis2) {
        this.flavorList = Arrays.asList(AXIS_FLAVOR, CANVAS_COMPONENT_FLAVOR, DataFlavor.stringFlavor);
        this.component = pwAxis2;
    }

    public TransferableCanvasComponent(pwTimeAxis pwTimeAxis2) {
        this.flavorList = Arrays.asList(TIME_AXIS_FLAVOR, AXIS_FLAVOR, CANVAS_COMPONENT_FLAVOR, DataFlavor.stringFlavor);
        this.component = pwTimeAxis2;
    }

    public TransferableCanvasComponent(pwPlot pwPlot2) {
        this.flavorList = Arrays.asList(PLOT_FLAVOR, CANVAS_COMPONENT_FLAVOR, DataFlavor.stringFlavor);
        this.component = pwPlot2;
    }

    public TransferableCanvasComponent(pwColorBar pwColorBar2) {
        this.flavorList = Arrays.asList(PLOT_FLAVOR, CANVAS_COMPONENT_FLAVOR, DataFlavor.stringFlavor);
        this.component = pwColorBar2;
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (this.isDataFlavorSupported(dataFlavor)) {
            if (dataFlavor.equals(DataFlavor.stringFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return this.component;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return this.flavorList.toArray(new DataFlavor[this.flavorList.size()]);
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return this.flavorList.contains(dataFlavor);
    }
}

