/*
 * Decompiled with CFR 0.152.
 */
package graph;

import das_proto.DasProperties;
import das_proto.data.DasFormatter;
import das_proto.data.Datum;
import das_proto.data.TimeDatum;
import das_proto.data.Units;
import event.dasMouseModule;
import graph.DataRange;
import graph.pwCanvas;
import graph.pwCanvasComponent;
import graph.pwColumn;
import graph.pwDevicePosition;
import graph.pwPlot;
import graph.pwRow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import javax.swing.JFrame;
import javax.swing.JPanel;
import util.pwMath;

public class TimeRangeLabel
extends pwCanvasComponent {
    DataRange dataRange;
    Formatter df;

    public TimeRangeLabel(DataRange dataRange, pwRow pwRow2, pwColumn pwColumn2) {
        this.setRow(pwRow2);
        this.setColumn(pwColumn2);
        this.dataRange = dataRange;
        mouseModule mouseModule2 = new mouseModule();
        this.mouseAdapter.addMouseModule(mouseModule2);
        this.mouseAdapter.setPrimaryModule(mouseModule2);
        this.df = new Formatter();
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHints(DasProperties.getRenderingHints());
        Datum datum = Datum.create(this.dataRange.getMinimum(), this.dataRange.getUnits());
        Datum datum2 = Datum.create(this.dataRange.getMaximum(), this.dataRange.getUnits());
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n = (int)Math.floor(this.getRow().getDMinimum() + 0.5);
        int n2 = (int)Math.floor(this.getColumn().getDMinimum() + 0.5);
        graphics2D.translate(-this.getX(), -this.getY());
        graphics2D.drawString(this.df.format(datum), n2, n - fontMetrics.getHeight() / 2);
        String string = this.df.format(datum2);
        graphics2D.drawString(string, (int)((double)n2 + this.getColumn().getWidth() - (double)fontMetrics.stringWidth(string)), n - fontMetrics.getHeight() / 2);
    }

    public void resize() {
        Rectangle2D.Double double_ = pwDevicePosition.toRectangle(this.getRow(), this.getColumn());
        this.setBounds(new Rectangle((int)double_.x - 30, (int)double_.y - 30, (int)double_.width + 60, (int)double_.height + 30));
    }

    public PropertyChangeListener createDataRangePropertyListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                Object object = propertyChangeEvent.getOldValue();
                Object object2 = propertyChangeEvent.getNewValue();
                if (string.equals("log")) {
                    TimeRangeLabel.this.update();
                    TimeRangeLabel.this.firePropertyChange("log", object, object2);
                } else if (string.equals("minimum")) {
                    TimeRangeLabel.this.update();
                    TimeRangeLabel.this.firePropertyChange("dataMinimum", object, object2);
                } else if (string.equals("maximum")) {
                    TimeRangeLabel.this.update();
                    TimeRangeLabel.this.firePropertyChange("dataMaximum", object, object2);
                }
                TimeRangeLabel.this.markDirty();
            }
        };
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        JPanel jPanel = new JPanel();
        pwCanvas pwCanvas2 = new pwCanvas(300, 300);
        pwRow pwRow2 = new pwRow(pwCanvas2, 0.1, 0.9);
        pwColumn pwColumn2 = new pwColumn(pwCanvas2, 0.1, 0.9);
        pwCanvas2.addCanvasComponent(pwPlot.createDummyPlot(pwRow2, pwColumn2));
        DataRange dataRange = new DataRange(null, TimeDatum.create("1998-01-01"), TimeDatum.create("1999-01-01"), false);
        pwCanvas2.addCanvasComponent(new TimeRangeLabel(dataRange, pwRow2, pwColumn2));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)pwCanvas2, "Center");
        jFrame.setContentPane(jPanel);
        jFrame.pack();
        jFrame.setVisible(true);
        pwCanvas2.repaint();
    }

    private static class Formatter
    extends DasFormatter {
        private boolean showSeconds = false;
        private boolean showMilli = false;

        private Formatter() {
        }

        private static int julday(int n, int n2, int n3) {
            int n4 = 367 * n3 - 7 * (n3 + (n + 9) / 12) / 4 - 3 * ((n3 + (n - 9) / 7) / 100 + 1) / 4 + 275 * n / 9 + n2 + 1721029;
            return n4;
        }

        public String format(Object object) {
            int n;
            double d;
            double d2;
            TimeDatum timeDatum = (TimeDatum)object;
            if (timeDatum.getUnits() == Units.mj1958) {
                d2 = timeDatum.getValue();
                d = d2 % 1.0 * 86400.0;
                n = (int)Math.floor(d2) + 2436205;
            } else if (timeDatum.getUnits() == Units.us2000) {
                d2 = timeDatum.getValue();
                d = pwMath.modp(d2, 8.64E10) / 1000000.0;
                n = (int)Math.floor(d2 / 8.64E10) + 2451545;
            } else {
                d2 = Units.getConverter(timeDatum.getUnits(), Units.us2000).convert(timeDatum.getValue());
                d = pwMath.modp(d2, 8.64E10) / 1000000.0;
                n = (int)Math.floor(d2 / 8.64E10) + 2451545;
            }
            int n2 = (int)(d + 0.5);
            int n3 = n2 / 3600;
            String string = (double)n3 < 10.0 ? "0" + n3 : "" + n3;
            int n4 = (n2 - n3 * 3600) / 60;
            String string2 = (double)n4 < 10.0 ? "0" + n4 : "" + n4;
            int n5 = n2 % 60;
            String string3 = (double)n5 < 10.0 ? "0" + n5 : "" + n5;
            int n6 = (int)(((double)(n - 1867216) - 0.25) / 36524.25);
            int n7 = n + 1 + n6 - n6 / 4;
            int n8 = n7 + 1524;
            int n9 = 6680 + (int)(((double)(n8 - 2439870) - 122.1) / 365.25);
            int n10 = 365 * n9 + n9 / 4;
            int n11 = (int)((double)(n8 - n10) / 30.6001);
            int n12 = n8 - n10 - (int)(30.6001 * (double)n11);
            int n13 = n11 - 1;
            n13 = (n13 - 1) % 12 + 1;
            int n14 = n9 - 4715;
            int n15 = (n14 -= n13 > 2 ? 1 : 0) <= 0 ? 1 : 0;
            DecimalFormat decimalFormat = new DecimalFormat();
            decimalFormat.setMinimumIntegerDigits(2);
            String string4 = (n14 -= n15) + "-" + decimalFormat.format(n13) + "-" + decimalFormat.format(n12);
            int n16 = Formatter.julday(1, 1, n14);
            DecimalFormat decimalFormat2 = new DecimalFormat();
            decimalFormat2.setMinimumIntegerDigits(3);
            string4 = string4 + " (" + decimalFormat2.format(n - n16 + 1) + ")";
            String string5 = string4 + " " + string + ":" + string2;
            this.showSeconds = (double)(n2 % 60) != 0.0;
            boolean bl = this.showMilli = d % 1.0 != 0.0;
            if (this.showSeconds) {
                if (this.showMilli) {
                    DecimalFormat decimalFormat3 = new DecimalFormat();
                    decimalFormat3.setMinimumFractionDigits(3);
                    decimalFormat3.setMinimumIntegerDigits(2);
                    string5 = string5 + ":" + decimalFormat3.format(n2 % 60);
                } else {
                    string5 = string5 + ":" + string3;
                }
            }
            return string5;
        }
    }

    private class mouseModule
    extends dasMouseModule {
        private mouseModule() {
        }
    }
}

