/*
 * Decompiled with CFR 0.152.
 */
package graph;

import das_proto.DasException;
import das_proto.data.DataSetDescriptor;
import das_proto.data.Units;
import das_proto.data.XMultiYDataSet;
import das_proto.data.XMultiYDataSetDescriptor;
import graph.Psym;
import graph.Renderer;
import graph.SymColor;
import graph.pwAxis;
import graph.pwPlot;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import util.DasExceptionHandler;
import xml.DasForm;

public class SymbolLineRenderer
extends Renderer {
    private Psym psym = Psym.LINES;
    private double symSize = 1.0;
    private float lineWidth = 1.0f;
    private SymColor color = SymColor.black;

    public SymbolLineRenderer(XMultiYDataSetDescriptor xMultiYDataSetDescriptor) {
        this((DataSetDescriptor)xMultiYDataSetDescriptor);
    }

    public SymbolLineRenderer(XMultiYDataSet xMultiYDataSet) {
        super(xMultiYDataSet);
    }

    protected SymbolLineRenderer(DataSetDescriptor dataSetDescriptor) {
        super(dataSetDescriptor);
    }

    protected SymbolLineRenderer(pwPlot pwPlot2, DataSetDescriptor dataSetDescriptor) {
        super(dataSetDescriptor);
        this.parent = pwPlot2;
    }

    public SymbolLineRenderer(pwPlot pwPlot2, XMultiYDataSetDescriptor xMultiYDataSetDescriptor) {
        this(xMultiYDataSetDescriptor);
        this.parent = pwPlot2;
    }

    public SymbolLineRenderer(pwPlot pwPlot2, XMultiYDataSet xMultiYDataSet) {
        this(xMultiYDataSet);
        this.parent = pwPlot2;
    }

    public void render(Graphics graphics, pwAxis pwAxis2, pwAxis pwAxis3) {
        XMultiYDataSet xMultiYDataSet = (XMultiYDataSet)this.getDataSet();
        if (xMultiYDataSet == null) {
            return;
        }
        double d = xMultiYDataSet.xSampleWidth;
        if (d == 0.0) {
            d = Double.POSITIVE_INFINITY;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (pwAxis2.getUnits() != xMultiYDataSet.getXUnits()) {
            throw new IllegalArgumentException("Data x units and xAxis units differ");
        }
        if (pwAxis3.getUnits() != xMultiYDataSet.getYUnits()) {
            throw new IllegalArgumentException("Data y units and yAxis units differ");
        }
        Units units = pwAxis2.getUnits();
        Units units2 = pwAxis3.getUnits();
        double d2 = pwAxis2.getDataMaximum(units);
        double d3 = pwAxis2.getDataMinimum(units);
        double d4 = pwAxis3.getDataMaximum(units2);
        double d5 = pwAxis3.getDataMinimum(units2);
        int n = 0;
        while (n < xMultiYDataSet.data.length - 1 && xMultiYDataSet.data[n].x < d3) {
            ++n;
        }
        if (n > xMultiYDataSet.data.length - 1) {
            --n;
        }
        int n2 = xMultiYDataSet.data.length - 1;
        while (n2 > 0 && xMultiYDataSet.data[n].x > d2) {
            --n2;
        }
        if (n2 < 0) {
            ++n2;
        }
        graphics2D.setColor(this.color.toColor());
        int n3 = 0;
        while (n3 < xMultiYDataSet.data[0].y.length) {
            int n4;
            int n5;
            if (this.psym.drawsLines()) {
                graphics2D.setStroke(new BasicStroke(this.lineWidth));
                n5 = (int)Math.floor(pwAxis2.transform(xMultiYDataSet.data[n].x, xMultiYDataSet.getXUnits()) + 0.5);
                n4 = (int)Math.floor(pwAxis3.transform(xMultiYDataSet.data[n].y[n3], xMultiYDataSet.getYUnits()) + 0.5);
                Line2D.Double double_ = new Line2D.Double();
                int n6 = n + 1;
                while (n6 <= n2) {
                    int n7 = (int)Math.floor(pwAxis2.transform(xMultiYDataSet.data[n6].x, xMultiYDataSet.getXUnits()) + 0.5);
                    int n8 = (int)Math.floor(pwAxis3.transform(xMultiYDataSet.data[n6].y[n3], xMultiYDataSet.getYUnits()) + 0.5);
                    if (xMultiYDataSet.data[n6].y[n3] != xMultiYDataSet.y_fill) {
                        if (xMultiYDataSet.data[n6].y[n3] != xMultiYDataSet.y_fill && xMultiYDataSet.data[n6 - 1].y[n3] != xMultiYDataSet.y_fill && Math.abs(xMultiYDataSet.data[n6].x - xMultiYDataSet.data[n6 - 1].x) < d) {
                            double_.setLine(n5, n4, n7, n8);
                            graphics2D.draw(double_);
                        }
                        n5 = n7;
                        n4 = n8;
                    }
                    ++n6;
                }
                graphics2D.setStroke(new BasicStroke(1.0f));
            }
            n5 = n;
            while (n5 <= n2) {
                if (xMultiYDataSet.data[n5].y[n3] != xMultiYDataSet.y_fill) {
                    n4 = (int)Math.floor(pwAxis2.transform(xMultiYDataSet.data[n5].x, xMultiYDataSet.getXUnits()) + 0.5);
                    int n9 = (int)Math.floor(pwAxis3.transform(xMultiYDataSet.data[n5].y[n3], xMultiYDataSet.getYUnits()) + 0.5);
                    this.psym.draw(graphics2D, n4, n9);
                }
                ++n5;
            }
            ++n3;
        }
    }

    public void updatePlotImage(pwAxis pwAxis2, pwAxis pwAxis3) {
    }

    public Psym getPsym() {
        return this.psym;
    }

    public void setPsym(Psym psym) {
        if (psym == null) {
            throw new NullPointerException("psym cannot be null");
        }
        Psym psym2 = this.psym;
        this.psym = psym;
        this.getParent().repaint();
    }

    public double getSymSize() {
        return this.symSize;
    }

    public void setSymSize(double d) {
        this.symSize = d;
        this.setPsym(this.psym);
    }

    public SymColor getColor() {
        return this.color;
    }

    public void setColor(SymColor symColor) {
        this.color = symColor;
        this.getParent().repaint();
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float f) {
        this.lineWidth = f;
        this.getParent().repaint();
    }

    protected void installRenderer() {
    }

    protected void uninstallRenderer() {
    }

    public static SymbolLineRenderer processLinePlotElement(Element element, pwPlot pwPlot2, DasForm dasForm) {
        String string = element.getAttribute("dataSetID");
        Psym psym = Psym.parsePsym(element.getAttribute("psym"));
        SymColor symColor = SymColor.parseSymColor(element.getAttribute("color"));
        SymbolLineRenderer symbolLineRenderer = new SymbolLineRenderer(pwPlot2, (XMultiYDataSet)null);
        float f = Float.parseFloat(element.getAttribute("lineWidth"));
        try {
            symbolLineRenderer.setDataSetID(string);
        }
        catch (DasException dasException) {
            DasExceptionHandler.handle(dasException);
        }
        symbolLineRenderer.setPsym(psym);
        symbolLineRenderer.setColor(symColor);
        symbolLineRenderer.setLineWidth(f);
        return symbolLineRenderer;
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("lineplot");
        element.setAttribute("dataSetID", this.getDataSetID());
        element.setAttribute("psym", this.getPsym().toString());
        element.setAttribute("color", this.getColor().toString());
        return element;
    }
}

