/*
 * Decompiled with CFR 0.152.
 */
package graph;

import components.HorizontalSpectrogramSlicer;
import components.VerticalSpectrogramAverager;
import components.VerticalSpectrogramSlicer;
import das.DasNameException;
import das_proto.DasException;
import das_proto.client.DataSetDescriptorNotAvailableException;
import das_proto.data.DataSetDescriptor;
import das_proto.data.XTaggedYScan;
import das_proto.data.XTaggedYScanDataSet;
import das_proto.data.XTaggedYScanDataSetConsumer;
import das_proto.data.XTaggedYScanDataSetDescriptor;
import das_proto.data.rebinDescriptor;
import event.DMMHorizontalDragRangeSelector;
import event.dasMouseInputAdapter_1;
import event.dasMouseModuleCrossHair;
import event.dasMouseModuleHorizontalSlicer;
import event.dasMouseModuleVerticalSlicer;
import graph.Renderer;
import graph.pwAxis;
import graph.pwColorBar;
import graph.pwColumn;
import graph.pwDevicePosition;
import graph.pwPlot;
import graph.pwRow;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import util.DasExceptionHandler;
import util.pwDie;
import xml.DasForm;
import xml.DasPropertyException;

public class SpectrogramRenderer
extends Renderer
implements XTaggedYScanDataSetConsumer {
    private pwColorBar colorBar;
    Image plotImage;
    RebinListener rebinListener = new RebinListener();
    static /* synthetic */ Class class$graph$pwColorBar;

    protected SpectrogramRenderer(DataSetDescriptor dataSetDescriptor, pwColorBar pwColorBar2) {
        super(dataSetDescriptor);
        this.colorBar = pwColorBar2;
        if (this.colorBar != null) {
            pwColorBar2.addPropertyChangeListener("dataMinimum", this.rebinListener);
            pwColorBar2.addPropertyChangeListener("dataMaximum", this.rebinListener);
            pwColorBar2.addPropertyChangeListener("log", this.rebinListener);
            pwColorBar2.addPropertyChangeListener("type", this.rebinListener);
        }
    }

    public SpectrogramRenderer(XTaggedYScanDataSetDescriptor xTaggedYScanDataSetDescriptor, pwColorBar pwColorBar2) {
        this((DataSetDescriptor)xTaggedYScanDataSetDescriptor, pwColorBar2);
    }

    public SpectrogramRenderer(pwPlot pwPlot2, XTaggedYScanDataSetDescriptor xTaggedYScanDataSetDescriptor, pwColorBar pwColorBar2) {
        this((DataSetDescriptor)xTaggedYScanDataSetDescriptor, pwColorBar2);
        this.parent = pwPlot2;
    }

    protected SpectrogramRenderer(pwPlot pwPlot2, DataSetDescriptor dataSetDescriptor, pwColorBar pwColorBar2) {
        this(dataSetDescriptor, pwColorBar2);
        this.parent = pwPlot2;
    }

    public pwAxis getZAxis() {
        return this.colorBar;
    }

    public pwColorBar getColorBar() {
        return this.colorBar;
    }

    public void setColorBar(pwColorBar pwColorBar2) {
        if (this.colorBar == pwColorBar2) {
            return;
        }
        if (this.colorBar != null) {
            this.colorBar.removePropertyChangeListener("dataMinimum", this.rebinListener);
            this.colorBar.removePropertyChangeListener("dataMaximum", this.rebinListener);
            this.colorBar.removePropertyChangeListener("log", this.rebinListener);
            this.colorBar.removePropertyChangeListener("type", this.rebinListener);
            if (this.parent != null && this.parent.getCanvas() != null) {
                this.parent.getCanvas().remove(this.colorBar);
            }
        }
        this.colorBar = pwColorBar2;
        if (this.colorBar != null) {
            this.colorBar.addPropertyChangeListener("dataMinimum", this.rebinListener);
            this.colorBar.addPropertyChangeListener("dataMaximum", this.rebinListener);
            this.colorBar.addPropertyChangeListener("log", this.rebinListener);
            this.colorBar.addPropertyChangeListener("type", this.rebinListener);
            if (this.parent != null && this.parent.getCanvas() != null) {
                this.parent.getCanvas().add(this.colorBar);
            }
        }
    }

    public void render(Graphics graphics, pwAxis pwAxis2, pwAxis pwAxis3) {
        if (this.plotImage != null) {
            double d = pwAxis2.getColumn().getDMinimum();
            double d2 = pwAxis3.getRow().getDMinimum();
            graphics.drawImage(this.plotImage, (int)d, (int)d2, this.getParent());
        }
        if (this.getDataSet() == null && this.lastException != null) {
            this.renderException(graphics, pwAxis2, pwAxis3, this.lastException);
        }
    }

    public void updatePlotImage(pwAxis pwAxis2, pwAxis pwAxis3) {
        Object object;
        XTaggedYScanDataSet xTaggedYScanDataSet;
        int n = (int)Math.floor(pwAxis2.getColumn().getDMaximum() + 0.5) - (int)Math.floor(pwAxis2.getColumn().getDMinimum() + 0.5);
        int n2 = (int)Math.floor(pwAxis3.getRow().getDMaximum() + 0.5) - (int)Math.floor(pwAxis3.getRow().getDMinimum() + 0.5);
        if (this.getParent() == null || n <= 1 || n2 <= 1) {
            pwDie.println("canvas not useable!!!");
            return;
        }
        int[] nArray = new int[n * n2];
        Arrays.fill(nArray, 0);
        if (this.getDataSet() == null) {
            xTaggedYScanDataSet = XTaggedYScanDataSet.create(new double[0], new double[0], new float[0][0]);
        } else {
            object = new rebinDescriptor(pwAxis2.getDataMinimum(), pwAxis2.getDataMaximum(), n, pwAxis2.isLog());
            rebinDescriptor rebinDescriptor2 = new rebinDescriptor(pwAxis3.getDataMinimum(), pwAxis3.getDataMaximum(), n2, pwAxis3.isLog());
            xTaggedYScanDataSet = ((XTaggedYScanDataSet)this.getDataSet()).rebin((rebinDescriptor)object, rebinDescriptor2);
        }
        object = this.getDataSet();
        int n3 = 0;
        XTaggedYScan[] xTaggedYScanArray = xTaggedYScanDataSet.getWeights();
        int n4 = xTaggedYScanDataSet.y_coordinate.length - 1;
        while (n4 >= 0) {
            int n5 = 0;
            while (n5 < xTaggedYScanDataSet.data.length) {
                if ((double)xTaggedYScanArray[n5].z[n4] > 0.0) {
                    nArray[n3] = this.colorBar.itransform(xTaggedYScanDataSet.data[n5].z[n4], xTaggedYScanDataSet.getZUnits());
                }
                ++n3;
                ++n5;
            }
            --n4;
        }
        MemoryImageSource memoryImageSource = new MemoryImageSource(n, n2, nArray, 0, n);
        this.plotImage = this.getParent().createImage(memoryImageSource);
        this.getParent().repaint();
    }

    public void setDataSetID(String string) throws DasException {
        if (string == null) {
            throw new NullPointerException("Null dataPath not allowed");
        }
        if (string.equals("")) {
            this.setDataSetDescriptor(null);
            return;
        }
        DataSetDescriptor dataSetDescriptor = DataSetDescriptor.create(string);
        if (!(dataSetDescriptor instanceof XTaggedYScanDataSetDescriptor)) {
            throw new DataSetDescriptorNotAvailableException(string + " does not refer to an x-tagged-y-scan data set");
        }
        this.setDataSetDescriptor(dataSetDescriptor);
    }

    protected void installRenderer() {
        if (this.parent != null && this.parent.getCanvas() != null && this.colorBar != null) {
            Object object;
            if (this.colorBar.getRow() == null || this.colorBar.getColumn() == null) {
                this.colorBar.setRow(this.parent.getRow());
                object = this.parent.getColumn();
                double d = ((pwDevicePosition)object).getMaximum() - ((pwDevicePosition)object).getMinimum();
                double d2 = ((pwDevicePosition)object).getMaximum() + d / 5.0;
                double d3 = d2 + d / 10.0;
                if (d3 > 1.0 - d / 5.0) {
                    double d4 = (1.0 - ((pwDevicePosition)object).getMaximum()) / 3.0;
                    d2 = ((pwDevicePosition)object).getMaximum() + d4 / 2.0;
                    d3 = d2 + d4;
                }
                this.colorBar.setColumn(new pwColumn(this.parent.getCanvas(), d2, d3));
            }
            this.parent.getCanvas().add(this.colorBar);
            if (!"true".equals(System.getProperty("java.awt.headless"))) {
                object = this.parent.mouseAdapter;
                VerticalSpectrogramSlicer verticalSpectrogramSlicer = VerticalSpectrogramSlicer.createPopupSlicer(this.parent, this, 640, 480);
                dasMouseModuleVerticalSlicer dasMouseModuleVerticalSlicer2 = dasMouseModuleVerticalSlicer.create(this);
                dasMouseModuleVerticalSlicer2.addDataPointSelectionListener(verticalSpectrogramSlicer);
                ((dasMouseInputAdapter_1)object).addMouseModule(dasMouseModuleVerticalSlicer2);
                HorizontalSpectrogramSlicer horizontalSpectrogramSlicer = HorizontalSpectrogramSlicer.createPopupSlicer(this.parent, this, 640, 480);
                dasMouseModuleHorizontalSlicer dasMouseModuleHorizontalSlicer2 = dasMouseModuleHorizontalSlicer.create(this);
                dasMouseModuleHorizontalSlicer2.addDataPointSelectionListener(horizontalSpectrogramSlicer);
                ((dasMouseInputAdapter_1)object).addMouseModule(dasMouseModuleHorizontalSlicer2);
                VerticalSpectrogramAverager verticalSpectrogramAverager = VerticalSpectrogramAverager.createPopupAverager(this.parent, this, 640, 480);
                DMMHorizontalDragRangeSelector dMMHorizontalDragRangeSelector = new DMMHorizontalDragRangeSelector(this.parent, this, this.parent.getXAxis());
                dMMHorizontalDragRangeSelector.setLabel("Vertical Averager");
                dMMHorizontalDragRangeSelector.addDataRangeSelectionListener(verticalSpectrogramAverager);
                ((dasMouseInputAdapter_1)object).addMouseModule(dMMHorizontalDragRangeSelector);
                dasMouseModuleCrossHair dasMouseModuleCrossHair2 = new dasMouseModuleCrossHair(this.parent, this, this.parent.getXAxis(), this.parent.getYAxis());
                ((dasMouseInputAdapter_1)object).addMouseModule(dasMouseModuleCrossHair2);
            }
        }
    }

    protected void uninstallRenderer() {
        if (this.colorBar != null && this.colorBar.getCanvas() != null) {
            this.colorBar.getCanvas().remove(this.colorBar);
        }
    }

    public static SpectrogramRenderer processSpectrogramElement(Element element, pwPlot pwPlot2, DasForm dasForm) throws DasPropertyException, DasNameException {
        Object object;
        String string = element.getAttribute("dataSetID");
        pwColorBar pwColorBar2 = null;
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            object = nodeList.item(n);
            if (object instanceof Element && object.getNodeName().equals("zAxis")) {
                pwColorBar2 = SpectrogramRenderer.processZAxisElement((Element)object, pwPlot2.getRow(), pwPlot2.getColumn(), dasForm);
            }
            ++n;
        }
        if (pwColorBar2 == null) {
            try {
                pwColorBar2 = (pwColorBar)dasForm.checkValue(element.getAttribute("colorbar"), class$graph$pwColorBar == null ? (class$graph$pwColorBar = SpectrogramRenderer.class$("graph.pwColorBar")) : class$graph$pwColorBar, "<colorbar>");
            }
            catch (DasPropertyException dasPropertyException) {
                dasPropertyException.setPropertyName("colorbar");
                throw dasPropertyException;
            }
        }
        object = new SpectrogramRenderer(pwPlot2, null, pwColorBar2);
        try {
            ((SpectrogramRenderer)object).setDataSetID(string);
        }
        catch (DasException dasException) {
            DasExceptionHandler.handle(dasException);
        }
        return object;
    }

    private static pwColorBar processZAxisElement(Element element, pwRow pwRow2, pwColumn pwColumn2, DasForm dasForm) throws DasPropertyException, DasNameException {
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof Element && node.getNodeName().equals("colorbar")) {
                return pwColorBar.processColorbarElement((Element)node, pwRow2, pwColumn2, dasForm);
            }
            ++n;
        }
        return null;
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("spectrogram");
        element.setAttribute("dataSetID", this.getDataSetID());
        Element element2 = document.createElement("zAxis");
        Element element3 = this.getColorBar().getDOMElement(document);
        if (element3.getAttribute("row").equals(this.getParent().getRow().getDasName())) {
            element3.removeAttribute("row");
        }
        if (element3.getAttribute("column").equals(this.getParent().getColumn().getDasName())) {
            element3.removeAttribute("column");
        }
        element2.appendChild(element3);
        element.appendChild(element2);
        return element;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class RebinListener
    implements PropertyChangeListener {
        protected RebinListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            SpectrogramRenderer.this.update(SpectrogramRenderer.this.getParent().getXAxis(), SpectrogramRenderer.this.getParent().getYAxis());
        }
    }
}

