/*
 * Decompiled with CFR 0.152.
 */
package graph;

import components.DasProgressPanel;
import components.PropertyEditor;
import das_proto.DasException;
import das_proto.data.ConstantDataSetDescriptor;
import das_proto.data.DataRequestThread;
import das_proto.data.DataRequestor;
import das_proto.data.DataSet;
import das_proto.data.DataSetConsumer;
import das_proto.data.DataSetDescriptor;
import das_proto.data.Datum;
import das_proto.data.NoDataInIntervalException;
import das_proto.data.Units;
import das_proto.data.dasReaderException;
import graph.pwAxis;
import graph.pwCanvas;
import graph.pwPlot;
import graph.pwTimeAxis;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.io.InterruptedIOException;
import javax.swing.JEditorPane;
import util.DasExceptionHandler;
import util.pwDie;

public abstract class Renderer
implements DataSetConsumer,
PropertyEditor.Editable {
    private DataSetDescriptor dsd;
    private DataSet ds;
    pwPlot parent;
    private DasProgressPanel progressPanel;
    private DataRequestThread drt;
    protected Exception lastException;

    protected Renderer(DataSetDescriptor dataSetDescriptor) {
        this.dsd = dataSetDescriptor;
    }

    protected Renderer(DataSet dataSet) {
        this(dataSet == null ? (DataSetDescriptor)null : new ConstantDataSetDescriptor(dataSet));
    }

    protected Renderer(pwPlot pwPlot2, DataSetDescriptor dataSetDescriptor) {
        this(dataSetDescriptor);
        this.parent = pwPlot2;
    }

    protected Renderer(pwPlot pwPlot2, DataSet dataSet) {
        this(dataSet == null ? (DataSetDescriptor)null : new ConstantDataSetDescriptor(dataSet));
        this.parent = pwPlot2;
    }

    public pwPlot getParent() {
        return this.parent;
    }

    public DataSet getDataSet() {
        return this.ds;
    }

    public void setDataSet(DataSet dataSet) {
        this.setDataSetDescriptor(new ConstantDataSetDescriptor(dataSet));
    }

    public void setDataSetID(String string) throws DasException {
        if (string == null) {
            throw new NullPointerException("Null dataPath not allowed");
        }
        if (string.equals("")) {
            this.setDataSetDescriptor(null);
            return;
        }
        DataSetDescriptor dataSetDescriptor = DataSetDescriptor.create(string);
        this.setDataSetDescriptor(dataSetDescriptor);
    }

    public String getDataSetID() {
        if (this.dsd == null) {
            return "";
        }
        return this.dsd.getDataSetID();
    }

    public abstract void render(Graphics var1, pwAxis var2, pwAxis var3);

    public void renderException(Graphics graphics, pwAxis pwAxis2, pwAxis pwAxis3, Exception exception) {
        int n = (int)pwAxis2.getColumn().getDMiddle();
        int n2 = (int)pwAxis3.getRow().getDMiddle();
        String string = exception.toString();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (exception instanceof NoDataInIntervalException) {
            string = "no data in interval";
        }
        int n3 = fontMetrics.stringWidth(string);
        Color color = graphics.getColor();
        graphics.setColor(Color.lightGray);
        graphics.drawString(string, n - n3 / 2, n2);
        graphics.setColor(color);
    }

    protected void loadDataSet(final pwAxis pwAxis2, final pwAxis pwAxis3) {
        if (this.parent == null || !this.parent.isDisplayable() || this.dsd == null) {
            return;
        }
        if (pwAxis2 instanceof pwTimeAxis) {
            this.lastException = null;
            final pwPlot pwPlot2 = this.getParent();
            final Cursor cursor = null;
            if (pwPlot2 != null) {
                pwPlot2.getCursor();
                pwPlot2.setCursor(new Cursor(3));
            }
            if (pwPlot2 != null) {
                ((pwCanvas)pwPlot2.getParent()).lockDisplay(this);
            }
            Datum datum = pwAxis2.getDataMaximum().subtract(pwAxis2.getDataMinimum());
            double d = datum.convertTo(Units.seconds).doubleValue();
            double d2 = Math.floor(pwAxis2.getColumn().getDMaximum() + 0.5) - Math.floor(pwAxis2.getColumn().getDMinimum() + 0.5);
            double d3 = d / d2;
            pwTimeAxis pwTimeAxis2 = (pwTimeAxis)pwAxis2;
            if (this.progressPanel == null) {
                this.progressPanel = new DasProgressPanel();
                ((Container)((pwCanvas)pwPlot2.getParent()).getGlassPane()).add(this.progressPanel);
            }
            this.progressPanel.setSize(this.progressPanel.getPreferredSize());
            int n = (int)pwAxis2.getColumn().getDMiddle();
            int n2 = (int)pwAxis2.getRow().getDMiddle();
            this.progressPanel.setLocation(n - this.progressPanel.getWidth() / 2, n2 - this.progressPanel.getHeight() / 2);
            this.dsd.addDasReaderListener(this.progressPanel);
            DataRequestor dataRequestor = new DataRequestor(){

                public void currentByteCount(int n) {
                }

                public void totalByteCount(int n) {
                }

                public void exception(Exception exception) {
                    if (!(exception instanceof InterruptedIOException)) {
                        if (exception instanceof dasReaderException || exception instanceof DasException) {
                            Renderer.this.lastException = exception;
                            this.finished(null);
                        } else {
                            Object[] objectArray = new Object[]{"Error reading data set", new JEditorPane("text/html", exception.getMessage())};
                            ((JEditorPane)objectArray[1]).setEditable(false);
                            DasExceptionHandler.handle(exception);
                            this.finished(null);
                        }
                    }
                }

                public void finished(DataSet dataSet) {
                    if (Renderer.this.dsd != null) {
                        Renderer.this.dsd.removeDasReaderListener(Renderer.this.progressPanel);
                    }
                    Renderer.this.progressPanel.setVisible(false);
                    if (pwPlot2 != null) {
                        pwPlot2.setCursor(cursor);
                    }
                    Renderer.this.ds = dataSet;
                    Renderer.this.updatePlotImage(pwAxis2, pwAxis3);
                    if (pwPlot2 != null) {
                        ((pwCanvas)pwPlot2.getParent()).freeDisplay(this);
                    }
                    pwDie.println("I GOT HERE WITH: " + Renderer.this.ds);
                }
            };
            if (this.drt == null) {
                this.drt = new DataRequestThread();
            }
            try {
                this.drt.request(this.dsd, "", pwTimeAxis2.getTimeMinimum(), pwTimeAxis2.getTimeMaximum(), d3, dataRequestor);
            }
            catch (InterruptedException interruptedException) {
                DasExceptionHandler.handle(interruptedException);
            }
        } else if (this.dsd instanceof ConstantDataSetDescriptor) {
            try {
                this.ds = this.dsd.getDataSet(null, null, null);
                this.updatePlotImage(pwAxis2, pwAxis3);
            }
            catch (DasException dasException) {
                DasExceptionHandler.handle(dasException);
            }
        } else {
            throw new AssertionError((Object)"xAxis not a timeAxis, and DataSetDescriptor is not constant");
        }
    }

    public abstract void updatePlotImage(pwAxis var1, pwAxis var2);

    public void update(pwAxis pwAxis2, pwAxis pwAxis3) {
        pwDie.println("in Render.update()");
        this.loadDataSet(pwAxis2, pwAxis3);
    }

    void setDataSetDescriptor(DataSetDescriptor dataSetDescriptor) {
        this.dsd = dataSetDescriptor;
        if (this.parent != null) {
            this.parent.markDirty();
            this.parent.update();
        }
    }

    protected abstract void installRenderer();

    protected abstract void uninstallRenderer();
}

