/*
 * Decompiled with CFR 0.152.
 */
package graph;

import components.PropertyEditor;
import java.awt.Graphics;
import javax.swing.Icon;

public class Psym
implements PropertyEditor.Enumeration {
    private static final String[] NAMES = new String[]{"lines", "dots", "circles", "triangles", "cross"};
    private static final boolean[] DRAWS_LINES = new boolean[]{true, false, false, false, false};
    public static final Psym LINES = new Psym(0);
    public static final Psym DOTS = new Psym(1);
    public static final Psym CIRCLES = new Psym(2);
    public static final Psym TRIANGLES = new Psym(3);
    public static final Psym CROSS = new Psym(4);
    private int nameIndex;

    private Psym(int n) {
        this.nameIndex = n;
    }

    public String toString() {
        return NAMES[this.nameIndex];
    }

    public Icon getListIcon() {
        return null;
    }

    public boolean drawsLines() {
        return DRAWS_LINES[this.nameIndex];
    }

    public void draw(Graphics graphics, int n, int n2) {
        switch (this.nameIndex) {
            case 0: {
                break;
            }
            case 1: {
                graphics.drawLine(n, n2, n, n2);
                break;
            }
            case 2: {
                graphics.drawOval(n - 4, n2 - 4, 8, 8);
                break;
            }
            case 3: {
                this.drawTriangle(graphics, n, n2);
                break;
            }
            case 4: {
                graphics.drawLine(n - 1, n2, n + 1, n2);
                graphics.drawLine(n, n2 - 1, n, n2 + 1);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid nameIndex for psym");
            }
        }
    }

    public void drawTriangle(Graphics graphics, int n, int n2) {
        graphics.drawLine(n, n2 - 2, n + 2, n2 + 2);
        graphics.drawLine(n + 2, n2 + 2, n - 2, n2 + 2);
        graphics.drawLine(n - 2, n2 + 2, n, n2 - 2);
    }

    public static Psym parsePsym(String string) {
        if (string.equals("lines")) {
            return LINES;
        }
        if (string.equals("dots")) {
            return DOTS;
        }
        if (string.equals("circles")) {
            return CIRCLES;
        }
        if (string.equals("triangles")) {
            return TRIANGLES;
        }
        if (string.equals("cross")) {
            return CROSS;
        }
        throw new IllegalArgumentException(string);
    }
}

