/*
 * Decompiled with CFR 0.152.
 */
package graph;

import das_proto.data.Datum;
import das_proto.data.Units;
import graph.event.pwUpdateEvent;
import graph.event.pwUpdateListener;
import graph.pwAxis;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Stack;
import javax.swing.event.EventListenerList;
import util.pwDie;

public class DataRange
implements Cloneable {
    private pwAxis parent;
    private Units units;
    private double minimum;
    private double maximum;
    private boolean log;
    private EventListenerList listenerList = new EventListenerList();
    private Stack history;
    private Stack forwardHistory;
    private PropertyChangeSupport propertyChangeDelegate;
    static /* synthetic */ Class class$graph$event$pwUpdateListener;

    public DataRange(pwAxis pwAxis2, Datum datum, Datum datum2, boolean bl) {
        if (datum.gt(datum2)) {
            throw new IllegalArgumentException("data min on axis is greater than data max");
        }
        if (!datum.isValid()) {
            throw new IllegalArgumentException("data_minimum on axis is NaN");
        }
        if (!datum2.isValid()) {
            throw new IllegalArgumentException("data_maximum on axis is NaN");
        }
        if (datum.getUnits() != datum2.getUnits()) {
            throw new IllegalArgumentException("units don't match on range");
        }
        this.parent = pwAxis2;
        this.units = datum.getUnits();
        this.minimum = datum.getValue();
        this.maximum = datum2.getValue();
        this.log = bl;
        this.history = new Stack();
        this.forwardHistory = new Stack();
        this.propertyChangeDelegate = new PropertyChangeSupport(this);
    }

    public boolean isLog() {
        return this.log;
    }

    public void setLog(boolean bl) {
        if (this.log == bl) {
            return;
        }
        boolean bl2 = this.log;
        if (bl && (this.minimum <= 0.0 || this.maximum <= 0.0)) {
            return;
        }
        this.log = bl;
        this.firePropertyChange("log", bl2, bl);
        this.fireUpdate();
    }

    public pwAxis getCreator() {
        return this.parent;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public double getMaximum() {
        return this.maximum;
    }

    public Units getUnits() {
        return this.units;
    }

    public void setMinimum(double d) {
        if (d > this.maximum) {
            if (this.isLog()) {
                this.setRange(d, d * 10.0);
            } else {
                this.setRange(d, d + 1.0);
            }
        } else {
            this.setRange(d, this.maximum);
        }
    }

    public void setMaximum(double d) {
        if (d < this.minimum) {
            if (this.isLog()) {
                this.setRange(d / 10.0, d);
            } else {
                this.setRange(d - 1.0, d);
            }
        } else {
            this.setRange(this.minimum, d);
        }
    }

    public void setRange(double d, double d2) {
        if (d > d2) {
            pwDie.println("min>max in pwAxis.DataRange.setRange");
            d2 = this.isLog() ? d * 10.0 : d + 1.0;
        }
        if (this.isLog()) {
            if (d < 0.0) {
                d = this.minimum;
            }
            if (d2 < 0.0) {
                d2 = this.maximum;
            }
        }
        double d3 = this.minimum;
        double d4 = this.maximum;
        Datum[] datumArray = new Datum[2];
        if (this.minimum != this.maximum) {
            datumArray[0] = new Datum(this.minimum, this.units);
            datumArray[1] = new Datum(this.maximum, this.units);
            this.history.push(datumArray);
        }
        this.forwardHistory.removeAllElements();
        this.minimum = d;
        this.maximum = d2;
        this.fireUpdate();
        if (this.minimum != d3) {
            this.firePropertyChange("minimum", d3, this.minimum);
        }
        if (this.maximum != d4) {
            this.firePropertyChange("maximum", d4, this.maximum);
        }
    }

    public void setRangePrev() {
        double d = this.minimum;
        double d2 = this.maximum;
        pwDie.println("history: " + this.history.size());
        pwDie.println("forwardHistory: " + this.forwardHistory.size());
        if (!this.history.isEmpty()) {
            this.forwardHistory.push(new Datum[]{new Datum(this.minimum, this.units), new Datum(this.maximum, this.units)});
            Datum[] datumArray = (Datum[])this.history.pop();
            if (datumArray[0].getUnits() != this.units) {
                datumArray[0] = datumArray[0].convertTo(this.units);
                datumArray[1] = datumArray[1].convertTo(this.units);
            }
            this.minimum = datumArray[0].getValue();
            this.maximum = datumArray[1].getValue();
            this.fireUpdate();
        }
        if (this.minimum != d) {
            this.firePropertyChange("minimum", d, this.minimum);
        }
        if (this.maximum != d2) {
            this.firePropertyChange("maximum", d2, this.maximum);
        }
        pwDie.println("history: " + this.history.size());
        pwDie.println("forwardHistory: " + this.forwardHistory.size());
        pwDie.println("-------------");
    }

    public void setRangeForward() {
        double d = this.minimum;
        double d2 = this.maximum;
        pwDie.println("history: " + this.history.size());
        pwDie.println("forwardHistory: " + this.forwardHistory.size());
        if (!this.forwardHistory.isEmpty()) {
            this.history.push(new Datum[]{new Datum(this.minimum, this.units), new Datum(this.maximum, this.units)});
            Datum[] datumArray = (Datum[])this.forwardHistory.pop();
            if (datumArray[0].getUnits() != this.units) {
                datumArray[0] = datumArray[0].convertTo(this.units);
                datumArray[1] = datumArray[1].convertTo(this.units);
            }
            this.minimum = datumArray[0].getValue();
            this.maximum = datumArray[1].getValue();
            this.fireUpdate();
        }
        pwDie.println("history: " + this.history.size());
        pwDie.println("forwardHistory: " + this.forwardHistory.size());
        if (this.minimum != d) {
            this.firePropertyChange("minimum", d, this.minimum);
        }
        if (this.maximum != d2) {
            this.firePropertyChange("maximum", d2, this.maximum);
        }
        pwDie.println("history: " + this.history.size());
        pwDie.println("forwardHistory: " + this.forwardHistory.size());
        pwDie.println("-------------");
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeDelegate.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeDelegate.addPropertyChangeListener(string, propertyChangeListener);
    }

    protected void firePropertyChange(String string, double d, double d2) {
        this.firePropertyChange(string, new Double(d), new Double(d2));
    }

    protected void firePropertyChange(String string, boolean bl, boolean bl2) {
        this.firePropertyChange(string, bl ? Boolean.TRUE : Boolean.FALSE, bl2 ? Boolean.TRUE : Boolean.FALSE);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.propertyChangeDelegate.firePropertyChange(string, object, object2);
    }

    public void addpwUpdateListener(pwUpdateListener pwUpdateListener2) {
        this.listenerList.add(class$graph$event$pwUpdateListener == null ? (class$graph$event$pwUpdateListener = DataRange.class$("graph.event.pwUpdateListener")) : class$graph$event$pwUpdateListener, pwUpdateListener2);
    }

    public void removepwUpdateListener(pwUpdateListener pwUpdateListener2) {
        this.listenerList.remove(class$graph$event$pwUpdateListener == null ? (class$graph$event$pwUpdateListener = DataRange.class$("graph.event.pwUpdateListener")) : class$graph$event$pwUpdateListener, pwUpdateListener2);
    }

    protected void fireUpdate() {
        Object[] objectArray = this.listenerList.getListenerList();
        pwUpdateEvent pwUpdateEvent2 = new pwUpdateEvent(this);
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$graph$event$pwUpdateListener == null ? DataRange.class$("graph.event.pwUpdateListener") : class$graph$event$pwUpdateListener)) {
                ((pwUpdateListener)objectArray[n + 1]).update(pwUpdateEvent2);
            }
            n -= 2;
        }
    }

    public void popHistory() {
        if (!this.history.empty()) {
            this.history.pop();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        DataRange dataRange = (DataRange)super.clone();
        dataRange.history = (Stack)this.history.clone();
        dataRange.forwardHistory = (Stack)this.forwardHistory.clone();
        return dataRange;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

