/*
 * Decompiled with CFR 0.152.
 */
package event;

import das_proto.data.Datum;
import event.DataRangeSelectionEvent;
import event.DataRangeSelectionListener;
import event.Gesture;
import event.HorizontalRangeGesturesRenderer;
import event.MouseDragEvent;
import event.MouseRangeGestureSelectionEvent;
import event.MouseRangeSelectionEvent;
import event.dasMouseModule;
import graph.pwAxis;
import graph.pwCanvasComponent;
import graph.pwPlot;
import graph.pwSpectrogramPlot;
import java.awt.Shape;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import util.pwDie;

public class dasMouseModuleHorizontalRangeSelector
extends dasMouseModule {
    pwAxis axis;
    private Hashtable hotSpotsMap;
    private EventListenerList listenerList = null;
    static /* synthetic */ Class class$event$DataRangeSelectionListener;

    public dasMouseModuleHorizontalRangeSelector(pwCanvasComponent pwCanvasComponent2, pwAxis pwAxis2) {
        if (!pwAxis2.isHorizontal()) {
            throw new IllegalArgumentException("Axis orientation is not horizontal");
        }
        this.parent = pwCanvasComponent2;
        this.dragRenderer = new HorizontalRangeGesturesRenderer(pwCanvasComponent2);
        this.axis = pwAxis2;
        this.setLabel("Zoom X");
        this.hotSpotsMap = new Hashtable();
    }

    public Vector getHotSpots() {
        return null;
    }

    public void hotSpotPressed(Shape shape) {
        MouseRangeGestureSelectionEvent mouseRangeGestureSelectionEvent = (MouseRangeGestureSelectionEvent)this.hotSpotsMap.get(shape);
        this.mouseRangeSelected(mouseRangeGestureSelectionEvent);
    }

    public static dasMouseModuleHorizontalRangeSelector create(pwPlot pwPlot2) {
        pwAxis pwAxis2 = pwPlot2.getXAxis();
        dasMouseModuleHorizontalRangeSelector dasMouseModuleHorizontalRangeSelector2 = new dasMouseModuleHorizontalRangeSelector(pwPlot2, pwPlot2.getXAxis());
        return dasMouseModuleHorizontalRangeSelector2;
    }

    public void mouseRangeSelected(MouseDragEvent mouseDragEvent) {
        MouseRangeSelectionEvent mouseRangeSelectionEvent = (MouseRangeSelectionEvent)mouseDragEvent;
        pwDie.println("" + this.getHotSpots());
        MouseRangeGestureSelectionEvent mouseRangeGestureSelectionEvent = (MouseRangeGestureSelectionEvent)mouseRangeSelectionEvent;
        if (!mouseRangeGestureSelectionEvent.isGesture()) {
            Datum datum;
            Datum datum2 = this.axis.invTransform(mouseRangeSelectionEvent.getMinimum());
            Datum datum3 = this.axis.invTransform(mouseRangeSelectionEvent.getMaximum());
            Datum datum4 = this.axis.findTick(datum2, 0.0, true);
            if (datum4.equals(datum = this.axis.findTick(datum3, 0.0, true))) {
                datum2 = this.axis.findTick(datum2, -1.0, true);
                datum3 = this.axis.findTick(datum3, 1.0, true);
            } else {
                datum2 = datum4;
                datum3 = datum;
            }
            DataRangeSelectionEvent dataRangeSelectionEvent = new DataRangeSelectionEvent(this.parent, datum2, datum3);
            this.fireDataRangeSelectionListenerDataRangeSelected(dataRangeSelectionEvent);
        } else if (mouseRangeGestureSelectionEvent.isBack()) {
            this.axis.setDataRangePrev();
        } else if (mouseRangeGestureSelectionEvent.isZoomOut()) {
            this.axis.setDataRangeZoomOut();
        } else if (mouseRangeGestureSelectionEvent.isForward()) {
            this.axis.setDataRangeForward();
        } else if (mouseRangeGestureSelectionEvent.getGesture() == Gesture.SCANPREV) {
            this.axis.scanPrevious();
        } else if (mouseRangeGestureSelectionEvent.getGesture() == Gesture.SCANNEXT) {
            this.axis.scanNext();
        }
    }

    public synchronized void addDataRangeSelectionListener(DataRangeSelectionListener dataRangeSelectionListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(class$event$DataRangeSelectionListener == null ? (class$event$DataRangeSelectionListener = dasMouseModuleHorizontalRangeSelector.class$("event.DataRangeSelectionListener")) : class$event$DataRangeSelectionListener, dataRangeSelectionListener);
    }

    public synchronized void removeDataRangeSelectionListener(DataRangeSelectionListener dataRangeSelectionListener) {
        this.listenerList.remove(class$event$DataRangeSelectionListener == null ? (class$event$DataRangeSelectionListener = dasMouseModuleHorizontalRangeSelector.class$("event.DataRangeSelectionListener")) : class$event$DataRangeSelectionListener, dataRangeSelectionListener);
    }

    private void fireDataRangeSelectionListenerDataRangeSelected(DataRangeSelectionEvent dataRangeSelectionEvent) {
        if (this.parent instanceof pwSpectrogramPlot) {
            dataRangeSelectionEvent.setDataSet(((pwSpectrogramPlot)this.parent).getData());
        }
        if (this.listenerList == null) {
            return;
        }
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$event$DataRangeSelectionListener == null ? dasMouseModuleHorizontalRangeSelector.class$("event.DataRangeSelectionListener") : class$event$DataRangeSelectionListener)) {
                ((DataRangeSelectionListener)objectArray[n + 1]).DataRangeSelected(dataRangeSelectionEvent);
            }
            n -= 2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

