/*
 * Decompiled with CFR 0.152.
 */
package event;

import components.PropertyEditor;
import event.BoxRenderer;
import event.DragRenderer;
import event.MouseDragEvent;
import event.MousePointSelectionEvent;
import event.dasMouseModule;
import graph.pwAxis;
import graph.pwCanvas;
import graph.pwCanvasComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import util.DasExceptionHandler;
import util.pwDie;

public class dasMouseInputAdapter_1
extends MouseInputAdapter {
    private dasMouseModule primary = null;
    private dasMouseModule secondary = null;
    private dasMouseModule tertiary = null;
    private Vector active = null;
    private Vector modules;
    private HashMap primaryActionButtonMap;
    private HashMap secondaryActionButtonMap;
    protected JPopupMenu primaryPopup;
    protected JPopupMenu secondaryPopup;
    private Point primaryPopupLocation;
    private Point secondaryPopupLocation;
    private JPanel pngFileNamePanel;
    private JTextField pngFileTextField;
    private JFileChooser pngFileChooser;
    JCheckBoxMenuItem primarySelectedItem;
    JCheckBoxMenuItem secondarySelectedItem;
    int numInserted;
    protected ActionListener popupListener;
    protected pwCanvasComponent parent = null;
    private Point selectionStart;
    private Point selectionEnd;
    private Point dSelectionStart;
    private Point dSelectionEnd;
    private Graphics2D g;
    private MousePointSelectionEvent mousePointSelection;
    private int xOffset;
    private int yOffset;
    private int button = 0;
    private MouseMode mouseMode = MouseMode.idle;
    private DragRenderer resizeRenderer = null;
    private Point resizeStart = null;
    Vector hotSpots = null;
    Rectangle dirtyBounds = null;

    public dasMouseInputAdapter_1(pwCanvasComponent pwCanvasComponent2) {
        this.parent = pwCanvasComponent2;
        this.modules = new Vector();
        this.primaryActionButtonMap = new HashMap();
        this.secondaryActionButtonMap = new HashMap();
        this.primaryPopup = this.createPopup();
        this.secondaryPopup = this.createPopup();
        this.active = null;
        this.mousePointSelection = new MousePointSelectionEvent(this, 0, 0);
        this.resizeRenderer = new BoxRenderer(pwCanvasComponent2);
        this.numInserted = 0;
    }

    public void replaceMouseModule(dasMouseModule dasMouseModule2, dasMouseModule dasMouseModule3) {
        JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)this.primaryActionButtonMap.get(dasMouseModule2);
        this.primaryActionButtonMap.put(dasMouseModule3, jCheckBoxMenuItem);
        this.primaryActionButtonMap.remove(dasMouseModule2);
        this.secondaryActionButtonMap.put(dasMouseModule3, this.secondaryActionButtonMap.get(dasMouseModule2));
        this.secondaryActionButtonMap.remove(dasMouseModule2);
        this.modules.removeElement(dasMouseModule2);
        this.modules.addElement(dasMouseModule3);
    }

    public void addMouseModule(dasMouseModule dasMouseModule2) {
        dasMouseModule dasMouseModule3 = this.getModuleByLabel(dasMouseModule2.getLabel());
        if (dasMouseModule3 != null) {
            pwDie.println(pwDie.INFORM, "Replacing mouse module " + dasMouseModule2.getLabel() + ".");
            this.replaceMouseModule(dasMouseModule3, dasMouseModule2);
        } else {
            this.modules.add(dasMouseModule2);
            String string = dasMouseModule2.getLabel();
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string);
            JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem(string);
            jCheckBoxMenuItem.addActionListener(this.popupListener);
            jCheckBoxMenuItem.setActionCommand("primary");
            jCheckBoxMenuItem2.addActionListener(this.popupListener);
            jCheckBoxMenuItem2.setActionCommand("secondary");
            this.primaryActionButtonMap.put(dasMouseModule2, jCheckBoxMenuItem);
            this.secondaryActionButtonMap.put(dasMouseModule2, jCheckBoxMenuItem2);
            this.primaryPopup.add((Component)jCheckBoxMenuItem, this.primaryActionButtonMap.size() - 1);
            this.secondaryPopup.add((Component)jCheckBoxMenuItem2, this.secondaryActionButtonMap.size() - 1);
        }
    }

    public void setPrimaryModule(dasMouseModule dasMouseModule2) {
        JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)this.primaryActionButtonMap.get(dasMouseModule2);
        if (jCheckBoxMenuItem != null) {
            jCheckBoxMenuItem.setSelected(true);
        }
        this.primarySelectedItem = jCheckBoxMenuItem;
        this.primary = dasMouseModule2;
        this.parent.setCursor(this.primary.getCursor());
    }

    public void setSecondaryModule(dasMouseModule dasMouseModule2) {
        JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)this.secondaryActionButtonMap.get(dasMouseModule2);
        if (jCheckBoxMenuItem != null) {
            jCheckBoxMenuItem.setSelected(true);
        }
        this.secondarySelectedItem = jCheckBoxMenuItem;
        this.secondary = dasMouseModule2;
    }

    public void setTertiaryModule(dasMouseModule dasMouseModule2) {
        this.tertiary = dasMouseModule2;
    }

    private JPopupMenu createPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.popupListener = this.createPopupMenuListener();
        jPopupMenu.addSeparator();
        if (this.parent instanceof PropertyEditor.Editable) {
            JMenuItem jMenuItem = new JMenuItem("properties");
            jMenuItem.addActionListener(this.popupListener);
            jMenuItem.setToolTipText("edit object properties");
            jPopupMenu.add(jMenuItem);
            jPopupMenu.addSeparator();
            JMenuItem jMenuItem2 = new JMenuItem("print...");
            jMenuItem2.setActionCommand("print");
            jMenuItem2.addActionListener(this.popupListener);
            jMenuItem2.setToolTipText("print entire canvas");
            jPopupMenu.add(jMenuItem2);
            JMenuItem jMenuItem3 = new JMenuItem("save as PNG...");
            jMenuItem3.setActionCommand("toPng");
            jMenuItem3.setToolTipText("save canvas to png image file");
            jMenuItem3.addActionListener(this.popupListener);
            jPopupMenu.add(jMenuItem3);
            jPopupMenu.addSeparator();
            JMenuItem jMenuItem4 = new JMenuItem("close");
            jMenuItem4.addActionListener(this.popupListener);
            jMenuItem4.setToolTipText("close this popup");
            jPopupMenu.add(jMenuItem4);
        }
        return jPopupMenu;
    }

    private ActionListener createPopupMenuListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                dasMouseInputAdapter_1 dasMouseInputAdapter_12 = dasMouseInputAdapter_1.this;
                String string = actionEvent.getActionCommand();
                if (string.equals("properties")) {
                    dasMouseInputAdapter_1.this.parent.showProperties();
                } else if (string.equals("print")) {
                    Printable printable = ((pwCanvas)dasMouseInputAdapter_1.this.parent.getParent()).getPrintable();
                    PrinterJob printerJob = PrinterJob.getPrinterJob();
                    printerJob.setPrintable(printable);
                    if (printerJob.printDialog()) {
                        try {
                            printerJob.print();
                        }
                        catch (PrinterException printerException) {
                            Object[] objectArray = new Object[]{"Error printing", printerException.getMessage()};
                            JOptionPane.showMessageDialog(null, objectArray, "ERROR", 0);
                        }
                    }
                } else if (string.equals("toPng")) {
                    Object object;
                    if (dasMouseInputAdapter_1.this.pngFileNamePanel == null) {
                        dasMouseInputAdapter_1.this.pngFileNamePanel = new JPanel();
                        dasMouseInputAdapter_1.this.pngFileNamePanel.setLayout(new BoxLayout(dasMouseInputAdapter_1.this.pngFileNamePanel, 0));
                        dasMouseInputAdapter_1.this.pngFileTextField = new JTextField(32);
                        dasMouseInputAdapter_1.this.pngFileTextField.setMaximumSize(dasMouseInputAdapter_1.this.pngFileTextField.getPreferredSize());
                        dasMouseInputAdapter_1.this.pngFileChooser = new JFileChooser();
                        dasMouseInputAdapter_1.this.pngFileChooser.setApproveButtonText("Select File");
                        dasMouseInputAdapter_1.this.pngFileChooser.setDialogTitle("Write to PNG");
                        object = new JButton("Browse");
                        ((AbstractButton)object).setActionCommand("pngBrowse");
                        ((AbstractButton)object).addActionListener(this);
                        dasMouseInputAdapter_1.this.pngFileNamePanel.add(dasMouseInputAdapter_1.this.pngFileTextField);
                        dasMouseInputAdapter_1.this.pngFileNamePanel.add((Component)object);
                    }
                    dasMouseInputAdapter_1.this.pngFileTextField.setText(dasMouseInputAdapter_1.this.pngFileChooser.getCurrentDirectory().getPath());
                    object = new String[]{"Write to PNG", "Cancel"};
                    int n = JOptionPane.showOptionDialog(dasMouseInputAdapter_1.this.parent, dasMouseInputAdapter_1.this.pngFileNamePanel, "Write to PNG", 0, 3, null, (Object[])object, "Ok");
                    if (n == 0) {
                        pwCanvas pwCanvas2 = (pwCanvas)dasMouseInputAdapter_1.this.parent.getParent();
                        try {
                            pwCanvas2.writeToPng(dasMouseInputAdapter_1.this.pngFileTextField.getText());
                        }
                        catch (IOException iOException) {
                            DasExceptionHandler.handle(iOException);
                        }
                    }
                } else if (string.equals("pngBrowse")) {
                    int n = dasMouseInputAdapter_1.this.pngFileChooser.showDialog(dasMouseInputAdapter_1.this.parent, "Select File");
                    if (n == 0) {
                        dasMouseInputAdapter_1.this.pngFileTextField.setText(dasMouseInputAdapter_1.this.pngFileChooser.getSelectedFile().getPath());
                    }
                } else if (!string.equals("close")) {
                    if (string.equals("primary")) {
                        JCheckBoxMenuItem jCheckBoxMenuItem = dasMouseInputAdapter_1.this.primarySelectedItem;
                        dasMouseInputAdapter_1.this.primarySelectedItem.setSelected(false);
                        int n = 0;
                        while (n < dasMouseInputAdapter_1.this.modules.size()) {
                            JCheckBoxMenuItem jCheckBoxMenuItem2 = (JCheckBoxMenuItem)dasMouseInputAdapter_1.this.primaryActionButtonMap.get(dasMouseInputAdapter_1.this.modules.get(n));
                            if (jCheckBoxMenuItem2.isSelected()) {
                                dasMouseInputAdapter_1.this.primarySelectedItem = jCheckBoxMenuItem2;
                                break;
                            }
                            ++n;
                        }
                        dasMouseInputAdapter_1.this.primarySelectedItem.setSelected(true);
                    } else if (string.equals("secondary")) {
                        dasMouseInputAdapter_1.this.secondarySelectedItem.setSelected(false);
                        Point point = dasMouseInputAdapter_1.this.secondaryPopupLocation;
                        int n = 0;
                        while (n < dasMouseInputAdapter_1.this.modules.size()) {
                            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)dasMouseInputAdapter_1.this.secondaryActionButtonMap.get(dasMouseInputAdapter_1.this.modules.get(n));
                            if (jCheckBoxMenuItem.isSelected()) {
                                dasMouseInputAdapter_1.this.secondarySelectedItem = jCheckBoxMenuItem;
                                break;
                            }
                            ++n;
                        }
                    } else {
                        pwDie.println("" + string);
                    }
                }
            }
        };
    }

    public void renderSelection(Graphics2D graphics2D) {
        int n = 0;
        while (n < this.active.size()) {
            pwCanvas pwCanvas2 = this.parent.getCanvas();
            this.selectionStart = SwingUtilities.convertPoint(pwCanvas2, this.dSelectionStart, this.parent);
            this.selectionEnd = SwingUtilities.convertPoint(pwCanvas2, this.dSelectionEnd, this.parent);
            ((dasMouseModule)this.active.get((int)n)).dragRenderer.renderDrag(graphics2D, this.selectionStart, this.selectionEnd);
            ++n;
        }
    }

    public void clearSelection(Graphics2D graphics2D) {
        if (this.active == null) {
            return;
        }
        int n = 0;
        while (n < this.active.size()) {
            ((dasMouseModule)this.active.get((int)n)).dragRenderer.clear(graphics2D);
            ++n;
        }
    }

    private MouseMode activateMouseMode(MouseEvent mouseEvent) {
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.parent.getRow() != null && this.parent.getColumn() != null) {
            double d = this.parent.getColumn().getDMinimum() - (double)this.xOffset;
            double d2 = this.parent.getColumn().getDMaximum() - (double)this.xOffset;
            double d3 = this.parent.getRow().getDMinimum() - (double)this.yOffset;
            double d4 = this.parent.getRow().getDMaximum() - (double)this.yOffset;
            bl = (double)mouseEvent.getX() < d + 5.0;
            bl2 = (double)mouseEvent.getX() > d2 - 5.0;
            bl3 = (double)mouseEvent.getY() < d3 + 5.0 && (double)mouseEvent.getY() >= d3;
            bl4 = (double)mouseEvent.getY() > d4 - 5.0;
        }
        MouseMode mouseMode = MouseMode.idle;
        Cursor cursor = new Cursor(0);
        if (!(this.parent instanceof pwAxis)) {
            if (bl) {
                if (bl3) {
                    mouseMode = MouseMode.resize;
                    cursor = new Cursor(6);
                } else if (bl4) {
                    mouseMode = MouseMode.resize;
                    cursor = new Cursor(4);
                }
            } else if (bl2) {
                if (bl3) {
                    mouseMode = MouseMode.resize;
                    cursor = new Cursor(7);
                } else if (bl4) {
                    mouseMode = MouseMode.resize;
                    cursor = new Cursor(5);
                }
            }
        }
        Shape shape = null;
        if (this.hotSpots != null) {
            object = this.hotSpots;
            int n = 0;
            while (n < ((Vector)object).size()) {
                Shape shape2 = (Shape)((Vector)object).get(n);
                if (shape2.contains(mouseEvent.getX(), mouseEvent.getY())) {
                    cursor = new Cursor(12);
                    mouseMode = MouseMode.hotSpot;
                    shape = shape2;
                }
                ++n;
            }
        }
        if (mouseMode == MouseMode.resize) {
            mouseMode.resizeBottom = bl4;
            mouseMode.resizeTop = bl3;
            mouseMode.resizeRight = bl2;
            mouseMode.resizeLeft = bl;
        }
        if (mouseMode != this.mouseMode) {
            this.getGlassPane().setCursor(cursor);
            if (this.mouseMode == MouseMode.hotSpot && mouseMode != MouseMode.hotSpot) {
                this.parent.repaint(this.dirtyBounds);
                this.dirtyBounds = null;
            } else if (mouseMode == MouseMode.hotSpot && this.mouseMode != MouseMode.hotSpot) {
                object = (Graphics2D)this.parent.getGraphics();
                ((Graphics)object).setColor(new Color(0, 200, 255, 50));
                ((Graphics2D)object).fill(shape);
                this.dirtyBounds = shape.getBounds();
            }
        }
        return mouseMode;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Point point = this.parent.getLocation();
        this.xOffset = point.x;
        this.yOffset = point.y;
        MouseMode mouseMode = this.activateMouseMode(mouseEvent);
        this.mouseMode = mouseMode != null ? mouseMode : MouseMode.idle;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        block22: {
            block20: {
                block21: {
                    Point point = this.parent.getLocation();
                    this.xOffset = point.x;
                    this.yOffset = point.y;
                    if (this.mouseMode != MouseMode.resize) break block20;
                    this.resizeStart = new Point(0, 0);
                    this.g = (Graphics2D)this.getGlassPane().getGraphics();
                    this.g.translate(this.parent.getX(), this.parent.getY());
                    if (this.mouseMode.resizeRight) {
                        this.resizeStart.x = 0;
                    } else if (this.mouseMode.resizeLeft) {
                        this.resizeStart.x = this.parent.getWidth();
                    }
                    if (!this.mouseMode.resizeTop) break block21;
                    this.resizeStart.y = this.parent.getHeight();
                    break block22;
                }
                if (!this.mouseMode.resizeBottom) break block22;
                this.resizeStart.y = 0;
                break block22;
            }
            if (this.mouseMode == MouseMode.hotSpot) {
                Vector vector = this.hotSpots;
                int n = 0;
                while (n < vector.size()) {
                    if (((Shape)vector.get(n)).contains(mouseEvent.getX(), mouseEvent.getY())) {
                        this.primary.hotSpotPressed((Shape)vector.get(n));
                    }
                    ++n;
                }
            } else if (this.active == null) {
                this.button = mouseEvent.getButton();
                this.selectionStart = mouseEvent.getPoint();
                this.dSelectionStart = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), this.parent.getCanvas());
                this.selectionEnd = mouseEvent.getPoint();
                this.dSelectionEnd = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), this.parent.getCanvas());
                this.g = (Graphics2D)this.parent.getGraphics();
                if (mouseEvent.isControlDown() || this.button == 3) {
                    if (this.button == 1 || this.button == 3) {
                        this.primaryPopupLocation = mouseEvent.getPoint();
                        this.primaryPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    } else {
                        this.secondaryPopupLocation = mouseEvent.getPoint();
                        this.secondaryPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                } else {
                    Object object;
                    int n;
                    this.active = new Vector();
                    if (this.button == 1 || this.button == 3) {
                        n = 0;
                        while (n < this.modules.size()) {
                            object = (JCheckBoxMenuItem)this.primaryActionButtonMap.get(this.modules.get(n));
                            if (((AbstractButton)object).isSelected()) {
                                this.active.add(this.modules.get(n));
                            }
                            ++n;
                        }
                    } else {
                        n = 0;
                        while (n < this.modules.size()) {
                            object = (JCheckBoxMenuItem)this.secondaryActionButtonMap.get(this.modules.get(n));
                            if (((AbstractButton)object).isSelected()) {
                                this.active.add(this.modules.get(n));
                            }
                            ++n;
                        }
                    }
                    this.mouseMode = MouseMode.moduleDrag;
                    this.mousePointSelection.set(mouseEvent.getX() + this.xOffset, mouseEvent.getY() + this.yOffset);
                    n = 0;
                    while (n < this.active.size()) {
                        object = (dasMouseModule)this.active.get(n);
                        if (((dasMouseModule)object).dragRenderer.isPointSelection()) {
                            this.mouseDragged(mouseEvent);
                        }
                        ++n;
                    }
                }
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.mouseMode == MouseMode.resize) {
            this.resizeRenderer.clear(this.g);
            this.resizeRenderer.renderDrag(this.g, this.resizeStart, mouseEvent.getPoint());
        } else if (this.active != null) {
            this.clearSelection(this.g);
            this.selectionEnd = mouseEvent.getPoint();
            this.dSelectionEnd = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), this.parent.getCanvas());
            this.renderSelection(this.g);
            this.mousePointSelection.set((int)this.dSelectionEnd.getX(), (int)this.dSelectionEnd.getY());
            int n = 0;
            while (n < this.active.size()) {
                dasMouseModule dasMouseModule2 = (dasMouseModule)this.active.get(n);
                if (dasMouseModule2.dragRenderer.isPointSelection()) {
                    dasMouseModule2.mousePointSelected(this.mousePointSelection);
                }
                if (dasMouseModule2.dragRenderer.isUpdatingDragSelection()) {
                    MouseDragEvent mouseDragEvent = dasMouseModule2.dragRenderer.getMouseDragEvent(this.parent, this.dSelectionStart, this.dSelectionEnd, mouseEvent.isShiftDown());
                    dasMouseModule2.mouseRangeSelected(mouseDragEvent);
                }
                ++n;
            }
        }
    }

    private void performResize(MouseEvent mouseEvent) {
        pwCanvas pwCanvas2 = (pwCanvas)this.parent.getParent();
        double d = this.parent.getColumn().getDMinimum();
        double d2 = this.parent.getColumn().getDMaximum();
        double d3 = this.parent.getRow().getDMinimum();
        double d4 = this.parent.getRow().getDMaximum();
        double d5 = (double)mouseEvent.getX() + (double)this.xOffset;
        double d6 = (double)mouseEvent.getY() + (double)this.yOffset;
        if (this.mouseMode.resizeRight) {
            d2 = d5;
        } else if (this.mouseMode.resizeLeft) {
            d = d5;
        }
        if (this.mouseMode.resizeTop) {
            d3 = d6;
        } else if (this.mouseMode.resizeBottom) {
            d4 = d6;
        }
        this.parent.getColumn().setDPosition(d, d2);
        this.parent.getRow().setDPosition(d3, d4);
        this.parent.resize();
        this.getGlassPane().setCursor(new Cursor(0));
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.mouseMode == MouseMode.resize) {
            this.performResize(mouseEvent);
        } else if (mouseEvent.getButton() == this.button && this.active != null) {
            this.clearSelection(this.g);
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = 0;
            while (n3 < this.active.size()) {
                boolean bl;
                dasMouseModule dasMouseModule2 = (dasMouseModule)this.active.get(n3);
                boolean bl2 = dasMouseModule2.dragRenderer.isXRangeSelection() && n2 >= 0 && n2 <= this.parent.getHeight();
                boolean bl3 = bl = dasMouseModule2.dragRenderer.isYRangeSelection() && n >= 0 && n <= this.parent.getWidth();
                if (bl2 || bl) {
                    MouseDragEvent mouseDragEvent = dasMouseModule2.dragRenderer.getMouseDragEvent(this.parent, this.dSelectionStart, this.dSelectionEnd, mouseEvent.isShiftDown());
                    dasMouseModule2.mouseRangeSelected(mouseDragEvent);
                }
                this.button = 0;
                ++n3;
            }
            this.active = null;
        }
    }

    public void removeMouseModule(dasMouseModule dasMouseModule2) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.primary != null) {
            this.hotSpots = this.primary.getHotSpots();
            this.getGlassPane().setCursor(this.primary.getCursor());
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.mouseMode == MouseMode.hotSpot) {
            this.parent.repaint(this.dirtyBounds);
            this.mouseMode = MouseMode.idle;
        }
        this.getGlassPane().setCursor(Cursor.getDefaultCursor());
    }

    public void addMenuItem(Component component) {
        if (this.numInserted == 0) {
            this.primaryPopup.insert(new JPopupMenu.Separator(), 0);
        }
        this.primaryPopup.insert(component, this.numInserted);
        ++this.numInserted;
    }

    public Component getGlassPane() {
        return ((pwCanvas)this.parent.getParent()).getGlassPane();
    }

    public dasMouseModule getModuleByLabel(String string) {
        dasMouseModule dasMouseModule2 = null;
        int n = 0;
        while (n < this.modules.size()) {
            if (string.equals(((dasMouseModule)this.modules.get(n)).getLabel())) {
                dasMouseModule2 = (dasMouseModule)this.modules.get(n);
            }
            ++n;
        }
        return dasMouseModule2;
    }

    private static class MouseMode {
        String s;
        boolean resizeTop = false;
        boolean resizeBottom = false;
        boolean resizeRight = false;
        boolean resizeLeft = false;
        static MouseMode idle = new MouseMode("idle");
        static MouseMode resize = new MouseMode("resize");
        static MouseMode moduleDrag = new MouseMode("moduleDrag");
        static MouseMode hotSpot = new MouseMode("hotSpot");

        MouseMode(String string) {
            this.s = string;
        }

        public String toString() {
            return this.s;
        }
    }
}

