/*
 * Decompiled with CFR 0.152.
 */
package event;

import event.DragRenderer;
import event.Gesture;
import event.GesturesRenderer;
import event.MouseDragEvent;
import event.MouseRangeGestureSelectionEvent;
import graph.pwCanvasComponent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

public class VerticalRangeGesturesRenderer
implements DragRenderer {
    protected int xInitial;
    protected int yInitial;
    private GesturesRenderer gr;
    private Rectangle dirtyBounds;
    private pwCanvasComponent parent;

    public VerticalRangeGesturesRenderer(pwCanvasComponent pwCanvasComponent2) {
        this.gr = new GesturesRenderer(pwCanvasComponent2);
        this.parent = pwCanvasComponent2;
        this.dirtyBounds = new Rectangle();
    }

    public void renderDrag(Graphics graphics, Point point, Point point2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        double d = point2.x - point.x;
        double d2 = -1 * (point2.y - point.y);
        double d3 = Math.atan2(d2, d) * 180.0 / Math.PI;
        double d4 = Math.sqrt(d2 * d2 + d * d);
        if (d4 < 20.0) {
            this.gr.renderDrag(graphics2D, point, point2);
            this.dirtyBounds.setBounds(this.gr.getDirtyBounds());
        } else {
            int n;
            int n2 = point2.y;
            int n3 = point.y;
            if (n2 < n3) {
                n = n2;
                n2 = n3;
                n3 = n;
            }
            n = n2 - n3;
            int n4 = point2.x;
            Color color = graphics2D.getColor();
            graphics2D.setColor(new Color(255, 255, 255, 100));
            graphics2D.setStroke(new BasicStroke(3.0f, 1, 1));
            if (n > 6) {
                graphics2D.drawLine(n4, n3 + 3, n4, n2 - 3);
            }
            graphics2D.drawLine(n4 + 2, n3, n4 - 2, n3);
            graphics2D.drawLine(n4 + 2, n2, n4 - 2, n2);
            graphics2D.setStroke(new BasicStroke());
            graphics2D.setColor(color);
            if (n > 6) {
                graphics2D.drawLine(n4, n3 + 3, n4, n2 - 3);
            }
            graphics2D.drawLine(n4 + 2, n3, n4 - 2, n3);
            graphics2D.drawLine(n4 + 2, n2, n4 - 2, n2);
            this.dirtyBounds.setLocation(n4 - 4, n3 - 2);
            this.dirtyBounds.add(n4 + 4, n2 + 2);
        }
    }

    public MouseDragEvent getMouseDragEvent(Object object, Point point, Point point2, boolean bl) {
        double d = -1 * (point2.y - point.y);
        double d2 = point2.x - point.x;
        double d3 = Math.sqrt(d * d + d2 * d2);
        if (d3 < 20.0) {
            return this.gr.getMouseDragEvent(object, point, point2, bl);
        }
        return new MouseRangeGestureSelectionEvent(object, (double)point.y, (double)point2.y, Gesture.NONE);
    }

    public void clear(Graphics graphics) {
        this.parent.paintImmediately(this.dirtyBounds);
    }

    public boolean isXRangeSelection() {
        return false;
    }

    public boolean isYRangeSelection() {
        return true;
    }

    public boolean isPointSelection() {
        return false;
    }

    public boolean isUpdatingDragSelection() {
        return false;
    }
}

