/*
 * Decompiled with CFR 0.152.
 */
package event;

import das_proto.DasProperties;
import das_proto.data.DasFormatter;
import das_proto.data.DataSet;
import das_proto.data.DataSetConsumer;
import das_proto.data.Datum;
import das_proto.data.XTaggedYScanDataSet;
import das_proto.data.XTaggedYScanDataSetConsumer;
import event.DragRenderer;
import event.MouseDragEvent;
import graph.pwAxis;
import graph.pwLabelAxis;
import graph.pwPlot;
import graph.pwStackedHistogramPlot;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.text.DecimalFormat;
import util.pwDie;

public class CrossHairRenderer
implements DragRenderer {
    protected int xInitial;
    protected int yInitial;
    protected DataSet ds;
    protected pwAxis XAxis;
    protected pwAxis YAxis;
    protected pwPlot parent;
    private int ix = 0;
    private int iy = 0;
    private int context;
    private DasFormatter nfx;
    private DasFormatter nfy;
    private DasFormatter nfz;
    private FontMetrics fm;
    private int dxMax = -999999;
    private Rectangle dirtyBounds;
    private Point crossHairLocation = null;
    private DataSetConsumer dataSetConsumer;

    public CrossHairRenderer(pwPlot pwPlot2, DataSetConsumer dataSetConsumer, pwAxis pwAxis2, pwAxis pwAxis3) {
        this.XAxis = pwAxis2;
        this.YAxis = pwAxis3;
        this.parent = pwPlot2;
        this.dataSetConsumer = dataSetConsumer;
        this.dirtyBounds = new Rectangle();
    }

    public void renderDrag(Graphics graphics, Point point, Point point2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHints(DasProperties.getRenderingHints());
        this.ds = this.dataSetConsumer.getDataSet();
        if (this.crossHairLocation != null) {
            this.drawCrossHair(graphics2D, this.crossHairLocation);
        }
        if (this.crossHairLocation == null) {
            String string;
            Serializable serializable;
            String string2;
            Datum datum = this.XAxis.invTransform(point2.x + this.parent.getX());
            Datum datum2 = this.YAxis.invTransform(point2.y + this.parent.getY());
            this.nfy = datum2.getFormatter();
            this.nfx = datum.getFormatter();
            String string3 = this.nfx.format(datum);
            if (!(this.YAxis instanceof pwLabelAxis)) {
                string2 = this.nfy.format(datum2);
            } else {
                string2 = ((pwLabelAxis)this.YAxis).getLabel(datum2.getValue());
                try {
                    double d = Double.parseDouble(string2);
                    if (this.ds instanceof XTaggedYScanDataSet) {
                        datum2 = new Datum(d, ((XTaggedYScanDataSet)this.ds).getYUnits());
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            String string4 = "";
            if (this.ds instanceof XTaggedYScanDataSet) {
                serializable = (XTaggedYScanDataSet)this.ds;
                if (datum.getUnits() != ((DataSet)serializable).getXUnits()) {
                    throw new IllegalStateException("x units and dataset x units differ");
                }
                if (datum2.getUnits() != ((XTaggedYScanDataSet)serializable).getYUnits()) {
                    throw new IllegalStateException("y units and dataset y units differ");
                }
                double d = datum.getValue();
                double d2 = datum2.getValue();
                Datum datum3 = ((XTaggedYScanDataSet)serializable).getClosestZValue(new Datum(d, ((DataSet)serializable).getXUnits()), new Datum(d2, ((XTaggedYScanDataSet)serializable).getYUnits()));
                if (this.dataSetConsumer instanceof XTaggedYScanDataSetConsumer) {
                    this.nfz = (DasFormatter)((XTaggedYScanDataSetConsumer)this.dataSetConsumer).getZAxis().getFormatter().clone();
                    this.nfz.setMinimumFractionDigits(this.nfz.getMinimumFractionDigits() + 1);
                } else if (this.parent instanceof pwStackedHistogramPlot) {
                    this.nfz = (DasFormatter)((pwStackedHistogramPlot)this.parent).getZAxis().getFormatter().clone();
                    this.nfz.setMinimumFractionDigits(this.nfz.getMinimumFractionDigits() + 1);
                } else {
                    this.nfz = new DasFormatter((DecimalFormat)DecimalFormat.getInstance());
                    this.nfz.setMaximumFractionDigits(2);
                    this.nfz.setMinimumFractionDigits(2);
                }
                string4 = this.nfz.format(datum3.getValue(), datum3.getUnits());
                string = "x:" + string3 + " y:" + string2 + " z:" + string4;
            } else {
                string = "x:" + string3 + " y:" + string2;
            }
            this.fm = this.parent.getGraphics().getFontMetrics();
            serializable = graphics2D.getColor();
            graphics2D.setColor(new Color(255, 255, 255, 200));
            Dimension dimension = this.parent.getSize();
            int n = this.fm.stringWidth(string) + 6;
            if (this.dxMax < n) {
                this.dxMax = n;
            }
            int n2 = this.fm.getAscent() + this.fm.getDescent();
            int n3 = point2.x + 3;
            int n4 = point2.y - 3 - n2;
            if (n3 + this.dxMax > dimension.width - 3 && point2.x - 3 - n > 0) {
                n3 = point2.x - 3 - n;
            }
            if (n4 < 13) {
                n4 = point2.y + 3;
            }
            this.dirtyBounds.setRect(n3, n4, n, n2);
            graphics2D.fill(this.dirtyBounds);
            graphics2D.setColor(new Color(20, 20, 20));
            graphics2D.drawString(string, n3 + 3, n4 + this.fm.getAscent());
            graphics2D.setColor((Color)serializable);
        }
        this.drawCrossHair(graphics2D, point2);
    }

    public MouseDragEvent getMouseDragEvent(Object object, Point point, Point point2, boolean bl) {
        return null;
    }

    private void drawCrossHair(Graphics graphics, Point point) {
        Graphics graphics2 = graphics.create();
        graphics2.setColor(new Color(0, 0, 0));
        graphics2.setXORMode(Color.white);
        if (this.crossHairLocation != null && !this.crossHairLocation.equals(point)) {
            this.drawCrossHair(graphics2, this.crossHairLocation);
        }
        Dimension dimension = this.parent.getSize();
        graphics2.drawLine(0, point.y, (int)dimension.getWidth(), point.y);
        graphics2.drawLine(point.x, 0, point.x, (int)dimension.getHeight());
        if (this.crossHairLocation != null) {
            if (this.crossHairLocation.equals(point)) {
                this.crossHairLocation = null;
            } else {
                pwDie.println("Sorry about the crosshair mess!");
                this.crossHairLocation = point;
            }
        } else {
            this.crossHairLocation = point;
        }
        graphics2.dispose();
    }

    public void clear(Graphics graphics) {
        if (this.crossHairLocation != null) {
            this.drawCrossHair(graphics, this.crossHairLocation);
        }
        this.parent.paintImmediately(this.dirtyBounds);
        boolean bl = true;
    }

    public boolean isXRangeSelection() {
        return false;
    }

    public boolean isYRangeSelection() {
        return false;
    }

    public boolean isPointSelection() {
        return true;
    }

    public boolean isUpdatingDragSelection() {
        return false;
    }
}

