/*
 * Decompiled with CFR 0.152.
 */
package event;

import event.DragRenderer;
import event.MouseBoxEvent;
import event.MouseDragEvent;
import graph.pwCanvasComponent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

public class BoxRenderer
implements DragRenderer {
    boolean xRangeSelection;
    boolean yRangeSelection;
    private Rectangle dirtyBounds;
    pwCanvasComponent parent;

    public BoxRenderer(pwCanvasComponent pwCanvasComponent2) {
        this.parent = pwCanvasComponent2;
        this.dirtyBounds = new Rectangle();
        this.xRangeSelection = true;
        this.yRangeSelection = true;
    }

    public void clear(Graphics graphics) {
        this.parent.paintImmediately(this.dirtyBounds);
    }

    public void renderDrag(Graphics graphics, Point point, Point point2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle rectangle = new Rectangle(point);
        rectangle.add(point2);
        Color color = graphics2D.getColor();
        graphics2D.setColor(new Color(255, 255, 255, 100));
        graphics2D.setStroke(new BasicStroke(3.0f, 1, 1));
        graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2D.setStroke(new BasicStroke());
        graphics2D.setColor(color);
        graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.dirtyBounds.setLocation(rectangle.x - 2, rectangle.y - 3);
        this.dirtyBounds.add(rectangle.x + rectangle.width + 2, rectangle.y + rectangle.height + 3);
    }

    public MouseDragEvent getMouseDragEvent(Object object, Point point, Point point2, boolean bl) {
        return new MouseBoxEvent(object, point, point2, bl);
    }

    public boolean isPointSelection() {
        return false;
    }

    public boolean isXRangeSelection() {
        return this.xRangeSelection;
    }

    public boolean isYRangeSelection() {
        return this.yRangeSelection;
    }

    public boolean isUpdatingDragSelection() {
        return false;
    }
}

