/*
 * Decompiled with CFR 0.152.
 */
package das_proto.server;

import das_proto.DasException;
import das_proto.DasProperties;
import das_proto.client.DasIOException;
import das_proto.client.DasServerException;
import das_proto.client.DasServerNotFoundException;
import das_proto.client.DataSetDescriptorNotAvailableException;
import das_proto.client.Key;
import das_proto.client.StandardDataStreamSource;
import das_proto.client.WebStandardDataStreamSource;
import java.awt.BorderLayout;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import util.DasExceptionHandler;
import util.crypt;
import util.pwDie;

public class DasServer {
    private String host;
    private String path;
    private int port;
    private StandardDataStreamSource standardDataStreamSource;
    private static Hashtable instanceHashtable = new Hashtable();
    public static DasServer plasmaWaveGroup;
    public static DasServer sarahandjeremy;

    private DasServer(String string, String string2) {
        String[] stringArray = string.split(":");
        if (stringArray.length > 1) {
            this.port = Integer.parseInt(stringArray[1]);
            string = stringArray[0];
        } else {
            this.port = -1;
        }
        this.host = string;
        this.path = string2;
        this.standardDataStreamSource = new WebStandardDataStreamSource(this);
    }

    public String getURL() {
        if (this.port == -1) {
            return "http://" + this.host + this.path;
        }
        return "http://" + this.host + ":" + this.port + this.path;
    }

    public static DasServer create(URL uRL) {
        String string;
        String string2 = uRL.getHost();
        int n = uRL.getPort();
        if (n != -1) {
            string2 = string2 + ":" + n;
        }
        if (instanceHashtable.containsKey(string = "http://" + string2 + uRL.getPath())) {
            return (DasServer)instanceHashtable.get(string);
        }
        String string3 = uRL.getPath();
        DasServer dasServer = new DasServer(string2, string3);
        instanceHashtable.put(string, dasServer);
        return dasServer;
    }

    public String getName() {
        String string = "server=id";
        try {
            URL uRL = new URL("http", this.host, this.port, this.path + "?" + string);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.connect();
            String string2 = uRLConnection.getContentType();
            InputStream inputStream = uRLConnection.getInputStream();
            byte[] byArray = this.read(inputStream);
            return new String(byArray);
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public ImageIcon getLogo() {
        String string = "server=logo";
        try {
            URL uRL = new URL("http", this.host, this.port, this.path + "?" + string);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.connect();
            String string2 = uRLConnection.getContentType();
            InputStream inputStream = uRLConnection.getInputStream();
            byte[] byArray = this.read(inputStream);
            return new ImageIcon(byArray);
        }
        catch (IOException iOException) {
            return new ImageIcon();
        }
    }

    public TreeModel getDataSetList() throws DasException {
        String string = "server=list";
        try {
            URL uRL = new URL("http", this.host, this.port, this.path + "?" + string);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.connect();
            String string2 = uRLConnection.getContentType();
            InputStream inputStream = uRLConnection.getInputStream();
            return this.createModel(inputStream);
        }
        catch (IOException iOException) {
            throw new DasIOException(iOException.getMessage());
        }
    }

    private TreeModel createModel(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(this.host, true);
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode, true);
        String string = bufferedReader.readLine();
        while (string != null) {
            Object object = defaultMutableTreeNode;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            block1: while (stringTokenizer.hasMoreTokens()) {
                Object object2;
                String string2 = stringTokenizer.nextToken();
                int n = 0;
                while (n < ((DefaultMutableTreeNode)object).getChildCount()) {
                    object2 = ((DefaultMutableTreeNode)object).getChildAt(n).toString();
                    if (((String)object2).equals(string2)) {
                        object = (DefaultMutableTreeNode)((DefaultMutableTreeNode)object).getChildAt(n);
                        continue block1;
                    }
                    ++n;
                }
                object2 = new DefaultMutableTreeNode(string2, stringTokenizer.hasMoreElements() ? true : string.endsWith("/"));
                ((DefaultMutableTreeNode)object).add((MutableTreeNode)object2);
                object = object2;
            }
            string = bufferedReader.readLine();
        }
        return defaultTreeModel;
    }

    public StandardDataStreamSource getStandardDataStreamSource() {
        return this.standardDataStreamSource;
    }

    public String getDataSetDescriptor(String string) throws DasException {
        URL uRL;
        try {
            uRL = new URL("http", this.host, this.port, this.path + "?server=dsdf&dataset=" + string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new DataSetDescriptorNotAvailableException("malformed URL");
        }
        catch (IOException iOException) {
            throw new DataSetDescriptorNotAvailableException("I/O Error");
        }
        pwDie.println(pwDie.VERBOSE, "getting " + uRL.toString());
        try {
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.connect();
            String string2 = uRLConnection.getContentType();
            String[] stringArray = string2.split(";");
            string2 = stringArray[0];
            if (!string2.equalsIgnoreCase("text/plain")) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
                String string3 = "";
                String string4 = bufferedReader.readLine();
                while (string4 != null) {
                    string3 = string3.concat(string4);
                    string4 = bufferedReader.readLine();
                }
                throw new IOException(string3);
            }
            byte[] byArray = this.read(uRLConnection.getInputStream());
            return new String(byArray);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new DasServerNotFoundException(fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            throw new DasIOException(iOException.getMessage());
        }
    }

    public Key authenticate(String string, String string2) {
        try {
            Key key = null;
            String string3 = "server=authenticator";
            string3 = string3 + "&user=" + URLEncoder.encode(string, "UTF-8");
            String string4 = crypt.crypt(string2);
            if (string2.equals("sendPropertyPassword")) {
                string4 = DasProperties.getInstance().getProperty("password");
            }
            string3 = string3 + "&passwd=" + URLEncoder.encode(string4, "UTF-8");
            URL uRL = new URL("http", this.host, this.port, this.path + "?" + string3);
            pwDie.println(pwDie.VERBOSE, uRL.toString());
            InputStream inputStream = uRL.openStream();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            String string5 = this.readServerResponse(bufferedInputStream);
            String string6 = "error";
            String string7 = "key";
            if (string5.substring(0, string7.length() + 2).equals("<" + string7 + ">")) {
                int n = string5.indexOf("</" + string7 + ">");
                String string8 = string5.substring(string7.length() + 2, n);
                key = new Key(string8);
            } else {
                key = null;
            }
            return key;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)"UTF-8 not supported");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void changePassword(String string, String string2, String string3) throws DasServerException {
        try {
            String string4 = "server=changePassword";
            string4 = string4 + "&user=" + URLEncoder.encode(string, "UTF-8");
            String string5 = crypt.crypt(string2);
            string4 = string4 + "&passwd=" + URLEncoder.encode(string5, "UTF-8");
            String string6 = crypt.crypt(string3);
            string4 = string4 + "&newPasswd=" + URLEncoder.encode(string6, "UTF-8");
            URL uRL = new URL("http", this.host, this.port, this.path + "?" + string4);
            pwDie.println(pwDie.VERBOSE, uRL.toString());
            InputStream inputStream = uRL.openStream();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            String string7 = this.readServerResponse(bufferedInputStream);
            String string8 = "error";
            String string9 = "key";
            if (string7.substring(0, string8.length() + 2).equals("<" + string8 + ">")) {
                int n = string7.indexOf("</" + string8 + ">");
                String string10 = string7.substring(string8.length() + 2, n);
                if (string10.equals("<badAuthentication/>")) {
                    throw new DasServerException("Bad User/Pass");
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)"UTF-8 not supported");
        }
        catch (IOException iOException) {
            throw new DasServerException("Failed Connection");
        }
    }

    public String readServerResponse(BufferedInputStream bufferedInputStream) {
        String string;
        block5: {
            bufferedInputStream.mark(Integer.MAX_VALUE);
            byte[] byArray = new byte[4096];
            int n = -1;
            int n2 = 0;
            try {
                int n3 = bufferedInputStream.read(byArray, n2, 4096 - n2);
                String string2 = "das2Response";
                if (n3 < string2.length() + 2) {
                    n2 += n3;
                    n3 = bufferedInputStream.read(byArray, n2, 4096 - n2);
                }
                if (new String(byArray, 0, 14, "UTF-8").equals("<" + string2 + ">")) {
                    while (new String(byArray, 0, n2, "UTF-8").indexOf("</" + string2 + ">") == -1 && n2 < 4096) {
                        n3 = bufferedInputStream.read(byArray, n2 += n3, 4096 - n2);
                    }
                    int n4 = new String(byArray, 0, n2, "UTF-8").indexOf("</" + string2 + ">");
                    string = new String(byArray, 14, n4 - 14);
                    pwDie.println("das2Response=" + string);
                    bufferedInputStream.reset();
                    bufferedInputStream.skip(string.length() + 2 * string2.length() + 5);
                    break block5;
                }
                bufferedInputStream.reset();
                string = "";
            }
            catch (IOException iOException) {
                string = "";
            }
        }
        return string;
    }

    public byte[] read(InputStream inputStream) throws IOException {
        int n;
        LinkedList<byte[]> linkedList = new LinkedList<byte[]>();
        int n2 = 0;
        int n3 = 0;
        InputStream inputStream2 = inputStream;
        long l = System.currentTimeMillis();
        byte[] byArray = new byte[4096];
        int n4 = -1;
        int n5 = 0;
        n2 = inputStream2.read(byArray, n5, 4096 - n5);
        while (n2 != -1) {
            n = n3;
            n4 = n5 += n2;
            if (n5 == 4096) {
                linkedList.addLast(byArray);
                byArray = new byte[4096];
                n5 = 0;
            }
            n3 += n2;
            n2 = inputStream2.read(byArray, n5, 4096 - n5);
        }
        if (n4 < 4096) {
            linkedList.addLast(byArray);
        }
        if (linkedList.size() == 0) {
            return new byte[0];
        }
        n = (linkedList.size() - 1) * 4096 + n4;
        byArray = new byte[n];
        Iterator iterator = linkedList.iterator();
        int n6 = 0;
        while (n6 < linkedList.size() - 1) {
            System.arraycopy(iterator.next(), 0, byArray, n6 * 4096, 4096);
            ++n6;
        }
        System.arraycopy(iterator.next(), 0, byArray, n6 * 4096, n4);
        return byArray;
    }

    public static void main(String[] stringArray) {
        DasServer dasServer = plasmaWaveGroup;
        JFrame jFrame = new JFrame();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(new JLabel(dasServer.getLogo()));
        jFrame.setContentPane(jPanel);
        jFrame.pack();
        jFrame.setVisible(true);
        pwDie.println(dasServer.getName());
        try {
            pwDie.println(dasServer.getDataSetDescriptor("galileo/pws/best-e"));
        }
        catch (Exception exception) {
            pwDie.println(exception);
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public URL getURL(String string) throws MalformedURLException {
        return new URL("http", this.host, this.port, this.path + "?" + string);
    }

    static {
        try {
            plasmaWaveGroup = DasServer.create(new URL("http://www-pw.physics.uiowa.edu/das/dasServer"));
            sarahandjeremy = DasServer.create(new URL("http://www.sarahandjeremy.net/das/dasServer.cgi"));
        }
        catch (MalformedURLException malformedURLException) {
            DasExceptionHandler.handle(malformedURLException);
        }
    }
}

