/*
 * Decompiled with CFR 0.152.
 */
package das_proto.data;

import das_proto.data.Datum;
import das_proto.data.Units;

public class rebinDescriptor {
    Units units;
    protected double start = 0.0;
    protected double end = 10.0;
    protected int nBin = 10;
    protected boolean isLog = false;
    public static final int FIRSTORLAST = -2;
    public static final int MINUSONE = -3;
    public static final int EXTRAPOLATE = -4;
    private int outOfBoundsAction = -3;

    public rebinDescriptor() {
    }

    public rebinDescriptor(double d, double d2, Units units, int n, boolean bl) {
        this.units = units;
        if (bl) {
            this.start = Math.log(d);
            this.end = Math.log(d2);
        } else {
            this.start = d;
            this.end = d2;
        }
        this.nBin = n;
        this.isLog = bl;
    }

    public rebinDescriptor(Datum datum, Datum datum2, int n, boolean bl) {
        this(datum.getValue(), datum2.getValue(), datum.getUnits(), n, bl);
        if (datum.getUnits() != datum2.getUnits()) {
            throw new IllegalArgumentException("start and end units differ");
        }
    }

    public int numberOfBins() {
        return this.nBin;
    }

    public int whichBin(double d, Units units) {
        if (units != this.units) {
            d = Units.getConverter(units, this.units).convert(d);
        }
        int n = 0;
        if (this.isLog) {
            d = Math.log(d);
        }
        if ((d < this.start || d >= this.end) && this.outOfBoundsAction != -4) {
            switch (this.outOfBoundsAction) {
                case -2: {
                    n = d < this.start ? 0 : this.nBin - 1;
                }
                case -3: {
                    n = -1;
                }
            }
        } else {
            n = (int)((d - this.start) * (double)this.nBin / (this.end - this.start));
        }
        return n;
    }

    public double[] binCenters() {
        double[] dArray = new double[this.nBin];
        int n = 0;
        while (n < this.nBin) {
            dArray[n] = this.start + ((double)n + 0.5) / (double)this.nBin * (this.end - this.start);
            ++n;
        }
        if (this.isLog) {
            int n2 = 0;
            while (n2 < this.nBin) {
                dArray[n2] = Math.exp(dArray[n2]);
                ++n2;
            }
        }
        return dArray;
    }

    public double[] binStarts() {
        double[] dArray = new double[this.nBin];
        int n = 0;
        while (n < this.nBin) {
            dArray[n] = this.start + (double)((float)n / (float)this.nBin) * (this.end - this.start);
            ++n;
        }
        if (this.isLog) {
            int n2 = 0;
            while (n2 < this.nBin) {
                dArray[n2] = Math.exp(dArray[n2]);
                ++n2;
            }
        }
        return dArray;
    }

    public double[] binStops() {
        double[] dArray = new double[this.nBin];
        int n = 0;
        while (n < this.nBin) {
            dArray[n] = this.start + (double)((float)(n + 1) / (float)this.nBin) * (this.end - this.start);
            ++n;
        }
        if (this.isLog) {
            int n2 = 0;
            while (n2 < this.nBin) {
                dArray[n2] = Math.exp(dArray[n2]);
                ++n2;
            }
        }
        return dArray;
    }

    public void setOutOfBoundsAction(int n) {
        this.outOfBoundsAction = n;
    }

    public double binWidth() {
        return (this.end - this.start) / (double)this.nBin;
    }

    public Units getUnits() {
        return this.units;
    }

    public String toString() {
        return "[" + this.start + "-" + this.end + " in " + this.nBin + " bins " + (this.isLog ? "Log" : "") + "]";
    }
}

