/*
 * Decompiled with CFR 0.152.
 */
package das_proto.data;

import das_proto.DasException;
import das_proto.das2Stream.MultiPlanarDataSet;
import das_proto.data.DataRequestor;
import das_proto.data.DataSet;
import das_proto.data.DataSetDescriptor;
import das_proto.data.Datum;
import das_proto.data.LocationUnits;
import das_proto.data.TimeDatum;
import das_proto.data.Units;
import das_proto.data.UnitsConverter;
import das_proto.data.XTaggedYScan;
import das_proto.data.XTaggedYScanDataSet;
import das_proto.data.XTaggedYScanDataSetCache;
import graph.Renderer;
import graph.SpectrogramRenderer;
import graph.pwAxis;
import graph.pwColorBar;
import graph.pwColumn;
import graph.pwPlot;
import graph.pwRow;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.Hashtable;
import util.pwDate;
import util.pwDie;

public class XTaggedYScanDataSetDescriptor
extends DataSetDescriptor {
    public float z_fill = Float.NaN;
    public String y_parameter = "";
    public String y_unit = "";
    public Units yUnits;
    public String z_parameter = "";
    public String z_unit = "";
    public Units zUnits;
    public double[] y_coordinate;
    public int ny = -1;
    public int items = -1;
    private XTaggedYScanDataSetCache dataCache;
    private boolean serverSideReduction = true;

    protected XTaggedYScanDataSetDescriptor() {
        super(Units.us2000);
        this.yUnits = Units.dimensionless;
        this.zUnits = Units.dimensionless;
    }

    protected XTaggedYScanDataSetDescriptor(Hashtable hashtable) {
        super(Units.us2000);
        if (hashtable != null) {
            this.setProperties(hashtable);
        }
        this.yUnits = Units.dimensionless;
        this.zUnits = Units.dimensionless;
    }

    public void setProperties(Hashtable hashtable) {
        super.setProperties(hashtable);
        if (hashtable.containsKey("y_parameter")) {
            this.y_parameter = (String)hashtable.get("y_parameter");
        }
        if (hashtable.containsKey("y_unit")) {
            this.y_unit = (String)hashtable.get("y_unit");
        }
        if (hashtable.containsKey("z_parameter")) {
            this.z_parameter = (String)hashtable.get("z_parameter");
        }
        if (hashtable.containsKey("z_unit")) {
            this.z_unit = (String)hashtable.get("z_unit");
        }
        if (hashtable.containsKey("z_fill")) {
            this.z_fill = ((Float)hashtable.get("z_fill")).floatValue();
        }
        if (hashtable.containsKey("y_coordinate")) {
            this.y_coordinate = (double[])hashtable.get("y_coordinate");
        }
        if (hashtable.containsKey("ny")) {
            this.ny = (Integer)hashtable.get("ny");
        }
        if (hashtable.containsKey("items")) {
            this.items = (Integer)hashtable.get("items");
        }
    }

    public DataSet getDataSet(Object object, pwDate pwDate2, pwDate pwDate3, double d) throws DasException {
        InputStream inputStream;
        double d2 = d;
        double d3 = d;
        double d4 = d3 = d3 > this.x_sample_width ? d3 : this.x_sample_width;
        if (this.isServerSideReduction()) {
            inputStream = this.standardDataStreamSource.getReducedInputStream(this, object, pwDate2, pwDate3, d);
            d2 = d > this.x_sample_width ? d : this.x_sample_width;
        } else {
            inputStream = this.standardDataStreamSource.getInputStream(this, object, pwDate2, pwDate3);
            d2 = this.x_sample_width;
        }
        XTaggedYScanDataSet xTaggedYScanDataSet = (XTaggedYScanDataSet)this.getDataSet(inputStream, object, pwDate2, pwDate3);
        xTaggedYScanDataSet.x_sample_width = d2;
        UnitsConverter unitsConverter = UnitsConverter.getConverter(Units.seconds, ((LocationUnits)this.getXUnits()).getOffsetUnits());
        xTaggedYScanDataSet.xSampleWidth = unitsConverter.convert(xTaggedYScanDataSet.x_sample_width);
        return xTaggedYScanDataSet;
    }

    public DataSet getDataSet(Object object, pwDate pwDate2, pwDate pwDate3) throws DasException {
        InputStream inputStream = this.standardDataStreamSource.getInputStream(this, object, pwDate2, pwDate3);
        XTaggedYScanDataSet xTaggedYScanDataSet = (XTaggedYScanDataSet)this.getDataSet(inputStream, object, pwDate2, pwDate3);
        return xTaggedYScanDataSet;
    }

    public DataSet getDataSet(InputStream inputStream, Object object, pwDate pwDate2, pwDate pwDate3) throws DasException {
        boolean bl;
        XTaggedYScanDataSet xTaggedYScanDataSet = new XTaggedYScanDataSet(this, pwDate2, pwDate3);
        xTaggedYScanDataSet.description = this.description;
        xTaggedYScanDataSet.x_parameter = this.x_parameter;
        xTaggedYScanDataSet.x_unit = this.x_unit;
        xTaggedYScanDataSet.x_sample_width = this.x_sample_width;
        UnitsConverter unitsConverter = UnitsConverter.getConverter(Units.seconds, ((LocationUnits)this.getXUnits()).getOffsetUnits());
        xTaggedYScanDataSet.xSampleWidth = unitsConverter.convert(xTaggedYScanDataSet.x_sample_width);
        xTaggedYScanDataSet.y_parameter = this.y_parameter;
        xTaggedYScanDataSet.y_unit = this.y_unit;
        xTaggedYScanDataSet.y_coordinate = (double[])this.y_coordinate.clone();
        xTaggedYScanDataSet.z_parameter = this.z_parameter;
        xTaggedYScanDataSet.z_unit = this.z_unit;
        xTaggedYScanDataSet.setZFill(this.z_fill);
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 50);
        try {
            bl = MultiPlanarDataSet.isMultiPlanarDataSetStream(pushbackInputStream);
        }
        catch (DasException dasException) {
            bl = false;
        }
        if (bl) {
            MultiPlanarDataSet multiPlanarDataSet = new MultiPlanarDataSet();
            try {
                System.out.println(multiPlanarDataSet.getDataSetNames());
                try {
                    DataRequestor dataRequestor = !(this.readerListener instanceof DataRequestor) ? null : (DataRequestor)((Object)this.readerListener);
                    multiPlanarDataSet.read(pushbackInputStream, dataRequestor);
                }
                catch (ClassCastException classCastException) {
                    System.out.println(classCastException);
                }
                xTaggedYScanDataSet = (XTaggedYScanDataSet)multiPlanarDataSet.getPrimaryDataSet();
                xTaggedYScanDataSet.setDataSetDescriptor(this);
            }
            catch (DasException dasException) {
                dasException.printStackTrace();
            }
        } else {
            float[] fArray = this.readFloats(pushbackInputStream, "", pwDate2, pwDate3);
            pwDie.println(TimeDatum.create(pwDate2));
            TimeDatum timeDatum = (TimeDatum)TimeDatum.create(pwDate2).convertTo(xTaggedYScanDataSet.getXUnits());
            int n = this.y_coordinate.length + 1;
            int n2 = fArray.length / n;
            xTaggedYScanDataSet.data = new XTaggedYScan[n2];
            double d = timeDatum.getValue();
            int n3 = 0;
            while (n3 < n2) {
                xTaggedYScanDataSet.data[n3] = new XTaggedYScan();
                xTaggedYScanDataSet.data[n3].x = d + unitsConverter.convert(fArray[n3 * n]);
                xTaggedYScanDataSet.data[n3].z = new float[n - 1];
                System.arraycopy(fArray, n3 * n + 1, xTaggedYScanDataSet.data[n3].z, 0, n - 1);
                ++n3;
            }
        }
        return xTaggedYScanDataSet;
    }

    public Units getYUnits() {
        return this.yUnits;
    }

    public pwAxis getZAxis(pwRow pwRow2, pwColumn pwColumn2) {
        return new pwAxis(new Datum(0.0, this.getZUnits()), new Datum(10.0, this.getZUnits()), pwRow2, pwColumn2, 3, false);
    }

    public Renderer getRenderer(pwPlot pwPlot2) {
        pwAxis pwAxis2 = this.getZAxis(pwPlot2.getRow(), pwPlot2.getColumn());
        pwColorBar pwColorBar2 = new pwColorBar(pwAxis2.getDataMinimum(), pwAxis2.getDataMaximum(), pwPlot2.getRow(), pwColorBar.getColorBarColumn(pwPlot2.getColumn()), pwAxis2.isLog());
        SpectrogramRenderer spectrogramRenderer = new SpectrogramRenderer(pwPlot2, this, pwColorBar2);
        return spectrogramRenderer;
    }

    public Units getZUnits() {
        return this.zUnits;
    }

    public void setServerSideReduction(boolean bl) {
        this.serverSideReduction = bl;
    }

    public boolean isServerSideReduction() {
        return this.serverSideReduction;
    }
}

