/*
 * Decompiled with CFR 0.152.
 */
package das_proto.data;

import das_proto.data.ConstantXTaggedYScanDataSetDescriptor;
import das_proto.data.DataSet;
import das_proto.data.Datum;
import das_proto.data.LocationUnits;
import das_proto.data.TimeDatum;
import das_proto.data.TimeLocationUnits;
import das_proto.data.Units;
import das_proto.data.UnitsConverter;
import das_proto.data.XTaggedYScan;
import das_proto.data.XTaggedYScanDataSetDescriptor;
import das_proto.data.rebinDescriptor;
import graph.SpectrogramRenderer;
import graph.pwAxis;
import graph.pwCanvas;
import graph.pwColorBar;
import graph.pwColumn;
import graph.pwPlot;
import graph.pwRow;
import graph.pwTimeAxis;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.LinkedList;
import javax.swing.JFrame;
import javax.swing.JPanel;
import util.pwDate;
import util.pwDie;

public class XTaggedYScanDataSet
extends DataSet
implements Serializable {
    public double x_sample_width;
    public double[] y_coordinate;
    private float z_fill = Float.NaN;
    public String description = "";
    public String x_parameter = "";
    public String x_unit = "";
    public String y_parameter = "";
    public String y_unit = "";
    public String z_parameter = "";
    public String z_unit = "";
    private Units yUnits = null;
    private Units zUnits = null;
    public XTaggedYScan[] data;
    private Hashtable auxData;
    public double ymin;
    public double ymax;
    public boolean yIsLog;
    public double zmin;
    public double zmax;
    public boolean zIsLog;
    private pwAxis xAxis = null;
    private pwAxis yAxis = null;
    public double xSampleWidth;
    private boolean nnRebin;

    public XTaggedYScanDataSet(XTaggedYScanDataSetDescriptor xTaggedYScanDataSetDescriptor) {
        super(xTaggedYScanDataSetDescriptor);
        if (xTaggedYScanDataSetDescriptor != null) {
            this.yUnits = xTaggedYScanDataSetDescriptor.getYUnits();
            this.zUnits = xTaggedYScanDataSetDescriptor.getZUnits();
        } else {
            this.yUnits = Units.dimensionless;
            this.zUnits = Units.dimensionless;
        }
        this.auxData = new Hashtable();
    }

    public XTaggedYScanDataSet(XTaggedYScanDataSetDescriptor xTaggedYScanDataSetDescriptor, pwDate pwDate2, pwDate pwDate3) {
        super(xTaggedYScanDataSetDescriptor, pwDate2, pwDate3);
        if (xTaggedYScanDataSetDescriptor != null) {
            this.yUnits = xTaggedYScanDataSetDescriptor.getYUnits();
            this.zUnits = xTaggedYScanDataSetDescriptor.getZUnits();
        } else {
            this.yUnits = Units.dimensionless;
            this.zUnits = Units.dimensionless;
        }
        this.auxData = new Hashtable();
    }

    public static XTaggedYScanDataSet create(XTaggedYScanDataSetDescriptor xTaggedYScanDataSetDescriptor, XTaggedYScan[] xTaggedYScanArray) {
        double d = Double.MAX_VALUE;
        double d2 = Double.MIN_VALUE;
        int n = 0;
        while (n < xTaggedYScanArray.length) {
            d = xTaggedYScanArray[n].x < d ? xTaggedYScanArray[n].x : d;
            d2 = xTaggedYScanArray[n].x > d2 ? xTaggedYScanArray[n].x : d2;
            ++n;
        }
        XTaggedYScanDataSet xTaggedYScanDataSet = new XTaggedYScanDataSet(xTaggedYScanDataSetDescriptor);
        if (xTaggedYScanDataSetDescriptor.getXUnits() instanceof TimeLocationUnits) {
            xTaggedYScanDataSet.setStartTime(pwDate.create(new TimeDatum(d, xTaggedYScanDataSetDescriptor.getXUnits())));
            xTaggedYScanDataSet.setEndTime(pwDate.create(new TimeDatum(d2, xTaggedYScanDataSetDescriptor.getXUnits())));
        }
        xTaggedYScanDataSet.data = xTaggedYScanArray;
        xTaggedYScanDataSet.y_coordinate = xTaggedYScanDataSetDescriptor.y_coordinate;
        xTaggedYScanDataSet.yUnits = xTaggedYScanDataSetDescriptor.getYUnits();
        xTaggedYScanDataSet.setXUnits(xTaggedYScanDataSetDescriptor.getXUnits());
        xTaggedYScanDataSet.zUnits = xTaggedYScanDataSetDescriptor.getZUnits();
        return xTaggedYScanDataSet;
    }

    public String toString() {
        return this.getClass().getName() + "[Description = \"" + this.description + "\" Start time = " + this.startTime + " End time = " + this.endTime + "]";
    }

    public void setZFill(float f) {
        if (Float.isNaN(f)) {
            throw new IllegalArgumentException("zFill cannot be NaN");
        }
        this.z_fill = f;
        if (this.data == null) {
            return;
        }
        XTaggedYScan[] xTaggedYScanArray = this.getWeights();
        int n = 0;
        while (n < this.data.length) {
            int n2 = 0;
            while (n2 < this.y_coordinate.length) {
                if (this.data[n].z[n2] == this.z_fill) {
                    xTaggedYScanArray[n].z[n2] = 0.0f;
                }
                ++n2;
            }
            ++n;
        }
        this.setWeights(xTaggedYScanArray);
    }

    public float getZFill() {
        return this.z_fill;
    }

    public XTaggedYScanDataSet rebin(rebinDescriptor rebinDescriptor2, rebinDescriptor rebinDescriptor3) {
        pwDie.println(" rebin: " + this.x_sample_width + " to " + rebinDescriptor2.binWidth());
        XTaggedYScanDataSet xTaggedYScanDataSet = this.binAverage(rebinDescriptor2, rebinDescriptor3);
        xTaggedYScanDataSet.setNnRebin(this.isNnRebin());
        xTaggedYScanDataSet.fillInterpolateY(rebinDescriptor3.isLog);
        xTaggedYScanDataSet.fillInterpolateX();
        return xTaggedYScanDataSet;
    }

    public XTaggedYScan[] getWeights() {
        XTaggedYScan[] xTaggedYScanArray;
        if (this.auxData.containsKey("weights")) {
            xTaggedYScanArray = (XTaggedYScan[])this.auxData.get("weights");
        } else {
            xTaggedYScanArray = new XTaggedYScan[this.data.length];
            int n = 0;
            while (n < xTaggedYScanArray.length) {
                float[] fArray = new float[this.y_coordinate.length];
                float f = this.getZFill();
                int n2 = 0;
                while (n2 < this.y_coordinate.length) {
                    fArray[n2] = this.data[n].z[n2] == f ? 0.0f : 1.0f;
                    ++n2;
                }
                xTaggedYScanArray[n] = new XTaggedYScan(this.data[n].x, fArray);
                ++n;
            }
            this.auxData.put("weights", xTaggedYScanArray);
        }
        return xTaggedYScanArray;
    }

    public void setWeights(XTaggedYScan[] xTaggedYScanArray) {
        if (xTaggedYScanArray.length != this.data.length || xTaggedYScanArray.length > 0 && xTaggedYScanArray[0].z.length != this.data[0].z.length) {
            throw new IllegalArgumentException("weights array doesn't match dimensions of data");
        }
        this.auxData.put("weights", xTaggedYScanArray);
    }

    public XTaggedYScan[] getPeaks() {
        if (this.auxData.containsKey("peaks")) {
            return (XTaggedYScan[])this.auxData.get("peaks");
        }
        XTaggedYScan[] xTaggedYScanArray = new XTaggedYScan[this.data.length];
        int n = 0;
        while (n < xTaggedYScanArray.length) {
            float[] fArray = new float[this.y_coordinate.length];
            int n2 = 0;
            while (n2 < this.y_coordinate.length) {
                fArray[n2] = this.data[n].z[n2];
                ++n2;
            }
            xTaggedYScanArray[n] = new XTaggedYScan(this.data[n].x, fArray);
            ++n;
        }
        this.auxData.put("peaks", xTaggedYScanArray);
        return xTaggedYScanArray;
    }

    public void setPeaks(XTaggedYScan[] xTaggedYScanArray) {
        if (xTaggedYScanArray.length != this.data.length || xTaggedYScanArray.length > 0 && xTaggedYScanArray[0].z.length != this.data[0].z.length) {
            throw new IllegalArgumentException("peaks array doesn't match dimensions of data");
        }
        this.auxData.put("peaks", xTaggedYScanArray);
    }

    public XTaggedYScanDataSet binAverageX(rebinDescriptor rebinDescriptor2) {
        int n;
        float[] fArray;
        int n2 = this.y_coordinate.length;
        int n3 = this.data.length;
        double[] dArray = rebinDescriptor2.binCenters();
        float f = -1.0E31f;
        XTaggedYScan[] xTaggedYScanArray = null;
        XTaggedYScan[] xTaggedYScanArray2 = null;
        XTaggedYScan[] xTaggedYScanArray3 = null;
        XTaggedYScan[] xTaggedYScanArray4 = null;
        XTaggedYScan[] xTaggedYScanArray5 = null;
        xTaggedYScanArray = new XTaggedYScan[rebinDescriptor2.nBin];
        xTaggedYScanArray5 = new XTaggedYScan[rebinDescriptor2.nBin];
        xTaggedYScanArray4 = this.getWeights();
        int n4 = 0;
        while (n4 < rebinDescriptor2.nBin) {
            float[] fArray2 = new float[n2];
            Arrays.fill(fArray2, 0.0f);
            xTaggedYScanArray[n4] = new XTaggedYScan(dArray[n4], fArray2);
            fArray = new float[n2];
            Arrays.fill(fArray, 0.0f);
            xTaggedYScanArray5[n4] = new XTaggedYScan(dArray[n4], fArray);
            ++n4;
        }
        if (this.auxData.containsKey("peaks")) {
            xTaggedYScanArray2 = (XTaggedYScan[])this.auxData.get("peaks");
            xTaggedYScanArray3 = new XTaggedYScan[rebinDescriptor2.nBin];
            int n5 = 0;
            while (n5 < rebinDescriptor2.nBin) {
                fArray = new float[n2];
                Arrays.fill(fArray, f);
                xTaggedYScanArray3[n5] = new XTaggedYScan(dArray[n5], fArray);
                ++n5;
            }
        }
        int n6 = 0;
        while (n6 < n3) {
            int n7 = rebinDescriptor2.whichBin(this.data[n6].x, this.getXUnits());
            if (n7 >= 0 && n7 < xTaggedYScanArray.length) {
                n = 0;
                while (n < n2) {
                    int n8 = n;
                    xTaggedYScanArray[n7].z[n8] = xTaggedYScanArray[n7].z[n8] + this.data[n6].z[n] * xTaggedYScanArray4[n6].z[n];
                    int n9 = n;
                    xTaggedYScanArray5[n7].z[n9] = xTaggedYScanArray5[n7].z[n9] + xTaggedYScanArray4[n6].z[n];
                    if (xTaggedYScanArray2 != null) {
                        xTaggedYScanArray3[n7].z[n] = xTaggedYScanArray3[n7].z[n] > xTaggedYScanArray2[n6].z[n] ? xTaggedYScanArray3[n7].z[n] : xTaggedYScanArray2[n6].z[n];
                    }
                    ++n;
                }
            }
            ++n6;
        }
        int n10 = 0;
        while (n10 < rebinDescriptor2.nBin) {
            n = 0;
            while (n < n2) {
                if (xTaggedYScanArray5[n10].z[n] > 0.0f) {
                    xTaggedYScanArray[n10].z[n] = xTaggedYScanArray[n10].z[n] / xTaggedYScanArray5[n10].z[n];
                }
                ++n;
            }
            ++n10;
        }
        XTaggedYScanDataSet xTaggedYScanDataSet = XTaggedYScanDataSet.create((XTaggedYScanDataSetDescriptor)this.getDataSetDescriptor(), xTaggedYScanArray);
        xTaggedYScanDataSet.setWeights(xTaggedYScanArray5);
        if (xTaggedYScanArray3 != null) {
            xTaggedYScanDataSet.setPeaks(xTaggedYScanArray3);
        }
        xTaggedYScanDataSet.xSampleWidth = rebinDescriptor2.binWidth();
        return xTaggedYScanDataSet;
    }

    public XTaggedYScanDataSet binAverage(rebinDescriptor rebinDescriptor2, rebinDescriptor rebinDescriptor3) {
        int n;
        int n2;
        long l = System.currentTimeMillis();
        XTaggedYScanDataSet xTaggedYScanDataSet = new XTaggedYScanDataSet((XTaggedYScanDataSetDescriptor)this.getDataSetDescriptor(), this.startTime, this.endTime);
        xTaggedYScanDataSet.x_sample_width = this.x_sample_width;
        xTaggedYScanDataSet.xSampleWidth = this.xSampleWidth;
        xTaggedYScanDataSet.z_fill = this.z_fill;
        xTaggedYScanDataSet.zUnits = this.zUnits;
        xTaggedYScanDataSet.yUnits = this.yUnits;
        double[] dArray = rebinDescriptor2.binCenters();
        int n3 = rebinDescriptor2.numberOfBins();
        int n4 = rebinDescriptor3.numberOfBins();
        XTaggedYScan[] xTaggedYScanArray = new XTaggedYScan[n3];
        XTaggedYScan[] xTaggedYScanArray2 = new XTaggedYScan[n3];
        float[] fArray = new float[n4];
        int n5 = 0;
        while (n5 < n3) {
            xTaggedYScanArray[n5] = new XTaggedYScan(dArray[n5], fArray);
            xTaggedYScanArray2[n5] = new XTaggedYScan(dArray[n5], fArray);
            ++n5;
        }
        xTaggedYScanDataSet.data = xTaggedYScanArray;
        double[] dArray2 = new double[rebinDescriptor3.numberOfBins()];
        double[] dArray3 = rebinDescriptor3.binCenters();
        int n6 = 0;
        while (n6 < dArray2.length) {
            dArray2[n6] = dArray3[n6];
            ++n6;
        }
        xTaggedYScanDataSet.y_coordinate = dArray2;
        XTaggedYScan[] xTaggedYScanArray3 = this.getWeights();
        int[] nArray = new int[this.y_coordinate.length];
        int n7 = 0;
        while (n7 < this.y_coordinate.length) {
            nArray[n7] = rebinDescriptor3.whichBin(this.y_coordinate[n7], this.yUnits);
            ++n7;
        }
        int n8 = 0;
        while (n8 < this.data.length) {
            n2 = rebinDescriptor2.whichBin(this.data[n8].x, this.getXUnits());
            if (n2 >= 0 && n2 < n3) {
                n = 0;
                while (n < this.y_coordinate.length) {
                    if (nArray[n] >= 0 && nArray[n] < n4) {
                        if (xTaggedYScanArray3 != null) {
                            xTaggedYScanArray[n2].z[nArray[n]] = xTaggedYScanArray[n2].z[nArray[n]] + this.data[n8].z[n] * xTaggedYScanArray3[n8].z[n];
                            xTaggedYScanArray2[n2].z[nArray[n]] = xTaggedYScanArray2[n2].z[nArray[n]] + xTaggedYScanArray3[n8].z[n];
                        } else {
                            xTaggedYScanArray[n2].z[nArray[n]] = xTaggedYScanArray[n2].z[nArray[n]] + this.data[n8].z[n] * 1.0f;
                            xTaggedYScanArray2[n2].z[nArray[n]] = xTaggedYScanArray2[n2].z[nArray[n]] + 1.0f;
                        }
                    }
                    ++n;
                }
            }
            ++n8;
        }
        n2 = 0;
        while (n2 < n3) {
            n = 0;
            while (n < n4) {
                xTaggedYScanArray[n2].z[n] = (double)xTaggedYScanArray2[n2].z[n] > 0.0 ? xTaggedYScanArray[n2].z[n] / xTaggedYScanArray2[n2].z[n] : this.z_fill;
                ++n;
            }
            ++n2;
        }
        xTaggedYScanDataSet.setWeights(xTaggedYScanArray2);
        return xTaggedYScanDataSet;
    }

    protected void fillInterpolateY(boolean bl) {
        int n;
        boolean bl2 = this.isNnRebin();
        int n2 = this.y_coordinate.length;
        int n3 = this.data.length;
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        double[] dArray = new double[this.y_coordinate.length];
        if (bl) {
            n = 0;
            while (n < n2) {
                dArray[n] = Math.log(this.y_coordinate[n]);
                ++n;
            }
        } else {
            n = 0;
            while (n < n2) {
                dArray[n] = this.y_coordinate[n];
                ++n;
            }
        }
        XTaggedYScan[] xTaggedYScanArray = this.getWeights();
        int n4 = 0;
        while (n4 < n3) {
            int n5;
            int n6 = -1;
            int n7 = -1;
            int n8 = 0;
            while (n8 < n2) {
                if ((double)xTaggedYScanArray[n4].z[n8] > 0.0 && n6 == n8 - 1) {
                    nArray[n8] = -1;
                    nArray2[n8] = -1;
                    n6 = n8;
                } else if ((double)xTaggedYScanArray[n4].z[n8] > 0.0 && n6 == -1) {
                    n6 = n8;
                } else if ((double)xTaggedYScanArray[n4].z[n8] > 0.0 && n6 < n8 - 1) {
                    if (n6 > -1) {
                        nArray[n8] = -1;
                        nArray2[n8] = -1;
                        n5 = n8 - 1;
                        while (n5 >= n6) {
                            n7 = n8;
                            nArray[n5] = n6;
                            nArray2[n5] = n7;
                            --n5;
                        }
                        n6 = n8;
                    }
                } else {
                    nArray[n8] = -1;
                    nArray2[n8] = -1;
                }
                ++n8;
            }
            n5 = 0;
            while (n5 < n2) {
                if (nArray[n5] != -1) {
                    float f = (float)((dArray[n5] - dArray[nArray[n5]]) / (dArray[nArray2[n5]] - dArray[nArray[n5]]));
                    if (bl2) {
                        f = f < 0.5f ? 0.0f : 1.0f;
                    }
                    float f2 = 1.0f - f;
                    this.data[n4].z[n5] = this.data[n4].z[nArray[n5]] * f2 + this.data[n4].z[nArray2[n5]] * f;
                    xTaggedYScanArray[n4].z[n5] = xTaggedYScanArray[n4].z[nArray[n5]] * f2 + xTaggedYScanArray[n4].z[nArray2[n5]] * f;
                }
                ++n5;
            }
            ++n4;
        }
    }

    protected void fillInterpolateX() {
        boolean bl = this.isNnRebin();
        int n = this.data.length;
        int n2 = this.y_coordinate.length;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        double[] dArray = new double[n];
        int n3 = 0;
        while (n3 < n) {
            dArray[n3] = this.data[n3].x;
            ++n3;
        }
        XTaggedYScan[] xTaggedYScanArray = this.getWeights();
        int n4 = 0;
        while (n4 < n2) {
            int n5;
            int n6 = -1;
            int n7 = -1;
            int n8 = 0;
            while (n8 < n) {
                if ((double)xTaggedYScanArray[n8].z[n4] > 0.0 && n6 == n8 - 1) {
                    nArray[n8] = -1;
                    nArray2[n8] = -1;
                    n6 = n8;
                } else if ((double)xTaggedYScanArray[n8].z[n4] > 0.0 && n6 == -1) {
                    n6 = n8;
                } else if ((double)xTaggedYScanArray[n8].z[n4] > 0.0 && n6 < n8 - 1) {
                    if (n6 > -1) {
                        nArray[n8] = -1;
                        nArray2[n8] = -1;
                        n5 = n8 - 1;
                        while (n5 > n6) {
                            n7 = n8;
                            nArray[n5] = n6;
                            nArray2[n5] = n7;
                            --n5;
                        }
                        n6 = n8;
                    }
                } else {
                    nArray[n8] = -1;
                    nArray2[n8] = -1;
                }
                ++n8;
            }
            n5 = 0;
            while (n5 < n) {
                if (nArray[n5] != -1 && dArray[nArray2[n5]] - dArray[nArray[n5]] < this.xSampleWidth * 2.0) {
                    float f = (float)((dArray[n5] - dArray[nArray[n5]]) / (dArray[nArray2[n5]] - dArray[nArray[n5]]));
                    if (bl) {
                        f = f < 0.5f ? 0.0f : 1.0f;
                    }
                    float f2 = 1.0f - f;
                    this.data[n5].z[n4] = this.data[nArray[n5]].z[n4] * f2 + this.data[nArray2[n5]].z[n4] * f;
                    xTaggedYScanArray[n5].z[n4] = xTaggedYScanArray[nArray[n5]].z[n4] * f2 + xTaggedYScanArray[nArray2[n5]].z[n4] * f;
                }
                ++n5;
            }
            ++n4;
        }
    }

    public XTaggedYScanDataSet append(XTaggedYScanDataSet xTaggedYScanDataSet) {
        if (this.getXUnits() != xTaggedYScanDataSet.getXUnits()) {
            throw new IllegalArgumentException("xValues have different units");
        }
        if (this.yUnits != xTaggedYScanDataSet.yUnits) {
            throw new IllegalArgumentException("yValues have different units");
        }
        if (this.zUnits != xTaggedYScanDataSet.zUnits) {
            throw new IllegalArgumentException("zValues have different units");
        }
        if (this.y_coordinate.length != xTaggedYScanDataSet.y_coordinate.length) {
            throw new IllegalArgumentException("incompatible data sets have differing y_coordinates");
        }
        int n = 0;
        while (n < xTaggedYScanDataSet.y_coordinate.length) {
            if (this.y_coordinate[n] != xTaggedYScanDataSet.y_coordinate[n]) {
                throw new IllegalArgumentException("incompatible data sets have differing y_coordinates");
            }
            ++n;
        }
        XTaggedYScanDataSet xTaggedYScanDataSet2 = new XTaggedYScanDataSet((XTaggedYScanDataSetDescriptor)this.getDataSetDescriptor(), this.getStartTime(), xTaggedYScanDataSet.getEndTime());
        int n2 = this.data.length;
        if (this.data.length == 0) {
            return xTaggedYScanDataSet;
        }
        int n3 = 0;
        while (n3 < xTaggedYScanDataSet.data.length - 1 && xTaggedYScanDataSet.data[n3].x < this.data[n2 - 1].x) {
            ++n3;
        }
        if (n3 == xTaggedYScanDataSet.data.length - 1) {
            return this;
        }
        int n4 = xTaggedYScanDataSet.data.length - n3;
        XTaggedYScan[] xTaggedYScanArray = new XTaggedYScan[n2 + n4];
        int n5 = 0;
        while (n5 < n2) {
            xTaggedYScanArray[n5] = this.data[n5];
            ++n5;
        }
        int n6 = 0;
        while (n6 < n4) {
            xTaggedYScanArray[n6 + n2] = xTaggedYScanDataSet.data[n6 + n3];
            ++n6;
        }
        xTaggedYScanDataSet2.data = xTaggedYScanArray;
        if (this.auxData != null) {
            Object[] objectArray = this.auxData.keySet().toArray();
            int n7 = 0;
            while (n7 < objectArray.length) {
                Object object = objectArray[n7];
                if (xTaggedYScanDataSet.auxData.containsKey(object)) {
                    XTaggedYScan[] xTaggedYScanArray2 = (XTaggedYScan[])this.auxData.get(object);
                    XTaggedYScan[] xTaggedYScanArray3 = (XTaggedYScan[])xTaggedYScanDataSet.auxData.get(object);
                    XTaggedYScan[] xTaggedYScanArray4 = new XTaggedYScan[n2 + n4];
                    int n8 = 0;
                    while (n8 < n2) {
                        xTaggedYScanArray4[n8] = xTaggedYScanArray2[n8];
                        ++n8;
                    }
                    int n9 = 0;
                    while (n9 < n4) {
                        xTaggedYScanArray4[n9 + n2] = xTaggedYScanArray3[n9];
                        ++n9;
                    }
                    xTaggedYScanDataSet2.auxData.put(object, xTaggedYScanArray4);
                }
                ++n7;
            }
        }
        xTaggedYScanDataSet2.x_sample_width = Math.max(this.x_sample_width, xTaggedYScanDataSet.x_sample_width);
        xTaggedYScanDataSet2.xSampleWidth = Math.max(this.xSampleWidth, xTaggedYScanDataSet.xSampleWidth);
        xTaggedYScanDataSet2.y_coordinate = this.y_coordinate;
        return xTaggedYScanDataSet2;
    }

    public static XTaggedYScanDataSet create(double[] dArray, double[] dArray2, float[][] fArray) {
        return XTaggedYScanDataSet.create(dArray, Units.dimensionless, dArray2, Units.dimensionless, fArray, Units.dimensionless);
    }

    public static XTaggedYScanDataSet create(double[] dArray, Units units, double[] dArray2, Units units2, float[][] fArray, Units units3) {
        if (dArray.length != fArray.length) {
            throw new IllegalArgumentException("x.length!=z.length");
        }
        if (fArray.length != 0 && dArray2.length != fArray[0].length) {
            throw new IllegalArgumentException("y.length!=z[0].length");
        }
        XTaggedYScanDataSet xTaggedYScanDataSet = new XTaggedYScanDataSet(null);
        xTaggedYScanDataSet.data = new XTaggedYScan[dArray.length];
        int n = 0;
        while (n < dArray.length) {
            xTaggedYScanDataSet.data[n] = new XTaggedYScan(dArray[n], fArray[n]);
            ++n;
        }
        xTaggedYScanDataSet.y_coordinate = (double[])dArray2.clone();
        float f = -3.4028235E38f;
        xTaggedYScanDataSet.setZFill(f);
        xTaggedYScanDataSet.setXUnits(units);
        return xTaggedYScanDataSet;
    }

    public pwAxis createXAxis(pwRow pwRow2, pwColumn pwColumn2) {
        int n = this.data.length;
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = this.data[n2].x;
            ++n2;
        }
        Units units = this.getXUnits();
        if (dArray[dArray.length - 1] / dArray[0] > 1000.0 && dArray[0] > 0.0 && !(units instanceof LocationUnits)) {
            boolean bl = true;
        } else {
            boolean bl = false;
        }
        if (!(this.getXUnits() instanceof TimeLocationUnits)) {
            return pwAxis.create(dArray, this.getXUnits(), pwRow2, pwColumn2, 2, false);
        }
        return pwTimeAxis.create(dArray, this.getXUnits(), pwRow2, pwColumn2, 2);
    }

    public pwAxis createYAxis(pwRow pwRow2, pwColumn pwColumn2) {
        double[] dArray = this.y_coordinate;
        Units units = this.getYUnits();
        boolean bl = dArray[dArray.length - 1] / dArray[0] > 1000.0 && dArray[0] > 0.0 && !(units instanceof LocationUnits);
        return pwAxis.create(dArray, this.yUnits, pwRow2, pwColumn2, 3, bl);
    }

    public pwAxis getXAxis(pwRow pwRow2, pwColumn pwColumn2) {
        if (this.xAxis == null) {
            this.xAxis = this.createXAxis(pwRow2, pwColumn2);
        }
        return this.xAxis;
    }

    public void setXAxis(pwAxis pwAxis2) {
        this.xAxis = pwAxis2;
    }

    public pwAxis getYAxis(pwRow pwRow2, pwColumn pwColumn2) {
        if (this.yAxis == null) {
            this.yAxis = this.createYAxis(pwRow2, pwColumn2);
        }
        return this.yAxis;
    }

    public void setYAxis(pwAxis pwAxis2) {
        this.yAxis = pwAxis2;
    }

    public Units getYUnits() {
        return this.yUnits;
    }

    public Units getZUnits() {
        return this.zUnits;
    }

    public void dumpToStream(OutputStream outputStream) {
        UnitsConverter unitsConverter = ((LocationUnits)this.getXUnits()).getOffsetUnits().getConverter(Units.seconds);
        PrintStream printStream = new PrintStream(outputStream);
        printStream.println("# Start Time: " + this.getStartTime());
        printStream.println("# End Time: " + this.getEndTime());
        printStream.println("# xSampleWidth: " + unitsConverter.convert(this.xSampleWidth));
        printStream.println("# X is first value, offset in seconds from Start Time.");
        printStream.println("#");
        printStream.println("# File created on: " + TimeDatum.now().toString() + " UT");
        String string = "\t";
        printStream.print("yValues:" + string);
        int n = 0;
        while (n < this.y_coordinate.length) {
            printStream.print("" + this.y_coordinate[n] + string);
            ++n;
        }
        printStream.println();
        TimeDatum timeDatum = TimeDatum.create(this.getStartTime());
        double d = timeDatum.convertTo(this.getXUnits()).doubleValue();
        int n2 = 0;
        while (n2 < this.data.length) {
            printStream.print("" + unitsConverter.convert(this.data[n2].x - d) + string);
            int n3 = 0;
            while (n3 < this.y_coordinate.length) {
                printStream.print("" + this.data[n2].z[n3] + string);
                ++n3;
            }
            printStream.println();
            ++n2;
        }
    }

    public void visualize() {
        pwCanvas pwCanvas2 = new pwCanvas(640, 480);
        pwRow pwRow2 = pwRow.create(pwCanvas2);
        pwColumn pwColumn2 = pwColumn.create(pwCanvas2);
        pwAxis pwAxis2 = this.createXAxis(pwRow2, pwColumn2);
        pwAxis pwAxis3 = this.createYAxis(pwRow2, pwColumn2);
        pwColorBar pwColorBar2 = new pwColorBar(new Datum(1.0E-15), new Datum(1.0E-13), pwRow2, pwColorBar.getColorBarColumn(pwColumn2), true);
        SpectrogramRenderer spectrogramRenderer = new SpectrogramRenderer(new ConstantXTaggedYScanDataSetDescriptor(this), pwColorBar2);
        pwPlot pwPlot2 = new pwPlot(pwAxis2, pwAxis3, pwRow2, pwColumn2);
        pwPlot2.addRenderer(spectrogramRenderer);
        pwCanvas2.addCanvasComponent(pwPlot2);
        JFrame jFrame = new JFrame("Visualize()");
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)pwCanvas2, "Center");
        jFrame.setContentPane(jPanel);
        jFrame.pack();
        jFrame.setVisible(true);
        jFrame.setDefaultCloseOperation(2);
    }

    public Datum getClosestZValue(Datum datum, Datum datum2) {
        int n;
        long l = System.currentTimeMillis();
        if (!datum.getUnits().equals(this.getXUnits()) || !datum2.getUnits().equals(this.getYUnits())) {
            throw new IllegalArgumentException("x and y units must be the same as the units for this dataset");
        }
        XTaggedYScan xTaggedYScan = new XTaggedYScan(datum.getValue(), new float[0]);
        int n2 = Arrays.binarySearch(this.data, xTaggedYScan, new XTagComparator());
        if (n2 < 0) {
            n = -(n2 + 1);
            n2 = n == 0 ? 0 : (n == this.data.length ? this.data.length - 1 : n);
        }
        if ((n = Arrays.binarySearch(this.y_coordinate, datum2.getValue())) < 0) {
            int n3 = -(n + 1);
            n = n3 == 0 ? 0 : (n3 == this.data.length ? this.data.length - 1 : n3);
        }
        Datum datum3 = new Datum(this.data[n2].z[n], this.zUnits);
        return datum3;
    }

    public XTaggedYScanDataSet binAverageX(Datum datum) {
        XTaggedYScan[] xTaggedYScanArray;
        Serializable serializable;
        double d = this.data[0].x;
        Units units = ((LocationUnits)this.getXUnits()).getOffsetUnits();
        UnitsConverter unitsConverter = datum.getUnits().getConverter(units);
        double d2 = datum.convertTo(units).doubleValue();
        LinkedList<XTaggedYScan> linkedList = new LinkedList<XTaggedYScan>();
        LinkedList<XTaggedYScan> linkedList2 = new LinkedList<XTaggedYScan>();
        int n = 0;
        int n2 = -1;
        XTaggedYScan xTaggedYScan = new XTaggedYScan(0.0, new float[this.data[0].z.length]);
        XTaggedYScan xTaggedYScan2 = new XTaggedYScan(0.0, new float[this.data[0].z.length]);
        XTaggedYScan[] xTaggedYScanArray2 = this.getWeights();
        while (n < this.data.length) {
            int n3;
            serializable = this.data[n];
            xTaggedYScanArray = xTaggedYScanArray2[n];
            int n4 = (int)((((XTaggedYScan)serializable).x - d) / d2);
            if (n4 != n2) {
                if (xTaggedYScan.x != 0.0) {
                    n3 = 0;
                    while (n3 < xTaggedYScan2.z.length) {
                        xTaggedYScan2.z[n3] = xTaggedYScan2.z[n3] / xTaggedYScan.z[n3];
                        ++n3;
                    }
                    xTaggedYScan2.x = d + ((double)n2 + 0.5) * d2;
                    linkedList.add(xTaggedYScan2);
                    linkedList2.add(xTaggedYScan);
                }
                n2 = n4;
                xTaggedYScan = new XTaggedYScan(0.0, new float[this.data[0].z.length]);
                xTaggedYScan2 = new XTaggedYScan(0.0, new float[this.data[0].z.length]);
            }
            if (n4 >= 0) {
                xTaggedYScan.x += 1.0;
                n3 = 0;
                while (n3 < xTaggedYScan2.z.length) {
                    if (((XTaggedYScan)serializable).z[n3] != this.getZFill()) {
                        int n5 = n3;
                        xTaggedYScan2.z[n5] = xTaggedYScan2.z[n5] + ((XTaggedYScan)serializable).z[n3] * xTaggedYScanArray.z[n3];
                        int n6 = n3;
                        xTaggedYScan.z[n6] = xTaggedYScan.z[n6] + xTaggedYScanArray.z[n3];
                    }
                    ++n3;
                }
            }
            ++n;
        }
        if (xTaggedYScan.x != 0.0) {
            int n7 = 0;
            while (n7 < xTaggedYScan2.z.length) {
                xTaggedYScan2.z[n7] = xTaggedYScan2.z[n7] / xTaggedYScan.z[n7];
                ++n7;
            }
            xTaggedYScan2.x = d + ((double)n2 + 0.5) * d2;
        }
        serializable = new XTaggedYScanDataSet((XTaggedYScanDataSetDescriptor)this.getDataSetDescriptor(), this.startTime, this.endTime);
        ((XTaggedYScanDataSet)serializable).xSampleWidth = d2 * 2.0 < this.xSampleWidth ? this.xSampleWidth : d2 * 2.0;
        ((XTaggedYScanDataSet)serializable).x_sample_width = ((LocationUnits)this.getXUnits()).getOffsetUnits().getConverter(Units.seconds).convert(((XTaggedYScanDataSet)serializable).xSampleWidth);
        ((XTaggedYScanDataSet)serializable).data = new XTaggedYScan[linkedList.size()];
        linkedList.toArray(((XTaggedYScanDataSet)serializable).data);
        xTaggedYScanArray = new XTaggedYScan[linkedList2.size()];
        linkedList2.toArray(xTaggedYScanArray);
        ((XTaggedYScanDataSet)serializable).setWeights(xTaggedYScanArray);
        ((XTaggedYScanDataSet)serializable).y_coordinate = this.y_coordinate;
        return serializable;
    }

    public boolean isNnRebin() {
        return this.nnRebin;
    }

    public void setNnRebin(boolean bl) {
        this.nnRebin = bl;
    }

    private static class XTagComparator
    implements Comparator {
        private XTagComparator() {
        }

        public int compare(Object object, Object object2) {
            XTaggedYScan xTaggedYScan = (XTaggedYScan)object;
            XTaggedYScan xTaggedYScan2 = (XTaggedYScan)object2;
            return xTaggedYScan.x < xTaggedYScan2.x ? -1 : (xTaggedYScan.x > xTaggedYScan2.x ? 1 : 0);
        }
    }
}

