/*
 * Decompiled with CFR 0.152.
 */
package das_proto.data;

import das_proto.DasException;
import das_proto.data.DataSet;
import das_proto.data.DataSetDescriptor;
import das_proto.data.Datum;
import das_proto.data.LocationUnits;
import das_proto.data.TCADataSet;
import das_proto.data.TimeDatum;
import das_proto.data.Units;
import das_proto.data.UnitsConverter;
import das_proto.data.XMultiY;
import das_proto.data.XMultiYDataSet;
import graph.Renderer;
import graph.SymbolLineRenderer;
import graph.pwAxis;
import graph.pwColumn;
import graph.pwPlot;
import graph.pwRow;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import util.pwDate;

public class XMultiYDataSetDescriptor
extends DataSetDescriptor {
    public double y_fill = Double.NaN;
    public String y_parameter = "";
    public String y_unit = "";
    public int ny = -1;
    public int items = -1;
    private Units yUnits = Units.dimensionless;

    protected XMultiYDataSetDescriptor(Hashtable hashtable) {
        super(Units.us2000);
        if (hashtable != null) {
            this.setProperties(hashtable);
        }
    }

    public void setProperties(Hashtable hashtable) {
        super.setProperties(hashtable);
        if (hashtable.containsKey("description")) {
            this.description = (String)hashtable.get("description");
        }
        if (hashtable.containsKey("form")) {
            this.form = (String)hashtable.get("form");
        }
        if (hashtable.containsKey("reader")) {
            this.reader = (String)hashtable.get("reader");
        }
        if (hashtable.containsKey("x_parameter")) {
            this.x_parameter = (String)hashtable.get("x_parameter");
        }
        if (hashtable.containsKey("x_unit")) {
            this.x_unit = (String)hashtable.get("x_unit");
        }
        if (hashtable.containsKey("y_parameter")) {
            this.y_parameter = (String)hashtable.get("y_parameter");
        }
        if (hashtable.containsKey("y_unit")) {
            this.y_unit = (String)hashtable.get("y_unit");
        }
        if (hashtable.containsKey("x_sample_width")) {
            this.x_sample_width = (Double)hashtable.get("x_sample_width");
        }
        if (hashtable.containsKey("y_fill")) {
            this.y_fill = (Double)hashtable.get("y_fill");
        }
        if (hashtable.containsKey("ny")) {
            this.ny = (Integer)hashtable.get("ny");
        }
        if (hashtable.containsKey("items")) {
            this.items = (Integer)hashtable.get("items");
        }
    }

    public DataSet getDataSet(InputStream inputStream, Object object, pwDate pwDate2, pwDate pwDate3) throws DasException {
        if (this.ny != -1) {
            XMultiYDataSet xMultiYDataSet = new XMultiYDataSet(this, pwDate2, pwDate3);
            xMultiYDataSet.description = this.description;
            xMultiYDataSet.x_parameter = this.x_parameter;
            xMultiYDataSet.x_unit = this.x_unit;
            xMultiYDataSet.x_sample_width = this.x_sample_width;
            UnitsConverter unitsConverter = Units.getConverter(Units.seconds, ((LocationUnits)this.getXUnits()).getOffsetUnits());
            xMultiYDataSet.xSampleWidth = unitsConverter.convert(this.x_sample_width);
            xMultiYDataSet.y_parameter = this.y_parameter;
            xMultiYDataSet.y_unit = this.y_unit;
            xMultiYDataSet.y_fill = this.y_fill;
            xMultiYDataSet.ny = this.ny;
            int n = this.ny + 1;
            TimeDatum timeDatum = (TimeDatum)TimeDatum.create(pwDate2).convertTo(xMultiYDataSet.getXUnits());
            double[] dArray = this.readDoubles(inputStream, "", pwDate2, pwDate3);
            int n2 = dArray.length / n;
            xMultiYDataSet.data = new XMultiY[n2];
            double d = timeDatum.getValue();
            int n3 = 0;
            while (n3 < n2) {
                xMultiYDataSet.data[n3] = new XMultiY();
                xMultiYDataSet.data[n3].x = d + unitsConverter.convert(dArray[n3 * n]);
                xMultiYDataSet.data[n3].y = new double[n - 1];
                System.arraycopy(dArray, n3 * n + 1, xMultiYDataSet.data[n3].y, 0, n - 1);
                ++n3;
            }
            return xMultiYDataSet;
        }
        TCADataSet tCADataSet = new TCADataSet(this, pwDate2, pwDate3);
        tCADataSet.description = this.description;
        tCADataSet.items = this.items;
        tCADataSet.label = new String[this.items];
        Arrays.fill(tCADataSet.label, "");
        Enumeration enumeration = this.properties.keys();
        Pattern pattern = Pattern.compile("label\\(\\d+\\)");
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Matcher matcher = pattern.matcher(string);
            if (!matcher.matches()) continue;
            int n = Integer.parseInt(string.substring(6, string.length() - 1).trim());
            tCADataSet.label[n] = this.properties.get(string).toString();
        }
        int n = this.items + 1;
        double[] dArray = this.readDoubles(inputStream, object, pwDate2, pwDate3);
        int n4 = dArray.length / n;
        tCADataSet.data = new XMultiY[n4];
        int n5 = 0;
        while (n5 < n4) {
            tCADataSet.data[n5] = new XMultiY();
            tCADataSet.data[n5].x = dArray[n5 * n];
            tCADataSet.data[n5].y = new double[n - 1];
            System.arraycopy(dArray, n5 * n + 1, tCADataSet.data[n5].y, 0, n - 1);
            ++n5;
        }
        return tCADataSet;
    }

    public Units getYUnits() {
        return this.yUnits;
    }

    public pwAxis getDefaultYAxis(pwRow pwRow2, pwColumn pwColumn2) {
        return new pwAxis(new Datum(0.0, this.getYUnits()), new Datum(10.0, this.getYUnits()), pwRow2, pwColumn2, 3);
    }

    public Renderer getRenderer(pwPlot pwPlot2) {
        return new SymbolLineRenderer(pwPlot2, this);
    }

    public pwPlot getPlot(pwRow pwRow2, pwColumn pwColumn2) {
        return new pwPlot(this.getDefaultXAxis(pwRow2, pwColumn2), this.getDefaultYAxis(pwRow2, pwColumn2), pwRow2, pwColumn2);
    }
}

