/*
 * Decompiled with CFR 0.152.
 */
package das_proto.data;

import das_proto.data.Units;
import util.pwDie;

public class UnitsConverter {
    public double offset;
    public double scale;
    private int numServed;
    private UnitsConverter inverse;
    private String id;
    public static UnitsConverter identity = new UnitsConverter(1.0, 0.0);

    public UnitsConverter(double d, double d2) {
        this(d, d2, "");
    }

    public UnitsConverter(double d, double d2, String string) {
        this.scale = d;
        this.offset = d2;
        this.id = string;
        this.numServed = 0;
        this.inverse = null;
    }

    public UnitsConverter getInversion() {
        if (this.inverse == null) {
            this.inverse = new UnitsConverter(1.0 / this.scale, -1.0 * this.offset / this.scale);
        }
        return this.inverse;
    }

    public double convert(double d) {
        return this.scale * d + this.offset;
    }

    public String toString() {
        if (this.id.equals("")) {
            return "" + this.scale + " * old + " + this.offset;
        }
        return this.id;
    }

    public static UnitsConverter getConverter(Units units, Units units2) {
        return Units.getConverter(units, units2);
    }

    public static void main(String[] stringArray) {
        UnitsConverter unitsConverter = new UnitsConverter(1.8, 32.0);
        UnitsConverter unitsConverter2 = unitsConverter.getInversion();
        pwDie.println("9.7");
        pwDie.println("" + unitsConverter.convert(9.7));
        pwDie.println("" + unitsConverter.convert(unitsConverter2.convert(9.7)));
        pwDie.println("" + unitsConverter2.convert(9.7));
        pwDie.println("" + unitsConverter2.convert(unitsConverter.convert(9.7)));
    }
}

