/*
 * Decompiled with CFR 0.152.
 */
package das_proto.data;

import das_proto.data.TimeLocationUnits;
import das_proto.data.UnitsConverter;
import java.util.Enumeration;
import java.util.Hashtable;
import util.pwDie;

public class Units {
    String id;
    String description;
    private static Hashtable conversionTable;
    public static Units dimensionless;
    public static Units celcius;
    public static Units fahrenheit;
    public static Units seconds;
    public static Units microseconds;
    public static Units days;
    public static TimeLocationUnits t2000;
    public static TimeLocationUnits us2000;
    public static TimeLocationUnits t1970;
    public static TimeLocationUnits mj1958;

    private static Hashtable getConversionTable() {
        if (conversionTable == null) {
            conversionTable = Units.buildConversionTable();
        }
        return conversionTable;
    }

    public static void dumpConversionTable() {
        Hashtable hashtable = Units.getConversionTable();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            Enumeration enumeration2 = ((Hashtable)enumeration.nextElement()).elements();
            while (enumeration2.hasMoreElements()) {
                pwDie.println(enumeration2.nextElement());
            }
        }
    }

    private static Hashtable buildConversionTable() {
        Hashtable hashtable = new Hashtable();
        Hashtable<TimeLocationUnits, UnitsConverter> hashtable2 = new Hashtable<TimeLocationUnits, UnitsConverter>();
        hashtable2.put(us2000, new UnitsConverter(1000000.0, 0.0));
        hashtable2.put(mj1958, new UnitsConverter(1.1574074074074073E-5, 15340.0));
        Hashtable<TimeLocationUnits, UnitsConverter> hashtable3 = new Hashtable<TimeLocationUnits, UnitsConverter>();
        hashtable3.put(mj1958, new UnitsConverter(1.1574074074074074E-11, 15340.0, "us2000->mj1958"));
        hashtable3.put(t2000, new UnitsConverter(1.0E-6, 0.0, "us2000->t2000"));
        Hashtable<Units, UnitsConverter> hashtable4 = new Hashtable<Units, UnitsConverter>();
        hashtable4.put(microseconds, new UnitsConverter(1000000.0, 0.0, "seconds->microseconds"));
        hashtable4.put(days, new UnitsConverter(1.1574074074074073E-5, 0.0));
        Hashtable<Units, UnitsConverter> hashtable5 = new Hashtable<Units, UnitsConverter>();
        hashtable5.put(microseconds, new UnitsConverter(8.64E10, 0.0, "days->microseconds"));
        Hashtable<Units, UnitsConverter> hashtable6 = new Hashtable<Units, UnitsConverter>();
        hashtable6.put(fahrenheit, new UnitsConverter(1.8, 32.0));
        hashtable.put(t2000, hashtable2);
        hashtable.put(us2000, hashtable3);
        hashtable.put(celcius, hashtable6);
        hashtable.put(seconds, hashtable4);
        hashtable.put(days, hashtable5);
        return hashtable;
    }

    private Units(String string) {
        this.id = string;
        this.description = "";
    }

    public Units(String string, String string2) {
        this.id = string;
        this.description = string2;
    }

    public static UnitsConverter getConverter(Units units, Units units2) {
        if (units2 == units) {
            return UnitsConverter.identity;
        }
        Hashtable hashtable = Units.getConversionTable();
        if (hashtable.containsKey(units)) {
            Hashtable hashtable2 = (Hashtable)hashtable.get(units);
            if (!hashtable2.containsKey(units2)) {
                throw new IllegalArgumentException("Can't convert from " + units.toString() + " to " + units2.toString());
            }
            return (UnitsConverter)hashtable2.get(units2);
        }
        if (hashtable.containsKey(units2)) {
            Hashtable hashtable3 = (Hashtable)hashtable.get(units2);
            if (!hashtable3.containsKey(units)) {
                throw new IllegalArgumentException("Can't convert from " + units.toString() + " to " + units2.toString());
            }
            return ((UnitsConverter)hashtable3.get(units)).getInversion();
        }
        throw new IllegalArgumentException("Can't convert from " + units.toString() + " to " + units2.toString());
    }

    public UnitsConverter getConverter(Units units) {
        return Units.getConverter(this, units);
    }

    public String toString() {
        return this.id;
    }

    public double parse(String string) {
        throw new IllegalArgumentException("not implemented for Units besides TimeLocationUnits.");
    }

    public static void main(String[] stringArray) {
        Units.dumpConversionTable();
        UnitsConverter unitsConverter = t2000.getConverter(us2000);
        int n = 50000000;
        double d = 0.0;
        long l = System.currentTimeMillis();
        int n2 = 0;
        while (n2 < n) {
            d += unitsConverter.convert(n2);
            ++n2;
        }
        System.out.println(System.currentTimeMillis() - l);
        System.out.println(d);
        d = 0.0;
        l = System.currentTimeMillis();
        double d2 = unitsConverter.scale;
        double d3 = unitsConverter.offset;
        int n3 = 0;
        while (n3 < n) {
            d += d2 * (double)n3 + d3;
            ++n3;
        }
        System.out.println(System.currentTimeMillis() - l);
        System.out.println(d);
    }

    static {
        dimensionless = new Units("");
        celcius = new Units("deg C");
        fahrenheit = new Units("deg F");
        seconds = new Units("s");
        microseconds = new Units("microseconds");
        days = new Units("days");
        t2000 = new TimeLocationUnits("t2000", "Seconds since midnight Jan 1, 2000.", seconds);
        us2000 = new TimeLocationUnits("us2000", "Microseconds since midnight Jan 1, 2000.", microseconds);
        t1970 = new TimeLocationUnits("t1970", "Seconds since midnight Jan 1, 1970", seconds);
        mj1958 = new TimeLocationUnits("mj1958", "Julian - 2436204.5", days);
    }
}

