/*
 * Decompiled with CFR 0.152.
 */
package das_proto.data;

import das_proto.data.DasFormatter;
import das_proto.data.DasTimeFormatter;
import das_proto.data.Datum;
import das_proto.data.TimeContext;
import das_proto.data.TimeLocationUnits;
import das_proto.data.Units;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import util.pwDate;

public class TimeDatum
extends Datum {
    public TimeDatum(double d, Units units) {
        super(d, units);
    }

    public String toString() {
        return pwDate.create(this).toString();
    }

    public static TimeDatum create(pwDate pwDate2) {
        pwDate pwDate3 = new pwDate("01/01/2000 00:00");
        return new TimeDatum(pwDate2.subtract(pwDate3) * 1000000.0, Units.us2000);
    }

    public static TimeDatum create(String string) {
        return TimeDatum.create(new pwDate(string));
    }

    public static double convert(int n, int n2, int n3, int n4, int n5, double d, TimeLocationUnits timeLocationUnits) {
        int n6;
        if (n2 > 0) {
            n6 = 367 * n - 7 * (n + (n2 + 9) / 12) / 4 - 3 * ((n + (n2 - 9) / 7) / 100 + 1) / 4 + 275 * n2 / 9 + n3 + 1721029;
        } else {
            int n7 = 1;
            int n8 = 1;
            n6 = 367 * n - 7 * (n + (n7 + 9) / 12) / 4 - 3 * ((n + (n7 - 9) / 7) / 100 + 1) / 4 + 275 * n7 / 9 + n8 + 1721029;
            n6 += n3 - 1;
        }
        d += (double)n4 * 3600.0 + (double)n5 * 60.0;
        if (timeLocationUnits == Units.us2000) {
            return (double)(n6 - 2451545) * 8.64E10 + d * 1000000.0;
        }
        throw new IllegalArgumentException("Not implemented for units: " + timeLocationUnits.toString());
    }

    public static TimeDatum now() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        ((Calendar)gregorianCalendar).setTimeZone(TimeZone.getTimeZone("GMT"));
        int n = gregorianCalendar.get(11);
        int n2 = gregorianCalendar.get(12);
        int n3 = gregorianCalendar.get(13);
        int n4 = gregorianCalendar.get(1);
        int n5 = gregorianCalendar.get(6);
        return TimeDatum.create(n4 + "//" + n5 + " " + n + ":" + n2 + ":" + n3);
    }

    public DasFormatter getFormatter(Datum datum, int n) {
        TimeDatum timeDatum = this;
        if (timeDatum.getUnits() != datum.getUnits()) {
            throw new IllegalArgumentException("Units don't match!");
        }
        datum = timeDatum.add(datum.subtract(timeDatum).divide(n));
        DasTimeFormatter dasTimeFormatter = new DasTimeFormatter(TimeContext.getContext(timeDatum, (TimeDatum)datum));
        return dasTimeFormatter;
    }

    public double getSecondsSinceMidnight() {
        Datum datum = this.convertTo(Units.t2000);
        if (datum.getValue() < 0.0) {
            double d = datum.getValue() % 86400.0;
            if (d == 0.0) {
                return 0.0;
            }
            return 86400.0 - d;
        }
        return datum.getValue() % 86400.0;
    }

    public static void main(String[] stringArray) {
        System.out.println(TimeDatum.now());
        System.out.println(TimeDatum.convert(2000, 1, 1, 0, 0, 0.0, Units.us2000));
        System.out.println(TimeDatum.convert(2000, 1, 2, 0, 0, 0.0, Units.us2000));
    }
}

