/*
 * Decompiled with CFR 0.152.
 */
package das_proto.data;

import das_proto.data.DasFormatter;
import das_proto.data.LocationUnits;
import das_proto.data.TimeDatum;
import das_proto.data.TimeLocationUnits;
import das_proto.data.Units;
import das_proto.data.UnitsConverter;
import java.util.Hashtable;
import util.pwDate;
import util.pwDie;
import util.pwMath;

public class Datum {
    private double value;
    private Units units;
    private DasFormatter nf;
    static int _allocations = 0;
    static Hashtable _allocation_source = new Hashtable();

    public Datum(double d) {
        this(d, Units.dimensionless);
    }

    public Datum(double d, Units units) {
        this.value = d;
        this.units = units;
        this.nf = new DasFormatter();
        if (++_allocations % 5000 == 0) {
            pwDie.println("  total Datums allocated: " + _allocations);
        }
    }

    public double doubleValue() {
        return this.value;
    }

    public Units getUnits() {
        return this.units;
    }

    public double getValue() {
        return this.value;
    }

    public Datum add(Datum datum) throws IllegalArgumentException {
        return this.add(datum.getValue(), datum.getUnits());
    }

    public Datum add(double d, Units units) throws IllegalArgumentException {
        Object object;
        if (this.units instanceof LocationUnits) {
            if (units instanceof LocationUnits) {
                throw new IllegalArgumentException("You can't add " + this.units + " to " + units);
            }
            Units units2 = ((LocationUnits)this.units).getOffsetUnits();
            if (units != units2) {
                UnitsConverter unitsConverter = Units.getConverter(units, units2);
                d = unitsConverter.convert(d);
            }
            return Datum.create(this.getValue() + d, this.units);
        }
        if (this.units != units) {
            object = Units.getConverter(units, this.units);
            d = ((UnitsConverter)object).convert(d);
        }
        object = Datum.create(this.value + d, this.units);
        return object;
    }

    public Datum subtract(double d, Units units) throws IllegalArgumentException {
        return this.add(-1.0 * d, units);
    }

    public Datum subtract(Datum datum) throws IllegalArgumentException {
        if (this.units instanceof LocationUnits) {
            LocationUnits locationUnits = (LocationUnits)this.getUnits();
            if (datum.getUnits() instanceof LocationUnits) {
                if (locationUnits != datum.getUnits()) {
                    datum = datum.convertTo(locationUnits);
                }
                double d = this.getValue() - datum.getValue();
                return new Datum(d, locationUnits.getOffsetUnits());
            }
            if (datum.getUnits() != locationUnits.getOffsetUnits()) {
                datum = datum.convertTo(locationUnits.getOffsetUnits());
            }
            return Datum.create(this.getValue() - datum.getValue(), locationUnits);
        }
        if (this.units != datum.units) {
            datum = datum.convertTo(this.units);
        }
        Datum datum2 = Datum.create(this.value - datum.value, this.units);
        return datum2;
    }

    public Datum divide(double d) {
        if (this.units instanceof LocationUnits) {
            throw new IllegalArgumentException("It doesn't make sense to divide LocationUnits, since they indicate a point in space/time");
        }
        return Datum.create(this.value / d, this.units);
    }

    public Datum multiply(double d) {
        if (this.units instanceof LocationUnits) {
            throw new IllegalArgumentException("It doesn't make sense to multiply LocationUnits, since they indicate a point in space/time");
        }
        return Datum.create(this.value * d, this.units);
    }

    public boolean equals(Datum datum) throws IllegalArgumentException {
        return this.compareTo(datum) == 0;
    }

    public boolean lt(Datum datum) throws IllegalArgumentException {
        return this.compareTo(datum) < 0;
    }

    public boolean gt(Datum datum) throws IllegalArgumentException {
        return this.compareTo(datum) > 0;
    }

    public int compareTo(Datum datum) throws IllegalArgumentException {
        double d;
        if (this.units != datum.units) {
            datum = datum.convertTo(this.units);
        }
        if ((d = this.value - datum.value) == 0.0) {
            return 0;
        }
        if (d < 0.0) {
            return -1;
        }
        return 1;
    }

    public boolean isValid() {
        return this.value != Double.NaN;
    }

    public Datum convertTo(Units units) throws IllegalArgumentException {
        UnitsConverter unitsConverter = this.units.getConverter(units);
        Datum datum = Datum.create(unitsConverter.convert(this.value), units);
        return datum;
    }

    public String toString() {
        if (this.nf == null) {
            return "" + this.value + " " + this.units;
        }
        return this.nf.format(this);
    }

    public Datum create(double d) {
        return Datum.create(d, this.units);
    }

    public static Datum create(double d, Units units) {
        if (units instanceof TimeLocationUnits) {
            return new TimeDatum(d, units);
        }
        return new Datum(d, units);
    }

    public static void main(String[] stringArray) {
        Datum datum = new Datum(32.0, Units.fahrenheit);
        Datum datum2 = new Datum(212.0, Units.fahrenheit);
        Datum datum3 = new Datum(100.0, Units.celcius);
        Units.dumpConversionTable();
        pwDie.println("" + datum);
        pwDie.println("" + datum2);
        pwDie.println("" + datum3);
        pwDie.println("" + datum2.convertTo(Units.celcius));
        pwDie.println("" + datum.convertTo(Units.celcius));
        pwDie.println("=======");
        pwDie.println("" + datum2.subtract(datum));
        pwDie.println("" + datum3.subtract(datum));
        pwDate pwDate2 = new pwDate("09/15/1997 17:27:32");
        TimeDatum timeDatum = TimeDatum.create(pwDate2);
        pwDie.println(pwDate2.toString());
        pwDie.println(pwDate.create(timeDatum));
    }

    public DasFormatter getFormatter() {
        if (this.nf == null) {
            this.nf = new DasFormatter();
        }
        return this.nf;
    }

    public void setFormatter(DasFormatter dasFormatter) {
        this.nf = dasFormatter;
    }

    public DasFormatter getFormatter(Datum datum, int n) {
        Datum datum2 = this;
        if (datum2.units != datum.units) {
            throw new IllegalArgumentException("Units don't match!");
        }
        double d = Math.abs(datum2.subtract(datum).getValue() / (double)n);
        int n2 = -1 * (int)Math.floor(pwMath.log10(d));
        n2 = n2 < 0 ? 0 : n2;
        DasFormatter dasFormatter = new DasFormatter();
        dasFormatter.setMaximumFractionDigits(n2);
        dasFormatter.setMinimumFractionDigits(n2);
        return dasFormatter;
    }

    public static DasFormatter getFormatter(Datum datum, Datum datum2, int n) {
        return datum.getFormatter(datum2, n);
    }

    public String format() {
        return this.nf.format(this);
    }

    public Datum parse(String string) {
        return this.nf.parse(string, this);
    }
}

