/*
 * Decompiled with CFR 0.152.
 */
package das_proto.data;

import das_proto.DasException;
import das_proto.client.DasIOException;
import das_proto.client.DataSetDescriptorNotAvailableException;
import das_proto.client.NoSuchDataSetException;
import das_proto.client.StandardDataStreamSource;
import das_proto.data.CachedXTaggedYScanDataSetDescriptor;
import das_proto.data.DataRequestor;
import das_proto.data.DataSet;
import das_proto.data.LocationUnits;
import das_proto.data.Units;
import das_proto.data.UnitsConverter;
import das_proto.data.XMultiYDataSetDescriptor;
import das_proto.server.DasServer;
import event.DasEventMulticaster;
import event.DasReaderEvent;
import event.DasReaderListener;
import event.ProgressIndicator;
import graph.Renderer;
import graph.pwAxis;
import graph.pwColumn;
import graph.pwPlot;
import graph.pwRow;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import util.DasExceptionHandler;
import util.IDLParser;
import util.pwDate;

public abstract class DataSetDescriptor
implements Serializable {
    public Hashtable properties = new Hashtable();
    public String description = "";
    public String form = "";
    public String reader = "";
    public String dataSetID = "No dsdfFile set";
    public String x_parameter = "";
    public String x_unit = "";
    public double x_sample_width = Double.NaN;
    public double xSampleWidth = Double.NaN;
    private Units xUnits;
    protected StandardDataStreamSource standardDataStreamSource;
    protected transient DataRequestor requestor;
    protected transient ProgressIndicator progressIndicator;
    private static final Pattern CLASS_ID = Pattern.compile("class:([a-zA-Z\\.]+)(?:\\?(.*))?");
    private static final Pattern NAME_VALUE = Pattern.compile("([_0-9a-zA-Z%+.]+)=([_0-9a-zA-Z%+./]+)");
    protected transient DasReaderListener readerListener;
    static /* synthetic */ Class class$java$util$Map;

    protected DataSetDescriptor(Units units) {
        this.xUnits = units;
    }

    public static DataSetDescriptor create(String string) throws DasException {
        Matcher matcher = CLASS_ID.matcher(string);
        if (matcher.matches()) {
            try {
                Object object;
                String string2 = matcher.group(1);
                String string3 = matcher.group(2);
                String[] stringArray = string3 != null && string3.length() > 0 ? string3.split("&") : new String[]{};
                URLDecoder uRLDecoder = new URLDecoder();
                HashMap<String, String> hashMap = new HashMap<String, String>();
                int n = 0;
                while (n < stringArray.length) {
                    object = NAME_VALUE.matcher(stringArray[n]);
                    if (!((Matcher)object).matches()) {
                        throw new NoSuchDataSetException("Invalid argument: " + stringArray[n]);
                    }
                    hashMap.put(URLDecoder.decode(((Matcher)object).group(1), "UTF-8"), URLDecoder.decode(((Matcher)object).group(2), "UTF-8"));
                    ++n;
                }
                object = Class.forName(string2);
                Method method = ((Class)object).getMethod("newDataSetDescriptor", class$java$util$Map == null ? (class$java$util$Map = DataSetDescriptor.class$("java.util.Map")) : class$java$util$Map);
                if (!Modifier.isStatic(method.getModifiers())) {
                    throw new NoSuchDataSetException("getDataSetDescriptor must be static");
                }
                return (DataSetDescriptor)method.invoke(null, hashMap);
            }
            catch (ClassNotFoundException classNotFoundException) {
                DataSetDescriptorNotAvailableException dataSetDescriptorNotAvailableException = new DataSetDescriptorNotAvailableException(classNotFoundException.getMessage());
                dataSetDescriptorNotAvailableException.initCause(classNotFoundException);
                throw dataSetDescriptorNotAvailableException;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                DataSetDescriptorNotAvailableException dataSetDescriptorNotAvailableException = new DataSetDescriptorNotAvailableException(noSuchMethodException.getMessage());
                dataSetDescriptorNotAvailableException.initCause(noSuchMethodException);
                throw dataSetDescriptorNotAvailableException;
            }
            catch (InvocationTargetException invocationTargetException) {
                DataSetDescriptorNotAvailableException dataSetDescriptorNotAvailableException = new DataSetDescriptorNotAvailableException(invocationTargetException.getTargetException().getMessage());
                dataSetDescriptorNotAvailableException.initCause(invocationTargetException.getTargetException());
                throw dataSetDescriptorNotAvailableException;
            }
            catch (IllegalAccessException illegalAccessException) {
                DataSetDescriptorNotAvailableException dataSetDescriptorNotAvailableException = new DataSetDescriptorNotAvailableException(illegalAccessException.getMessage());
                dataSetDescriptorNotAvailableException.initCause(illegalAccessException);
                throw dataSetDescriptorNotAvailableException;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
        }
        if (!string.startsWith("http://")) {
            string = "http://www-pw.physics.uiowa.edu/das/dasServer?" + string;
        }
        try {
            DataSetDescriptor dataSetDescriptor = DataSetDescriptor.create(new URL(string));
            dataSetDescriptor.dataSetID = string;
            return dataSetDescriptor;
        }
        catch (MalformedURLException malformedURLException) {
            throw new DasIOException(malformedURLException.getMessage());
        }
    }

    public void setStandardDataStreamSource(StandardDataStreamSource standardDataStreamSource) {
        this.standardDataStreamSource = standardDataStreamSource;
    }

    public StandardDataStreamSource getStandardDataStreamSource() {
        return this.standardDataStreamSource;
    }

    public boolean isDas2Stream() {
        String string = (String)this.properties.get("das2Stream");
        return string != null && string.equals("1");
    }

    public void setRequestor(DataRequestor dataRequestor) {
        this.requestor = dataRequestor;
    }

    public static DataSetDescriptor create(File file) throws IOException, FileNotFoundException {
        return DataSetDescriptor.create(new FileInputStream(file));
    }

    private static DataSetDescriptor create(InputStream inputStream) throws IOException {
        return DataSetDescriptor.create(new InputStreamReader(inputStream));
    }

    private static DataSetDescriptor create(Reader reader) throws IOException {
        DataSetDescriptor dataSetDescriptor;
        BufferedReader bufferedReader = new BufferedReader(reader);
        IDLParser iDLParser = new IDLParser();
        String string = bufferedReader.readLine();
        int n = 1;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        while (string != null) {
            int n2 = string.trim().indexOf(59);
            if (n2 == 0) {
                ++n;
                string = bufferedReader.readLine();
                continue;
            }
            if (n2 != -1) {
                string = string.substring(0, n2);
            }
            n2 = string.indexOf(61);
            String string2 = string.substring(0, n2).trim();
            String string3 = string.substring(n2 + 1).trim();
            if (string2.equals("description")) {
                String string4 = string3.substring(1, string3.length() - 1);
                hashtable.put(string2, string4);
            } else if (string2.equals("groupAccess")) {
                hashtable.put(string2, string3.substring(1, string3.length() - 1));
            } else if (string2.equals("form")) {
                hashtable.put(string2, string3);
            } else if (string2.equals("reader")) {
                String string5 = string3.substring(1, string3.length() - 1);
                hashtable.put(string2, string5);
            } else if (string2.equals("x_parameter")) {
                String string6 = string3.substring(1, string3.length() - 1);
                hashtable.put(string2, string6);
            } else if (string2.equals("x_unit")) {
                String string7 = string3.substring(1, string3.length() - 1);
                hashtable.put(string2, string7);
            } else if (string2.equals("y_parameter")) {
                String string8 = string3.substring(1, string3.length() - 1);
                hashtable.put(string2, string8);
            } else if (string2.equals("y_unit")) {
                String string9 = string3.substring(1, string3.length() - 1);
                hashtable.put(string2, string9);
            } else if (string2.equals("z_parameter")) {
                String string10 = string3.substring(1, string3.length() - 1);
                hashtable.put(string2, string10);
            } else if (string2.equals("z_unit")) {
                String string11 = string3.substring(1, string3.length() - 1);
                hashtable.put(string2, string11);
            } else if (string2.equals("x_sample_width")) {
                double d = iDLParser.parseIDLScalar(string3);
                if (d == Double.NaN) {
                    throw new IOException("Could not parse \"" + string3 + "\" at line " + n);
                }
                hashtable.put(string2, new Double(d));
            } else if (string2.equals("y_fill")) {
                double d = iDLParser.parseIDLScalar(string3);
                if (d == Double.NaN) {
                    throw new IOException("Could not parse \"" + string3 + "\" at line " + n);
                }
                hashtable.put(string2, new Double(d));
            } else if (string2.equals("z_fill")) {
                double d = (float)iDLParser.parseIDLScalar(string3);
                if (d == Double.NaN) {
                    throw new IOException("Could not parse \"" + string3 + "\" at line " + n);
                }
                hashtable.put(string2, new Float(d));
            } else if (string2.equals("y_coordinate")) {
                double[] dArray = iDLParser.parseIDLArray(string3);
                if (dArray == null) {
                    throw new IOException("Could not parse \"" + string3 + "\" at line " + n);
                }
                hashtable.put(string2, dArray);
            } else if (string2.equals("ny")) {
                int n3;
                try {
                    n3 = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IOException("Could not parse \"" + string3 + "\" at line " + n);
                }
                hashtable.put(string2, new Integer(n3));
            } else if (string2.equals("items")) {
                int n4;
                try {
                    n4 = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IOException("Could not parse \"" + string3 + "\" at line " + n);
                }
                hashtable.put(string2, new Integer(n4));
            } else if (string3.charAt(0) == '\'' && string3.charAt(string3.length() - 1) == '\'') {
                hashtable.put(string2, string3.substring(1, string3.length() - 1));
            } else if (string3.charAt(0) == '\"' && string3.charAt(string3.length() - 1) == '\"') {
                hashtable.put(string2, string3.substring(1, string3.length() - 1));
            } else {
                hashtable.put(string2, string3);
            }
            string = bufferedReader.readLine();
            ++n;
        }
        String string12 = (String)hashtable.get("form");
        if (string12.equals("x_tagged_y_scan")) {
            dataSetDescriptor = new CachedXTaggedYScanDataSetDescriptor(hashtable);
        } else if (string12.equals("x_multi_y")) {
            dataSetDescriptor = new XMultiYDataSetDescriptor(hashtable);
        } else {
            throw new IllegalArgumentException("dsdf file is invalid, 'form' keyword is not valid.");
        }
        return dataSetDescriptor;
    }

    public Object getProperty(String string) {
        return this.properties.get(string);
    }

    public String[] getPropertyNames() {
        Enumeration enumeration = this.properties.keys();
        String[] stringArray = new String[this.properties.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    public float[] readFloats(InputStream inputStream, Object object, pwDate pwDate2, pwDate pwDate3) throws DasException {
        byte[] byArray = this.readBytes(inputStream, object, pwDate2, pwDate3);
        float[] fArray = new float[byArray.length / 4];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        floatBuffer.get(fArray);
        return fArray;
    }

    public double[] readDoubles(InputStream inputStream, Object object, pwDate pwDate2, pwDate pwDate3) throws DasException {
        byte[] byArray = this.readBytes(inputStream, object, pwDate2, pwDate3);
        double[] dArray = new double[byArray.length / 4];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = floatBuffer.get();
            ++n;
        }
        return dArray;
    }

    public byte[] readBytes(InputStream inputStream, Object object, pwDate pwDate2, pwDate pwDate3) throws DasException {
        int n;
        LinkedList<byte[]> linkedList = new LinkedList<byte[]>();
        int n2 = 0;
        int n3 = 0;
        InputStream inputStream2 = inputStream;
        long l = System.currentTimeMillis();
        this.fireReaderStarted();
        byte[] byArray = new byte[4096];
        int n4 = -1;
        int n5 = 0;
        if (this.progressIndicator != null) {
            this.progressIndicator.started();
        }
        try {
            n2 = inputStream2.read(byArray, n5, 4096 - n5);
            while (n2 != -1) {
                n = n3;
                this.fireReaderUpdate(n);
                if (this.progressIndicator != null) {
                    this.progressIndicator.setTaskProgress(n);
                }
                n4 = n5 += n2;
                if (n5 == 4096) {
                    linkedList.addLast(byArray);
                    byArray = new byte[4096];
                    n5 = 0;
                }
                n3 += n2;
                n2 = inputStream2.read(byArray, n5, 4096 - n5);
            }
        }
        catch (IOException iOException) {
            throw new DasIOException(iOException.getMessage());
        }
        if (n4 >= 0 && n4 < 4096) {
            linkedList.addLast(byArray);
        }
        if (linkedList.size() == 0) {
            throw new DasIOException("Error reading data for '" + this.description + "', no data available");
        }
        n = (linkedList.size() - 1) * 4096 + n4;
        byArray = new byte[n];
        Iterator iterator = linkedList.iterator();
        int n6 = 0;
        while (n6 < linkedList.size() - 1) {
            System.arraycopy(iterator.next(), 0, byArray, n6 * 4096, 4096);
            ++n6;
        }
        System.arraycopy(iterator.next(), 0, byArray, n6 * 4096, n4);
        return byArray;
    }

    public DataSet getDataSet(pwDate pwDate2, pwDate pwDate3) throws DasException {
        return this.getDataSet("", pwDate2, pwDate3);
    }

    public String toString() {
        return this.dataSetID;
    }

    public abstract DataSet getDataSet(InputStream var1, Object var2, pwDate var3, pwDate var4) throws DasException;

    public DataSet getDataSet(Object object, pwDate pwDate2, pwDate pwDate3) throws DasException {
        DataSet dataSet;
        try {
            InputStream inputStream = this.standardDataStreamSource.getInputStream(this, object, pwDate2, pwDate3);
            dataSet = this.getDataSet(inputStream, object, pwDate2, pwDate3);
        }
        catch (DasException dasException) {
            DasExceptionHandler.handle(dasException);
            dataSet = null;
        }
        return dataSet;
    }

    public DataSet getDataSet(Object object, pwDate pwDate2, pwDate pwDate3, double d) throws DasException {
        DataSet dataSet;
        try {
            InputStream inputStream = this.standardDataStreamSource.getInputStream(this, object, pwDate2, pwDate3);
            dataSet = this.getDataSet(inputStream, object, pwDate2, pwDate3);
        }
        catch (DasException dasException) {
            DasExceptionHandler.handle(dasException);
            dataSet = null;
        }
        return dataSet;
    }

    public String getDataSetID() {
        return this.dataSetID;
    }

    public void addDasReaderListener(DasReaderListener dasReaderListener) {
        this.readerListener = DasEventMulticaster.add(this.readerListener, dasReaderListener);
    }

    public void removeDasReaderListener(DasReaderListener dasReaderListener) {
        this.readerListener = DasEventMulticaster.remove(this.readerListener, dasReaderListener);
    }

    protected void fireReaderStarted() {
        if (this.readerListener != null) {
            this.readerListener.readerStarted(new DasReaderEvent(this, 0));
        }
    }

    protected void fireReaderUpdate(int n) {
        if (this.readerListener != null) {
            this.readerListener.readerUpdate(new DasReaderEvent(this, n));
        }
    }

    protected void fireReaderFinished(int n) {
        if (this.readerListener != null) {
            this.readerListener.readerUpdate(new DasReaderEvent(this, n));
        }
    }

    public void setProperties(Hashtable hashtable) {
        this.properties = hashtable;
        if (hashtable.containsKey("description")) {
            this.description = (String)hashtable.get("description");
        }
        if (hashtable.containsKey("form")) {
            this.form = (String)hashtable.get("form");
        }
        if (hashtable.containsKey("reader")) {
            this.reader = (String)hashtable.get("reader");
        }
        if (hashtable.containsKey("x_parameter")) {
            this.x_parameter = (String)hashtable.get("x_parameter");
        }
        if (hashtable.containsKey("x_unit")) {
            this.x_unit = (String)hashtable.get("x_unit");
        }
        if (hashtable.containsKey("x_sample_width")) {
            this.x_sample_width = (Double)hashtable.get("x_sample_width");
            UnitsConverter unitsConverter = UnitsConverter.getConverter(Units.seconds, ((LocationUnits)this.getXUnits()).getOffsetUnits());
            this.xSampleWidth = unitsConverter.convert(this.x_sample_width);
        }
    }

    public Units getXUnits() {
        return this.xUnits;
    }

    public boolean isRestrictedAccess() {
        boolean bl = this.properties.containsKey("groupAccess") ? !this.properties.get("groupAccess").equals("") : false;
        return bl;
    }

    public pwAxis getDefaultXAxis(pwRow pwRow2, pwColumn pwColumn2) {
        return null;
    }

    public Renderer getRenderer(pwPlot pwPlot2) {
        return null;
    }

    public static DataSetDescriptor create(URL uRL) throws DasException {
        DasServer dasServer = DasServer.create(uRL);
        try {
            String string = dasServer.getDataSetDescriptor(uRL.getQuery());
            DataSetDescriptor dataSetDescriptor = DataSetDescriptor.create(new StringReader(string));
            dataSetDescriptor.standardDataStreamSource = dasServer.getStandardDataStreamSource();
            dataSetDescriptor.dataSetID = uRL.toExternalForm();
            return dataSetDescriptor;
        }
        catch (IOException iOException) {
            throw new DasIOException(iOException.getMessage());
        }
    }

    public static void main(String[] stringArray) {
        try {
            URL uRL = new URL("http://www-pw.physics.uiowa.edu/das/dasServer?galileo/pws/best-e");
            DataSetDescriptor dataSetDescriptor = DataSetDescriptor.create(uRL);
            System.out.println(dataSetDescriptor);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println(malformedURLException);
        }
        catch (DasException dasException) {
            System.out.println(dasException);
        }
    }

    public void setProgressIndicator(ProgressIndicator progressIndicator) {
        this.progressIndicator = progressIndicator;
    }

    public ProgressIndicator getProgressIndicator() {
        return this.progressIndicator;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

