/*
 * Decompiled with CFR 0.152.
 */
package das_proto.data;

import das_proto.data.DataSet;
import das_proto.data.DataSetDescriptor;
import util.pwDate;
import util.pwDie;

public class DataSetCache {
    Tag[] buffer = new Tag[1];
    private boolean enabled = true;
    public int hits = 0;
    public int misses = 0;

    public void store(DataSetDescriptor dataSetDescriptor, pwDate pwDate2, pwDate pwDate3, double d, Object object, DataSet dataSet) {
        if (!this.enabled) {
            return;
        }
        Tag tag = new Tag(dataSetDescriptor, pwDate2, pwDate3, d, object, dataSet);
        int n = -1;
        int n2 = this.buffer.length - 1;
        while (n2 >= 0) {
            if (this.buffer[n2] == null) {
                n = n2;
            }
            --n2;
        }
        if (n == -1) {
            long l = Long.MAX_VALUE;
            int n3 = -1;
            int n4 = this.buffer.length - 1;
            while (n4 >= 0) {
                if (this.buffer[n4].lastAccess < l) {
                    n3 = n4;
                    l = this.buffer[n4].lastAccess;
                }
                --n4;
            }
            n = n3;
        }
        this.buffer[n] = tag;
    }

    int findStored(DataSetDescriptor dataSetDescriptor, pwDate pwDate2, pwDate pwDate3, double d, Object object) {
        Tag tag = new Tag(dataSetDescriptor, pwDate2, pwDate3, d, object, null);
        int n = -1;
        int n2 = 0;
        while (n2 < this.buffer.length) {
            if (this.buffer[n2] != null && this.buffer[n2].isWithin(tag)) {
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    public boolean haveStored(DataSetDescriptor dataSetDescriptor, pwDate pwDate2, pwDate pwDate3, double d, Object object) {
        Tag tag = new Tag(dataSetDescriptor, pwDate2, pwDate3, d, object, null);
        pwDie.println(this.toString());
        pwDie.println("    need: " + tag.toString());
        int n = this.findStored(dataSetDescriptor, pwDate2, pwDate3, d, object);
        if (n != -1) {
            ++this.hits;
            return true;
        }
        ++this.misses;
        return false;
    }

    public DataSet retrieve(DataSetDescriptor dataSetDescriptor, pwDate pwDate2, pwDate pwDate3, double d, Object object) {
        int n = this.findStored(dataSetDescriptor, pwDate2, pwDate3, d, object);
        if (n != -1) {
            pwDie.println(" time offset= " + this.buffer[n].start.subtract(pwDate2));
            ++this.buffer[n].nhits;
            this.buffer[n].lastAccess = System.currentTimeMillis();
            return this.buffer[n].data;
        }
        throw new IllegalArgumentException("Data not found in buffer");
    }

    public void reset() {
        int n = 0;
        while (n < this.buffer.length) {
            this.buffer[n] = null;
            ++n;
        }
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (!bl) {
            this.reset();
        }
    }

    public double calcHitRate() {
        return (double)this.hits * 100.0 / (double)(this.hits + this.misses);
    }

    public String toString() {
        String string = "\n---XTaggedYScanDataSetCache---\n";
        int n = 0;
        while (n < this.buffer.length) {
            string = string + "Buffer " + n + ": ";
            string = this.buffer[n] != null ? string + this.buffer[n].toString() : string + "";
            string = string + "\n";
            ++n;
        }
        string = string + "-------------------";
        return string;
    }

    protected class Tag {
        DataSetDescriptor dsd;
        pwDate start;
        pwDate end;
        double resolution;
        Object params;
        DataSet data;
        int nhits;
        long birthTime;
        long lastAccess;

        Tag() {
            this(null, null, null, 1.0E31, null, null);
        }

        Tag(DataSetDescriptor dataSetDescriptor, pwDate pwDate2, pwDate pwDate3, double d, Object object, DataSet dataSet) {
            this.dsd = dataSetDescriptor;
            this.start = pwDate2;
            this.end = pwDate3;
            this.resolution = d;
            this.params = object;
            this.data = dataSet;
            this.nhits = 0;
            this.lastAccess = this.birthTime = System.currentTimeMillis();
        }

        protected boolean isWithin(Tag tag) {
            boolean bl = this.dsd != null && tag.dsd != null;
            bl = bl && tag.dsd.toString().equals(this.dsd.toString());
            bl = bl && tag.start.compareTo(this.start) >= 0 && tag.end.compareTo(this.end) <= 0;
            bl = bl && tag.resolution >= this.resolution;
            bl = bl && (tag.params == this.params || tag.params.toString().equals(this.params.toString()));
            return bl;
        }

        public String toString() {
            return this.dsd.toString() + " " + this.start.toString() + " - " + this.end.toString() + " @ " + this.resolution + "s  [" + this.nhits + " hits]";
        }
    }
}

