/*
 * Decompiled with CFR 0.152.
 */
package das_proto.data;

import das_proto.data.DasFormatter;
import das_proto.data.Datum;
import das_proto.data.TimeContext;
import das_proto.data.TimeDatum;
import das_proto.data.Units;
import util.pwDie;
import util.pwMath;

public class DasTimeFormatter
extends DasFormatter {
    private TimeContext timeContext;
    private boolean showDoy;
    private boolean alwaysShowDate;

    public DasTimeFormatter(TimeContext timeContext) {
        this.timeContext = timeContext;
        this.showDoy = false;
        this.alwaysShowDate = false;
    }

    private static int julday(int n, int n2, int n3) {
        int n4 = 367 * n3 - 7 * (n3 + (n + 9) / 12) / 4 - 3 * ((n3 + (n - 9) / 7) / 100 + 1) / 4 + 275 * n / 9 + n2 + 1721029;
        return n4;
    }

    public String format(TimeDatum timeDatum) {
        String string;
        int n;
        int n2;
        int n3;
        double d;
        double d2;
        if (timeDatum.getUnits() == Units.mj1958) {
            d2 = timeDatum.getValue();
            d = d2 % 1.0 * 86400.0;
            n3 = (int)Math.floor(d2) + 2436205;
        } else if (timeDatum.getUnits() == Units.us2000) {
            d2 = timeDatum.getValue();
            d = pwMath.modp(d2, 8.64E10) / 1000000.0;
            n3 = (int)Math.floor(d2 / 8.64E10) + 2451545;
        } else {
            d2 = Units.getConverter(timeDatum.getUnits(), Units.us2000).convert(timeDatum.getValue());
            d = pwMath.modp(d2, 8.64E10) / 1000000.0;
            n3 = (int)Math.floor(d2 / 8.64E10) + 2451545;
        }
        if (this.timeContext == null) {
            this.timeContext = TimeContext.DAYS;
        }
        String string2 = (double)(n2 = (n = (int)(d + 0.5)) / 3600) < 10.0 ? "0" + n2 : "" + n2;
        int n4 = (n - n2 * 3600) / 60;
        String string3 = (double)n4 < 10.0 ? "0" + n4 : "" + n4;
        int n5 = n % 60;
        String string4 = (double)n5 < 10.0 ? "0" + n5 : "" + n5;
        int n6 = (int)(((double)(n3 - 1867216) - 0.25) / 36524.25);
        int n7 = n3 + 1 + n6 - n6 / 4;
        int n8 = n7 + 1524;
        int n9 = 6680 + (int)(((double)(n8 - 2439870) - 122.1) / 365.25);
        int n10 = 365 * n9 + n9 / 4;
        int n11 = (int)((double)(n8 - n10) / 30.6001);
        int n12 = n8 - n10 - (int)(30.6001 * (double)n11);
        int n13 = n11 - 1;
        n13 = (n13 - 1) % 12 + 1;
        int n14 = n9 - 4715;
        String string5 = (n14 -= (n14 -= n13 > 2 ? 1 : 0) <= 0 ? 1 : 0) + "-" + n13 + "-" + n12;
        if (this.showDoy) {
            int n15 = DasTimeFormatter.julday(1, 1, n14);
            string5 = string5 + " (" + (n3 - n15 + 1) + ")";
        }
        if (this.timeContext == TimeContext.MILLISECONDS) {
            n5 = (int)d % 60;
            string4 = (double)n5 < 10.0 ? "0" + n5 : "" + n5;
            long l = Math.round(d % 1.0 * 1000.0);
            string = string2 + ":" + string3 + ":" + string4 + "." + (l < 100L ? "0" + (l < 10L ? "0" : "") : "") + l;
        } else {
            string = this.timeContext == TimeContext.SECONDS || this.timeContext == TimeContext.MINUTES ? string2 + ":" + string3 + ":" + string4 : (this.timeContext == TimeContext.HOURS ? string2 + ":" + string3 : (this.timeContext == TimeContext.DAYS ? string5 : (n2 == 0 ? string5 : string5)));
        }
        if (!this.timeContext.gt(TimeContext.HOURS) && this.alwaysShowDate) {
            string = string5 + " " + string;
        }
        return string;
    }

    public String format(Object object) {
        if (!(object instanceof TimeDatum)) {
            throw new IllegalArgumentException("Argument is not a TimeDatum! (" + object.getClass().getName() + ")");
        }
        TimeDatum timeDatum = (TimeDatum)object;
        return this.format(timeDatum);
    }

    public void setShowDoy(boolean bl) {
        this.showDoy = bl;
    }

    public void setAlwaysShowDate(boolean bl) {
        this.alwaysShowDate = bl;
    }

    public String format(double d, Units units) {
        return this.format(new TimeDatum(d, units));
    }

    public Datum parse(String string, Datum datum) {
        return TimeDatum.create(string);
    }

    public TimeContext getContext() {
        return this.timeContext;
    }

    public static void main(String[] stringArray) {
        TimeDatum timeDatum = TimeDatum.create("2001-3-1");
        DasTimeFormatter dasTimeFormatter = new DasTimeFormatter(TimeContext.DAYS);
        DasTimeFormatter dasTimeFormatter2 = new DasTimeFormatter(TimeContext.MILLISECONDS);
        pwDie.println(dasTimeFormatter.format(timeDatum));
        pwDie.println(dasTimeFormatter.format(timeDatum.convertTo(Units.t2000)));
        pwDie.println(dasTimeFormatter.format(timeDatum.convertTo(Units.mj1958)));
        pwDie.println("---------------------");
        pwDie.println(dasTimeFormatter2.format(timeDatum));
        pwDie.println(dasTimeFormatter2.format(TimeDatum.create("2001-3-1 01:14")));
        TimeDatum timeDatum2 = TimeDatum.create("1996-3-1 01:14");
        pwDie.println(dasTimeFormatter2.format(timeDatum2));
        pwDie.println(dasTimeFormatter.format(timeDatum2));
    }
}

