/*
 * Decompiled with CFR 0.152.
 */
package das_proto.data;

import das_proto.data.Datum;
import das_proto.data.Units;
import java.text.DecimalFormat;
import java.text.ParsePosition;

public class DasFormatter
implements Cloneable {
    DecimalFormat nf;

    public DasFormatter() {
        this.nf = new DecimalFormat();
    }

    public DasFormatter(DecimalFormat decimalFormat) {
        this.nf = decimalFormat;
    }

    public void setMaximumFractionDigits(int n) {
        this.nf.setMaximumFractionDigits(n);
    }

    public int getMaximumFractionDigits() {
        return this.nf.getMaximumFractionDigits();
    }

    public int getMinimumFractionDigits() {
        return this.nf.getMinimumFractionDigits();
    }

    public void setMinimumFractionDigits(int n) {
        this.nf.setMinimumFractionDigits(n);
    }

    public Object clone() {
        try {
            DasFormatter dasFormatter = (DasFormatter)super.clone();
            dasFormatter.nf = (DecimalFormat)this.nf.clone();
            return dasFormatter;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String format(Object object) {
        if (!(object instanceof Datum)) {
            throw new IllegalArgumentException("Argument is not a Datum! (" + object.getClass().getName() + ")");
        }
        Datum datum = (Datum)object;
        return this.format(datum.getValue(), datum.getUnits());
    }

    public String format(double d, Units units) {
        return this.nf.format(d) + units;
    }

    public String grannyFormat(double d, Units units) {
        String string = this.format(d, units);
        if (string.indexOf("E") != -1) {
            int n = string.indexOf("E");
            String string2 = string.substring(0, n);
            string2 = Double.parseDouble(string2) == 1.0 ? "10" : string2 + "*10";
            String string3 = string.substring(n + 1);
            string = string2 + "!A" + string3;
        }
        return string;
    }

    public Datum parse(String string, Datum datum) {
        return datum.create(this.nf.parse(string, new ParsePosition(0)).doubleValue());
    }
}

