/*
 * Decompiled with CFR 0.152.
 */
package das_proto.data;

import das_proto.data.DataSet;
import das_proto.server.DataSetReader;
import event.DasReaderListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Comparator;
import java.util.HashSet;
import java.util.SortedSet;
import java.util.TreeSet;
import util.pwDate;

public class CachedDataSetReader
implements DataSetReader {
    protected DataSetReader reader;
    private SortedSet startTimeSet;
    private SortedSet endTimeSet;

    public CachedDataSetReader(DataSetReader dataSetReader) {
        this.reader = dataSetReader;
        this.startTimeSet = new TreeSet(new StartTimeComparator());
        this.endTimeSet = new TreeSet(new EndTimeComparator());
    }

    public DataSet getDataSet(String string, Object object, pwDate pwDate2, pwDate pwDate3) throws IOException {
        System.out.println("HERE");
        DataSet dataSet = this.restore(string, object, pwDate2, pwDate3);
        if (dataSet == null) {
            dataSet = this.reader.getDataSet(string, object, pwDate2, pwDate3);
            DataSetDescriptor dataSetDescriptor = new DataSetDescriptor();
            dataSetDescriptor.dsdfPath = string;
            dataSetDescriptor.param = object == null ? "" : object.toString();
            dataSetDescriptor.startTime = pwDate2;
            dataSetDescriptor.endTime = pwDate3;
            File file = File.createTempFile("das2.", ".obj");
            System.out.print("Temp file created: ");
            System.out.println(file.getCanonicalPath());
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
            objectOutputStream.writeObject(dataSet);
            objectOutputStream.flush();
            objectOutputStream.close();
            dataSetDescriptor.filename = file.getCanonicalPath();
            this.startTimeSet.add(dataSetDescriptor);
            this.endTimeSet.add(dataSetDescriptor);
        }
        System.out.print("Contents of startTimeSet: ");
        System.out.println(this.startTimeSet);
        System.out.print("Contents of endTimeSet: ");
        System.out.println(this.endTimeSet);
        return dataSet;
    }

    public DataSet restore(String string, Object object, pwDate pwDate2, pwDate pwDate3) throws IOException {
        DataSetDescriptor dataSetDescriptor = new DataSetDescriptor();
        dataSetDescriptor.dsdfPath = string;
        dataSetDescriptor.param = object == null ? "" : object.toString();
        dataSetDescriptor.startTime = pwDate2;
        dataSetDescriptor.endTime = pwDate3;
        HashSet<DataSetDescriptor> hashSet = new HashSet<DataSetDescriptor>(this.startTimeSet.tailSet(dataSetDescriptor));
        hashSet.retainAll(this.endTimeSet.tailSet(dataSetDescriptor));
        if (hashSet.isEmpty()) {
            return null;
        }
        DataSetDescriptor dataSetDescriptor2 = (DataSetDescriptor)hashSet.iterator().next();
        ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(dataSetDescriptor2.filename));
        DataSet dataSet = null;
        try {
            dataSet = (DataSet)objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        objectInputStream.close();
        return dataSet;
    }

    public boolean isSaved(String string, Object object, pwDate pwDate2, pwDate pwDate3) {
        DataSetDescriptor dataSetDescriptor = new DataSetDescriptor();
        dataSetDescriptor.dsdfPath = string;
        dataSetDescriptor.param = object.toString();
        dataSetDescriptor.startTime = pwDate2;
        dataSetDescriptor.endTime = pwDate3;
        if (this.startTimeSet.contains(dataSetDescriptor)) {
            return true;
        }
        HashSet<DataSetDescriptor> hashSet = new HashSet<DataSetDescriptor>(this.startTimeSet.tailSet(dataSetDescriptor));
        hashSet.retainAll(this.endTimeSet.tailSet(dataSetDescriptor));
        return !hashSet.isEmpty();
    }

    public void addDasReaderListener(DasReaderListener dasReaderListener) {
        this.reader.addDasReaderListener(dasReaderListener);
    }

    public void removeDasReaderListener(DasReaderListener dasReaderListener) {
        this.reader.removeDasReaderListener(dasReaderListener);
    }

    protected class EndTimeComparator
    implements Comparator {
        protected EndTimeComparator() {
        }

        public int compare(Object object, Object object2) {
            DataSetDescriptor dataSetDescriptor = (DataSetDescriptor)object;
            DataSetDescriptor dataSetDescriptor2 = (DataSetDescriptor)object2;
            if (dataSetDescriptor.dsdfPath.equals(dataSetDescriptor2.dsdfPath)) {
                return dataSetDescriptor.endTime.compareTo(dataSetDescriptor2.endTime);
            }
            return dataSetDescriptor.dsdfPath.compareTo(dataSetDescriptor2.dsdfPath);
        }
    }

    protected class StartTimeComparator
    implements Comparator {
        protected StartTimeComparator() {
        }

        public int compare(Object object, Object object2) {
            DataSetDescriptor dataSetDescriptor = (DataSetDescriptor)object;
            DataSetDescriptor dataSetDescriptor2 = (DataSetDescriptor)object2;
            if (dataSetDescriptor.dsdfPath.equals(dataSetDescriptor2.dsdfPath)) {
                return dataSetDescriptor.startTime.compareTo(dataSetDescriptor2.startTime) * -1;
            }
            return dataSetDescriptor.dsdfPath.compareTo(dataSetDescriptor2.dsdfPath) * -1;
        }
    }

    protected class DataSetDescriptor {
        public String dsdfPath;
        public String param;
        public pwDate startTime;
        public pwDate endTime;
        public String filename;

        protected DataSetDescriptor() {
        }
    }
}

