/*
 * Decompiled with CFR 0.152.
 */
package das_proto.das2Stream;

import das_proto.das2Stream.SkeletonDescriptor;
import das_proto.das2Stream.StreamDescriptor;
import das_proto.data.DataSet;
import das_proto.data.Datum;
import das_proto.data.TimeDatum;
import das_proto.data.UnitsConverter;
import das_proto.data.XTaggedYScan;
import das_proto.data.XTaggedYScanDataSet;
import das_proto.data.XTaggedYScanDataSetDescriptor;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Hashtable;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import util.pwDate;

public class StreamYScanDescriptor
extends XTaggedYScanDataSetDescriptor
implements SkeletonDescriptor {
    int nitems = -999;
    double[] yCoordinate;
    TimeDatum startTime;
    TimeDatum endTime;
    ArrayList records;
    String name;

    public StreamYScanDescriptor(Node node, StreamDescriptor streamDescriptor) {
        super((Hashtable)null);
        if (!node.getNodeName().equals("YScan")) {
            throw new IllegalArgumentException("xml tree root node is not the right type. Node type is: " + node.getNodeName());
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        this.startTime = (TimeDatum)streamDescriptor.getStartTime();
        this.endTime = (TimeDatum)streamDescriptor.getEndTime();
        Node node2 = namedNodeMap.getNamedItem("nitems");
        if (node2 != null) {
            this.nitems = Integer.parseInt(node2.getNodeValue());
        }
        if ((node2 = namedNodeMap.getNamedItem("yCoordinate")) != null) {
            String string = node2.getNodeValue();
            try {
                this.yCoordinate = new double[this.nitems];
                int n = 0;
                int n2 = 0;
                while (n2 < this.nitems - 1) {
                    int n3 = string.indexOf(",", n) - 1;
                    this.yCoordinate[n2] = Double.parseDouble(string.substring(n, n3));
                    n = n3 + 2;
                    ++n2;
                }
                this.yCoordinate[this.nitems - 1] = Double.parseDouble(string.substring(n));
                this.y_coordinate = this.yCoordinate;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Error in das2stream at yCoordinate");
            }
        }
        this.name = (node2 = namedNodeMap.getNamedItem("name")) != null ? node2.getNodeValue() : "";
        this.records = new ArrayList();
    }

    public int getSizeBytes() {
        return this.nitems * 4;
    }

    public void read(byte[] byArray, int n, int n2) {
        float[] fArray = new float[this.nitems];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        floatBuffer.position(n / 4);
        floatBuffer.get(fArray);
        this.records.add(new XTaggedYScan(-1.0E31, fArray));
    }

    public int getNumRecords() {
        return this.records.size();
    }

    public DataSet asDataSet(Datum[] datumArray) {
        if (datumArray.length != this.records.size()) {
            throw new IllegalArgumentException("Number of xValues doesn't match number of records");
        }
        XTaggedYScanDataSet xTaggedYScanDataSet = XTaggedYScanDataSet.create(this, this.records.toArray(new XTaggedYScan[this.records.size()]));
        xTaggedYScanDataSet.setStartTime(pwDate.create(this.startTime));
        xTaggedYScanDataSet.setEndTime(pwDate.create(this.endTime));
        xTaggedYScanDataSet.y_coordinate = this.yCoordinate;
        UnitsConverter unitsConverter = null;
        if (datumArray.length > 0) {
            unitsConverter = datumArray[0].getUnits().getConverter(this.getXUnits());
        }
        int n = 0;
        while (n < xTaggedYScanDataSet.data.length) {
            xTaggedYScanDataSet.data[n].x = unitsConverter.convert(datumArray[n].getValue());
            ++n;
        }
        xTaggedYScanDataSet.setName(this.name);
        return xTaggedYScanDataSet;
    }

    public String getName() {
        return this.name;
    }
}

